/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum UserLoginType {
    WECHAT(1),
    PHONE(2),
    FICTION(3);

    private int code;
    private static final Map<Integer, UserLoginType> CACHE;

    private UserLoginType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static UserLoginType getByCode(Integer taskId) {
        UserLoginType userLoginType = CACHE.get(taskId);
        if (userLoginType != null) {
            return userLoginType;
        }
        return null;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(UserLoginType.values()), UserLoginType::getCode);
    }
}

