/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.util;

import cn.com.duiba.tuia.news.center.enums.AndroidPushNotificationEnum;
import cn.com.duiba.tuia.news.center.pojo.JiGuangPushPoJo;
import cn.com.duiba.tuia.news.center.util.DataUtil;
import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.CIDResult;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.audience.AudienceTarget;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import cn.jpush.api.report.MessagesResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JiGuangPushUtils {
    private static Logger logger = LoggerFactory.getLogger(JiGuangPushUtils.class);
    private static String masterSecret;
    private static String appKey;
    private static boolean jiGuangSwitch;
    public static String URL_MAIN_ACTIVITY;
    public static String URL_WALLET_ACTIVITY;
    public static String URL_INVITE_ACTIVITY;
    public static String URL_LIMIT_PACKET_ACTIVITY;
    public static String URL_LUCK_PACKET_ACTIVITY;
    public static String TODAY_READ_TITLE;
    public static String TODAY_READ_ALERT;
    public static String TODAY_SIGN_TITLE;
    public static String TODAY_SING_ALERT;
    public static String DIS_RED_PACK_TITLE;
    public static String DIS_RED_PACK_ALERT;
    public static String RECALL_TITLE;
    public static String RECALL_ALERT;
    public static String VERSION_TAG;
    public static String LAND_PACKET_TITLE;
    public static String LAND_PACKET_ALERT;
    public static String LIMIT_PACKET_HELP_TITLE;
    public static String LIMIT_PACKET_HELP_ALERT;
    public static String INVITE_SUCCESS_TITLE;
    public static String INVITE_SUCCESS_ALERT;
    public static String DOUBLE_PACKET_TITLE;
    public static String DOUBLE_PACKET_ALERT;
    public static String LUCK_PACKET_SEND_IN_TITLE;
    public static String LUCK_PACKET_SEND_IN_ALERT;
    public static String LUCK_PACKET_SEND_WAIT_TITLE;
    public static String LUCK_PACKET_SEND_WAIT_ALERT;
    public static String WAKE_TO_PICK_1_TITLE;
    public static String WAKE_TO_PICK_1_ALERT;
    public static String WAKE_TO_PICK_2_TITLE;
    public static String WAKE_TO_PICK_2_ALERT;
    public static String POINT_PACKET_TITLE;
    public static String POINT_PACKET_ALERT;
    public static String ACTIVITY_REWARD_TITLE;
    public static String ACTIVITY_REWARD_ALERT;
    public static String ACTIVITY_SET_TITLE;
    public static String ACTIVITY_SET_ALERT;
    public static String ONE_CASH_WITHDRAW_TITLE;
    public static String ONE_CASH_WITHDRAW_ALERT;

    public static void setMasterSecret(String masterSecret) {
        JiGuangPushUtils.masterSecret = masterSecret;
    }

    public static void setAppKey(String appKey) {
        JiGuangPushUtils.appKey = appKey;
    }

    public static void setJiGuangSwitch(boolean jiGuangSwitch) {
        JiGuangPushUtils.jiGuangSwitch = jiGuangSwitch;
    }

    public static void addRemoveDevicesFromTag(String tag, Set<String> addRegIds, Set<String> removeRegIds) throws APIConnectionException, APIRequestException {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        jpushClient.addRemoveDevicesFromTag(tag, addRegIds, removeRegIds);
        jpushClient.close();
    }

    public static MessagesResult selectReport(String msgId) throws APIConnectionException, APIRequestException {
        if (StringUtils.isBlank((String)msgId)) {
            return null;
        }
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        return jpushClient.getReportMessages(msgId);
    }

    public static PushPayload buildPushObjectWithTag(JiGuangPushPoJo jiGuangPushPoJo, AndroidPushNotificationEnum androidPushNotificationEnum) {
        AndroidNotification androidNotification = ((AndroidNotification.Builder)AndroidNotification.newBuilder().setUriActivity(androidPushNotificationEnum.getActivityUrl()).setAlert((Object)androidPushNotificationEnum.getAlert()).setTitle(androidPushNotificationEnum.getTitle()).addExtras(androidPushNotificationEnum.getExtra())).build();
        Notification notification = Notification.newBuilder().addPlatformNotification((PlatformNotification)androidNotification).build();
        PushPayload.Builder builder = PushPayload.newBuilder().setPlatform(Platform.all()).setNotification(notification);
        Audience.Builder addAudienceTarget = Audience.newBuilder();
        if (CollectionUtils.isNotEmpty(jiGuangPushPoJo.getAndTags()) && CollectionUtils.isEmpty(jiGuangPushPoJo.getNotTags())) {
            addAudienceTarget.addAudienceTarget(AudienceTarget.tag_and(jiGuangPushPoJo.getAndTags()));
        }
        if (CollectionUtils.isEmpty(jiGuangPushPoJo.getAndTags()) && CollectionUtils.isNotEmpty(jiGuangPushPoJo.getNotTags())) {
            addAudienceTarget.addAudienceTarget(AudienceTarget.tag_not(jiGuangPushPoJo.getNotTags()));
        }
        if (CollectionUtils.isNotEmpty(jiGuangPushPoJo.getAndTags()) && CollectionUtils.isNotEmpty(jiGuangPushPoJo.getNotTags())) {
            addAudienceTarget.addAudienceTarget(AudienceTarget.tag_not(jiGuangPushPoJo.getNotTags())).addAudienceTarget(AudienceTarget.tag_and(jiGuangPushPoJo.getAndTags()));
        }
        if (!jiGuangSwitch) {
            addAudienceTarget.addAudienceTarget(AudienceTarget.registrationId(JiGuangPushUtils.rids()));
        }
        return builder.setAudience(addAudienceTarget.build()).build();
    }

    public static PushPayload buildPushObjectWithRegIds(JiGuangPushPoJo jiGuangPushPoJo, AndroidPushNotificationEnum androidPushNotificationEnum) {
        AndroidNotification androidNotification = ((AndroidNotification.Builder)AndroidNotification.newBuilder().setUriActivity(androidPushNotificationEnum.getActivityUrl()).setAlert((Object)androidPushNotificationEnum.getAlert()).setTitle(androidPushNotificationEnum.getTitle()).addExtras(androidPushNotificationEnum.getExtra())).build();
        Notification notification = Notification.newBuilder().addPlatformNotification((PlatformNotification)androidNotification).build();
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.registrationId(jiGuangPushPoJo.getRegistrationIds())).setNotification(notification).build();
    }

    public static PushResult sendPush(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        PushResult pushResult = jpushClient.sendPush(pushPayload);
        jpushClient.close();
        return pushResult;
    }

    public static void deleteTagBothPlatform(String tag) throws APIConnectionException, APIRequestException {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        jpushClient.deleteTag(tag, null);
        jpushClient.close();
    }

    public static void updateTagByRegId(String id, List<String> tag4remove, List<String> tag4add) {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        try {
            jpushClient.updateDeviceTagAlias(id, null, JiGuangPushUtils.toSet(tag4add), JiGuangPushUtils.toSet(tag4remove));
        }
        catch (Exception e) {
            logger.warn("\u6781\u5149\u4fee\u6539tag\u5931\u8d25:" + id + " key:" + appKey, (Throwable)e);
        }
    }

    private static Set<String> toSet(List<String> list) {
        HashSet set = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(list)) {
            set.addAll(list);
        }
        return set;
    }

    public static Map<String, String> WALLETPAGEMAP() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("page", "wallet");
        return map;
    }

    public static Map<String, String> MAINPAGEMAP() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("page", "home");
        map.put("tabId", "0");
        return map;
    }

    public static Map<String, String> REDPACKETFARMMAP() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("page", "home");
        map.put("tabId", "1");
        return map;
    }

    public static Map<String, String> INVITEMAP() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("page", "inviteDetail");
        map.put("logFrom", "6");
        map.put("url", "https://api.tuipine.com/landPage/index/MTc=?from=6");
        return map;
    }

    public static Map<String, String> INVITEINMAP() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", DataUtil.getDomian() + "/apprentice/entry.html?from=7#/recruit?kefu=kefu");
        return map;
    }

    public static Map<String, String> LANDMAP() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("page", "home");
        map.put("tabId", "2");
        return map;
    }

    public static Map<String, String> LIMITPACKETMAP() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("page", "timeRedPacket");
        return map;
    }

    public static Map<String, String> LUCKPACKETMAP() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", "https://activity.tuibat.com/land/landPage?id=MTU5NQ&activityType=groupRedPacket");
        return map;
    }

    public static Map<String, String> POINTPACKETMAP() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", "https://activity.tuibat.com/land/landPage?id=MTgwNw&activityType=clickTwiceEarn");
        return map;
    }

    public static Map<String, String> POINTPACKETINTRMAP() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", "https://activity.tuibat.com/land/landPage?id=MTgwNw&activityType=clickTwiceEarn");
        map.put("page", "groupRedPacket");
        return map;
    }

    public static Map<String, String> ACTIVITYCOINREWARD() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", "https://api.tuipine.com/landPage/index/NA==");
        map.put("page", "groupRedPacket");
        return map;
    }

    public static Map<String, String> ONECASHWITHDRAW() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("page", "home");
        map.put("tabId", "0");
        map.put("path", "/main/home");
        JSONObject data = new JSONObject();
        data.put("id", (Object)4);
        map.put("data", data.toJSONString());
        return map;
    }

    public static List<String> getCid(int count) throws APIConnectionException, APIRequestException {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        CIDResult cidResult = jpushClient.getCidList(count, null);
        return cidResult.cidlist;
    }

    private static List<String> rids() {
        ArrayList<String> list = new ArrayList<String>();
        if (!jiGuangSwitch) {
            list.add("18071adc03074a33fa5");
            list.add("1507bfd3f7eae7fb926");
            list.add("18071adc03074ad1eda");
            list.add("160a3797c80f8ecdf54");
            list.add("1507bfd3f7ea24e1a2c");
            list.add("18071adc03077642880");
            list.add("170976fa8aad91a0877");
            list.add("1507bfd3f79564a0231");
            list.add("18071adc035e3f252f7");
        }
        return list;
    }

    static {
        URL_MAIN_ACTIVITY = "com.ttyouqu.app.module.MainActivity";
        URL_WALLET_ACTIVITY = "com.ttyouqu.app.module.WalletActivity";
        URL_INVITE_ACTIVITY = "com.ttyouqu.app.ui.activity.HWPushActivity";
        URL_LIMIT_PACKET_ACTIVITY = "com.ttyouqu.app.module.frggame.acttimeredpacket.TimeRedPacketActivity";
        URL_LUCK_PACKET_ACTIVITY = "com.ttyouqu.app.module.actgroupredpacket.GroupRedPacketActivity";
        TODAY_READ_TITLE = "\u60a8\u6709\u4e00\u7b14\u65b0\u589e\u6536\u76ca\uff01";
        TODAY_READ_ALERT = "\u6536\u76ca\u5df2\u5230\u8d26\uff0c\u70b9\u51fb\u7acb\u5373\u63d0\u73b0>>";
        TODAY_SIGN_TITLE = "\u30101\u6761\u672a\u8bfb\u6d88\u606f\u3011";
        TODAY_SING_ALERT = "\u4f60\u4eca\u65e5\u8fd8\u6709\u73b0\u91d1\u5f85\u9886\u53d6\uff0c\u770b\u8d44\u8baf\u8f7b\u677e\u8d5a\u94b1\uff0c\u6bcf\u65e5\u65e0\u4e0a\u9650\u54e6~";
        DIS_RED_PACK_TITLE = "\u73b0\u91d1\u7ea2\u5305\u9650\u65f6\u514d\u8d39\u9886\u53d6";
        DIS_RED_PACK_ALERT = "\u65f6\u95f4\u6709\u9650\uff0c\u5148\u9886\u5148\u5f97>>";
        RECALL_TITLE = "\u9886\u53d6\u4f60\u7684\u65b0\u4eba\u5956\u52b1 >>";
        RECALL_ALERT = "\u53ea\u6709\u4e00\u6b21\u4e13\u4eab\u673a\u4f1a\u54e6\uff0c\u4e0d\u9886\u53d6\u5c31\u6ca1\u6709\u5566~";
        VERSION_TAG = "VERSION_1.2.3";
        LAND_PACKET_TITLE = "\u7ea2\u5305\u6536\u53d6\u63d0\u9192";
        LAND_PACKET_ALERT = "\u4f60\u7684\u7ea2\u5305\u5df2\u6210\u719f\uff0c\u518d\u4e0d\u6536\u53d6\u5c31\u6ca1\u5566~\u70b9\u51fb\u6536\u53d6>>";
        LIMIT_PACKET_HELP_TITLE = "\u597d\u53cb\u5e2e\u62c6\u6210\u529f\uff0c\u4f60\u83b7\u5f97\u4e00\u4e2a\u65b0\u7ea2\u5305\uff01";
        LIMIT_PACKET_HELP_ALERT = "\u4f60\u7684\u597d\u53cb\u5e2e\u4f60\u62c6\u4e86\u9650\u65f6\u7ea2\u5305\uff0c\u5e2e\u62c6\u8fdb\u5ea6\u5df2\u66f4\u65b0\uff0c\u5feb\u6765\u770b\u770b >>";
        INVITE_SUCCESS_TITLE = "\u606d\u559c\u83b7\u5f97\u4e00\u7b14\u73b0\u91d1\u5956\u52b1\uff01";
        INVITE_SUCCESS_ALERT = "\u4f60\u7684\u597d\u53cb\u7ed1\u5b9a\u4e86\u4f60\u7684\u9080\u8bf7\u7801\uff0c\u597d\u53cb\u9605\u8bfb\u540e\u5373\u53ef\u62ff\u5230\u73b0\u91d1\u5956\u52b1 >>";
        DOUBLE_PACKET_TITLE = "{{%s}}\u4e3a\u4f60\u52a9\u529b\u6210\u529f";
        DOUBLE_PACKET_ALERT = "\u5f53\u524d\u7ffb\u500d{{%s}}\uff0c\u5feb\u6233\u8fdb\u6765\u770b\u770b";
        LUCK_PACKET_SEND_IN_TITLE = "\u7fa4\u7ea2\u5305\u6536\u76ca\u63d0\u9192";
        LUCK_PACKET_SEND_IN_ALERT = "\u6709\u94b1\u5165\u8d26\u4e86\uff0c\u5feb\u53bb\u770b\u770b\uff01";
        LUCK_PACKET_SEND_WAIT_TITLE = "\u7fa4\u7ea2\u5305\u6536\u76ca\u63d0\u9192";
        LUCK_PACKET_SEND_WAIT_ALERT = "\u4f60\u6709\u6536\u76ca\u5f85\u5165\u8d26\uff0c\u5feb\u53bb\u50ac\u4e00\u4e0b\uff01";
        WAKE_TO_PICK_1_TITLE = "/";
        WAKE_TO_PICK_1_ALERT = "\u60a8\u7684\u7ea2\u5305\u5df2\u7ecf\u6210\u719f\uff0c\u518d\u4e0d\u6536\u53d6\u5c31\u8981\u88ab\u4eba\u5077\u5b8c\u5566\uff01\u70b9\u51fb\u6536\u53d6>>";
        WAKE_TO_PICK_2_TITLE = "\u6536\u7ea2\u5305\u5566\uff01";
        WAKE_TO_PICK_2_ALERT = "\u60a8\u7684\u7ea2\u5305\u5df2\u6210\u719f\uff0c\u518d\u4e0d\u6536\u53d6\u5c31\u8981\u88ab\u5077\u5566\uff01\u70b9\u51fb\u6536\u53d6>>";
        POINT_PACKET_TITLE = "\u606d\u559c";
        POINT_PACKET_ALERT = "\u60a8\u83b7\u5f97\u4e86\u65b0\u7684\u62bd\u5956\u673a\u4f1a\uff01\u5feb\u53bb\u62bd\u5956\uff01";
        ACTIVITY_REWARD_TITLE = "\u6709\u65b0\u7684\u91d1\u5e01\u6536\u76ca\u5566\uff0c\u5feb\u53bb\u770b\u770b\uff01";
        ACTIVITY_REWARD_ALERT = "\u6709\u65b0\u7684\u91d1\u5e01\u6536\u76ca\u5566\uff0c\u5feb\u53bb\u770b\u770b\uff01";
        ACTIVITY_SET_TITLE = "\u6709\u91d1\u5e01\u6536\u76ca\u672a\u9886\u53d6\uff0c\u518d\u4e0d\u6765\u5c31\u665a\u5566\uff01";
        ACTIVITY_SET_ALERT = "\u6709\u91d1\u5e01\u6536\u76ca\u672a\u9886\u53d6\uff0c\u518d\u4e0d\u6765\u5c31\u665a\u5566\uff01";
        ONE_CASH_WITHDRAW_TITLE = "\u606d\u559c\u60a8\u6210\u4e3a\u672c\u6708\u5e78\u8fd0\u7528\u6237\uff01\uff01\uff01";
        ONE_CASH_WITHDRAW_ALERT = "\u83b7\u5f971\u5143\u63d0\u73b0\u7279\u6743\uff0c\u70b9\u51fb\u7acb\u523b\u63d0\u73b0 >>";
    }
}

