package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.loginReward.LoginNewRewardDto;
import cn.com.duiba.tuia.news.center.dto.loginReward.NewReward184Dto;

import java.util.List;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteAccountService.java , v 0.1 2018/1/3 下午2:18 ZhouFeng Exp $
 */
@AdvancedFeignClient
public interface RemoteLoginRewardService {

    /**
     * 根据用户Id获取当前的任务进度和奖励
     * @param userId
     * @return
     */
    List<LoginNewRewardDto> getRewardListByUserId(Long userId);

    /**
     * 根据用户Id，奖励类型，任务新增数量增加任务完成度
     * @param userId
     * @param item
     * @param count
     * @return
     */
    boolean addPlan(Long userId,Integer item,Long count);

    /**
     * 领取新人任务后获得的提现券
     * @param userId
     * @return
     */
    boolean getTicketForNewUser(Long userId);

    /**
     * 根据用户Id获取分天获取注册奖励的数据
     * @param userId
     * @return
     */
    NewReward184Dto getRewardDetailByUserId(Long userId);

    /**
     * 根据用户Id获取分天获取注册奖励的数据(无奖励模式)
     * @param userId
     * @return
     */
    NewReward184Dto getRewardDetailWithoutReward(Long userId);

    /**
     * 根据用户Id获取分天获取注册奖励的数据
     * @param userId
     * @return
     */
    NewReward184Dto getRewardDetailByUserIdAndVersion(Long userId, String version);


    /**
     * 推送完成新手任务
     *
     * @param userId
     * @return
     */
    boolean pushFinish(Long userId);
}
