/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum ShortMessageType {
    INVITE_MSG(1, "\u9080\u8bf7\u77ed\u4fe1"),
    INVITE_REMIND(2, "\u9080\u8bf7\u63d0\u9192\u77ed\u4fe1");

    private Integer type;
    private String desc;
    private static final Map<Integer, ShortMessageType> CACHE;

    private ShortMessageType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ShortMessageType getByType(Integer type) {
        return CACHE.get(type);
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(ShortMessageType.values()), ShortMessageType::getType);
    }
}

