/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.enums.CoinTradeCode;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum CoinExpenseCode implements CoinTradeCode
{
    SETTLE(1, "\u91d1\u5e01\u7ed3\u7b97"),
    HAOWAN_GAME(2, "\u597d\u73a9\u5c0f\u6e38\u620f"),
    REFRESH_STANGER(3, "\u7ea2\u5305\u519c\u573a"),
    BEAT_BY_DOG(4, "\u7ea2\u5305\u519c\u573a"),
    RISK_MANAGEMENT(5, "\u91d1\u5e01\u6536\u56de\uff1a\u8fdd\u89c4\u6536\u76ca\u6263\u9664"),
    LOTTERY_BUY(6, "\u8d2d\u4e70\u5f69\u7968");

    private Integer code;
    private String desc;
    private static final Map<Integer, CoinExpenseCode> CACHE;

    public Integer getCode() {
        return this.code;
    }

    private CoinExpenseCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public Long getTaskId() {
        return (long)this.code;
    }

    @Override
    public String getTaskDescription() {
        return this.desc;
    }

    public static CoinExpenseCode getByCode(Integer code) {
        CoinExpenseCode coinExpenseCode = CACHE.get(code);
        if (coinExpenseCode != null) {
            return coinExpenseCode;
        }
        return null;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(CoinExpenseCode.values()), CoinExpenseCode::getCode);
    }
}

