/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.enums.CoinTradeCode;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum RewardTaskType implements CoinTradeCode
{
    READING_NEWS(1L, "\u9605\u8bfb\u6587\u7ae0"),
    SIGN_IN(2L, "\u7b7e\u5230\u5956\u52b1"),
    COMPENSATE(3L, "\u7528\u6237\u8865\u507f"),
    WATCH_VIDEO(4L, "\u89c2\u770b\u89c6\u9891"),
    INVITE_READ(5L, "\u597d\u53cb\u9605\u8bfb"),
    BIND_INVITE_CODE(6L, "\u7ed1\u5b9a\u9080\u8bf7\u7801"),
    ACCOUNT_BIND_CODE(7L, "\u5b8c\u5584\u8d44\u6599"),
    PICK_PACKET(8L, "\u6536\u53d6\u7ea2\u5305"),
    SHARE_INVITE(9L, "\u5206\u4eab\u9080\u8bf7\u94fe\u63a5"),
    HAOWAN_GAME(10L, "\u597d\u73a9\u5c0f\u6e38\u620f"),
    STEAL_PACKET(11L, "\u5077\u53d6\u7ea2\u5305"),
    POINT_PACKET(12L, "\u75af\u72c2\u62bd\u5956"),
    LUCK_PACKET_SHARE(13L, "\u7fa4\u7ea2\u5305\u5206\u4eab"),
    SIGN_IN_SHARE(14L, "\u7b7e\u5230\u5206\u4eab\u5956\u52b1"),
    FRIEND_OPEN_SIGN_IN_SHARE(15L, "\u7b7e\u5230\u597d\u53cb\u9605\u8bfb\u5956\u52b1"),
    FRIEND_OPEN_HOT_ARTICLE_SHARE(16L, "\u597d\u53cb\u6253\u5f00\u70ed\u6587\u5206\u4eab"),
    ACTIVITY_SET_OPEN(17L, "\u7528\u6237\u6253\u5f00\u5408\u96c6"),
    ARTICLE_SHARE_FIRST(18L, "\u9996\u6b21\u6b63\u6587\u5206\u4eab\u5956\u52b1"),
    ARTICLE_SHARE_READING(19L, "\u6b63\u6587\u5206\u4eab\u9605\u8bfb\u5956\u52b1"),
    TIME_COIN(20L, "\u65f6\u6bb5\u5956\u52b1"),
    OBJECT_REWARD(21L, "\u53c2\u4e0e\u6d3b\u52a8"),
    RISK_CANCEL(22L, "\u98ce\u63a7\u53d6\u6d88"),
    MISSION_162(31L, "\u4efb\u52a1\u5956\u52b1"),
    MISSION_SHARE(32L, "\u4efb\u52a1:\u5206\u4eab\u5956\u52b1"),
    MISSION_PLANT(33L, "\u4efb\u52a1:\u79cd\u690d\u5956\u52b1"),
    LOGIN_REWARD_PLANT(41L, "\u65b0\u4eba\u79cd\u690d\u5956\u52b1"),
    MONEY_TREE_HARVEST(42L, "\u6447\u94b1\u6811\u91d1\u5e01\u5956\u52b1"),
    COIN_COMPENSATE(43L, "\u63d0\u73b0\u989d\u5ea6\u914d\u7f6e\u7528\u6237\u8865\u507f\u91d1"),
    COIN_BOX_OPEN(44L, "\u5b9d\u7bb1\u5f00\u542f\u5956\u52b1"),
    COIN_BOX_SHARE(45L, "\u5b9d\u7bb1\u5206\u4eab\u5956\u52b1"),
    COIN_BOX_SHARE_READ(46L, "\u5b9d\u7bb1\u5206\u4eab\u9605\u8bfb\u5956\u52b1"),
    STEP_REWARD(47L, "\u8d70\u8def\u5956\u52b1"),
    INVITE_SHIFU(48L, "\u62dc\u5e08\u5956\u52b1"),
    AD_REWARD(49L, "\u9605\u8bfb\u6587\u7ae0"),
    SEARCH_REWARD(50L, "\u641c\u7d22\u5956\u52b1"),
    GUAFEN_REWARD(51L, "\u74dc\u5206\u91d1\u5e01\u6d3b\u52a8\u5956\u52b1"),
    NEW_SIGN_REWARD(52L, "\u6253\u5361\u74dc\u5206\u91d1\u5e01"),
    TRY_PLAY_REWARD(53L, "\u8bd5\u73a9\u5956\u52b1"),
    TUIA_LAND_PACKET(54L, "\u7ea2\u5305\u6536\u53d6"),
    REWARD_VIDEO(55L, "\u89c2\u770b\u89c6\u9891\u5956\u52b1"),
    FORM_REWARD(56L, "\u586b\u5199\u8868\u5355\u5956\u52b1"),
    FICTION_ADVERT(57L, "\u5c0f\u8bf4\u5956\u52b1"),
    ARTICLE_REWARD(58L, "\u9605\u8bfb\u7ffb\u500d\u5956\u52b1"),
    LOTTERY(59L, "\u65f6\u65f6\u5f69\u5956\u52b1"),
    SIMPLE_PLAY(60L, "\u7b80\u5355\u8d5a");

    private Long taskId;
    private String taskDescription;
    private static final Map<Long, RewardTaskType> CACHE;

    private RewardTaskType(Long taskId, String taskDescription) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
    }

    @Override
    public Long getTaskId() {
        return this.taskId;
    }

    @Override
    public String getTaskDescription() {
        return this.taskDescription;
    }

    public static RewardTaskType getByTaskId(Long taskId) {
        RewardTaskType rewardTaskType = CACHE.get(taskId);
        if (rewardTaskType != null) {
            return rewardTaskType;
        }
        return null;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(RewardTaskType.values()), RewardTaskType::getTaskId);
    }
}

