package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.pointpacket.BroadcastRsp;
import cn.com.duiba.tuia.news.center.dto.pointpacket.OpenPointRsp;
import cn.com.duiba.tuia.news.center.dto.pointpacket.PointConfigRsp;
import cn.com.duiba.tuia.news.center.dto.pointpacket.PointPacketDteailRsp;
import cn.com.duiba.tuia.news.center.dto.pointpacket.PointRewardRsp;
import cn.com.duiba.tuia.news.center.dto.pointpacket.PushCondition;

import java.util.List;


/**
 * Created by xiaotian on 2018/8/3.
 * @author xiaotian
 */
@AdvancedFeignClient
public interface RemotePointPacketService {

    /**
     * 根据类型获取点点赚转盘的配置信息
     * @return
     */
    List<PointConfigRsp> getPointConfig(Integer type);

    /**
     * 根据pointId获取点点赚详情
     * @param code
     * @return
     */
    PointPacketDteailRsp getPointDetail(Integer type,Long userId,String code) throws BizException;

    /**
     * 根据pointId获取打开列表
     * @param pointId 点点赚唯一键Id
     * @param pageNo 页数
     * @param pageSize 页码
     * @return 列表
     */
    List<OpenPointRsp> getOpenList(Long pointId,Integer pageNo,Integer pageSize) throws BizException;

    /**
     * 增加抽奖次数（app分享成功后回调增加抽奖次数，微信jssdk分享成功回调增加抽奖次数）
     * @param pointId
     * @return
     */
    boolean addPlayTimes(Integer type,Long pointId);

    /**
     * 提现满额5元的接口
     * @param pointId
     * @return
     */
    boolean withdraw(Long userId,Long pointId) throws BizException;


    /**
     * 获取奖励
     * @return
     */
    PointRewardRsp getReward(Integer type,Long userId,String code) throws BizException;

    /**
     * 微信好友打开页面增加抽奖次数
     * @param pointId
     * @param code
     * @return
     */
    boolean addPalyTimesByOpen(Long pointId,String code);

    /**
     * 返回时间点的打开列表
     * @return
     */
    PushCondition  getPushCondition(Long userId);


    /**
     * 获取公告
     * @param type
     * @param size
     * @return
     */
    List<BroadcastRsp>  getPointBroadcastList(Integer type,Integer size);


    /**
     * 根据pointId获取当前app用户的累计赚取的零钱数
     * @param point
     * @return
     */
    Long getAllIncomeByPoint(Long point);

}
