package cn.com.duiba.tuia.news.center.dto;

import cn.com.duiba.tuia.news.center.enums.OrderType;

import java.io.Serializable;
import java.util.Date;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: CoinOrderDto.java , v 0.1 2017/12/30 下午3:50 ZhouFeng Exp $
 */
public class CoinOrderDto implements Serializable {

    private static final long serialVersionUID = -8775535971262093757L;
    /**
     * 流水号
     */
    private Long serialNumer;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 金币数
     */
    private Long fee;

    /**
     * 流水类型
     */
    private OrderType orderType;

    /**
     * 流水详情码 收入时为任务id，支出时参见CoinExpenseCode
     */
    private Integer code;

    /**
     * 流水时间
     */
    private Date gmtCreate;

    public Long getSerialNumer() {
        return serialNumer;
    }

    public void setSerialNumer(Long serialNumer) {
        this.serialNumer = serialNumer;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public OrderType getOrderType() {
        return orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
}
