package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 */
public enum ObjectRewardEnum {

    COIN("coin"),

    FARM("landpacket"),

    ARTICLEDOUBLE("articleDouble"),

    TREEDOUBLE("treeDouble"),

    SIGNDOUBLE("signDouble");

    private String code;


    ObjectRewardEnum(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }

    private static final Map<String,ObjectRewardEnum> CACHE =  Maps.uniqueIndex(Arrays.asList(ObjectRewardEnum.values()),
            ObjectRewardEnum::getCode);


    public static ObjectRewardEnum getByCode(String code){
        return CACHE.get(code);
    }

    public static ObjectRewardEnum getByInput(String code){
        return Arrays.stream(ObjectRewardEnum.values()).filter(objectRewardEnum -> objectRewardEnum.getCode().contains(code)).findFirst().orElse(null);
    }

}
