package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.advert.GroupAdMappingDto;
import cn.com.duiba.tuia.news.center.dto.advert.NewAdvertConfigDto;
import cn.com.duiba.tuia.news.center.dto.flowadvert.FlowAdvertConfigDto;
import cn.com.duiba.tuia.news.center.dto.flowadvert.FlowAdvertDto;
import cn.com.duiba.tuia.news.center.dto.localnews.CityDto;
import cn.com.duiba.tuia.news.center.enums.AdGroupCode;

import java.util.List;

/**
 * @author zhou_wb
 * 用户广告配置
 */
@AdvancedFeignClient
public interface RemoteAdvertConfigService {
    /**
     * 后台查询信息流广告配置
     */
    List<FlowAdvertConfigDto>  selectAllForBk(Integer adGroup);


    /**
     * 根据版本获取配置列表
     */
    List<FlowAdvertConfigDto> selectByVersion(Long version);


    /**
     * 保存与更新配置列表
     */
    boolean save(FlowAdvertConfigDto flowAdvertConfigDto);


    /**
     * 更新配置状态
     */
    boolean updateStatus(Long id,Integer status);

    /**
     * 获取广告配置列表
     */
    List<FlowAdvertDto>  selectAllFlowConfig();


    /**
     *
     * @param adGroupCode  {@link AdGroupCode}
     * 根据场景获取广告配置
     */
    List<FlowAdvertConfigDto> selectByAdGroup(AdGroupCode adGroupCode);


    /**
     * @param adGroupCode  {@link AdGroupCode}
     * 根据场景与版本获取广告配置
     */
    List<FlowAdvertConfigDto> selectByAdGroupAndVersion(AdGroupCode adGroupCode,Long version);

    /**
     * 新版本获取所有广告位配置
     * @return
     */
    List<NewAdvertConfigDto> selectAll();


    /**
     * 查询场景下的 广告配置映射
     * @param adGroupCode
     * @return
     */
    List<GroupAdMappingDto> selectAdMappingByAdGroup(AdGroupCode adGroupCode);
}
