package cn.com.duiba.tuia.news.center.dto;

import java.io.Serializable;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: UserDto.java , v 0.1 2017/12/28 下午2:40 ZhouFeng Exp $
 */
public class UserDto implements Serializable {

    private static final long serialVersionUID = -1781348640181205055L;
    /**
     * 用户ID
     */
    private Long userId;

    private String token;

    /**
     * 是否为新用户
     */
    private Boolean newUser;

    /**
     * 新用户的奖励，单位：分
     */
    private Long reward;

    /** 头像 */
    private String headImage;

    /** 昵称 */
    private String nickName;

    /**微信Id*/
    private String unionId;

    /**
     * 绑定状态
     */
    private BindingDto bindingDto;

    /** 邀请人id */
    private Long inviterId;

    /** 邀请活动来源 */
    private Integer inviterActSource;

    public UserDto() {
    }

    private UserDto(Builder builder) {
        setUserId(builder.userId);
        setToken(builder.token);
        setNewUser(builder.newUser);
        setReward(builder.reward);
        setHeadImage(builder.headImage);
        setNickName(builder.nickName);
        setBindingDto(builder.bindingDto);
        setUnionId(builder.unionId);
        setInviterId(builder.inviterId);
        setInviterActSource(builder.inviterActSource);
    }

    public Integer getInviterActSource() {
        return inviterActSource;
    }

    public void setInviterActSource(Integer inviterActSource) {
        this.inviterActSource = inviterActSource;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public BindingDto getBindingDto() {
        return bindingDto;
    }

    public void setBindingDto(BindingDto bindingDto) {
        this.bindingDto = bindingDto;
    }

    public String getHeadImage() {
        return headImage;
    }

    public void setHeadImage(String headImage) {
        this.headImage = headImage;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Boolean getNewUser() {
        return newUser;
    }

    public void setNewUser(Boolean newUser) {
        this.newUser = newUser;
    }

    public Long getReward() {
        return reward;
    }

    public void setReward(Long reward) {
        this.reward = reward;
    }

    public Long getInviterId() {
        return inviterId;
    }

    public void setInviterId(Long inviterId) {
        this.inviterId = inviterId;
    }

    public static final class Builder {
        private Long userId;
        private String token;
        private Boolean newUser;
        private Long reward;
        private String headImage;
        private String nickName;
        private BindingDto bindingDto;
        private String unionId;
        private Long inviterId;
        private Integer inviterActSource;

        public Builder() {
            //builder
        }

        public Builder userId(Long val) {
            userId = val;
            return this;
        }

        public Builder bindingDto(BindingDto val) {
            bindingDto = val;
            return this;
        }
        public Builder token(String val) {
            token = val;
            return this;
        }

        public Builder newUser(Boolean val) {
            newUser = val;
            return this;
        }

        public Builder reward(Long val) {
            reward = val;
            return this;
        }

        public Builder headImage(String val) {
            headImage = val;
            return this;
        }
        public Builder nickName(String val) {
            nickName = val;
            return this;
        }
        public Builder unionId(String val) {
            unionId = val;
            return this;
        }
        public Builder inviterId(Long val) {
            inviterId = val;
            return this;
        }
        public Builder inviterActSource(Integer val) {
            inviterActSource = val;
            return this;
        }
        public UserDto build() {
            return new UserDto(this);
        }
    }
}
