package cn.com.duiba.tuia.news.center.dto;

import java.io.Serializable;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: AccountDetailDto.java , v 0.1 2018/1/3 下午4:59 ZhouFeng Exp $
 */
public class AccountDetailDto implements Serializable {

    private static final long serialVersionUID = 4862476678284690330L;
    /**
     * 可用零钱余额
     */
    private Long changeBalance;

    /**
     * 待兑换金币
     */
    private Long unsettleCoins;

    /**
     * 账户内所有未兑换的金币数额
     */
    private Long allPocketCoin;

    /**
     * 累计零钱收益
     */
    private Long totalIncomeChange;

    /**
     * 昨日零钱收益(未结算时为null)
     */
    private Long yesterdayIncomeChange;

    /**
     * 昨日汇率(未结算时为null)
     */
    private Double yesterdayExchangeRate;

    /**
     * 昨日金币收入
     */
    private Long              yesterdayIncomeCoin;


    /**
     * 今日是否提现过
     */
    private boolean todayWithdraw;

    /**
     * 明日可预计提现
     */
    private Long tomorrowWithdraw;

    public Long getTomorrowWithdraw() {
        return tomorrowWithdraw;
    }

    public void setTomorrowWithdraw(Long tomorrowWithdraw) {
        this.tomorrowWithdraw = tomorrowWithdraw;
    }

    public boolean isTodayWithdraw() {
        return todayWithdraw;
    }

    public void setTodayWithdraw(boolean todayWithdraw) {
        this.todayWithdraw = todayWithdraw;
    }

    public Long getAllPocketCoin() {
        return allPocketCoin;
    }

    public void setAllPocketCoin(Long allPocketCoin) {
        this.allPocketCoin = allPocketCoin;
    }

    public Long getYesterdayIncomeCoin() {
        return yesterdayIncomeCoin;
    }

    public void setYesterdayIncomeCoin(Long yesterdayIncomeCoin) {
        this.yesterdayIncomeCoin = yesterdayIncomeCoin;
    }

    public Long getChangeBalance() {
        return changeBalance;
    }

    public void setChangeBalance(Long changeBalance) {
        this.changeBalance = changeBalance;
    }

    public Long getUnsettleCoins() {
        return unsettleCoins;
    }

    public void setUnsettleCoins(Long unsettleCoins) {
        this.unsettleCoins = unsettleCoins;
    }

    public Long getTotalIncomeChange() {
        return totalIncomeChange;
    }

    public void setTotalIncomeChange(Long totalIncomeChange) {
        this.totalIncomeChange = totalIncomeChange;
    }

    public Long getYesterdayIncomeChange() {
        return yesterdayIncomeChange;
    }

    public void setYesterdayIncomeChange(Long yesterdayIncomeChange) {
        this.yesterdayIncomeChange = yesterdayIncomeChange;
    }

    public Double getYesterdayExchangeRate() {
        return yesterdayExchangeRate;
    }

    public void setYesterdayExchangeRate(Double yesterdayExchangeRate) {
        this.yesterdayExchangeRate = yesterdayExchangeRate;
    }
}
