package cn.com.duiba.tuia.news.center.dto;

import cn.com.duiba.tuia.news.center.enums.WithdrawChannelType;
import cn.com.duiba.tuia.news.center.enums.WithdrawType;

import java.io.Serializable;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: WithdrawApplyDto.java , v 0.1 2018/1/3 上午11:15 ZhouFeng Exp $
 */
public class WithdrawApplyDto implements Serializable {

    private static final long serialVersionUID = 3991424999705637254L;
    /**
     * 提现金额
     */
    private Long fee;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 提现渠道
     */
    private WithdrawChannelType channel;

    /**
     * 提现类型
     */
    private WithdrawType withdrawType;

    /**
     * 收款人姓名
     */
    private String payeeName;

    /**
     * 收款人账号
     */
    private String payeeAccount;

    /**
     * 收款备注
     */
    private String payeeRemark;

    /**
     * 是否用了特权券(默认没有使用)
     */
    private Boolean useDisCount = false;

    /**
     * 版本号
     */
    private String version;

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Boolean getUseDisCount() {
        return useDisCount;
    }

    public void setUseDisCount(Boolean useDisCount) {
        this.useDisCount = useDisCount;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public WithdrawChannelType getChannel() {
        return channel;
    }

    public void setChannel(WithdrawChannelType channel) {
        this.channel = channel;
    }

    public WithdrawType getWithdrawType() {
        return withdrawType;
    }

    public void setWithdrawType(WithdrawType withdrawType) {
        this.withdrawType = withdrawType;
    }

    public String getPayeeName() {
        return payeeName;
    }

    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    public String getPayeeAccount() {
        return payeeAccount;
    }

    public void setPayeeAccount(String payeeAccount) {
        this.payeeAccount = payeeAccount;
    }

    public String getPayeeRemark() {
        return payeeRemark;
    }

    public void setPayeeRemark(String payeeRemark) {
        this.payeeRemark = payeeRemark;
    }
}
