package cn.com.duiba.tuia.news.center.enums.articleRewardConfig;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 审核状态
 *
 * @author ElinZhou
 * @version $Id: ApplyStatus.java , v 0.1 2018/1/2 下午3:50 ElinZhou Exp $
 */
public enum ArticleRewardConfigEnum {
    /**
     * 点开激励视频
     */
    VIDOE_DIAN(0,"点开激励视频"),

    /**
     * 汇量激励视频
     */
    VIDEO_HUI(1,"汇量激励视频"),

    /**
     * 原生sdk
     */
    YUAN_SDK(2,"原生sdk"),

    /**
     * 激励互动
     */
    TUIA_H5(3,"激励互动"),

    /**
     * 自有激励视频
     */
    VIDEO_H5(4,"魔力赚H5激励视频"),

    /**
     * 视频H5
     */
    VIDEO_H5_SDK(5,"魔力赚SDK激励视频"),

    ;
    private static final Map<Integer, ArticleRewardConfigEnum> CACHE = Maps.uniqueIndex(Arrays.asList(ArticleRewardConfigEnum
            .values()), ArticleRewardConfigEnum::getCode);

    private Integer code;
    private String desc;

    ArticleRewardConfigEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);
    }

    public static ArticleRewardConfigEnum of(Integer aCode) {
        return CACHE.get(aCode);
    }

}
