package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.req.OutOrderDto;

import java.util.Date;

/**
 * Created by xiaotian on 2018/7/9
 * @author xiaotian
 */
@AdvancedFeignClient
public interface RemoteOutOrderService {
    /**
     * 通过内部orderId获取订单状态
     * @param orderId
     * @return
     */
    OutOrderDto getByOrderId(Long orderId);

    /**
     * 根据外部订单Id，获取
     * @param outOrderId tuia订单Id
     * @since 1.4.1
     * @return
     */
    OutOrderDto insertTuiaOrderByOutOrderId(Long slotId ,Long outOrderId) throws BizException;



    /**
     * 根据外部订单Id，获取
     * @param outOrderId tuia订单Id
     * @since 1.4.1
     * @return
     */
    OutOrderDto insertTuiaOrderByconsumeIdAndorderId(Long slotId ,Long consumeId,String outOrderId) throws BizException;


    /**
     * 将设备和oid绑定
     * @param deviceId
     * @param oId
     * @return
     */
    Boolean bindDeviceIdAndOId(String deviceId,String oId);



    /**
     *  根据设备Id查询tuia的oid
     * @param deviceId
     * @return
     */
    String selectOIdByDeviceId(String deviceId);


    /**
     * 根据设备获取创建时间
     * @param deviceId
     * @return
     */
    Date getCreateTime(String deviceId);
}
