/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.util;

import cn.com.duiba.tuia.news.center.enums.RedisKey;
import com.google.common.base.Joiner;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class RedisKeyUtil {
    private static final String SEPARATOR = "_";
    private static final String NC_PREFIX = "NC";
    private static final String TUIA_PREFIX = "TUIA";

    public static String tokenKey(String token) {
        return RedisKeyUtil.getKey(RedisKey.K49, token);
    }

    public static String uniqueRewardTaskKey(Long userId, Long taskId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K50, userId, taskId, localDate);
    }

    public static String rewardTaskLockKey(Long userId, Long taskId) {
        return RedisKeyUtil.getKey(RedisKey.K51, userId, taskId);
    }

    public static String unsettleCoinsKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K52, userId);
    }

    public static String yesterdayIncomeKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K53, userId);
    }

    public static String settledChangeKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K54, userId);
    }

    public static String todayTaskCoinKey(Long userId, Long taskId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K63, userId, taskId, localDate);
    }

    private static String getKey(RedisKey redisKey, Object ... objects) {
        return RedisKeyUtil.getKey(NC_PREFIX, redisKey, objects);
    }

    private static String getKey(String prefix, RedisKey redisKey, Object ... objects) {
        Joiner joiner = Joiner.on((String)SEPARATOR).skipNulls();
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(prefix);
        items.add((Object)redisKey);
        items.addAll(Arrays.stream(objects).map(value -> value == null ? "null" : value).collect(Collectors.toList()));
        return joiner.join(items);
    }

    private RedisKeyUtil() {
    }
}

