/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.util;

import cn.com.duiba.tuia.news.center.enums.RedisKey;
import com.google.common.base.Joiner;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class RedisKeyUtil {
    private static final String SEPARATOR = "_";
    private static final String NC_PREFIX = "NC";
    private static final String TUIA_PREFIX = "TUIA";

    public static String tokenKey(String token) {
        return RedisKeyUtil.getKey(RedisKey.K49, token);
    }

    public static String uniqueRewardTaskKey(Long userId, Long taskId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K50, userId, taskId, localDate);
    }

    public static String rewardTaskLockKey(Long userId, Long taskId) {
        return RedisKeyUtil.getKey(RedisKey.K51, userId, taskId);
    }

    public static String unsettleCoinsKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K52, userId);
    }

    public static String yesterdayIncomeKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K53, userId);
    }

    public static String settledChangeKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K54, userId);
    }

    public static String allReadTaskNumKeyNew(Long userId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K68, userId, localDate);
    }

    public static String withdrawKey(Long userId, Integer source, Long fee) {
        return RedisKeyUtil.getKey(RedisKey.K72, userId, source, fee);
    }

    public static String versionKey() {
        return RedisKeyUtil.getKey(RedisKey.K69, new Object[0]);
    }

    public static String probabilityAndPerNumKey() {
        return RedisKeyUtil.getKey(RedisKey.K70, new Object[0]);
    }

    public static String PerNumKey() {
        return RedisKeyUtil.getKey(RedisKey.K71, new Object[0]);
    }

    public static String verificationCodeKey(String phoneNum) {
        return RedisKeyUtil.getKey(RedisKey.K75, phoneNum);
    }

    public static String sendMesCountKey(String deviceId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K76, deviceId, localDate);
    }

    public static String sendMesRepetitionKey(String phonenum) {
        return RedisKeyUtil.getKey(RedisKey.K78, phonenum);
    }

    public static String phoneLoginKey(String phonenum) {
        return RedisKeyUtil.getKey(RedisKey.K80, phonenum);
    }

    public static String sendMesKey(String phoneNum) {
        return RedisKeyUtil.getKey(RedisKey.K79, phoneNum);
    }

    public static String getFristLandCreate(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K81, userId);
    }

    public static String todayTaskCoinKey(Long userId, Long taskId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K63, userId, taskId, localDate);
    }

    public static String inviteeReadingRewardKey(Long userId, Integer type) {
        return RedisKeyUtil.getKey(RedisKey.K82, userId, type);
    }

    public static String openLandKey(Long userId, Integer taskId) {
        return RedisKeyUtil.getKey(RedisKey.K84, userId, taskId);
    }

    public static String pickPacketKey(Long userId, Long landId) {
        return RedisKeyUtil.getKey(RedisKey.K85, userId, landId);
    }

    public static String getInviteChangeRewardKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K86, userId);
    }

    public static String getInviteRewardLimitKey() {
        return RedisKeyUtil.getKey(RedisKey.K87, new Object[0]);
    }

    private static String getKey(RedisKey redisKey, Object ... objects) {
        return RedisKeyUtil.getKey(NC_PREFIX, redisKey, objects);
    }

    private static String getKey(String prefix, RedisKey redisKey, Object ... objects) {
        Joiner joiner = Joiner.on((String)SEPARATOR).skipNulls();
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(prefix);
        items.add((Object)redisKey);
        items.addAll(Arrays.stream(objects).map(value -> value == null ? "null" : value).collect(Collectors.toList()));
        return joiner.join(items);
    }

    private RedisKeyUtil() {
    }
}

