package cn.com.duiba.tuia.news.center.util;

import cn.com.duiba.tuia.news.center.enums.RedisKey;
import com.google.common.base.Joiner;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * redis key组装工具类
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RedisKeyUtil.java , v 0.1 2017/5/19 下午4:56 ZhouFeng Exp $
 */
public class RedisKeyUtil {

    private static final String SEPARATOR = "_";

    private static final String NC_PREFIX = "NC";

    private static final String TUIA_PREFIX = "TUIA";

    /**
     * token对应userid缓存key
     *
     * @param token
     * @return
     */
    public static String tokenKey(String token) {
        return getKey(RedisKey.K49, token);
    }

    /**
     * 目标不可重复性任务日完成记录key
     *
     * @param userId
     * @param taskId
     * @param localDate
     * @return
     */
    public static String uniqueRewardTaskKey(Long userId, Long taskId, LocalDate localDate) {
        return getKey(RedisKey.K50, userId, taskId, localDate);
    }

    /**
     * 用户领奖分布式锁key
     *
     * @param userId
     * @param taskId
     * @return
     */
    public static String rewardTaskLockKey(Long userId, Long taskId) {
        return getKey(RedisKey.K51, userId, taskId);
    }

    /**
     * 未结算金币key
     *
     * @param userId
     * @return
     */
    public static String unsettleCoinsKey(Long userId) {
        return getKey(RedisKey.K52, userId);
    }

    /**
     * 昨日收入key
     *
     * @param userId
     * @return
     */
    public static String yesterdayIncomeKey(Long userId) {
        return getKey(RedisKey.K53, userId);
    }

    /**
     * 用户已结算零钱总额缓存
     *
     * @param userId
     * @return
     */
    public static String settledChangeKey(Long userId) {
        return getKey(RedisKey.K54, userId);
    }

    /**
     * 用户今日已经看过的文章加视频数量(新)
     *
     * @param userId
     * @return
     */
    public static String allReadTaskNumKeyNew(Long userId, LocalDate localDate) {
        return getKey(RedisKey.K68, userId,localDate);
    }

    /**
     * 获取用户提现锁（防刷）
     *
     * @param userId
     * @return
     */
    public static String withdrawKey(Long userId,Integer source,Long fee) {
        return getKey(RedisKey.K72, userId,source,fee);
    }

    /**
     *  版本控制的Key
     *
     * @return
     */
    public static String versionKey() {
        return getKey(RedisKey.K69);
    }

    /**
     * 设置第七天中奖的该路和人数的Key
     *
     * @return
     */
    public static String probabilityAndPerNumKey() {
        return getKey(RedisKey.K70);
    }

    /**
     * 金额大额中奖人数
     *
     * @return
     */
    public static String PerNumKey() {
        return getKey(RedisKey.K71);
    }

    /**
     * 10分钟短信验证码
     *
     * @return
     */
    public static String verificationCodeKey(String phoneNum) {
        return getKey(RedisKey.K75,phoneNum);
    }
    /**
     * 一天内无法发送的短信数量
     *
     * @return
     */
    public static String sendMesCountKey(String deviceId,LocalDate localDate) {
        return getKey(RedisKey.K76,deviceId,localDate);
    }


    /**
     * 微信好友的帮戳记录
     *
     * @return
     */
    public static String helpList(String unionId,LocalDate localDate) {
        return getKey(RedisKey.K88,unionId,localDate);
    }


    /**
     * 微信好友的帮戳锁
     *
     * @return
     */
    public static String helpLock(String unionId) {
        return getKey(RedisKey.K89,unionId);
    }


    /**
     *  限时红包提现锁
     *
     * @return
     */
    public static String limitWithdraw(Long userId) {
        return getKey(RedisKey.K90,userId);
    }

    /**
     * 一个手机号在55秒内不能重新发送短信
     * @param phonenum
     * @return
     */
    public static String sendMesRepetitionKey(String phonenum) {
        return getKey(RedisKey.K78,phonenum);
    }

    /**
     * 手机好登陆防止不能多次登陆
     * @param phonenum
     * @return
     */
    public static  String phoneLoginKey(String phonenum){
        return getKey(RedisKey.K80,phonenum);
    }

    /**
     * 发送短信验证码的key（redis锁防止重复发送短信验证码）
     * @param phoneNum
     * @return
     */
    public static  String sendMesKey(String phoneNum){
        return getKey(RedisKey.K79,phoneNum);
    }


    /**
     * 用户第一块地的开启时间
     * @param userId
     * @return
     */
    public static  String getFristLandCreate(Long userId){
        return getKey(RedisKey.K81,userId);
    }

    /**
     * 今日用户获取的金币数量key
     *
     * @param userId    用户id
     * @param taskId    任务 id
     * @param localDate 日期
     */
    public static String todayTaskCoinKey(Long userId, Long taskId, LocalDate localDate) {
        return getKey(RedisKey.K63, userId, taskId, localDate);
    }

    /**
     * 被邀请人阅读文章邀请人结算现金金币key
     * @param userId
     * @param type
     * @return
     */
    public static  String inviteeReadingRewardKey(Long userId,Integer type){
        return getKey(RedisKey.K82, userId, type);
    }


    /**
     * 开土地的自旋锁Key
     * @param userId
     * @param taskId
     * @return
     */
    public static  String openLandKey(Long userId,Integer taskId){
        return getKey(RedisKey.K84, userId, taskId);
    }

    /**
     *  摘红包的自旋锁Key
     * @param userId
     * @param landId
     * @return
     */
    public static  String pickPacketKey(Long userId,Long landId){
        return getKey(RedisKey.K85, userId, landId);
    }

    /**
     * 邀请人获取被邀请人的奖励金锁key
     * @param userId
     * @return
     */
    public static  String getInviteChangeRewardKey(Long userId){
        return getKey(RedisKey.K86, userId);
    }


    /**
     * 好友阅读结算限流key
     * @return
     */
    public static  String getInviteRewardLimitKey(){
        return getKey(RedisKey.K87);
    }


    private static String getKey(RedisKey redisKey, Object... objects) {
        return getKey(NC_PREFIX, redisKey, objects);
    }

    private static String getKey(String prefix, RedisKey redisKey, Object... objects) {


        Joiner joiner = Joiner.on(SEPARATOR).skipNulls();
        List<Object> items = new ArrayList<>();
        items.add(prefix);
        items.add(redisKey);
        items.addAll(Arrays.stream(objects).map(value -> value == null ? "null" : value).collect(Collectors.toList()));
        return joiner.join(items);

    }

    private RedisKeyUtil() {
        // 不允许创建实例
    }

   
}
