package cn.com.duiba.tuia.news.center.log;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;

import static com.alibaba.fastjson.JSON.toJSONString;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: BaseInnerLog.java , v 0.1 2017/7/20 下午4:49 ZhouFeng Exp $
 */
public class BaseInnerLog {

    private static final Logger LOGGER = LoggerFactory.getLogger(BaseInnerLog.class);

    /**
     * 广告平台日志统一分组
     */
    private static final String ADVERT_INNER_LOG_GROUP = "1";

    private static final String DATE_FORMATTER = "yyyy-MM-dd HH:mm:ss";

    public static void log(String json, LogType logType) {

        if (StringUtils.isNotEmpty(json)) {

            BaseInnerRuleDto ruleDto = new BaseInnerRuleDto();
            ruleDto.setGroup(ADVERT_INNER_LOG_GROUP);
            ruleDto.setJson(json);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMATTER);
            ruleDto.setTime(simpleDateFormat.format(new Date()));
            ruleDto.setType(logType.getType());
            String jsonString = toJSONString(ruleDto);
            LOGGER.info("{}", jsonString);

        }

    }

    public static void log(Object object) {
        log(toJSONString(object));
    }

    private BaseInnerLog() {
        // 不可实例化类
    }

}
