package cn.com.duiba.tuia.news.center.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import org.apache.commons.lang.StringUtils;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: VersionUtil.java , v 0.1 2018/7/19 上午10:20 ElinZhou Exp $
 */
public class VersionUtil {

    public static final Long FIRST = 0L;

    public static final Long LAST = 1099511627775L;

    private VersionUtil() {
        throw new UnsupportedOperationException("不可实例化的类");
    }


    public static Long toVersionNumber(String code) {

        if (StringUtils.isBlank(code)) {
            throw new IllegalArgumentException("版本号为空");
        }

        AtomicInteger bit = new AtomicInteger(32);

        return Splitter.on(".").omitEmptyStrings().trimResults().splitToList(code).stream().mapToLong
                (Long::parseLong).reduce(0, (a, b) -> a | (b << bit.getAndAdd(-8)));

    }

    public static String toVersionCode(Long num) {

        if (num == null) {
            throw new IllegalArgumentException("版本号不能为空");
        }
        return Joiner.on(".").join(Stream.iterate(40, bit -> bit -= 8).limit(5).map(bit -> (((long) Math.pow(2, bit)
                - 1) & num) >> bit - 8).map(String::valueOf).collect(Collectors.toList()));
    }

    public static void main(String... args) {
//        System.out.println(Long.toBinaryString((long) Math.pow(2, 33) - 1));
//        System.out.println(Long.toBinaryString(VersionUtil.toVersionNumber("1.2.3.4.5")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1.2.3.4.5")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("0.2.3.4.5")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("100.2.3.4.5")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1.2")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1.2.3")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("0")));
        System.out.println(VersionUtil.toVersionNumber("255.255.255.255.255"));
    }


}
