/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class VersionUtil {
    public static final Long FIRST = 0L;
    public static final Long LAST = 0xFFFFFFFFFFL;

    private VersionUtil() {
        throw new UnsupportedOperationException("\u4e0d\u53ef\u5b9e\u4f8b\u5316\u7684\u7c7b");
    }

    public static Long toVersionNumber(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new IllegalArgumentException("\u7248\u672c\u53f7\u4e3a\u7a7a");
        }
        AtomicInteger bit = new AtomicInteger(32);
        return Splitter.on((String)".").omitEmptyStrings().trimResults().splitToList((CharSequence)code).stream().mapToLong(Long::parseLong).reduce(0L, (a, b) -> a | b << bit.getAndAdd(-8));
    }

    public static String toVersionCode(Long num) {
        if (num == null) {
            throw new IllegalArgumentException("\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Joiner.on((String)".").join((Iterable)Stream.iterate(40, bit -> {
            bit = bit - 8;
            return bit;
        }).limit(5L).map(bit -> ((long)Math.pow(2.0, bit.intValue()) - 1L & num) >> bit - 8).map(String::valueOf).collect(Collectors.toList()));
    }

    public static void main(String ... args) {
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1.2.3.4.5")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("0.2.3.4.5")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("100.2.3.4.5")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1.2")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1.2.3")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("0")));
        System.out.println(VersionUtil.toVersionNumber("1.4.5"));
    }
}

