package cn.com.duiba.tuia.news.center.constant;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: GlobalConstant.java , v 0.1 2018/5/3 上午9:58 ZhouFeng Exp $
 */
public class GlobalConstant {

    /**
     * 用户默认头像
     */
    public static String DEFAULT_USER_HEAD_IMAGE = "http://yun.duiba.com.cn/babi/img/qoyou0eypp.png";

    /**
     * 群红包用户分享任务次数
     */
    public static Long LUCK_PACKET_SHARE_TIMES_ALL = 2L;

    /**
     * 用户默认头像
     */
    public static String DEFAULT_USER_NAME = "趣闻用户";

    /**
     * 限时红包上限
     */
    public static Long LIMIT_PACKET_MAX_COUNT = 588L;

    /**
     * 新的邀请规则开始时间
     */
    public static Date NEW_INVITE_RULE_START_TIME;

    /**
     * 群红包额外增加的金额
     */
    public static Long LUCKY_PACKET_EXTRA_AMOUNT = 588L;

    /**
     * ios审核特殊手机号校验
     */
    public static String IOS_CHECK_PHONE ="13687539776";

    /**
     * 特殊验证码校验
     */
    public static String IOS_CHECK_CODE = "98876";

    /**
     * 成功一元提现后返回的奖励
     */
    public static Long NEW_TICKET_APPLY_REWARD = 58L;

    /**
     * 成功一元提现后返回的奖励1.7.0版本
     */
    public static Long NEW_TICKET_APPLY_REWARD_170 = 28L;



    public static String CONTENT_SUFFIX = "，复制并打开天天趣闻即可自动帮拆";

    public static String CONTENT_PREFIX = "天天趣闻限时红包帮拆口令为";

    public static String OUT_REWARD_TITLE = "现金奖励到账";

    public static String OUT_REWARD_CONTENT = "已存入零钱，可申请提现";

    public static Integer DOG_VALID_DAY = 3;

    public static Integer DOG_STICK_MAX = 10;

    public static Long REFRESH_STRANGER_COIN = 10L;

    public static Map<Integer,List<String>> SELF = new HashMap<>();
    public static Map<Integer,List<String>> OTHER = new HashMap<>();


    public static final Integer BATCH_ID_MAKER_SIZE = 1000;

    static {
        SimpleDateFormat aDate=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        try {
            NEW_INVITE_RULE_START_TIME = aDate.parse("2018-07-01 00:00:00");
        } catch (ParseException e) {
            NEW_INVITE_RULE_START_TIME = new Date();
        }
        SELF.put(1, new ArrayList<>(Arrays.asList("主人，我来守护咱家的红包啦！",
                "主人可以放心出门啦，家里有我在~")));
        SELF.put(2, new ArrayList<>(Arrays.asList("主人，我吓退好几个小贼，成功守护了红包~",
                "有我在，红包一个都没被偷呢~",
                "主人，又有不少红包成熟啦，赶快收取吧~")));
        SELF.put(3, new ArrayList<>(Arrays.asList("啊呜，我被打晕了，主人快去帮我报仇吧~",
                "我奋力抵抗，怎奈小贼有打狗棒....",
                "主人，有人偷了咱们的红包，快去抢回来！")));
        SELF.put(4, new ArrayList<>(Arrays.asList("新的一天要元气满满哦~",
                "阳光超级好，我要沐浴着阳光融化在主人的爱里啦~",
                "睡前来看一下旺财，明天会收获更多红包哦~",
                "邀请好友就有3元奖励哦~",
                "可靠消息，连续签到7天就有最高200元现金哦~",
                "看家只是我的副业，其实我的主业是招财狗~",
                "我仿佛嗅到隔壁红包熟了，主人快去看看吧~",
                "据说阅读文章可以获得更多金币~",
                "今天赚的金币明天都会兑换成零钱哦~",
                "看视频也能获得金币啦！",
                "参与右下角大转盘，赢取丰厚金币奖励~",
                "每当月黑风高的时候，总会思念隔壁的小母狗"
                )));
        OTHER.put(1, new ArrayList<>(Arrays.asList("你是谁！有我在休想偷走红包！",
                "要是来偷红包的话，我劝你还是提前放弃吧",
                "敢偷红包的话，我可是会咬人的！")));
        OTHER.put(2, new ArrayList<>(Arrays.asList("额.....我好像....扛不住了.....",
                "我可不是怕你，只是你的打狗棒太厉害.....",
                "你等着，主人会为我报仇的......")));
        OTHER.put(3, new ArrayList<>(Arrays.asList("我不发威，你还真当我是只宠物狗啊！",
                "我只使出了一成力，再动弹别怪我不客气！",
                "有我在，你是不会成功的！")));
    }


    public static final String SETTLE_NOTICE_ROBOT = "https://oapi.dingtalk" +
            ".com/robot/send?access_token=354e8ec519b05909cf1f258f6b2087102d0c5e4cc8714b0e8bf4a60141ea2329";


    private GlobalConstant() {
        //can not instance
    }


}
