/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.util;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.tuia.news.center.enums.RedisKey;
import cn.com.duiba.tuia.news.center.util.VersionUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Joiner;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class RedisKeyUtil {
    private static final String SEPARATOR = "_";
    private static final String NC_PREFIX = "NC";
    private static final String QUWEN_PREFIX = "QW";

    public static String tokenKey(String token) {
        return RedisKeyUtil.getKey(RedisKey.K49, token);
    }

    public static String uniqueRewardTaskKey(Long userId, Long taskId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K50, userId, taskId, localDate);
    }

    public static String getNewLandStealCountKey() {
        int dayOfMonth = LocalDate.now().getDayOfMonth();
        return RedisKeyUtil.getKey(RedisKey.K449, dayOfMonth);
    }

    public static String rewardTaskLockKey(Long userId, Long taskId) {
        return RedisKeyUtil.getKey(RedisKey.K051, userId, taskId);
    }

    public static String unsettleCoinsKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K52, userId);
    }

    public static String yesterdayIncomeKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K53, userId);
    }

    public static String settledChangeKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K54, userId);
    }

    public static String allReadTaskNumKeyNew(Long userId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K68, userId, localDate);
    }

    public static String allWatchingTaskNumKeyNew(Long userId, LocalDate localDate, String version) {
        if (StringUtils.isBlank((String)version) || VersionUtil.toVersionNumber(version) < VersionUtil.toVersionNumber("1.8.0")) {
            return RedisKeyUtil.allReadTaskNumKeyNew(userId, localDate);
        }
        return RedisKeyUtil.getKey(RedisKey.K415, userId, localDate);
    }

    public static String withdrawKey(Long userId, Integer source, Long fee) {
        return RedisKeyUtil.getKey(RedisKey.K072, userId, source, fee);
    }

    public static String versionKey() {
        return RedisKeyUtil.getKey(RedisKey.K69, new Object[0]);
    }

    public static String probabilityAndPerNumKey() {
        return RedisKeyUtil.getKey(RedisKey.K70, new Object[0]);
    }

    public static String PerNumKey() {
        return RedisKeyUtil.getKey(RedisKey.K71, new Object[0]);
    }

    public static String verificationCodeKey(String phoneNum) {
        return RedisKeyUtil.getKey(RedisKey.K75, phoneNum);
    }

    public static String sendMesCountKey(String deviceId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K76, deviceId, localDate);
    }

    public static String helpList(String unionId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K88, unionId, localDate);
    }

    public static String helpLock(Long packetId) {
        return RedisKeyUtil.getKey(RedisKey.K089, packetId);
    }

    public static String limitWithdraw(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K090, userId);
    }

    public static String sendMesRepetitionKey(String phonenum) {
        return RedisKeyUtil.getKey(RedisKey.K78, phonenum);
    }

    public static String phoneLoginKey(String phonenum) {
        return RedisKeyUtil.getKey(RedisKey.K80, phonenum);
    }

    public static String sendMesKey(String phoneNum) {
        return RedisKeyUtil.getKey(RedisKey.K79, phoneNum);
    }

    public static String getFristLandCreate(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K81, userId);
    }

    public static String todayTaskCoinKey(Long userId, Long taskId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K63, userId, taskId, localDate);
    }

    public static String inviteeReadingRewardKey(Long userId, Integer type) {
        return RedisKeyUtil.getKey(RedisKey.K082, userId, type);
    }

    public static String openLandKey(Long userId, Integer taskId) {
        return RedisKeyUtil.getKey(RedisKey.K084, userId, taskId);
    }

    public static String pickPacketKey(Long userId, Long landId) {
        return RedisKeyUtil.getKey(RedisKey.K85, userId, landId);
    }

    public static String getInviteChangeRewardKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K86, userId);
    }

    public static String wechatAccessToken(String code) {
        if (SpringEnvironmentUtils.isPreEnv()) {
            return RedisKeyUtil.getKey(RedisKey.K442, code);
        }
        return RedisKeyUtil.getKey(RedisKey.K93, code);
    }

    public static String newWechatAccessToken(String code, Integer dangerLevel) {
        if (dangerLevel == null) {
            return RedisKeyUtil.wechatAccessToken(code);
        }
        if (SpringEnvironmentUtils.isPreEnv()) {
            return RedisKeyUtil.getKey(RedisKey.K442, dangerLevel, code);
        }
        return RedisKeyUtil.getKey(RedisKey.K93, dangerLevel, code);
    }

    public static String getInviteRewardLimitKey() {
        return RedisKeyUtil.getKey(RedisKey.K87, new Object[0]);
    }

    public static String getWaitPushKey(LocalDateTime time) {
        return RedisKeyUtil.getKey(RedisKey.K91, time.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
    }

    public static String getWaitPushLockKey() {
        return RedisKeyUtil.getKey(RedisKey.K91, new Object[0]);
    }

    public static String openLimitPacketKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K095, userId);
    }

    public static String wechatToken() {
        if (SpringEnvironmentUtils.isPreEnv()) {
            return RedisKeyUtil.getKey(RedisKey.K406, new Object[0]);
        }
        return RedisKeyUtil.getKey(RedisKey.K96, new Object[0]);
    }

    public static String newWechatToken(Integer dangerLevel) {
        if (dangerLevel == null) {
            return RedisKeyUtil.wechatToken();
        }
        if (SpringEnvironmentUtils.isPreEnv()) {
            return RedisKeyUtil.getKey(RedisKey.K406, dangerLevel);
        }
        return RedisKeyUtil.getKey(RedisKey.K96, dangerLevel);
    }

    public static String wechatTicket() {
        if (SpringEnvironmentUtils.isPreEnv()) {
            return RedisKeyUtil.getKey(RedisKey.K293, new Object[0]);
        }
        return RedisKeyUtil.getKey(RedisKey.K97, new Object[0]);
    }

    public static String newWechatTicket(Integer dangerLevel) {
        if (dangerLevel == null) {
            return RedisKeyUtil.wechatTicket();
        }
        if (SpringEnvironmentUtils.isPreEnv()) {
            return RedisKeyUtil.getKey(RedisKey.K293, dangerLevel);
        }
        return RedisKeyUtil.getKey(RedisKey.K97, dangerLevel);
    }

    public static String newsHelpKey(Long packetId) {
        return RedisKeyUtil.getKey(RedisKey.K098, packetId);
    }

    public static String wechatUserInfo(String openId) {
        return RedisKeyUtil.getKey(RedisKey.K99, openId);
    }

    public static String shareInviteKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K0100, userId);
    }

    public static String lastRefreshFarm(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K103, userId);
    }

    public static String todayReflashStranger(Long userId, LocalDate date) {
        return RedisKeyUtil.getKey(RedisKey.K106, userId, date);
    }

    public static String strangerList(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K107, userId);
    }

    public static String canPickUserIdSet() {
        return RedisKeyUtil.getKey(RedisKey.K108, new Object[0]);
    }

    public static String operateUserIdFarm(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K108, userId);
    }

    public static String getNewFristLandCreate(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K110, userId);
    }

    public static String getLandUsersOpt(String time) {
        return RedisKeyUtil.getKey(RedisKey.K111, time);
    }

    public static String moveInviteToFriend(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K112, userId);
    }

    public static String alreadyGetInviteChange(Long userId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K113, userId, localDate);
    }

    public static String getDogDefeanse(Long userId, Long dogUserId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K114, userId, dogUserId, localDate);
    }

    public static String pickAssistantLastTime(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K115, userId);
    }

    public static String getDogProp(Long userId, Integer taskId, LocalDate date) {
        return RedisKeyUtil.getKey(RedisKey.K116, userId, taskId, date);
    }

    public static String getFriendAndSecondPacketIds(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K117, userId);
    }

    public static String applyFriendKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K118, userId);
    }

    public static String operateFriendApply(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K119, userId);
    }

    public static String doublePacketLock(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K0121, userId);
    }

    public static String luckPacketReady(Long userId, String timesStamp) {
        return RedisKeyUtil.getKey(RedisKey.K122, userId, timesStamp);
    }

    public static String todayGetLuckPacketTimes(String unionId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K123, unionId, localDate);
    }

    public static String todaySendPushLuckPacketTimes(Long userId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K124, userId, localDate);
    }

    public static String openLuckPacket(Long packetId) {
        return RedisKeyUtil.getKey(RedisKey.K125, packetId);
    }

    public static String getWaitTagKey(LocalDateTime time) {
        return RedisKeyUtil.getKey(RedisKey.K126, time.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
    }

    public static String getWaitTagLockKey() {
        return RedisKeyUtil.getKey(RedisKey.K126, new Object[0]);
    }

    public static String waitPick(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K128, userId);
    }

    public static String pointAppCondition(Long userId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K131, userId, localDate);
    }

    public static String pointWechatCondition(String unionId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K132, unionId, localDate);
    }

    public static String getOpenUrlPointTime(String unionId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K133, unionId, localDate);
    }

    public static String appPointPump(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K0134, userId);
    }

    public static String wechatPointPump(String unionId) {
        return RedisKeyUtil.getKey(RedisKey.K0135, unionId);
    }

    public static String pointOperateRecord(String time) {
        return RedisKeyUtil.getKey(RedisKey.K136, time);
    }

    public static String getDailyTaskKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K140, userId, DateUtils.getDayStr((Date)new Date()));
    }

    public static String luckPacketSendTimesToday(Long userId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K139, userId, localDate);
    }

    public static String pointWithdraw(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K142, userId);
    }

    public static String getSignInLockKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K0143, userId);
    }

    public static String getUserAlreadyReadingKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K230, userId);
    }

    public static String getSignInDateContent(Date date) {
        return RedisKeyUtil.getKey(RedisKey.K145, DateUtils.getDayStr((Date)date));
    }

    public static String getUserSignInShareRewardFlag(Long userId, Date date) {
        return RedisKeyUtil.getKey(RedisKey.K146, userId, DateUtils.getDayStr((Date)date));
    }

    public static String getUserSignInShareRewardRecord(String openid, Date date) {
        return RedisKeyUtil.getKey(RedisKey.K147, openid, DateUtils.getDayStr((Date)date));
    }

    public static String getNormalPlanReward(Long userId, LocalDate date) {
        return RedisKeyUtil.getKey(RedisKey.K159, userId, date);
    }

    public static String inviteRecordByInviteeKey(Long inviteeId) {
        return RedisKeyUtil.getKey(RedisKey.K157, inviteeId);
    }

    public static String todayCoinBalanceKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K158, userId);
    }

    public static String initNewLandFinishKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K160, userId);
    }

    public static String getCanStealIdListKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K179, userId);
    }

    public static String farmDogKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K176, userId);
    }

    public static String getRandomUserListKey(Date date) {
        return RedisKeyUtil.getKey(RedisKey.K445, DateUtils.getDayStr((Date)date));
    }

    public static String getNormalLockKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K171, userId);
    }

    public static String getNewTaskCache(Long userId, LocalDate localDate, Integer taskId) {
        return RedisKeyUtil.getKey(RedisKey.K172, userId, localDate, taskId);
    }

    public static String getNormalTaskCache(Long userId, LocalDate localDate, Integer taskId) {
        return RedisKeyUtil.getKey(RedisKey.K173, userId, localDate, taskId);
    }

    public static String getLoginUserPhone(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K178, userId);
    }

    public static String getUserTaskInfo(Long userId, Integer taskType) {
        return RedisKeyUtil.getKey(RedisKey.K180, userId, taskType);
    }

    public static String addEnemyLock(Long userId, Long enemyId) {
        return RedisKeyUtil.getKey(RedisKey.K175, userId, enemyId);
    }

    public static String getFristSignReward(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K187, userId);
    }

    public static String userChangeBalanceCacheKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K177, userId);
    }

    public static String newCashPacketCacheKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K189, userId);
    }

    public static String userStolenPacketKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K195, userId);
    }

    public static String userDailyRecordIdCacheKey(Long userId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K184, userId, localDate);
    }

    public static String userWechatCheckInfoForUserId(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K185, userId);
    }

    public static String userWechatCheckInfoForOpenId(String openId) {
        return RedisKeyUtil.getKey(RedisKey.K186, openId);
    }

    public static String getUserCashPacketKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K181, userId);
    }

    public static String getUserJiGuangRegistrationId(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K183, userId);
    }

    public static String getDeviceIMEIKey(String deviceId, String imei) {
        return RedisKeyUtil.getKey(RedisKey.K191, deviceId, imei);
    }

    public static String getDeviceRegIdKey(String deviceId, String regId) {
        return RedisKeyUtil.getKey(RedisKey.K198, deviceId, regId);
    }

    public static String lastRipePacketKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K190, userId);
    }

    public static String getTaskByUserId(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K192, userId);
    }

    public static String getHaveInitTask(Long userId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K205, userId, localDate);
    }

    public static String initTaskLock(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K206, userId);
    }

    public static String getUserCacheKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K200, userId);
    }

    public static String getUserLandCacheKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K201, userId);
    }

    public static String getUserActionCacheKey(Long userId, Integer actionType) {
        return RedisKeyUtil.getKey(RedisKey.K202, userId, actionType);
    }

    public static String getOwnPageConfigKey(Integer platform) {
        return RedisKeyUtil.getKey(RedisKey.K221, platform);
    }

    public static String getNewUserReadingGuideKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K226, userId);
    }

    public static String getInviteeCacheKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K222, userId);
    }

    public static String getDogStitckKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K225, userId);
    }

    public static String getCityListKey() {
        return RedisKeyUtil.getKey(RedisKey.K250, new Object[0]);
    }

    public static String getFirstLevelCityListKey() {
        return RedisKeyUtil.getKey(RedisKey.K253, new Object[0]);
    }

    public static String getUserActionUpdateSetKey(int userActionType, Date date, Long userId) {
        Long num = userId % 1024L;
        String tb = num.toString();
        if (num < 10L) {
            tb = "000" + num;
        } else if (num >= 10L && num < 100L) {
            tb = "00" + num;
        } else if (num >= 100L && num < 1000L) {
            tb = "0" + num;
        }
        return RedisKeyUtil.getKey(RedisKey.K229, userActionType, DateUtils.getDayStr((Date)date), tb);
    }

    public static String getRateKey(Date date) {
        return RedisKeyUtil.getKey(RedisKey.K227, DateUtils.getDayNumber((Date)date));
    }

    public static String getInsertTicketKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K242, userId);
    }

    public static String dynamicSourceSwitch() {
        return RedisKeyUtil.getKey(QUWEN_PREFIX, RedisKey.KEY02, new Object[0]);
    }

    public static String rewardTaskKey(Long userId, Long taskId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K252, userId, taskId, localDate);
    }

    public static String enemyListCacheKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K255, userId);
    }

    public static String beStealUserList(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K258, userId);
    }

    public static String missionProgress(Long missionId, Long userId) {
        Calendar calendar = Calendar.getInstance();
        int i = calendar.get(5);
        return RedisKeyUtil.getKey(RedisKey.K266, missionId, userId, i);
    }

    public static String missionRecordList(Long userId, Integer missionType) {
        return RedisKeyUtil.getKey(RedisKey.K267, userId, missionType);
    }

    public static String missionProgressStatus(Long userId, Long missionId) {
        Calendar calendar = Calendar.getInstance();
        int i = calendar.get(5);
        return RedisKeyUtil.getKey(RedisKey.K272, missionId, userId, i);
    }

    public static String getObjectRewardKey(Long userId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K262, userId, localDate);
    }

    public static String getObjectRewardLock(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K263, userId);
    }

    public static String getRiskWeekKey(String userInfo) {
        return RedisKeyUtil.getKey(RedisKey.K269, userInfo);
    }

    public static String getRiskDayKey(String userInfo, String date) {
        return RedisKeyUtil.getKey(RedisKey.K268, userInfo, date);
    }

    public static String getPartnerCacheKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K274, userId);
    }

    public static String getUpdatePddOrderForPidSet() {
        return RedisKeyUtil.getKey(RedisKey.K278, new Object[0]);
    }

    public static String getLastUpdatePddOrderTimeKey() {
        return RedisKeyUtil.getKey(RedisKey.K280, new Object[0]);
    }

    public static String getReadRewardListKey(Long userId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K283, userId, localDate);
    }

    public static String bindPhoneKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K285, userId);
    }

    public static String fristWithdraw(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K289, userId);
    }

    public static String getLoginRewardList(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K291, userId);
    }

    public static String addLoginRewardPlanKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K292, userId);
    }

    public static String readingRankingListKey(int topN) {
        return RedisKeyUtil.getKey(RedisKey.K290, topN);
    }

    public static String fristWithdrawRewardKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K297, userId);
    }

    public static String getKey(RedisKey redisKey, Object ... objects) {
        return RedisKeyUtil.getKey(NC_PREFIX, redisKey, objects);
    }

    public static String getXcxDayGoldLimitKey(String openId) {
        int dayOfMonth = DateTime.now().getDayOfMonth();
        return RedisKeyUtil.getKey(RedisKey.K294, openId, dayOfMonth);
    }

    public static String getXcxUserShareArtKey(String openId, Long artId) {
        return RedisKeyUtil.getKey(RedisKey.K295, openId, artId);
    }

    public static String getXcxUserDayFirstShareKey(String openId) {
        int dayOfMonth = DateTime.now().getDayOfMonth();
        return RedisKeyUtil.getKey(RedisKey.K408, openId, dayOfMonth);
    }

    public static String getXcxUserDaySignKey(String openId) {
        int dayOfMonth = DateTime.now().getDayOfMonth();
        return RedisKeyUtil.getKey(RedisKey.K409, openId, dayOfMonth);
    }

    public static String getXcxUserVisitRewardKey(String openId) {
        return RedisKeyUtil.getKey(RedisKey.K296, openId);
    }

    public static String getUpdatePddOrderForUserIdSet() {
        return RedisKeyUtil.getKey(RedisKey.K416, new Object[0]);
    }

    public static String allPromotion(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K413, userId);
    }

    public static String getNewUserGetTicketFlagKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K411, userId);
    }

    public static String getNewUserTicketLockKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K414, userId);
    }

    public static String getPddPidByUserId(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K418, userId);
    }

    public static String getXcxUserShareCount(String openId) {
        int dayOfMonth = DateTime.now().getDayOfMonth();
        return RedisKeyUtil.getKey(RedisKey.K420, openId, dayOfMonth);
    }

    public static String getXcxUserShareRewardStatusKey(String openId) {
        int dayOfMonth = DateTime.now().getDayOfMonth();
        return RedisKeyUtil.getKey(RedisKey.K420, "r", openId, dayOfMonth);
    }

    public static String getXcxUserReadCount(String openId) {
        int dayOfMonth = DateTime.now().getDayOfMonth();
        return RedisKeyUtil.getKey(RedisKey.K421, openId, dayOfMonth);
    }

    public static String getNewSubRewardCacheKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K425, userId);
    }

    public static String getRollCacheKey() {
        return RedisKeyUtil.getKey(RedisKey.K426, new Object[0]);
    }

    public static String getLoginSubRewardKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K428, new Object[0]);
    }

    public static String getXcxUserInviteGoldKey(String openId) {
        return RedisKeyUtil.getKey(RedisKey.K422, openId);
    }

    public static String getCoinBoxLockKey(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K424, userId);
    }

    public static String getCoinBoxShareReadRewardKey(Long boxId) {
        return RedisKeyUtil.getKey(RedisKey.K434, boxId);
    }

    public static String getCashLimitNow(LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K446, localDate);
    }

    public static String mammonFinance() {
        return RedisKeyUtil.getKey(QUWEN_PREFIX, RedisKey.KEY09, new Object[0]);
    }

    public static String getCoinBoxShareRewardUserIdList(String openid, LocalDate date) {
        return RedisKeyUtil.getKey(RedisKey.K430, openid, date);
    }

    public static String getPidCache(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K441, userId);
    }

    public static String doEventLock(Long userId, String eventType) {
        return RedisKeyUtil.getKey(RedisKey.K444, userId, eventType);
    }

    public static String getPddHelpGoodsLimitKey(Long userId, LocalDate date) {
        return RedisKeyUtil.getKey(RedisKey.K451, userId, date);
    }

    public static String oneWithdrawPullNew(Long userId) {
        return RedisKeyUtil.getKey(RedisKey.K452, userId);
    }

    public static String checkWhiteCache(String version, String source) {
        return RedisKeyUtil.getKey(RedisKey.K448, version, source);
    }

    private static String getKey(String prefix, RedisKey redisKey, Object ... objects) {
        Joiner joiner = Joiner.on((String)SEPARATOR).skipNulls();
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(prefix);
        items.add((Object)redisKey);
        items.addAll(Arrays.stream(objects).map(value -> value == null ? "null" : value).collect(Collectors.toList()));
        return joiner.join(items);
    }

    private RedisKeyUtil() {
    }
}

