package cn.com.duiba.tuia.news.center.constant;

import cn.com.duiba.tuia.news.center.enums.DataBase;

import java.util.HashSet;
import java.util.Set;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: DataBaseInvokeRegister.java , v 0.1 2018/7/9 下午9:53 ZhouFeng Exp $
 */
public class DataBaseInvokeRegister {

    private static final ThreadLocal<Set<DataBase>> THREAD_LOCAL = new ThreadLocal<>();

    private DataBaseInvokeRegister() {
    }

    public static void regist(DataBase dataBase) {
        if (THREAD_LOCAL.get() == null) {
            THREAD_LOCAL.set(new HashSet<>(16));
        }

        THREAD_LOCAL.get().add(dataBase);
    }


    public static Set<DataBase> getRegisted() {
        return THREAD_LOCAL.get();
    }

    public static void clear() {
        THREAD_LOCAL.set(null);
    }
}
