package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: DataBase.java , v 0.1 2018/7/9 下午9:43 ZhouFeng Exp $
 */
public enum DataBase {
    /**
     * 趣闻主库
     */
    NEWS,

    /**
     * 用户库
     */
    USER,


    /**
     * 金币库
     */
    COIN,

    /**
     * 零钱库
     */
    CHANGE,

    /**
     * 统计库
     */
    STATISTICS;

    private static final Map<String, DataBase> CACHE = Maps.uniqueIndex(Arrays.asList(DataBase.values()),
            DataBase::name);


    public static DataBase of(String name) {
        return CACHE.get(name);
    }

}
