/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.app;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCode;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.compute.biz.bo.PsBo;
import cn.com.duiba.nezha.compute.biz.bo.StdCoderModelSaveBo;
import cn.com.duiba.nezha.compute.biz.constant.feature.FeatureCoderModelListConstant;
import cn.com.duiba.nezha.compute.biz.dto.DenseCoderDo;
import cn.com.duiba.nezha.compute.biz.dto.PsModelSample;
import cn.com.duiba.nezha.compute.biz.dto.SparceCoderDo;
import cn.com.duiba.nezha.compute.biz.dto.SparceCoderStatDo;
import cn.com.duiba.nezha.compute.biz.enums.AdvertTypeEnum;
import cn.com.duiba.nezha.compute.biz.enums.hbase.HbaseOpsEnum;
import cn.com.duiba.nezha.compute.biz.enums.model.ModelKeyEnum;
import cn.com.duiba.nezha.compute.biz.ps.PsAgent;
import cn.com.duiba.nezha.compute.biz.support.SampleParse;
import cn.com.duiba.nezha.compute.core.FeatureValue;
import cn.com.duiba.nezha.compute.core.LabeledDpFeature;
import cn.com.duiba.nezha.compute.core.LabeledSparseDpaFeature;
import cn.com.duiba.nezha.compute.core.LabeledSparsePoint;
import cn.com.duiba.nezha.compute.core.model.local.LocalModel;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.core.util.DateUtil;
import cn.com.duiba.nezha.compute.core.vo.Feature;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.sql.Row;
import scala.collection.Iterator;

public class FeatureCoderApp {
    public static Boolean sparceCodeOffline(Iterator<Row> partitionOfRecords, String modelId) throws Exception {
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sparceCodeOffline");
        ArrayList<PsModelSample> samples = new ArrayList<PsModelSample>();
        int i = 0;
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(2));
                String feature = row.getString(3);
                psModelSample.setFeature(feature);
                if (i < 3) {
                    System.out.println(JSON.toJSONString((Object)psModelSample));
                }
                samples.add(psModelSample);
                if (++i <= 100 || i % 10000 != 0) continue;
                FeatureCoderApp.sparceCodeOfflineBatch(samples, modelId);
                samples.clear();
                System.gc();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<LabeledSparsePoint> labeledSparsePointList = SampleParse.parseOfEachField(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        System.out.println("sparceCodeOffline.labeledSparsePointList.size=" + labeledSparsePointList.size());
        FeatureCoderApp.updateSparceCode(labeledSparsePointList, modelId);
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
        return true;
    }

    public static Boolean dpCodeOffline(Iterator<Row> partitionOfRecords, String modelId) throws Exception {
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  dpCodeOffline");
        ArrayList<PsModelSample> samples = new ArrayList<PsModelSample>();
        int i = 0;
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                String feature = row.getString(1);
                psModelSample.setJoinCnt(row.getLong(2));
                psModelSample.setFee((long)row.getDouble(3));
                psModelSample.setFeature(feature);
                if (i % 100000 == 0) {
                    System.out.println("psModelSample: " + JSON.toJSONString((Object)psModelSample));
                }
                samples.add(psModelSample);
                if (++i <= 100 || i % 10000 != 0) continue;
                FeatureCoderApp.sparceDpCodeOfflineBatch(samples, modelId);
                samples.clear();
                System.gc();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("FeatureCoderModelListConstant.getCoderFeatureList\uff1a" + JSON.toJSONString(FeatureCoderModelListConstant.getCoderFeatureList(modelId)));
        List<LabeledDpFeature> labeledSparsePointList = SampleParse.dpParseOfEachField(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        System.out.println("sparceCodeOffline.labeledSparsePointList.size=" + labeledSparsePointList.size());
        FeatureCoderApp.updateDpSparceCode(labeledSparsePointList, modelId);
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
        return true;
    }

    public static Boolean sparceDpCodeOfflineBatch(List<PsModelSample> samples, String modelId) throws Exception {
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sparceDpCodeOfflineBatch start");
        List<LabeledDpFeature> labeledSparsePointList = SampleParse.dpParseOfEachField(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        System.out.println("sparceDpCodeOffline.labeledSparsePointList.size=" + labeledSparsePointList.size());
        FeatureCoderApp.updateDpSparceCode(labeledSparsePointList, modelId);
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sparceDpCodeOfflineBatch end ");
        return true;
    }

    public static Boolean materialCodeOffline(Iterator<Row> partitionOfRecords, String modelId) throws Exception {
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  materialCodeOffline");
        ArrayList<PsModelSample> samples = new ArrayList<PsModelSample>();
        int i = 0;
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                String feature = row.getString(1);
                psModelSample.setFeature(feature);
                if (i % 100000 == 0) {
                    System.out.println("psModelSample: " + JSON.toJSONString((Object)psModelSample));
                }
                samples.add(psModelSample);
                if (++i <= 100 || i % 10000 != 0) continue;
                FeatureCoderApp.sparceCodeOfflineBatch(samples, modelId);
                samples.clear();
                System.gc();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<LabeledSparsePoint> labeledSparsePointList = SampleParse.parseOfEachField(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        System.out.println("sparceCodeOffline.labeledSparsePointList.size=" + labeledSparsePointList.size());
        FeatureCoderApp.updateSparceCode(labeledSparsePointList, modelId);
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
        return true;
    }

    public static Boolean sparceCodeOfflineBatch(List<PsModelSample> samples, String modelId) throws Exception {
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sparceCodeOfflineBatch start");
        List<LabeledSparsePoint> labeledSparsePointList = SampleParse.parseOfEachField(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        System.out.println("sparceCodeOffline.labeledSparsePointList.size=" + labeledSparsePointList.size());
        FeatureCoderApp.updateSparceCode(labeledSparsePointList, modelId);
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sparceCodeOfflineBatch end ");
        return true;
    }

    public static List<FeatureValue> sparceCodeOffline(Iterator<Row> partitionOfRecords, double sampleRatio, String modelId, AdvertTypeEnum advertTypeEnum) throws Exception {
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sparceCodeOffline");
        ArrayList<PsModelSample> samples = new ArrayList<PsModelSample>();
        int i = 0;
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(2));
                String feature = row.getString(3);
                psModelSample.setFeature(feature);
                if (i < 3) {
                    System.out.println(JSON.toJSONString((Object)psModelSample));
                }
                ++i;
                samples.add(psModelSample);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<LabeledSparsePoint> labeledSparsePointList = SampleParse.parseOfEachField(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        System.out.println("sparceCodeOffline.labeledSparsePointList.size=" + labeledSparsePointList.size());
        FeatureCoderApp.updateSparceCode(labeledSparsePointList, modelId);
        List<FeatureValue> featureValueList = SampleParse.parseFieldFeatures(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
        return featureValueList;
    }

    public static List<String> getRawSample(Iterator<String> partitionOfRecords, double sampleRatio, String modelId, AdvertTypeEnum advertTypeEnum) throws Exception {
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sparceCode");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            if (!(Math.random() < sampleRatio) || orderId == null) continue;
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList, advertTypeEnum);
        ArrayList<String> ret = new ArrayList<String>();
        for (PsModelSample sample : samples) {
            ret.add(JSON.toJSONString((Object)sample));
        }
        return ret;
    }

    public static List<FeatureValue> sparceCodeV2(Iterator<String> partitionOfRecords, double sampleRatio, String modelId, AdvertTypeEnum advertTypeEnum) throws Exception {
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + " sparceCodeV2 start \u7279\u5f81-\u7a00\u758f\u7f16\u7801 ");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            if (!(Math.random() < sampleRatio) || orderId == null) continue;
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList, advertTypeEnum);
        System.out.println("samples=" + JSON.toJSONString((Object)samples.get(0)));
        System.out.println(JSON.toJSONString(FeatureCoderModelListConstant.getCoderFeatureList(modelId)));
        List<Map<String, FeatureCode>> labeledSparsePointList = SampleParse.parseOfEachFieldV2(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        FeatureCoderApp.updateSparceCodeV2(labeledSparsePointList, modelId);
        List<FeatureValue> featureValueList = SampleParse.parseFieldFeatures(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sparceCodeV2 end  \u7279\u5f81-\u7a00\u758f\u7f16\u7801 ");
        return featureValueList;
    }

    public static List<FeatureValue> sparceCode(Iterator<String> partitionOfRecords, double sampleRatio, String modelId, AdvertTypeEnum advertTypeEnum) throws Exception {
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sparceCode");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            if (!(Math.random() < sampleRatio) || orderId == null) continue;
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList, advertTypeEnum);
        System.out.println("samples=" + JSON.toJSONString((Object)samples.get(0)));
        System.out.println(JSON.toJSONString(FeatureCoderModelListConstant.getCoderFeatureList(modelId)));
        if (advertTypeEnum.equals((Object)AdvertTypeEnum.DPA_ACT) || advertTypeEnum.equals((Object)AdvertTypeEnum.DPA_ACT_NON_SDK) || advertTypeEnum.equals((Object)AdvertTypeEnum.DPA_INTERCEPT)) {
            List<LabeledSparseDpaFeature> labeledSparseDpaFeatures = SampleParse.parseOfEachField2(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
            FeatureCoderApp.updateSparceCode2(labeledSparseDpaFeatures, modelId);
        } else {
            List<LabeledSparsePoint> labeledSparsePointList = SampleParse.parseOfEachField(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
            FeatureCoderApp.updateSparceCode(labeledSparsePointList, modelId);
        }
        List<FeatureValue> featureValueList = SampleParse.parseFieldFeatures(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
        return featureValueList;
    }

    public static List<FeatureValue> sparceCodeAdx(Iterator<String> partitionOfRecords, double sampleRatio, String modelId, AdvertTypeEnum advertTypeEnum) throws Exception {
        System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sparceCode");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            if (!(Math.random() < sampleRatio) || orderId == null) continue;
            orderIdList.add(orderId);
        }
        List<PsModelSample> retTmp = PsBo.getPsSample(orderIdList, advertTypeEnum);
        if (retTmp != null) {
            List<PsModelSample> samples = retTmp.stream().filter(Objects::nonNull).filter(FeatureCoderApp::validSample).collect(Collectors.toList());
            System.out.println("samples=" + JSON.toJSONString(samples.get(0)));
            System.out.println("filter samples list size: " + samples.size());
            System.out.println(JSON.toJSONString(FeatureCoderModelListConstant.getCoderFeatureList(modelId)));
            if (advertTypeEnum.equals((Object)AdvertTypeEnum.DPA_ACT) || advertTypeEnum.equals((Object)AdvertTypeEnum.DPA_ACT_NON_SDK) || advertTypeEnum.equals((Object)AdvertTypeEnum.DPA_INTERCEPT)) {
                List<LabeledSparseDpaFeature> labeledSparseDpaFeatures = SampleParse.parseOfEachField2(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
                FeatureCoderApp.updateSparceCode2(labeledSparseDpaFeatures, modelId);
            } else {
                List<LabeledSparsePoint> labeledSparsePointList = SampleParse.parseOfEachField(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
                FeatureCoderApp.updateSparceCode(labeledSparsePointList, modelId);
            }
            List<FeatureValue> featureValueList = SampleParse.parseFieldFeatures(samples, FeatureCoderModelListConstant.getCoderFeatureList(modelId));
            System.out.println(DateUtil.getCurrentTime((cn.com.duiba.nezha.compute.core.enums.DateStyle)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
            return featureValueList;
        }
        return null;
    }

    public static boolean validSample(PsModelSample psModelSample) {
        boolean ret = false;
        double label = FeatureCoderApp.toLabel(psModelSample.getIsClick());
        String feature = psModelSample.getFeature();
        JSONObject featureMap = JSONObject.parseObject((String)feature);
        if (featureMap == null) {
            return false;
        }
        String app_id = featureMap.getOrDefault("f201001", "-1");
        if (label > 0.5 && app_id.equals("67018")) {
            ret = true;
        }
        return ret;
    }

    public static double toLabel(Long isClick) {
        double label = 0.0;
        if (FeatureCoderApp.valid(isClick)) {
            label = 1.0;
        }
        return label;
    }

    public static boolean valid(Long val) {
        boolean ret = false;
        if (val != null && (double)val.longValue() > 0.1) {
            ret = true;
        }
        return ret;
    }

    public static void updateSparceCodeV2(List<Map<String, FeatureCode>> samples, String modelId) throws Exception {
        if (samples == null || samples.size() < 1) {
            return;
        }
        PsAgent psAgent = new PsAgent(modelId, 1000000, 1);
        SparceCoderStatDo sparceCoderStatDo = FeatureCoderApp.getIncrModelV2(samples);
        LocalModel sparceCountIncrModel = sparceCoderStatDo.sparceCountToLocalModel();
        LocalModel sparceLastTimeUpdateModel = sparceCoderStatDo.sparceLastTimeToLocalModel();
        psAgent.push(sparceCountIncrModel, HbaseOpsEnum.INCREMENT);
        psAgent.push(sparceLastTimeUpdateModel, HbaseOpsEnum.INSERT_AND_UPDATE);
    }

    public static void updateSparceCode(List<LabeledSparsePoint> samples, String modelId) throws Exception {
        if (samples == null || samples.size() < 1) {
            return;
        }
        PsAgent psAgent = new PsAgent(modelId, 1000000, 1);
        SparceCoderStatDo sparceCoderStatDo = FeatureCoderApp.getIncrModel(samples);
        LocalModel sparceCountIncrModel = sparceCoderStatDo.sparceCountToLocalModel();
        LocalModel sparceLastTimeUpdateModel = sparceCoderStatDo.sparceLastTimeToLocalModel();
        psAgent.push(sparceCountIncrModel, HbaseOpsEnum.INCREMENT);
        psAgent.push(sparceLastTimeUpdateModel, HbaseOpsEnum.INSERT_AND_UPDATE);
    }

    public static void updateDpSparceCode(List<LabeledDpFeature> samples, String modelId) throws Exception {
        if (samples == null || samples.size() < 1) {
            return;
        }
        PsAgent psAgent = new PsAgent(modelId, 1000000, 1);
        SparceCoderStatDo sparceCoderStatDo = FeatureCoderApp.getDpIncrModel(samples);
        LocalModel sparceCountIncrModel = sparceCoderStatDo.sparceCountToLocalModel();
        LocalModel sparceLastTimeUpdateModel = sparceCoderStatDo.sparceLastTimeToLocalModel();
        psAgent.push(sparceCountIncrModel, HbaseOpsEnum.INCREMENT);
        psAgent.push(sparceLastTimeUpdateModel, HbaseOpsEnum.INSERT_AND_UPDATE);
    }

    public static void updateSparceCode2(List<LabeledSparseDpaFeature> samples, String modelId) throws Exception {
        if (samples == null || samples.size() < 1) {
            return;
        }
        PsAgent psAgent = new PsAgent(modelId, 1000000, 1);
        SparceCoderStatDo sparceCoderStatDo = FeatureCoderApp.getIncrModel2(samples);
        LocalModel sparceCountIncrModel = sparceCoderStatDo.sparceCountToLocalModel();
        LocalModel sparceLastTimeUpdateModel = sparceCoderStatDo.sparceLastTimeToLocalModel();
        psAgent.push(sparceCountIncrModel, HbaseOpsEnum.INCREMENT);
        psAgent.push(sparceLastTimeUpdateModel, HbaseOpsEnum.INSERT_AND_UPDATE);
    }

    public static List<FeatureValue> sparceCodeOfFields(String sparceKey, List<FeatureValue> list, String modelId) throws Exception {
        System.out.println("sparceCodeOfFields \u7a00\u758f-\u7279\u5f81\u7f16\u7801 start");
        ArrayList<Object> ret = new ArrayList<FeatureValue>();
        if (AssertUtil.isEmpty(list)) {
            return ret;
        }
        SparceCoderDo sparceCoderDo = StdCoderModelSaveBo.getFieldSparceCoderByKeyFromJedis(sparceKey);
        if (sparceCoderDo == null) {
            sparceCoderDo = new SparceCoderDo();
        }
        System.out.println("sparceCodeOfFields \u83b7\u53d6\u7a00\u758f\u7f16\u7801 sparceCoderDo.getUpdateTime()=" + sparceCoderDo.getUpdateTime());
        System.out.println("sparceCodeOfFields \u83b7\u53d6\u7a00\u758f\u7f16\u7801 sparceCoderDo.getSyncTime()=" + sparceCoderDo.getSyncTime());
        if (AssertUtil.isEmpty(sparceCoderDo.getFeaturesCoderMap())) {
            sparceCoderDo.setFeaturesCoderMap(new HashMap<String, Map<String, Set<Integer>>>());
        }
        Map<String, Map<String, Set<Integer>>> mergeFeatureMap = sparceCoderDo.getFeaturesCoderMap();
        ArrayList mergeFeatureValueList = new ArrayList();
        String syncTime = sparceCoderDo.getSyncTime();
        System.out.println("sparceCodeOfFields \u7f16\u7801 \u5f53\u524d\u6837\u672c");
        HashMap<String, Map> featureMap = new HashMap<String, Map>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            FeatureValue featureValue = list.get(i);
            if (featureValue == null) continue;
            String filed = featureValue.field();
            String value = featureValue.value();
            Set code = FeatureCoderModelListConstant.getFeatureMap(modelId).get(filed).code(value);
            if (!featureMap.containsKey(filed)) {
                featureMap.put(filed, new HashMap());
            }
            ((Map)featureMap.get(filed)).put(value, code);
        }
        System.out.println("sparceCodeOfFields \u7279\u5f81\u7f16\u7801\u8bb0\u5f55\uff0c\u65e7\u7684");
        mergeFeatureMap.forEach((field, codeMap) -> codeMap.forEach((value, code) -> {
            if (!featureMap.containsKey(field)) {
                code.stream().forEach(c -> mergeFeatureValueList.add(new FeatureValue(field, value, (long)c.intValue())));
            }
            ((Map)mergeFeatureMap.get(field)).put(value, code);
        }));
        System.out.println("sparceCodeOfFields \u7a00\u758f\u7f16\u7801\u8bb0\u5f55\uff0c \u5f53\u524d\u6837\u672c");
        featureMap.forEach((field, codeMap) -> {
            if (!mergeFeatureMap.containsKey(field)) {
                mergeFeatureMap.put((String)field, new HashMap());
            }
            codeMap.forEach((value, code) -> {
                ((Map)mergeFeatureMap.get(field)).put(value, code);
                code.stream().forEach(c -> mergeFeatureValueList.add(new FeatureValue(field, value, (long)c.intValue())));
            });
        });
        sparceCoderDo.setFeaturesCoderMap(mergeFeatureMap);
        System.out.println("sparceCodeOfFields \u540c\u6b65");
        if (syncTime != null && LocalDateUtil.getIntervalMinutes((String)syncTime, (DateStyle)DateStyle.YYYYMMDDHHMMSS) > 1440L && AssertUtil.isNotEmpty(mergeFeatureValueList)) {
            ret = mergeFeatureValueList;
            sparceCoderDo.setSyncTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYYMMDDHHMMSS));
        }
        if (syncTime == null && sparceCoderDo.getUpdateTime() != null && AssertUtil.isNotEmpty(mergeFeatureValueList)) {
            ret = mergeFeatureValueList;
            sparceCoderDo.setSyncTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYYMMDDHHMMSS));
        }
        System.out.println("sparceCodeOfFields \u4fdd\u5b58\u7a00\u758f\u7279\u5f81\u7f16\u7801");
        sparceCoderDo.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYYMMDDHHMMSS));
        sparceCoderDo.setSyncTime(null);
        StdCoderModelSaveBo.saveFieldSparceCoderByKeyToJedis(sparceKey, sparceCoderDo);
        return ret;
    }

    public static List<FeatureValue> sparceCodeOfFields(String sparceKey, List<FeatureValue> list, String modelId, AdvertTypeEnum taskType) throws Exception {
        System.out.println("sparceCodeOfFields \u7a00\u758f-\u7279\u5f81\u7f16\u7801 start");
        ArrayList<Object> ret = new ArrayList<FeatureValue>();
        if (AssertUtil.isEmpty(list)) {
            return ret;
        }
        SparceCoderDo sparceCoderDo = StdCoderModelSaveBo.getFieldSparceCoderByKeyFromJedis(sparceKey, taskType);
        if (sparceCoderDo == null) {
            sparceCoderDo = new SparceCoderDo();
        }
        System.out.println("sparceCodeOfFields \u83b7\u53d6\u7a00\u758f\u7f16\u7801 sparceCoderDo.getUpdateTime()=" + sparceCoderDo.getUpdateTime());
        System.out.println("sparceCodeOfFields \u83b7\u53d6\u7a00\u758f\u7f16\u7801 sparceCoderDo.getSyncTime()=" + sparceCoderDo.getSyncTime());
        if (AssertUtil.isEmpty(sparceCoderDo.getFeaturesCoderMap())) {
            sparceCoderDo.setFeaturesCoderMap(new HashMap<String, Map<String, Set<Integer>>>());
        }
        Map<String, Map<String, Set<Integer>>> mergeFeatureMap = sparceCoderDo.getFeaturesCoderMap();
        ArrayList mergeFeatureValueList = new ArrayList();
        String syncTime = sparceCoderDo.getSyncTime();
        System.out.println("sparceCodeOfFields \u7f16\u7801 \u5f53\u524d\u6837\u672c");
        HashMap<String, Map> featureMap = new HashMap<String, Map>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            FeatureValue featureValue = list.get(i);
            if (featureValue == null) continue;
            String filed = featureValue.field();
            String value = featureValue.value();
            Set code = FeatureCoderModelListConstant.getFeatureMap(modelId).get(filed).code(value);
            if (!featureMap.containsKey(filed)) {
                featureMap.put(filed, new HashMap());
            }
            ((Map)featureMap.get(filed)).put(value, code);
        }
        System.out.println("sparceCodeOfFields \u7279\u5f81\u7f16\u7801\u8bb0\u5f55\uff0c\u65e7\u7684");
        mergeFeatureMap.forEach((field, codeMap) -> codeMap.forEach((value, code) -> {
            if (!featureMap.containsKey(field)) {
                code.stream().forEach(c -> mergeFeatureValueList.add(new FeatureValue(field, value, (long)c.intValue())));
            }
            ((Map)mergeFeatureMap.get(field)).put(value, code);
        }));
        System.out.println("sparceCodeOfFields \u7a00\u758f\u7f16\u7801\u8bb0\u5f55\uff0c \u5f53\u524d\u6837\u672c");
        featureMap.forEach((field, codeMap) -> {
            if (!mergeFeatureMap.containsKey(field)) {
                mergeFeatureMap.put((String)field, new HashMap());
            }
            codeMap.forEach((value, code) -> {
                ((Map)mergeFeatureMap.get(field)).put(value, code);
                code.stream().forEach(c -> mergeFeatureValueList.add(new FeatureValue(field, value, (long)c.intValue())));
            });
        });
        sparceCoderDo.setFeaturesCoderMap(mergeFeatureMap);
        System.out.println("sparceCodeOfFields \u540c\u6b65");
        if (syncTime != null && LocalDateUtil.getIntervalMinutes((String)syncTime, (DateStyle)DateStyle.YYYYMMDDHHMMSS) > 1440L && AssertUtil.isNotEmpty(mergeFeatureValueList)) {
            ret = mergeFeatureValueList;
            sparceCoderDo.setSyncTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYYMMDDHHMMSS));
        }
        if (syncTime == null && sparceCoderDo.getUpdateTime() != null && AssertUtil.isNotEmpty(mergeFeatureValueList)) {
            ret = mergeFeatureValueList;
            sparceCoderDo.setSyncTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYYMMDDHHMMSS));
        }
        System.out.println("sparceCodeOfFields \u4fdd\u5b58\u7a00\u758f\u7279\u5f81\u7f16\u7801");
        sparceCoderDo.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYYMMDDHHMMSS));
        sparceCoderDo.setSyncTime(null);
        StdCoderModelSaveBo.saveFieldSparceCoderByKeyToJedis(sparceKey, sparceCoderDo, taskType);
        return ret;
    }

    public static void denseCodeOfFields(String modelId) throws Exception {
        System.out.println("denseCodeOfFields start");
        DenseCoderDo denseCoderDo = StdCoderModelSaveBo.getFieldCoderByKeyFromJedis(modelId);
        if (denseCoderDo == null) {
            denseCoderDo = new DenseCoderDo();
        }
        System.out.println("denseCodeOfFields \u83b7\u53d6\u7a00\u758f\u7f16\u7801\u6620\u5c04");
        PsAgent psAgent = new PsAgent(modelId, 1000000, 1);
        SparceCoderStatDo sparceCoderStatDo = new SparceCoderStatDo();
        sparceCoderStatDo.setFeatureList(FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        LocalModel sparceLastTimeSearchModel = sparceCoderStatDo.getSearchSparceLastTimeLocalModel();
        LocalModel sparceCountSearchModel = sparceCoderStatDo.getSearchSparceCountLocalModel();
        psAgent.pullAll(sparceLastTimeSearchModel);
        LocalModel sparceLastTimeLocalModel = psAgent.getLocalModel();
        sparceCoderStatDo.setSparceLastTimeLocalModel(sparceLastTimeLocalModel);
        psAgent.pullAll(sparceCountSearchModel);
        LocalModel sparceCountLocalModel = psAgent.getLocalModel();
        sparceCoderStatDo.setSparceCountLocalModel(sparceCountLocalModel);
        Map<String, Map<Long, Long>> sparceLastTime = sparceCoderStatDo.sparceLastTimeToMap();
        sparceCoderStatDo.setSparceLastTime(sparceLastTime);
        Map<String, Map<Long, Long>> sparceCount = sparceCoderStatDo.sparceCountToMap();
        sparceCoderStatDo.setSparceCount(sparceCount);
        System.out.println("denseCodeOfFields \u7279\u5f81\u7a20\u5bc6\u7f16\u7801\u66f4\u65b0");
        DenseCoderDo newDenseCoderDo = FeatureCoderApp.denseCoderUpdate(denseCoderDo, sparceCoderStatDo);
        System.out.println("denseCodeOfFields \u4fdd\u5b58\u7279\u5f81\u7a20\u5bc6\u7f16\u7801");
        StdCoderModelSaveBo.saveFieldCoderByKeyToJedis(modelId, newDenseCoderDo);
        System.out.println("denseCodeOfFields end");
    }

    public static void denseCodeOfFields(String modelId, AdvertTypeEnum taskType) throws Exception {
        System.out.println("denseCodeOfFields start");
        DenseCoderDo denseCoderDo = StdCoderModelSaveBo.getFieldCoderByKeyFromJedis(modelId, taskType);
        if (denseCoderDo == null) {
            denseCoderDo = new DenseCoderDo();
        }
        System.out.println("denseCodeOfFields \u83b7\u53d6\u7a00\u758f\u7f16\u7801\u6620\u5c04");
        PsAgent psAgent = new PsAgent(modelId, 1000000, 1);
        SparceCoderStatDo sparceCoderStatDo = new SparceCoderStatDo();
        sparceCoderStatDo.setFeatureList(FeatureCoderModelListConstant.getCoderFeatureList(modelId));
        LocalModel sparceLastTimeSearchModel = sparceCoderStatDo.getSearchSparceLastTimeLocalModel();
        LocalModel sparceCountSearchModel = sparceCoderStatDo.getSearchSparceCountLocalModel();
        psAgent.pullAll(sparceLastTimeSearchModel);
        LocalModel sparceLastTimeLocalModel = psAgent.getLocalModel();
        sparceCoderStatDo.setSparceLastTimeLocalModel(sparceLastTimeLocalModel);
        psAgent.pullAll(sparceCountSearchModel);
        LocalModel sparceCountLocalModel = psAgent.getLocalModel();
        sparceCoderStatDo.setSparceCountLocalModel(sparceCountLocalModel);
        Map<String, Map<Long, Long>> sparceLastTime = sparceCoderStatDo.sparceLastTimeToMap();
        sparceCoderStatDo.setSparceLastTime(sparceLastTime);
        Map<String, Map<Long, Long>> sparceCount = sparceCoderStatDo.sparceCountToMap();
        sparceCoderStatDo.setSparceCount(sparceCount);
        System.out.println("denseCodeOfFields \u7279\u5f81\u7a20\u5bc6\u7f16\u7801\u66f4\u65b0");
        DenseCoderDo newDenseCoderDo = FeatureCoderApp.denseCoderUpdate(denseCoderDo, sparceCoderStatDo);
        System.out.println("denseCodeOfFields \u4fdd\u5b58\u7279\u5f81\u7a20\u5bc6\u7f16\u7801");
        StdCoderModelSaveBo.saveFieldCoderByKeyToJedis(modelId, newDenseCoderDo, taskType);
        System.out.println("denseCodeOfFields end");
    }

    public static void denseCodeOfModelList(String coderId, AdvertTypeEnum taskType) throws Exception {
        System.out.println("denseCodeOfModelList start");
        DenseCoderDo filedDenseCoderDo = StdCoderModelSaveBo.getFieldCoderByKeyFromJedis(coderId, taskType);
        if (filedDenseCoderDo == null) {
            filedDenseCoderDo = new DenseCoderDo();
        }
        List<ModelKeyEnum> modelKeyEnumList = FeatureCoderModelListConstant.getModelList(coderId);
        System.out.println("denseCodeOfModelList\uff0cmodelList=" + JSON.toJSONString(modelKeyEnumList));
        for (int i = 0; i < modelKeyEnumList.size(); ++i) {
            String onlineModelId = modelKeyEnumList.get(i).getIndex();
            String psModelId = modelKeyEnumList.get(i).getPsIndex();
            CODER modelDenseCode = FeatureCoderApp.denseCodeOfModel(psModelId, filedDenseCoderDo);
            StdCoderModelSaveBo.saveModelCoderByKeyToJedis(onlineModelId, modelDenseCode, taskType);
        }
        System.out.println("denseCodeOfModelList end");
    }

    public static CODER denseCodeOfModel(String modelId, DenseCoderDo filedDenseCoderDo) throws Exception {
        System.out.println("denseCodeOfModel\uff0cstart, onlineModelId=" + modelId);
        CODER ret = new CODER();
        if (filedDenseCoderDo == null) {
            filedDenseCoderDo = new DenseCoderDo();
        }
        HashMap<String, Map> modelCoderMap = new HashMap<String, Map>();
        List<FeatureBaseType> featureBaseTypeList = FeatureCoderModelListConstant.getModelFeatureList(modelId);
        Long startIndex = 0L;
        for (int i = 0; i < featureBaseTypeList.size(); ++i) {
            String field = featureBaseTypeList.get(i).getName();
            Map fieldMap = filedDenseCoderDo.getDenseCoderMap().getOrDefault(field, new HashMap());
            modelCoderMap.put(field, fieldMap);
        }
        ret.setCoderMap(modelCoderMap);
        ret.setModelId(modelId);
        ret.setFeatureBaseType(featureBaseTypeList);
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((String)cn.com.duiba.nezha.compute.core.enums.DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
        System.out.println("denseCodeOfModel\uff0cend, onlineModelId=" + modelId);
        return ret;
    }

    public static Map<Long, Long> mapAllValueAdd(Map<Long, Long> map, Long addValue) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>();
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            retMap.put(entry.getKey(), entry.getValue() + addValue);
        }
        return retMap;
    }

    public static DenseCoderDo denseCoderUpdate(DenseCoderDo denseCoderDo, SparceCoderStatDo sparceCoderStatDo) {
        DenseCoderDo ret = new DenseCoderDo();
        HashMap<String, Map<Integer, Integer>> retMap = new HashMap<String, Map<Integer, Integer>>();
        if (denseCoderDo != null) {
            System.out.println("denseCoderUpdate denseCoderDo is null");
            ret = denseCoderDo;
        }
        Map<String, Map<Integer, Integer>> denseCoderMap = denseCoderDo.getDenseCoderMap();
        Map<String, Map<Long, Long>> sparceLastTimeMap = sparceCoderStatDo.getSparceLastTime();
        List<FeatureBaseType> featureBaseTypeList = sparceCoderStatDo.getFeatureList();
        for (FeatureBaseType featureBaseType : featureBaseTypeList) {
            String field = featureBaseType.getName();
            int size = featureBaseType.getDenseLen();
            if (!sparceLastTimeMap.containsKey(field)) continue;
            Map<Integer, Integer> denseCoderFieldMap = FeatureCoderApp.denseCoderFieldUpdate(denseCoderMap.get(field), sparceLastTimeMap.get(field), size);
            retMap.put(field, denseCoderFieldMap);
            System.out.println("filed=" + field + ",denseCoderFieldMap.size=" + denseCoderFieldMap.size());
        }
        ret.setDenseCoderMap(retMap);
        return ret;
    }

    public static Map<Integer, Integer> denseCoderFieldUpdate(Map<Integer, Integer> denseCoderMap, Map<Long, Long> sparceLastTime, int size) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        if (denseCoderMap == null) {
            denseCoderMap = new HashMap<Integer, Integer>();
        }
        if (sparceLastTime == null) {
            sparceLastTime = new HashMap<Long, Long>();
        }
        Set<Integer> denseCoderKeySet = denseCoderMap.keySet();
        Set<Long> sparceLastTimeKeySet = sparceLastTime.keySet();
        Set<Integer> originValidKeySet = FeatureCoderApp.setRetainAll2(denseCoderKeySet, sparceLastTimeKeySet);
        Map<Integer, Integer> originValidMap = FeatureCoderApp.getSubMapWithKey(originValidKeySet, denseCoderMap);
        HashSet<Integer> originValidValueSet = new HashSet<Integer>(originValidMap.values());
        ret.putAll(originValidMap);
        Set<Integer> newKeySet = FeatureCoderApp.setRemoveAll3(sparceLastTimeKeySet, denseCoderKeySet);
        int newKeySize = newKeySet.size();
        ArrayList<Integer> newKeyList = new ArrayList<Integer>(newKeySet);
        int j = 0;
        for (int i = 1; i < size && j < newKeySize; ++i) {
            if (originValidValueSet.contains(i)) continue;
            ret.put((Integer)newKeyList.get(j), i);
            ++j;
        }
        return ret;
    }

    public static Set<Integer> setRetainAll(Set<Integer> set1, Set<Integer> set2) {
        HashSet<Integer> result = new HashSet<Integer>();
        result.addAll(set1);
        result.retainAll(set2);
        return result;
    }

    public static Set<Integer> setRetainAll2(Set<Integer> set1, Set<Long> set2) {
        HashSet<Integer> set2Intger = new HashSet<Integer>();
        set2.stream().forEach(a -> set2Intger.add(a.intValue()));
        return FeatureCoderApp.setRetainAll(set1, set2Intger);
    }

    public static Set<Integer> setRemoveAll(Set<Integer> set1, Set<Integer> set2) {
        HashSet<Integer> result = new HashSet<Integer>();
        result.addAll(set1);
        result.removeAll(set2);
        return result;
    }

    public static Set<Integer> setRemoveAll2(Set<Integer> set1, Set<Long> set2) {
        HashSet<Integer> set2Intger = new HashSet<Integer>();
        set2.stream().forEach(a -> set2Intger.add(a.intValue()));
        return FeatureCoderApp.setRemoveAll(set1, set2Intger);
    }

    public static Set<Integer> setRemoveAll3(Set<Long> set1, Set<Integer> set2) {
        HashSet<Integer> set1Intger = new HashSet<Integer>();
        set1.stream().forEach(a -> set1Intger.add(a.intValue()));
        return FeatureCoderApp.setRemoveAll(set1Intger, set2);
    }

    public static Map<Integer, Integer> getSubMapWithKey(Set<Integer> key, Map<Integer, Integer> map) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        key.stream().forEach(x -> {
            Integer cfr_ignored_0 = (Integer)ret.put((Integer)x, (Integer)map.get(x));
        });
        return ret;
    }

    public static SparceCoderStatDo getIncrModelV2(List<Map<String, FeatureCode>> samples) {
        SparceCoderStatDo sparceCoderStatDo = new SparceCoderStatDo();
        Long second = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        for (Map<String, FeatureCode> labeledSparsePoint : samples) {
            for (Map.Entry<String, FeatureCode> entry : labeledSparsePoint.entrySet()) {
                String fieldId = entry.getKey();
                FeatureCode fieldCode = entry.getValue();
                if (!sparceCoderStatDo.getSparceCount().containsKey(fieldId)) {
                    sparceCoderStatDo.getSparceCount().put(fieldId, new HashMap());
                    sparceCoderStatDo.getSparceLastTime().put(fieldId, new HashMap());
                }
                for (int i = 0; i < fieldCode.indices.length; ++i) {
                    int indices = fieldCode.indices[i];
                    FeatureCoderApp.mapIncrement(sparceCoderStatDo.getSparceCount().get(fieldId), (long)indices + 0L, 0L);
                    FeatureCoderApp.mapPutFilter(sparceCoderStatDo.getSparceLastTime().get(fieldId), (long)indices + 0L, second);
                }
            }
        }
        return sparceCoderStatDo;
    }

    public static SparceCoderStatDo getDpIncrModel(List<LabeledDpFeature> samples) {
        SparceCoderStatDo sparceCoderStatDo = new SparceCoderStatDo();
        Long second = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        for (LabeledDpFeature labeledSparsePoint : samples) {
            Feature feature = labeledSparsePoint.feature();
            for (int i = 0; i < feature.fields.length; ++i) {
                String field = feature.fields[i];
                int indices = feature.indices[i];
                if (!sparceCoderStatDo.getSparceCount().containsKey(field)) {
                    sparceCoderStatDo.getSparceCount().put(field, new HashMap());
                    sparceCoderStatDo.getSparceLastTime().put(field, new HashMap());
                }
                FeatureCoderApp.mapIncrement(sparceCoderStatDo.getSparceCount().get(field), (long)indices + 0L, 0L);
                FeatureCoderApp.mapPutFilter(sparceCoderStatDo.getSparceLastTime().get(field), (long)indices + 0L, second);
            }
        }
        return sparceCoderStatDo;
    }

    public static SparceCoderStatDo getIncrModel(List<LabeledSparsePoint> samples) {
        SparceCoderStatDo sparceCoderStatDo = new SparceCoderStatDo();
        Long second = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        for (LabeledSparsePoint labeledSparsePoint : samples) {
            Feature feature = labeledSparsePoint.feature();
            for (int i = 0; i < feature.fields.length; ++i) {
                String field = feature.fields[i];
                int indices = feature.indices[i];
                if (!sparceCoderStatDo.getSparceCount().containsKey(field)) {
                    sparceCoderStatDo.getSparceCount().put(field, new HashMap());
                    sparceCoderStatDo.getSparceLastTime().put(field, new HashMap());
                }
                FeatureCoderApp.mapIncrement(sparceCoderStatDo.getSparceCount().get(field), (long)indices + 0L, 0L);
                FeatureCoderApp.mapPutFilter(sparceCoderStatDo.getSparceLastTime().get(field), (long)indices + 0L, second);
            }
        }
        return sparceCoderStatDo;
    }

    public static SparceCoderStatDo getIncrModel2(List<LabeledSparseDpaFeature> samples) {
        SparceCoderStatDo sparceCoderStatDo = new SparceCoderStatDo();
        Long second = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        for (LabeledSparseDpaFeature labeledSparsePoint : samples) {
            Feature feature = labeledSparsePoint.feature();
            for (int i = 0; i < feature.fields.length; ++i) {
                String field = feature.fields[i];
                int indices = feature.indices[i];
                if (!sparceCoderStatDo.getSparceCount().containsKey(field)) {
                    sparceCoderStatDo.getSparceCount().put(field, new HashMap());
                    sparceCoderStatDo.getSparceLastTime().put(field, new HashMap());
                }
                FeatureCoderApp.mapIncrement(sparceCoderStatDo.getSparceCount().get(field), (long)indices + 0L, 0L);
                FeatureCoderApp.mapPutFilter(sparceCoderStatDo.getSparceLastTime().get(field), (long)indices + 0L, second);
            }
        }
        return sparceCoderStatDo;
    }

    public static void mapIncrement(Map<Long, Long> map, Long key, Long defaultValue) {
        map.put(key, map.getOrDefault(key, defaultValue) + 1L);
    }

    public static void mapPutFilter(Map<Long, Long> map, Long key, Long defaultValue) {
        if (!map.containsKey(key)) {
            map.put(key, defaultValue);
        }
    }

    public static void printTest(String msg) {
        System.out.println(msg);
    }
}

