/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo;

import cn.com.duiba.nezha.compute.biz.constant.ProjectConstant;
import cn.com.duiba.nezha.compute.biz.constant.model.HParamsConstant;
import cn.com.duiba.nezha.compute.biz.ps.PsAgent;
import cn.com.duiba.nezha.compute.biz.utils.conf.ConfProperties;
import cn.com.duiba.nezha.compute.biz.utils.conf.ConfigFactory;
import cn.com.duiba.nezha.compute.core.jmodel.JLocalModel;
import cn.com.duiba.nezha.compute.core.model.local.LocalModel;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.FMFTRLHyperParams;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.SparseFMWithFTRL;
import com.alibaba.fastjson.JSON;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PsSyncBo {
    private static final Logger logger = LoggerFactory.getLogger(PsSyncBo.class);

    public static void sync(String psModelId, String version, String path, int syncType) {
        if (PsSyncBo.paramsCheck(psModelId, version, path, syncType)) {
            if (syncType == 0) {
                PsSyncBo.backup(psModelId, version, path);
            } else {
                PsSyncBo.overWrite(psModelId, version, path);
            }
        }
    }

    public static boolean paramsCheck(String psModelId, String version, String path, int syncType) {
        logger.info("model sync,input,psModelId=" + psModelId + ",version=" + version + ",path=" + path + ",syncType=" + syncType);
        System.out.println("model sync,input,psModelId=" + psModelId + ",version=" + version + ",path=" + path + ",syncType=" + syncType);
        if (psModelId == null) {
            logger.error("invalid params ,psModelId is null");
            return false;
        }
        if (version == null) {
            logger.error("invalid params ,version is null");
            return false;
        }
        if (path == null) {
            logger.error("invalid params ,path is null");
            return false;
        }
        return true;
    }

    public static boolean backup(String psModelId, String version, String path) {
        try {
            LocalModel localModel = PsSyncBo.pullLocalModelFromPs(psModelId);
            PsSyncBo.pushLocalModelToOSS(psModelId, version, path, localModel);
            System.out.println("localmodel backup succeed");
            return true;
        }
        catch (Exception e) {
            logger.error("backup happend error,", (Throwable)e);
            System.out.println("localmodel backup failed");
            return false;
        }
    }

    public static boolean overWrite(String psModelId, String version, String path) {
        try {
            LocalModel localModel = PsSyncBo.pullLocalModelFromOSS(psModelId, version, path);
            PsSyncBo.pushLocalModelToPs(psModelId, localModel);
            System.out.println("localmodel overWrite succeed");
            return true;
        }
        catch (Exception e) {
            logger.error("overWrite happend error,", (Throwable)e);
            System.out.println("localmodel overWrite failed");
            return false;
        }
    }

    public static LocalModel pullLocalModelFromPs(String modelId) throws Exception {
        PsAgent psAgent = new PsAgent(modelId);
        FMFTRLHyperParams hyperParams = HParamsConstant.getHParams(modelId);
        int factorNum = psAgent.getBaseInfo().getFactorNum();
        if (hyperParams != null) {
            factorNum = hyperParams.factorNum();
        }
        if (factorNum == 0) {
            throw new Exception("pullLocalModelFromPs happend error ,factorNum =" + factorNum);
        }
        boolean status = psAgent.pull(SparseFMWithFTRL.searchModel((int)psAgent.getBaseInfo().getDim(), (int)psAgent.getBaseInfo().getFactorNum()), true);
        return psAgent.getLocalModel();
    }

    public static void pushLocalModelToPs(String modelId, LocalModel localModel) throws Exception {
        PsAgent psAgent = new PsAgent(modelId);
        psAgent.pushAll(localModel);
    }

    public static LocalModel pullLocalModelFromOSS(String modelId, String version, String path) throws Exception {
        String str = PsSyncBo.downloadFromOSS(version, path);
        JLocalModel jLocalModel = (JLocalModel)JSON.parseObject((String)str, JLocalModel.class);
        return LocalModel.toLocalModel((JLocalModel)jLocalModel);
    }

    public static void pushLocalModelToOSS(String modelId, String version, String path, LocalModel localModel) throws Exception {
        JLocalModel jLocalModel = LocalModel.toJLocalModel((LocalModel)localModel);
        String str = JSON.toJSONString((Object)jLocalModel);
        PsSyncBo.uploadToOSS(version, path, str);
    }

    private static String downloadFromOSS(String version, String path) throws IOException {
        String line;
        OSS ossClient = PsSyncBo.formatOssClient();
        ConfProperties configProperties = ConfigFactory.getInstance().getConfigProperties("/application.properties");
        String bucketName = configProperties.getProperty(ProjectConstant.ALIYUN_OSS_BUCKET);
        String filePath = PsSyncBo.formatVersionFilePath(version, path);
        OSSObject ossObject = ossClient.getObject(bucketName, filePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(ossObject.getObjectContent()));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        reader.close();
        ossClient.shutdown();
        return sb.toString();
    }

    private static void uploadToOSS(String version, String path, String content) throws FileNotFoundException {
        OSS ossClient = PsSyncBo.formatOssClient();
        String filePath = PsSyncBo.formatVersionFilePath(version, path);
        ConfProperties configProperties = ConfigFactory.getInstance().getConfigProperties("/application.properties");
        String bucketName = configProperties.getProperty(ProjectConstant.ALIYUN_OSS_BUCKET);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, filePath, (InputStream)new ByteArrayInputStream(content.getBytes()));
        ossClient.putObject(putObjectRequest);
        ossClient.shutdown();
    }

    private static OSS formatOssClient() throws FileNotFoundException {
        ConfProperties configProperties = ConfigFactory.getInstance().getConfigProperties("/application.properties");
        String endpoint = configProperties.getProperty(ProjectConstant.ALIYUN_OSS_ENDPOINT);
        String accessKeyId = configProperties.getProperty(ProjectConstant.ALIYUN_OSS_ACCESSKEY_ID);
        String accessKeySecret = configProperties.getProperty(ProjectConstant.ALIYUN_OSS_ACCESSKEY_SECRET);
        return new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
    }

    private static String formatVersionFilePath(String version, String path) {
        return path + "/" + version;
    }
}

