/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo;

import cn.com.duiba.nezha.compute.biz.conf.JedisPoolConf;
import cn.com.duiba.nezha.compute.biz.utils.jedis.JedisUtil;
import cn.com.duiba.nezha.compute.core.CollectionUtil;
import cn.com.duiba.nezha.compute.core.model.ops.VectorOps;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.core.util.DataUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.spark.mllib.linalg.SparseVector;

public class RedisBaseBo {
    public static long MULTIPLES = 1000000L;
    public static int NEW_SCALA = 4;
    public static int TTL = 2592000;
    private static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.psJedisConfig);

    public static void insertSparseVector(String rowKey, SparseVector object) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey, object})) {
            Object[] indices = VectorOps.toStrIndex((SparseVector)object);
            long[] values = CollectionUtil.double2long((double[])object.values(), (long)MULTIPLES);
            if (AssertUtil.isNotEmpty((Object[])indices)) {
                jedisUtil.multiSetex(rowKey, (String[])indices, values, TTL);
                jedisUtil.sadd(rowKey + "_set", (String[])indices, TTL);
            }
        }
    }

    public static void deleteSparseVector(String rowKey) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey})) {
            Set<String> indicesStr = jedisUtil.smember(rowKey + "_set");
            jedisUtil.multiDelete(rowKey, indicesStr);
        }
    }

    public static void incrementSparseVector(String rowKey, SparseVector object) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey, object})) {
            Object[] indices = VectorOps.toStrIndex((SparseVector)object);
            long[] values = CollectionUtil.double2long((double[])object.values(), (long)MULTIPLES);
            if (AssertUtil.isNotEmpty((Object[])indices)) {
                jedisUtil.multiIncrByex(rowKey, (String[])indices, values, TTL);
                jedisUtil.sadd(rowKey + "_set", (String[])indices, TTL);
            }
        }
    }

    public static SparseVector searchSparseVector(String rowKey, String[] cols, int size) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey, cols})) {
            ArrayList<Long> index = new ArrayList<Long>();
            ArrayList<Long> value = new ArrayList<Long>();
            Map<String, String> response = jedisUtil.multiGetReturnBySubKey(rowKey, cols);
            if (AssertUtil.isNotEmpty(response)) {
                for (Map.Entry<String, String> entry : response.entrySet()) {
                    String key = entry.getKey();
                    String val = entry.getValue();
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{key, val})) continue;
                    Long keyL = Long.valueOf(key);
                    Long valL = Long.valueOf(val);
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{keyL, valL})) continue;
                    index.add(keyL);
                    value.add(valL);
                }
            }
            double[] valuesDouble = CollectionUtil.long22double(value, (long)MULTIPLES, (int)NEW_SCALA);
            int[] indices = CollectionUtil.toArray(index);
            return VectorOps.toVector((int)size, (int[])indices, (double[])valuesDouble);
        }
        return null;
    }

    public static SparseVector searchSparseVector(String rowKey, SparseVector object) throws Exception {
        SparseVector ret = null;
        if (object != null) {
            String[] cols = VectorOps.toStrIndex((SparseVector)object);
            int size = object.size();
            ret = RedisBaseBo.searchSparseVector(rowKey, cols, size);
        }
        return ret;
    }

    public static SparseVector searchSparseVector(String rowKey, int vSize) throws Exception {
        SparseVector ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey})) {
            HashMap mapV = new HashMap();
            Set<String> indicesStr = jedisUtil.smember(rowKey + "_set");
            if (AssertUtil.isNotEmpty(indicesStr)) {
                ArrayList<String> idStr = new ArrayList<String>(indicesStr);
                Collections.sort(idStr);
                String[] indices = idStr.toArray(new String[idStr.size()]);
                ret = RedisBaseBo.searchSparseVector(rowKey, indices, vSize);
                if (ret != null) {
                    String[] cols = VectorOps.toStrIndex((SparseVector)ret);
                    HashSet<String> colSet = new HashSet<String>(Arrays.asList(cols));
                    indicesStr.removeAll(colSet);
                    jedisUtil.srem(rowKey + "_set", indicesStr);
                }
            }
        }
        return ret;
    }

    public static void insertMapValue(String rowKey, String[] indices, double[] values) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey, indices, values}) && indices.length == values.length) {
            long[] valueLong = CollectionUtil.double2long((double[])values, (long)MULTIPLES);
            if (AssertUtil.isNotEmpty((Object[])indices)) {
                jedisUtil.multiSetex(rowKey, indices, valueLong, TTL);
                jedisUtil.sadd(rowKey + "_set", indices, TTL);
            }
        }
    }

    public static void incrementMapValue(String rowKey, String[] indices, double[] values) throws Exception {
        RedisBaseBo.incrementMapValue(rowKey, indices, values, MULTIPLES);
    }

    public static void incrementMapValue(String rowKey, String[] indices, double[] values, long multiples) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey, indices, values}) && indices.length == values.length) {
            long[] valueLong = CollectionUtil.double2long((double[])values, (long)multiples);
            if (AssertUtil.isNotEmpty((Object[])indices)) {
                jedisUtil.multiIncrByex(rowKey, indices, valueLong, TTL);
                jedisUtil.sadd(rowKey + "_set", indices, TTL);
            }
        }
    }

    public static Map<String, Double> searchMapValue(String rowKey, Set<String> keySet) throws Exception {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey, keySet})) {
            Map<String, String> response = jedisUtil.multiGetReturnBySubKey(rowKey, keySet);
            if (AssertUtil.isNotEmpty(response)) {
                for (Map.Entry<String, String> entry : response.entrySet()) {
                    String key = entry.getKey();
                    String val = entry.getValue();
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{key, val})) continue;
                    Long valL = Long.valueOf(val);
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{valL})) continue;
                    retMap.put(key, DataUtil.long2double((long)valL, (long)MULTIPLES, (int)NEW_SCALA));
                }
            }
            return retMap;
        }
        return null;
    }

    public static void deleteMapValue(String rowKey) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey})) {
            Set<String> indicesStr = jedisUtil.smember(rowKey + "_set");
            jedisUtil.multiDelete(rowKey, indicesStr);
        }
    }

    public static <T> void insert(String rowKey, T object) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey, object})) {
            jedisUtil.setObjectex(rowKey, object, TTL);
        }
    }

    public static <T> T get(String rowKey, Class<T> clazz) throws Exception {
        T retT = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey, clazz})) {
            retT = jedisUtil.get(rowKey, clazz);
        }
        return retT;
    }

    public static void delete(String rowKey) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKey})) {
            jedisUtil.delete(rowKey);
        }
    }
}

