/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo;

import cn.com.duiba.nezha.compute.biz.bo.PsBo;
import cn.com.duiba.nezha.compute.biz.dto.PsModelSample;
import cn.com.duiba.nezha.compute.biz.enums.AdvertTypeEnum;
import cn.com.duiba.nezha.compute.biz.enums.SampleTypeEnum;
import cn.com.duiba.nezha.compute.biz.support.SampleParse;
import cn.com.duiba.nezha.compute.core.LabeledESMMDcvrFeature;
import cn.com.duiba.nezha.compute.core.LabeledESMMFeature;
import cn.com.duiba.nezha.compute.core.LabeledESMMSparsePoint;
import cn.com.duiba.nezha.compute.core.LabeledFeature;
import cn.com.duiba.nezha.compute.core.LabeledMaterialFeature;
import cn.com.duiba.nezha.compute.core.LabeledPoint;
import cn.com.duiba.nezha.compute.core.LabeledPointPairWise;
import cn.com.duiba.nezha.compute.core.LabeledSparsePoint;
import cn.com.duiba.nezha.compute.core.LabeledWeightedDpaFeature;
import cn.com.duiba.nezha.compute.core.SlotLabeledPoint;
import cn.com.duiba.nezha.compute.core.enums.DateStyle;
import cn.com.duiba.nezha.compute.core.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.sql.Row;
import scala.collection.Iterator;

public class SampleBo {
    public static Map<String, String> lastParseRecord = new HashMap<String, String>();

    public static void setLastParseRecord(String model, String time) {
        lastParseRecord.put(model, time);
    }

    public static String getLastParseRecord(String model) {
        return lastParseRecord.get(model);
    }

    public static double negativeAdxRegSampleFilter(LabeledPoint labeledPoint, double negativeSampleRatio) {
        double ret = 0.0;
        if (labeledPoint == null) {
            ret = 0.0;
        }
        if (labeledPoint != null && labeledPoint.label() < 0.5 && Math.random() > negativeSampleRatio) {
            ret = 0.0;
        }
        return ret;
    }

    public static boolean negativeSampleFilter(LabeledPoint labeledPoint, double negativeSampleRatio) {
        boolean ret = true;
        if (labeledPoint == null) {
            ret = false;
        }
        if (labeledPoint != null && labeledPoint.label() < 0.5 && Math.random() > negativeSampleRatio) {
            ret = false;
        }
        return ret;
    }

    public static boolean negativeSampleFilter(LabeledPointPairWise labeledPoint, double negativeSampleRatio) {
        boolean ret = true;
        if (labeledPoint == null) {
            ret = false;
        }
        if (labeledPoint != null && labeledPoint.label() < 0.5 && Math.random() > negativeSampleRatio) {
            ret = false;
        }
        return ret;
    }

    public static boolean negativeSampleFilter(LabeledMaterialFeature labeledMaterialFeature, double negativeSampleRatio) {
        boolean ret = true;
        if (labeledMaterialFeature == null) {
            ret = false;
        }
        if (labeledMaterialFeature != null && labeledMaterialFeature.ctrLabel() < 0.5 && Math.random() > negativeSampleRatio) {
            ret = false;
        }
        return ret;
    }

    public static boolean negativeSampleFilter(LabeledSparsePoint labeledPoint, double negativeSampleRatio) {
        boolean ret = true;
        if (labeledPoint == null) {
            ret = false;
        }
        if (labeledPoint != null && labeledPoint.label() < 0.5 && Math.random() > negativeSampleRatio) {
            ret = false;
        }
        return ret;
    }

    public static LabeledPoint[] getSampleByOrderIdList(String modelId, boolean isCtr, List<String> orderIdList) throws Exception {
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        List<LabeledPoint> data = SampleParse.parse(samples, modelId, isCtr);
        LabeledPoint[] dataArray = data.toArray(new LabeledPoint[data.size()]);
        return dataArray;
    }

    public static LabeledPoint[] getSampleByOrderIdListWithFilter(String modelId, boolean isCtr, List<String> orderIdList, double negativeSampleRatio) throws Exception {
        LabeledPoint[] ret = null;
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        List<LabeledPoint> data = SampleParse.parse(samples, modelId, isCtr);
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledPoint[] getSampleWithFilter(String modelId, boolean isCtr, List<PsModelSample> samples, double negativeSampleRatio) throws Exception {
        LabeledPoint[] ret = null;
        List<LabeledPoint> data = SampleParse.parse(samples, modelId, isCtr);
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledPoint[] getSampleOffline(String modelId, boolean isCtr, List<PsModelSample> samples, double negativeSampleRatio) throws Exception {
        LabeledPoint[] ret = null;
        List<LabeledPoint> data = SampleParse.parse(samples, modelId, isCtr);
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledPoint[] getPdSampleWithFilter(String modelId, boolean isCtr, List<PsModelSample> samples, double negativeSampleRatio) throws Exception {
        LabeledPoint[] ret = null;
        System.out.println("===parese_pre, size=" + samples.size());
        List<LabeledPoint> data = SampleParse.parseAdxPd(samples, modelId, isCtr);
        System.out.println("===parese_after, size=" + data.size());
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledPoint[] getSampleWithMissingFilter(String modelId, boolean isCtr, List<PsModelSample> samples, double negativeSampleRatio, String[] checkFieldIds) throws Exception {
        LabeledPoint[] ret = null;
        List<LabeledPoint> data = SampleParse.parseWithMissingFilter(samples, modelId, isCtr, checkFieldIds);
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledPoint[] getSampleWithDelayFilter(String modelId, boolean isCtr, List<PsModelSample> samples, double negativeSampleRatio, Long delayFilter) throws Exception {
        LabeledPoint[] ret = null;
        List<LabeledPoint> data = SampleParse.parseWithDelayFilter(samples, modelId, isCtr, delayFilter);
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledPoint[] getDCvrSampleWithFilter(String modelId, List<PsModelSample> samples, double negativeSampleRatio) throws Exception {
        LabeledPoint[] ret = null;
        List<LabeledPoint> data = SampleParse.parseDCvr(samples, modelId);
        System.out.println("datasize()=" + data.size());
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledPoint[] getSampleWithFilter(String modelId, boolean isCtr, List<PsModelSample> samples, List<PsModelSample> bCvrSamples, double negativeSampleRatio) throws Exception {
        LabeledPoint[] ret = null;
        List<LabeledPoint> data = SampleParse.parse(samples, modelId, isCtr, true);
        List<LabeledPoint> bCvrData = SampleParse.parse(bCvrSamples, modelId, isCtr, false);
        int n2_cnt = 0;
        for (int i = 0; i < data.size(); ++i) {
            if (!(data.get(i).label() < 0.1)) continue;
            ++n2_cnt;
        }
        System.out.println("datasize()=" + data.size() + ",n_cnt=" + n2_cnt);
        if (bCvrData != null) {
            data.addAll(bCvrData);
            int n_cnt = 0;
            for (int i = 0; i < bCvrData.size(); ++i) {
                if (!(bCvrData.get(i).label() < 0.1)) continue;
                ++n_cnt;
            }
            System.out.println("bCvrData.size()=" + bCvrData.size() + ",n_cnt=" + n_cnt);
        }
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledPoint[] getSdkSample(String modelId, boolean isCtr, List<PsModelSample> samples, List<PsModelSample> bCvrSamples, double negativeSampleRatio) throws Exception {
        LabeledPoint[] ret = null;
        List<LabeledPoint> data = SampleParse.parseWithSdkFilter(samples, modelId, isCtr, true);
        List<LabeledPoint> bCvrData = SampleParse.parseWithSdkFilter(bCvrSamples, modelId, isCtr, false);
        System.out.println("datasize()=" + data.size());
        if (bCvrData != null) {
            data.addAll(bCvrData);
            System.out.println("bCvrData.size()=" + bCvrData.size());
        }
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledPoint[] getSampleWithFilterTradeSample(String modelId, boolean isCtr, List<PsModelSample> samples, List<PsModelSample> bCvrSamples, double negativeSampleRatio, Set<Integer> tradeCodes) throws Exception {
        LabeledPoint[] ret = null;
        List<LabeledPoint> data = SampleParse.parseWithTradeFilter(samples, modelId, isCtr, true, tradeCodes);
        List<LabeledPoint> bCvrData = SampleParse.parseWithTradeFilter(bCvrSamples, modelId, isCtr, false, tradeCodes);
        System.out.println("datasize()=" + data.size());
        if (bCvrData != null) {
            data.addAll(bCvrData);
            System.out.println("bCvrData.size()=" + bCvrData.size());
        }
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledPoint[] getSampleWithFilterMissingSample(String modelId, boolean isCtr, List<PsModelSample> samples, List<PsModelSample> bCvrSamples, double negativeSampleRatio, String[] checkFieldIds) throws Exception {
        LabeledPoint[] ret = null;
        List<LabeledPoint> data = SampleParse.parseWithMissingFilter(samples, modelId, isCtr, true, checkFieldIds);
        List<LabeledPoint> bCvrData = SampleParse.parseWithMissingFilter(bCvrSamples, modelId, isCtr, false, checkFieldIds);
        System.out.println("datasize()=" + data.size());
        if (bCvrData != null) {
            data.addAll(bCvrData);
            System.out.println("bCvrData.size()=" + bCvrData.size());
        }
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledSparsePoint[] getSampleWithFilterWithField(String modelId, boolean isCtr, List<PsModelSample> samples, List<PsModelSample> bCvrSamples, double negativeSampleRatio) throws Exception {
        LabeledSparsePoint[] ret = null;
        List<LabeledSparsePoint> data = SampleParse.parseWithField(samples, modelId, isCtr, true);
        List<LabeledSparsePoint> bCvrData = SampleParse.parseWithField(bCvrSamples, modelId, isCtr, false);
        data.addAll(bCvrData);
        if (data != null) {
            List<LabeledSparsePoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledSparsePoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledESMMSparsePoint[] getESMMSample(String ctrModelId, String cvrModelId, List<PsModelSample> samples) throws Exception {
        LabeledESMMSparsePoint[] ret = null;
        List<LabeledESMMSparsePoint> dataList = SampleParse.parseESMM(samples, ctrModelId, cvrModelId);
        if (dataList != null) {
            ret = dataList.toArray(new LabeledESMMSparsePoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledESMMSparsePoint[] getESMMSample(String ctrModelId, String cvrModelId, List<PsModelSample> samples, List<PsModelSample> bCvrSamples) throws Exception {
        LabeledESMMSparsePoint[] ret = null;
        List<LabeledESMMSparsePoint> dataList = SampleParse.parseESMM(samples, ctrModelId, cvrModelId, false);
        List<LabeledESMMSparsePoint> dataList2 = SampleParse.parseESMM(bCvrSamples, ctrModelId, cvrModelId, true);
        if (dataList2 != null) {
            dataList.addAll(dataList2);
            System.out.println("dataList2.size() = " + dataList2.size());
        }
        if (dataList != null) {
            ret = dataList.toArray(new LabeledESMMSparsePoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledSparsePoint[] getSampleWithFilterField(String modelId, boolean isCtr, List<PsModelSample> samples, double negativeSampleRatio) throws Exception {
        LabeledSparsePoint[] ret = null;
        List<LabeledSparsePoint> data = SampleParse.parseWithField(samples, modelId, isCtr);
        if (data != null) {
            List<LabeledSparsePoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledSparsePoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledSparsePoint[] getMaterialSampleWithFilterField(String modelId, boolean isCtr, List<LabeledSparsePoint> samples, double negativeSampleRatio) throws Exception {
        LabeledSparsePoint[] ret = null;
        List<LabeledSparsePoint> data = SampleParse.parseWithFieldOffline(samples, modelId, isCtr);
        if (data != null) {
            List<LabeledSparsePoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledSparsePoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledSparsePoint[] getSparseSampleByOrderIdList(String modelId, boolean isCtr, List<String> orderIdList) throws Exception {
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        List<LabeledSparsePoint> data = SampleParse.parseSparse(samples, modelId, isCtr);
        LabeledSparsePoint[] dataArray = data.toArray(new LabeledSparsePoint[data.size()]);
        return dataArray;
    }

    public static LabeledSparsePoint[] getSparseSampleByOrderIdListWithFilter(String modelId, boolean isCtr, List<String> orderIdList, double negativeSampleRatio) throws Exception {
        LabeledSparsePoint[] ret = null;
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        List<LabeledSparsePoint> data = SampleParse.parseSparse(samples, modelId, isCtr);
        if (data != null) {
            List<LabeledSparsePoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledSparsePoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledFeature[] getSampleStrByOrderIdList(boolean isCtr, List<String> orderIdList, SampleTypeEnum sampleType, AdvertTypeEnum taskType) throws Exception {
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList, taskType);
        List<LabeledFeature> data = null;
        if (sampleType == null || SampleTypeEnum.CTR.equals((Object)sampleType)) {
            data = SampleParse.parse(samples, isCtr);
        }
        if (SampleTypeEnum.BCVR.equals((Object)sampleType)) {
            data = SampleParse.parseBcvrAdx(samples);
        }
        if (SampleTypeEnum.ADX_IDEA.equals((Object)sampleType)) {
            data = SampleParse.parseADXIdea(samples);
        }
        if (SampleTypeEnum.ADX_LAUNCH_PV.equals((Object)sampleType)) {
            data = SampleParse.parseADXLaunchPV(samples);
        }
        if (SampleTypeEnum.ADX_CHARGE_PV.equals((Object)sampleType)) {
            data = SampleParse.parseADXChargePV(samples);
        }
        if (SampleTypeEnum.ACT_RES_PLUG.equals((Object)sampleType)) {
            data = SampleParse.parseACT(samples);
        }
        if (SampleTypeEnum.ACT_TITLE.equals((Object)sampleType)) {
            data = SampleParse.parseACTTITLE(samples);
        }
        if (SampleTypeEnum.ACT_INTER.equals((Object)sampleType)) {
            data = SampleParse.parseACTINTER(samples);
        }
        if (SampleTypeEnum.PLUG_INTER.equals((Object)sampleType)) {
            data = SampleParse.parsePLUGINTER(samples);
        }
        LabeledFeature[] dataArray = data.toArray(new LabeledFeature[data.size()]);
        return dataArray;
    }

    public static LabeledWeightedDpaFeature[] getDPASampleStrByRid(List<String> ridList) throws Exception {
        LabeledWeightedDpaFeature[] dataArray = null;
        try {
            List<PsModelSample> samples = PsBo.getDPAACTPsSample(ridList);
            List<LabeledWeightedDpaFeature> data = SampleParse.parseDPAACT(samples);
            dataArray = data.toArray(new LabeledWeightedDpaFeature[data.size()]);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return dataArray;
    }

    public static LabeledWeightedDpaFeature[] getDPANonSdkSampleStrByRid(List<String> ridList) throws Exception {
        LabeledWeightedDpaFeature[] dataArray = null;
        try {
            List<PsModelSample> samples = PsBo.getDPAACTPsSample(ridList);
            List<LabeledWeightedDpaFeature> data = SampleParse.parseDPANonSdkACT(samples);
            dataArray = data.toArray(new LabeledWeightedDpaFeature[data.size()]);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return dataArray;
    }

    public static LabeledWeightedDpaFeature[] getDPAInterceptSampleStrByRid(List<String> ridList, Double negativeSampleRatio) throws Exception {
        LabeledWeightedDpaFeature[] dataArray = null;
        try {
            List<PsModelSample> samples = PsBo.getDPAACTPsSample(ridList);
            List<LabeledWeightedDpaFeature> data = SampleParse.parseDPAIntercept(samples, negativeSampleRatio);
            dataArray = data.toArray(new LabeledWeightedDpaFeature[data.size()]);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return dataArray;
    }

    public static LabeledWeightedDpaFeature[] getDPASampleStrByRid(List<String> ridList, Double negativeSampleRatio) throws Exception {
        LabeledWeightedDpaFeature[] dataArray = null;
        try {
            List<PsModelSample> samples = PsBo.getDPAACTPsSample(ridList);
            List<LabeledWeightedDpaFeature> data = SampleParse.parseDPAACT(samples, negativeSampleRatio);
            dataArray = data.toArray(new LabeledWeightedDpaFeature[data.size()]);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return dataArray;
    }

    public static LabeledWeightedDpaFeature[] getDPANonSdkSampleStrByRid(List<String> ridList, Double negativeSampleRatio) throws Exception {
        LabeledWeightedDpaFeature[] dataArray = null;
        try {
            List<PsModelSample> samples = PsBo.getDPAACTPsSample(ridList);
            List<LabeledWeightedDpaFeature> data = SampleParse.parseDPANonSdkACT(samples, negativeSampleRatio);
            dataArray = data.toArray(new LabeledWeightedDpaFeature[data.size()]);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return dataArray;
    }

    public static LabeledPoint[] getMaterialWithFilter(String modelId, boolean isCtr, List<PsModelSample> samples, double negativeSampleRatio, HashMap<String, Double> PosNegMap) throws Exception {
        LabeledPoint[] ret = null;
        System.out.println("===parse_pre, size=" + samples.size());
        List<LabeledPoint> data = SampleParse.parseMaterial(samples, modelId, PosNegMap);
        System.out.println("===parse_after, size=" + data.size());
        System.out.println("===negativeSampleRatio" + PosNegMap);
        if (data != null) {
            ret = data.toArray(new LabeledPoint[data.size()]);
        }
        return ret;
    }

    public static SlotLabeledPoint[] getMaterialWithFilterSlot(String modelId, boolean isCtr, List<PsModelSample> samples, double negativeSampleRatio, HashMap<String, Double> PosNegMap) throws Exception {
        SlotLabeledPoint[] ret = null;
        System.out.println("===parse_pre, size=" + samples.size());
        List<SlotLabeledPoint> data = SampleParse.parseMaterialSlot(samples, modelId, PosNegMap);
        System.out.println("===parse_after, size=" + data.size());
        System.out.println("===negativeSampleRatio" + PosNegMap);
        if (data != null) {
            ret = data.toArray(new SlotLabeledPoint[data.size()]);
        }
        return ret;
    }

    public static SlotLabeledPoint[] getDpWithFilterSlot(String modelId, boolean isCtr, List<PsModelSample> samples, double negativeSampleRatio) throws Exception {
        SlotLabeledPoint[] ret = null;
        System.out.println("===parse_pre, size=" + samples.size());
        List<SlotLabeledPoint> data = SampleParse.parseDpSlot(samples, modelId);
        System.out.println("===parse_after, size=" + data.size());
        if (data != null) {
            ret = data.toArray(new SlotLabeledPoint[data.size()]);
        }
        return ret;
    }

    public static SlotLabeledPoint[] getMaterialWithFilterSlot(String modelId, boolean isCtr, List<PsModelSample> nonAdSamples, List<PsModelSample> adSamples, double negativeSampleRatio, HashMap<String, Double> nonAdPosNegMap, HashMap<String, Double> adPosNegMap) throws Exception {
        SlotLabeledPoint[] ret = null;
        System.out.println("===parse_pre, non ad size=" + nonAdSamples.size() + ", ad size=" + adSamples.size());
        List<SlotLabeledPoint> data = SampleParse.parseMaterialSlot(nonAdSamples, adSamples, modelId, nonAdPosNegMap, adPosNegMap);
        System.out.println("===parse_after, size=" + data.size());
        System.out.println("===non ad negativeSampleRatio:" + nonAdPosNegMap + ",ad negativeSampleRatio:" + adPosNegMap);
        if (data != null) {
            ret = data.toArray(new SlotLabeledPoint[data.size()]);
        }
        return ret;
    }

    public static LabeledPoint[] getMaterialWithFilterOffline(String modelId, List<LabeledPoint> samples, double negativeSampleRatio) throws Exception {
        LabeledPoint[] ret = null;
        System.out.println("===parse_pre, size=" + samples.size());
        System.out.println("===parse_after, size=" + samples.size());
        System.out.println("===negativeSampleRatio" + negativeSampleRatio);
        if (samples != null) {
            List<LabeledPoint> dataList = samples.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        System.out.println("getMaterialWithFilterOffline===ret" + ret.length);
        return ret;
    }

    public static LabeledPointPairWise[] getMaterialWithFilterPairOffline(String modelId, List<LabeledPointPairWise> samples, double negativeSampleRatio) throws Exception {
        LabeledPointPairWise[] ret = null;
        System.out.println("===parse_pre, size=" + samples.size());
        System.out.println("===parse_after, size=" + samples.size());
        System.out.println("===negativeSampleRatio" + negativeSampleRatio);
        if (samples != null) {
            List<LabeledPointPairWise> dataList = samples.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPointPairWise[dataList.size()]);
        }
        System.out.println("getMaterialWithFilterPairOffline===ret length: " + ret.length);
        return ret;
    }

    public static LabeledPoint[] getMaterialWithFilter1(String modelId, boolean isCtr, List<PsModelSample> samples, double negativeSampleRatio) throws Exception {
        LabeledPoint[] ret = null;
        System.out.println("===parse_pre, size=" + samples.size());
        List<LabeledPoint> data = SampleParse.parseMaterial1(samples, modelId);
        System.out.println("===parse_after, size=" + data.size());
        System.out.println("===negativeSampleRatio" + negativeSampleRatio);
        if (data != null) {
            List<LabeledPoint> dataList = data.stream().filter(lp -> SampleBo.negativeSampleFilter(lp, negativeSampleRatio)).collect(Collectors.toList());
            ret = dataList.toArray(new LabeledPoint[dataList.size()]);
        }
        return ret;
    }

    public static LabeledESMMDcvrFeature[] getSampleStrByRow(Iterator<Row> partitionOfRecords) throws Exception {
        LabeledESMMDcvrFeature[] ret = null;
        ArrayList<LabeledESMMDcvrFeature> retTmp = new ArrayList<LabeledESMMDcvrFeature>();
        ArrayList samples = new ArrayList();
        int i = 0;
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                Long cvrLableL = row.getLong(0);
                Long dcvrLableL = row.getLong(1);
                String feature = row.getString(3);
                Integer cvrLable = cvrLableL.intValue();
                Integer dcvrLable = dcvrLableL.intValue();
                if (++i < 5) {
                    System.out.println("row_0=" + row.get(0) + ",row_1=" + row.get(1) + ",row_2=" + row.get(2) + ",row_3=" + row.get(3));
                }
                if (cvrLable == null || dcvrLable == null || feature == null) continue;
                if (cvrLable > 1) {
                    cvrLable = 1;
                }
                if (dcvrLable > 1) {
                    dcvrLable = 1;
                }
                if (cvrLable == 0 && dcvrLable == 1) {
                    dcvrLable = 0;
                }
                LabeledESMMDcvrFeature labeledESMMDcvrFeature = new LabeledESMMDcvrFeature((double)cvrLable.intValue(), (double)dcvrLable.intValue(), feature);
                retTmp.add(labeledESMMDcvrFeature);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ret = retTmp.toArray(new LabeledESMMDcvrFeature[retTmp.size()]);
        System.out.println("getSampleStrByRow.size=" + ret.length);
        return ret;
    }

    public static LabeledFeature[] getSampleStrByOrderIdList(boolean isCtr, List<String> orderIdList) throws Exception {
        return SampleBo.getSampleStrByOrderIdList(isCtr, orderIdList, SampleTypeEnum.CTR, AdvertTypeEnum.HD_AD);
    }

    public static LabeledFeature[] getBcvrSampleStrByOrderIdList(List<String> orderIdList) throws Exception {
        return SampleBo.getSampleStrByOrderIdList(false, orderIdList, SampleTypeEnum.BCVR, AdvertTypeEnum.HD_AD);
    }

    public static LabeledESMMFeature[] getBcvrESMMSampleStrByOrderIdList(List<String> orderIdList) throws Exception {
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        List<LabeledESMMFeature> data = SampleParse.parseESMMBcvr(samples);
        LabeledESMMFeature[] dataArray = data.toArray(new LabeledESMMFeature[data.size()]);
        return dataArray;
    }

    public static LabeledESMMFeature[] getESMMSampleStrByOrderIdList(List<String> orderIdList) throws Exception {
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        List<LabeledESMMFeature> data = SampleParse.parseESMM(samples);
        LabeledESMMFeature[] dataArray = data.toArray(new LabeledESMMFeature[data.size()]);
        return dataArray;
    }

    public static String[] getOrderList(List<String> timeList, boolean isDisplayADs, AdvertTypeEnum taskType) throws Exception {
        return SampleBo.getOrderList(timeList, isDisplayADs, 1.0, taskType);
    }

    public static String[] getOrderList(List<String> timeList, boolean isDisplayADs, double sampleRatio, AdvertTypeEnum taskType) throws Exception {
        String[] ret = null;
        try {
            if (timeList != null) {
                List<String> retTmp2;
                List<String> retTmp = PsBo.getOrderList(timeList, taskType);
                System.out.println("retTmp=" + retTmp.size());
                if (retTmp != null && (retTmp2 = retTmp.stream().filter(orderId -> SampleBo.adTypeFilter(orderId, isDisplayADs)).filter(orderId -> SampleBo.sampleFilter(sampleRatio)).collect(Collectors.toList())) != null && retTmp2.size() > 0) {
                    ret = retTmp2.toArray(new String[retTmp2.size()]);
                }
            }
            if (ret != null) {
                System.out.println("getOrderList.size=" + ret.length);
            } else {
                System.out.println("getOrderList.size=0");
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return ret;
    }

    public static String[] getOrderList(List<String> timeList, boolean isDisplayADs, double sampleRatio) throws Exception {
        if (Math.random() > 0.9) {
            System.gc();
        }
        return SampleBo.getOrderList(timeList, isDisplayADs, sampleRatio, null);
    }

    public static String[] getOrderList(List<String> timeList, boolean isDisplayADs) throws Exception {
        return SampleBo.getOrderList(timeList, isDisplayADs, 1.0, null);
    }

    public static String[] getOrderListTest(List<String> timeList, boolean isDisplayADs) throws Exception {
        return SampleBo.getOrderList(timeList, isDisplayADs, 1.0, null);
    }

    public static String[] getADXOrderList(List<String> timeList, boolean isDisplayADs) throws Exception {
        return SampleBo.getOrderList(timeList, isDisplayADs, 1.0, AdvertTypeEnum.ADX_AD);
    }

    public static String[] getZZOrderList(List<String> timeList, boolean isDisplayADs) throws Exception {
        return SampleBo.getOrderList(timeList, isDisplayADs, 1.0, AdvertTypeEnum.V_ADD_AD);
    }

    public static String[] getMaterialOrderList(List<String> timeList, boolean isDisplayADs) throws Exception {
        return SampleBo.getOrderList(timeList, isDisplayADs, 1.0, AdvertTypeEnum.MATERIAL);
    }

    public static String[] getApiMaterialOrderList(List<String> timeList, boolean isDisplayADs) throws Exception {
        return SampleBo.getOrderList(timeList, isDisplayADs, 1.0, AdvertTypeEnum.API_MATERIAL);
    }

    public static String[] getDpOrderList(List<String> timeList, boolean isDisplayADs) throws Exception {
        return SampleBo.getOrderList(timeList, isDisplayADs, 1.0, AdvertTypeEnum.DP);
    }

    public static List<String> getMinuteSecondInterval(String baseTime, int size, AdvertTypeEnum taskType) {
        if (AdvertTypeEnum.ADX_IDEA == taskType) {
            return SampleBo.getMinuteSecondInterval(baseTime, size, 1.0);
        }
        return SampleBo.getMinuteSecondInterval(baseTime, size);
    }

    public static List<String> getMinuteSecondInterval(String baseTime, int size) {
        ArrayList<String> dateList = new ArrayList<String>();
        Date baseDate = DateUtil.getDate((String)baseTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM);
        for (int i = 0; i < size * 60; ++i) {
            Date addDate = DateUtil.addSecond((Date)baseDate, (int)i);
            String dateStr = DateUtil.getDateTime((Date)addDate, (DateStyle)DateStyle.YYYYMMDDHHMMSS);
            dateList.add(dateStr);
        }
        System.out.println((String)dateList.get(0));
        System.out.println((String)dateList.get(dateList.size() - 1));
        return dateList;
    }

    public static List<String> getMinuteSecondInterval(String baseTime, int size, double ratio) {
        ArrayList<String> dateList = new ArrayList<String>();
        Date baseDate = DateUtil.getDate((String)baseTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM);
        for (int i = 0; i < size * 60; ++i) {
            if (!(Math.random() < ratio)) continue;
            Date addDate = DateUtil.addSecond((Date)baseDate, (int)i);
            String dateStr = DateUtil.getDateTime((Date)addDate, (DateStyle)DateStyle.YYYYMMDDHHMMSS);
            dateList.add(dateStr);
        }
        return dateList;
    }

    public static String[] getMinuteSecondIntervalArray(String baseTime, int size, double ratio) {
        List<String> dataList = SampleBo.getMinuteSecondInterval(baseTime, size, ratio);
        String[] array2 = dataList.toArray(new String[dataList.size()]);
        return array2;
    }

    public static List<String> getTimeInterval(String baseTime, int minute) {
        ArrayList<String> dateList = new ArrayList<String>();
        Date baseDate = DateUtil.getDate((String)baseTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
        Date baseDate2 = DateUtil.addMinute((Date)baseDate, (int)minute);
        System.out.println("time=" + DateUtil.getDate((Date)baseDate2, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM));
        for (int i = 0; i < 60; ++i) {
            Date addDate = DateUtil.addSecond((Date)baseDate2, (int)i);
            String dateStr = DateUtil.getDateTime((Date)addDate, (DateStyle)DateStyle.YYYYMMDDHHMMSS);
            dateList.add(dateStr);
        }
        return dateList;
    }

    public static List<String> getMinuteSecondInterval(String baseTime) {
        ArrayList<String> dateList = new ArrayList<String>();
        Date baseDate = DateUtil.getDate((String)baseTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM);
        for (int i = 0; i < 60; ++i) {
            Date addDate = DateUtil.addSecond((Date)baseDate, (int)i);
            String dateStr = DateUtil.getDateTime((Date)addDate, (DateStyle)DateStyle.YYYYMMDDHHMMSS);
            dateList.add(dateStr);
        }
        return dateList;
    }

    public static List<String> getTimeIntervalWithRatio(String baseTime, int minute, double ratio) {
        ArrayList<String> dateList = new ArrayList<String>();
        Date baseDate = DateUtil.getDate((String)baseTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
        Date baseDate2 = DateUtil.addMinute((Date)baseDate, (int)minute);
        System.out.println("time=" + DateUtil.getDate((Date)baseDate2, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM));
        for (int i = 0; i < 60; ++i) {
            if (!(Math.random() < ratio)) continue;
            Date addDate = DateUtil.addSecond((Date)baseDate2, (int)i);
            String dateStr = DateUtil.getDateTime((Date)addDate, (DateStyle)DateStyle.YYYYMMDDHHMMSS);
            dateList.add(dateStr);
        }
        return dateList;
    }

    public static String getTimeMinuteAdd(String baseTime, int minute) {
        Date baseDate = DateUtil.getDate((String)baseTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM);
        Date baseDate2 = DateUtil.addMinute((Date)baseDate, (int)minute);
        return DateUtil.getDate((Date)baseDate2, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM);
    }

    public static String getTimeMinuteAdd(Date baseDate, int minute) {
        Date baseDate2 = DateUtil.addMinute((Date)baseDate, (int)minute);
        return DateUtil.getDate((Date)baseDate2, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM);
    }

    public static String getPosMinute(String baseTime, int posMin, int perMinInterval, int interNum) {
        String ret = baseTime;
        Date baseDate = DateUtil.getDate((String)baseTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM);
        int bMin = DateUtil.getMinute((Date)baseDate);
        int bMinYu = (bMin + perMinInterval) % perMinInterval;
        int add = -(bMinYu - (posMin %= perMinInterval));
        if (add > 0) {
            add -= perMinInterval;
        }
        ret = SampleBo.getTimeMinuteAdd(baseDate, add += interNum * perMinInterval);
        return ret;
    }

    public static String getTimeWithPosForMinuteStepSize(String baseTime, int posMin, int stepSize, int delay) {
        String ret = null;
        Date baseDate = DateUtil.getDate((String)baseTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM);
        Date maxDate = DateUtil.addMinute((Date)baseDate, (int)(-1 * delay));
        int bMin = DateUtil.getMinute((Date)maxDate);
        int bMinYu = (bMin + stepSize) % stepSize;
        int add = -(bMinYu - (posMin %= stepSize));
        if (add > 0) {
            add -= stepSize;
        }
        ret = SampleBo.getTimeMinuteAdd(maxDate, add);
        return ret;
    }

    public static boolean adTypeFilter(String orderId, boolean isDisPlayADs) {
        boolean ret = false;
        boolean isDisPlayOrderId = orderId.contains("view");
        if (isDisPlayADs && isDisPlayOrderId) {
            ret = true;
        }
        if (!isDisPlayADs && !isDisPlayOrderId) {
            ret = true;
        }
        return ret;
    }

    public static boolean sampleFilter(double sampleRatio) {
        return Math.random() < sampleRatio;
    }
}

