/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.model.FFM;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.compute.biz.conf.JedisPoolConf;
import cn.com.duiba.nezha.compute.biz.conf.MongoDbConf;
import cn.com.duiba.nezha.compute.biz.constant.ProjectConstant;
import cn.com.duiba.nezha.compute.biz.constant.ps.PsConstant;
import cn.com.duiba.nezha.compute.biz.utils.jedis.JedisUtil;
import cn.com.duiba.nezha.compute.biz.utils.mongodb.MongoClientUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StdModelSaveBo {
    public static MongoClientUtil mongoClientUtil = new MongoClientUtil(MongoDbConf.config);
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);
    public static JedisUtil materialJedisUtil = new JedisUtil(JedisPoolConf.materialJedisConfig);

    private static String getLastModelKey(String modelKey) {
        return "nz_last_model_new_" + modelKey + "_";
    }

    private static String getADXModelKey(String modelKey) {
        return "TAE:ALGBID:MODEL:" + modelKey;
    }

    public static void saveModelByKeyToMD(String modelKey, FM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSaveBo.getLastModelKey(modelKey);
            HashMap<String, FM> map = new HashMap<String, FM>();
            map.put(key, model);
            System.out.println("save model with key " + key);
            mongoClientUtil.writeUpdateT2(MongoDbConf.config.getDatabaseName(), PsConstant.MODEL_TYPE, key, model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveModelByKeyToMDFFM(String modelKey, FFM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSaveBo.getLastModelKey(modelKey);
            HashMap<String, FFM> map = new HashMap<String, FFM>();
            map.put(key, model);
            System.out.println("save model with key " + key);
            System.out.println("ffmSaveModel.Weight0:  " + model.getParamsDoffm().getWeight0());
            System.out.println("ffmSaveModel.WeightSize:  " + model.getParamsDoffm().getWeight().size());
            System.out.println("ffmSaveModel.matrixSize:  " + model.getParamsDoffm().getVectorV3().size());
            System.out.println("ffmSaveModel.f501001_size:  " + ((Map)model.getParamsDoffm().getVectorV3().get("f501001")).size());
            System.out.println("ffmSaveModel.f501001_1L_size:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(1L)).size());
            System.out.println("ffmSaveModel.f501001_0L_size:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(0L)).size());
            System.out.println("ffmSaveModel.f501001_0L_8454273L:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(0L)).get(0x810081L));
            System.out.println("ffmSaveModel.f501001_0L_4259920L:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(0L)).get(4259920L));
            System.out.println("ffmSaveModel.f501001_0L_1344099L:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(0L)).get(1344099L));
            System.out.println("ffmSaveModel.f501001_0L_22312122L:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(0L)).get(22312122L));
            System.out.println("ffmSaveModel.f501001_0L_15214161L:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(0L)).get(15214161L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FM getModelByKeyFromMD(String modelKey) {
        FM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSaveBo.getLastModelKey(modelKey);
            System.out.println(" std read model with key=" + key);
            ret = mongoClientUtil.findT(MongoDbConf.config.getDatabaseName(), PsConstant.MODEL_TYPE, key, FM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static FFM getModelByKeyFromMDFFM(String modelKey) {
        FFM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSaveBo.getLastModelKey(modelKey);
            System.out.println(" std read model with key=" + key);
            ret = mongoClientUtil.findT(MongoDbConf.config.getDatabaseName(), PsConstant.MODEL_TYPE, key, FFM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveModelByKeyToJedis(String modelKey, FM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSaveBo.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
            StdModelSaveBo.updateTime(key, jedisUtil);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveListByKeyToJedis(String modelKey, List<String> list) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, list})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            System.out.println("save model with key " + modelKey);
            String value = JSON.toJSONString(list);
            jedisUtil.setex(modelKey, value, ProjectConstant.WEEK_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveMaterialModelByKeyToJedis(String modelKey, FM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveMaterialLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSaveBo.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            materialJedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
            StdModelSaveBo.updateTime(key, materialJedisUtil);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveMaterialModelByKeyToJedisFFM(String modelKey, FFM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveMaterialLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSaveBo.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            materialJedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
            StdModelSaveBo.updateTime(key, materialJedisUtil);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveADXModelByKeyToJedis(String modelKey, FM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSaveBo.getADXModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
            StdModelSaveBo.updateTime(key, jedisUtil);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FM getModelByKeyFromJedis(String modelKey) {
        FM ret = null;
        if (cn.com.duiba.nezha.compute.core.util.AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSaveBo.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (FM)JSON.parseObject((String)ret2, FM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveModelByKeyToJedisFFM(String modelKey, FFM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSaveBo.getLastModelKey(modelKey);
            System.out.println("ffmSaveModel.f501001_0L_8454273L:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(0L)).get(0x810081L));
            System.out.println("ffmSaveModel.f501001_0L_4259920L:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(0L)).get(4259920L));
            System.out.println("ffmSaveModel.f501001_0L_1344099L:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(0L)).get(1344099L));
            System.out.println("ffmSaveModel.f501001_0L_22312122L:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(0L)).get(22312122L));
            System.out.println("ffmSaveModel.f501001_0L_15214161L:  " + ((Map)((Map)model.getParamsDoffm().getVectorV3().get("f501001")).get(0L)).get(15214161L));
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
            StdModelSaveBo.updateTime(key, jedisUtil);
            System.out.println("save model with key done " + key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FFM getModelByKeyFromJedisFFM(String modelKey) {
        FFM ret = null;
        if (cn.com.duiba.nezha.compute.core.util.AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSaveBo.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (FFM)JSON.parseObject((String)ret2, FFM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void updateTime(String modelKey, JedisUtil jedisUtil) {
        String updateTimeKey = modelKey + "_update_time";
        String updateTime = LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
        jedisUtil.setex(updateTimeKey, updateTime, ProjectConstant.WEEK_1_EXPIRE);
    }
}

