/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo;

import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.FFM;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.compute.biz.bo.StdCoderModelSaveBo;
import cn.com.duiba.nezha.compute.biz.bo.StdModelSaveBo;
import cn.com.duiba.nezha.compute.biz.constant.feature.FeatureBcvrListConstant;
import cn.com.duiba.nezha.compute.biz.constant.feature.FeatureCoderModelListConstant;
import cn.com.duiba.nezha.compute.biz.constant.feature.FeatureListConstant;
import cn.com.duiba.nezha.compute.biz.constant.model.HParamsConstant;
import cn.com.duiba.nezha.compute.biz.dto.PsModelSample;
import cn.com.duiba.nezha.compute.biz.dto.SparceCoderStatDo;
import cn.com.duiba.nezha.compute.biz.enums.AdvertTypeEnum;
import cn.com.duiba.nezha.compute.biz.enums.model.ESMMModelKeyEnum;
import cn.com.duiba.nezha.compute.biz.enums.model.ModelKeyEnum;
import cn.com.duiba.nezha.compute.biz.enums.model.PsTypeEnum;
import cn.com.duiba.nezha.compute.biz.ps.PsAgent;
import cn.com.duiba.nezha.compute.biz.support.SampleParse;
import cn.com.duiba.nezha.compute.core.CollectionUtil;
import cn.com.duiba.nezha.compute.core.LabeledESMMDcvrFeature;
import cn.com.duiba.nezha.compute.core.LabeledESMMFeature;
import cn.com.duiba.nezha.compute.core.LabeledFeature;
import cn.com.duiba.nezha.compute.core.LabeledWeightedDpaFeature;
import cn.com.duiba.nezha.compute.core.enums.DateStyle;
import cn.com.duiba.nezha.compute.core.jmodel.JLocalModel;
import cn.com.duiba.nezha.compute.core.jmodel.JLocalVector;
import cn.com.duiba.nezha.compute.core.model.local.LocalModel;
import cn.com.duiba.nezha.compute.core.util.DateUtil;
import cn.com.duiba.nezha.compute.mllib.ffm.ftrl.FFMFTRL;
import cn.com.duiba.nezha.compute.mllib.ffm.ftrl.FFMFTRLHyperParams;
import cn.com.duiba.nezha.compute.mllib.ffm.ftrl.SparseFFMWithFTRL;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.FMFTRL;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.FMFTRLHyperParams;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.SparseFMWithFTRL;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Row;
import scala.collection.Iterator;

public class SyncBo {
    public static void delete(String modelId) throws Exception {
        PsAgent psAgent = new PsAgent(modelId);
        FMFTRLHyperParams hyperParams = HParamsConstant.getHParams(modelId);
        psAgent.delete(SparseFMWithFTRL.searchModel((int)psAgent.getBaseInfo().getDim(), (int)hyperParams.factorNum()));
    }

    public static void hbase2RedisFFM(String modelId) {
        try {
            FFMFTRLHyperParams hyperParams = HParamsConstant.getHParamsFFM(modelId);
            if (DateUtil.getCurrentTime().compareTo("2020-04-02 23:00:00") < 0) {
                PsAgent psAgentR = new PsAgent(modelId, PsTypeEnum.REDIS);
                if (!psAgentR.pullBaseInfo()) {
                    System.out.println("ps model,redis is null ,sync hbase -> redis ");
                    PsAgent psAgentH = new PsAgent(modelId, PsTypeEnum.HBASE);
                    psAgentH.pullBaseInfo();
                    List<FeatureBaseType> featureBaseTypeList = FeatureListConstant.getFeatureInfo(modelId);
                    if (featureBaseTypeList == null) {
                        featureBaseTypeList = FeatureBcvrListConstant.getFeatureInfo(modelId);
                    }
                    ArrayList<String> featureFieldList = new ArrayList<String>();
                    for (FeatureBaseType featureBaseType : featureBaseTypeList) {
                        featureFieldList.add(featureBaseType.getName());
                    }
                    String[] featureFieldArray = new String[featureFieldList.size()];
                    featureFieldList.toArray(featureFieldArray);
                    LocalModel localModelInitial = SparseFFMWithFTRL.searchModelWithField((int)psAgentH.getBaseInfo().getDim(), (int)hyperParams.factorNum(), (String[])featureFieldArray);
                    boolean status = psAgentH.pull(localModelInitial, true);
                    LocalModel localModel = psAgentH.getLocalModel();
                    psAgentR.pushAll(localModel, psAgentH.getBaseInfo());
                } else {
                    System.out.println("ps model,redis is exists ,continue ");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void hbase2RedisFM(String modelId) {
        try {
            FMFTRLHyperParams hyperParams = HParamsConstant.getHParams(modelId);
            if (DateUtil.getCurrentTime().compareTo("2020-04-02 23:59:00") < 0) {
                PsAgent psAgentR = new PsAgent(modelId, PsTypeEnum.REDIS);
                if (!psAgentR.pullBaseInfo()) {
                    System.out.println("ps model,redis is null ,sync hbase -> redis  start");
                    PsAgent psAgentH = new PsAgent(modelId, PsTypeEnum.HBASE);
                    boolean status = psAgentH.pull(SparseFMWithFTRL.searchModel((int)psAgentH.getBaseInfo().getDim(), (int)hyperParams.factorNum()), true);
                    LocalModel localModel = psAgentH.getLocalModel();
                    psAgentR.pushAll(localModel, psAgentH.getBaseInfo());
                    System.out.println("ps model,redis is null ,sync hbase -> redis  end");
                } else {
                    System.out.println("ps model,redis is exists ,continue ");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void coderHbase2Redis(String modelId) {
        try {
            PsAgent psAgentR = new PsAgent(modelId, 1000000, 1);
            psAgentR.setType(PsTypeEnum.REDIS);
            if (DateUtil.getCurrentTime().compareTo("2020-04-02 23:00:00") < 0) {
                if (!psAgentR.pullBaseInfo()) {
                    System.out.println("ps model,redis is null ,sync hbase -> redis ");
                    PsAgent psAgentH = new PsAgent(modelId, 1000000, 1);
                    psAgentH.setType(PsTypeEnum.HBASE);
                    psAgentH.pullBaseInfo();
                    SparceCoderStatDo sparceCoderStatDo = new SparceCoderStatDo();
                    sparceCoderStatDo.setFeatureList(FeatureCoderModelListConstant.getCoderFeatureList(modelId));
                    LocalModel sparceCountSearchModel = sparceCoderStatDo.getSearchSparceCountLocalModel();
                    psAgentH.pullAll(sparceCountSearchModel);
                    psAgentR.pushAll(psAgentH.getLocalModel(), psAgentH.getBaseInfo());
                } else {
                    System.out.println("ps model,redis is exists ,continue ");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void coderHbase2RedisAndReadTest(String modelId) {
        try {
            SyncBo.coderHbase2Redis(modelId);
            SparceCoderStatDo sparceCoderStatDo = new SparceCoderStatDo();
            PsAgent psAgentH = new PsAgent(modelId, 1000000, 1);
            psAgentH.setType(PsTypeEnum.HBASE);
            sparceCoderStatDo.setFeatureList(FeatureCoderModelListConstant.getCoderFeatureList(modelId));
            LocalModel sparceCountSearchModel = sparceCoderStatDo.getSearchSparceCountLocalModel();
            psAgentH.pullAll(sparceCountSearchModel);
            sparceCoderStatDo.setSparceCountLocalModel(psAgentH.getLocalModel());
            Map<String, Map<Long, Long>> sparceCount = sparceCoderStatDo.sparceCountToMap();
            System.out.println("hbase read " + JSON.toJSONString(sparceCount));
            SparceCoderStatDo sparceCoderStatDo2 = new SparceCoderStatDo();
            PsAgent psAgentR = new PsAgent(modelId, 1000000, 1);
            psAgentR.setType(PsTypeEnum.REDIS);
            sparceCoderStatDo2.setFeatureList(FeatureCoderModelListConstant.getCoderFeatureList(modelId));
            LocalModel sparceCountSearchModel2 = sparceCoderStatDo2.getSearchSparceCountLocalModel();
            psAgentR.pullAll(sparceCountSearchModel2);
            sparceCoderStatDo2.setSparceCountLocalModel(psAgentR.getLocalModel());
            Map<String, Map<Long, Long>> sparceCount2 = sparceCoderStatDo2.sparceCountToMap();
            System.out.println("redis read " + JSON.toJSONString(sparceCount2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void hbase2RedisFMAndReadTest(String modelId) {
        try {
            FM m1 = SyncBo.getJModel(modelId, PsTypeEnum.REDIS);
            String feature = "{\"f608001\":\"0\",\"f104001\":\"89505\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f505001\":\"\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f201001\":\"69636\",\"f660001\":\"17\",\"f609001\":\"1\",\"f804004\":\"1\",\"f804003\":\"3\",\"f804002\":\"0\",\"f804001\":\"3\",\"f810001\":\"1\",\"f770001\":\"07.14.0051\",\"f810002\":\"0\",\"f306001\":\"2\",\"chargeType\":\"1\",\"f206001\":\"540\",\"f504001\":\"\",\"f601001\":\"1\",\"f601002\":\"1\",\"f607001\":\"0\",\"f206002\":\"538\",\"f811001\":\"102\",\"f403004\":\"0\",\"f805001\":\"3\",\"f805002\":\"0\",\"f805003\":\"3\",\"f805004\":\"1\",\"f9940\":\"2,13,25,37,49,61,73,85,97,109,121,133,145,157,169\",\"f9941\":\"|||5337|||5337|||5337|5337||5337\",\"f9942\":\"0.618099,0.526595,0.465138,0.358335,0.530794,0.503094,0.525437,0.370032\",\"f9943\":\"5337\",\"f9702\":\"0\",\"f9944\":\"5337\",\"f602001\":\"1\",\"f205002\":\"197\",\"f205001\":\"196\",\"f701001\":\"1061178\",\"f811002\":\"102\",\"f404003\":\"workother\",\"f106001\":\"22597\",\"f660201\":\"0\",\"f112001\":\"\",\"f101001\":\"61178\",\"f701002\":\"1069636\",\"f9607\":\"null\",\"f9608\":\"null\",\"f9609\":\"null\",\"f503001\":\"4509\",\"time\":\"20200406160207\",\"f9601\":\"null\",\"f9602\":\"null\",\"f602002\":\"1\",\"f9603\":\"null\",\"orderId\":\"taw-810035721541023\",\"f113001\":\"04.01.0006,04.03.0013,04.03.0017\",\"f806001\":\"3\",\"f806002\":\"0\",\"f806003\":\"3\",\"f830101\":\"null\",\"f9916\":\"02.24.0001&2\",\"f806004\":\"1\",\"f830102\":\"null\",\"f9917\":\"02.24.0001&1\",\"f830103\":\"null\",\"f9918\":\"02.24.0001&1\",\"f830104\":\"null\",\"f9919\":\"02.24.0001&8\",\"adxRid\":\"0011d50b4e90e08a9b8795a588d309ff-k8ls9qnq-28499299_1000000000381\",\"f502001\":\"16\",\"f502002\":\"1\",\"f611001\":\"1\",\"f9902\":\"5337\",\"f9903\":\"1\",\"f770501\":\"0\",\"f606002\":\"10\",\"f606001\":\"99\",\"f102001\":\"02.24.0001\",\"f9930\":\"0\",\"f9931\":\"-1\",\"f301001\":\"999999\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"326766\",\"advertId\":\"61178\",\"f807002\":\"0\",\"f9924\":\"\",\"f807001\":\"3\",\"f507001\":\"3\",\"f807004\":\"1\",\"f830111\":\"null\",\"f807003\":\"3\",\"f830112\":\"null\",\"f9927\":\"0\",\"f830113\":\"null\",\"f9928\":\"0\",\"f830114\":\"null\",\"f9929\":\"0\",\"f770401\":\"0\",\"f9921\":\"\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"\",\"f9802\":\"0\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"unknow\",\"f610001\":\"0\",\"f303001\":\"1\",\"f114001\":\"119\",\"consumerId\":\"1190868170313727\",\"f114002\":\"227\",\"f406001\":\"1\",\"f830011\":\"null\",\"f830012\":\"null\",\"f830013\":\"null\",\"f830014\":\"null\",\"f115001\":\"0\",\"f808002\":\"0_0,02.24.0001_0\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"0_1,02.24.0001_1\",\"f8803\":\"1\",\"f605001\":\"99\",\"f605002\":\"10\",\"f302001\":\"-1\"}\n";
            JSONObject featureIdxMap = JSON.parseObject((String)feature);
            System.out.println("m1:" + m1.predict((Map)featureIdxMap));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void hbase2RedisFFMAndReadTest(String modelId) {
        try {
            SyncBo.hbase2RedisFFM(modelId);
            FFM m1 = SyncBo.getJModelFFM(modelId, PsTypeEnum.REDIS);
            FFM m2 = SyncBo.getJModelFFM(modelId, PsTypeEnum.HBASE);
            String feature = "{\"f4010010\":\"Mozilla/5.0 (Linux; Android 6.0; CAM-AL00 Build/HONORCAM-AL00; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.132 MQQBrowser/6.2 TBS/044328 Mobile Safari/537.36 mojia/1007010802\",\"f4010091\":\"2\",\"f3010120\":\"1\",\"f2010030\":\"4\",\"f4010090\":\"2\",\"f1010010\":\"11\",\"f5010060\":\"0\",\"f4010041\":\"0\",\"f4010121\":\"21\",\"f2010020\":\"0\",\"f4010080\":\"1\",\"f3010010\":\"5128\",\"f3010130\":\"0\",\"f6010020\":\"com.moji.mjweather\",\"f5010070\":\"0\",\"f4010122\":\"3\",\"f4010031\":\"86\",\"f4010030\":\"6102\",\"f4010110\":\"108.86984\",\"f4010070\":\"0\",\"f2010050\":\"4\",\"f6010010\":\"mojiWeather\",\"f2010010\":\"80\",\"f3010060\":\"60\",\"f6010090\":\"80\",\"f5010080\":\"0\",\"f4010020\":\"111.18.90.230\",\"f3010070\":\"60\",\"f4010060\":\"CAM-AL00\",\"f1010020\":\"3\",\"f5010090\":\"0\",\"f5010050\":\"864233033321573\",\"f5010010\":\"O\",\"f4010100\":\"34.865234\"}";
            JSONObject featureIdxMap = JSON.parseObject((String)feature);
            System.out.println("m1:" + m1.predict((Map)featureIdxMap));
            System.out.println("m2:" + m2.predict((Map)featureIdxMap));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static LocalModel getSearchModel(String modelId) throws Exception {
        PsAgent psAgent = new PsAgent(modelId);
        FMFTRLHyperParams hyperParams = HParamsConstant.getHParams(modelId);
        boolean status = psAgent.pull(SparseFMWithFTRL.searchModel((int)psAgent.getBaseInfo().getDim(), (int)hyperParams.factorNum()), true);
        LocalModel localModel = psAgent.getLocalModel();
        return localModel;
    }

    public static FMFTRL getLocalModel(String modelId, PsTypeEnum psTypeEnum) throws Exception {
        PsAgent psAgent = new PsAgent(modelId, psTypeEnum);
        FMFTRLHyperParams hyperParams = HParamsConstant.getHParams(modelId);
        boolean status = psAgent.pull(SparseFMWithFTRL.searchModel((int)psAgent.getBaseInfo().getDim(), (int)hyperParams.factorNum()), true);
        LocalModel localModel = psAgent.getLocalModel();
        JLocalModel jLocalModel = LocalModel.toJLocalModel((LocalModel)localModel);
        System.out.println(JSON.toJSONString((Object)jLocalModel.getValueMap()));
        System.out.println(JSON.toJSONString((Object)((JLocalVector)jLocalModel.getVectorMap().get((Object)"w_z")).jsparseVector.size));
        localModel = LocalModel.toLocalModel((JLocalModel)jLocalModel);
        FMFTRL model = new FMFTRL();
        model.setAlpha(hyperParams.alpha()).setBeta(hyperParams.beta()).setLambda1(hyperParams.lambda1()).setLambda2(hyperParams.lambda2()).setLocalModel(localModel);
        model.setDim(psAgent.getBaseInfo().getDim()).setFacotrNum(hyperParams.factorNum());
        return model;
    }

    public static FFMFTRL getLocalModelFFM(String modelId, PsTypeEnum psTypeEnum) throws Exception {
        PsAgent psAgent = new PsAgent(modelId, psTypeEnum);
        FFMFTRLHyperParams hyperParams = HParamsConstant.getHParamsFFM(modelId);
        List<FeatureBaseType> featureBaseTypeList = FeatureListConstant.getFeatureInfo(modelId);
        if (featureBaseTypeList == null) {
            featureBaseTypeList = FeatureBcvrListConstant.getFeatureInfo(modelId);
        }
        ArrayList<String> featureFieldList = new ArrayList<String>();
        for (FeatureBaseType featureBaseType : featureBaseTypeList) {
            featureFieldList.add(featureBaseType.getName());
        }
        String[] featureFieldArray = new String[featureFieldList.size()];
        featureFieldList.toArray(featureFieldArray);
        LocalModel localModelInitial = SparseFFMWithFTRL.searchModelWithField((int)psAgent.getBaseInfo().getDim(), (int)hyperParams.factorNum(), (String[])featureFieldArray);
        boolean status = psAgent.pull(localModelInitial, true);
        LocalModel localModel = psAgent.getLocalModel();
        FFMFTRL model = new FFMFTRL();
        model.setAlpha(hyperParams.alpha()).setBeta(hyperParams.beta()).setLambda1(hyperParams.lambda1()).setLambda2(hyperParams.lambda2()).setLocalModel(featureFieldArray, localModel);
        model.setDim(psAgent.getBaseInfo().getDim()).setFacotrNum(hyperParams.factorNum());
        return model;
    }

    public static FM getJModel(String modelId, PsTypeEnum psTypeEnum) throws Exception {
        FM fmModel = SyncBo.getLocalModel(modelId, psTypeEnum).toStdFM();
        fmModel.setModelId(modelId);
        fmModel.setUpdateTime(DateUtil.getCurrentTime());
        List<FeatureBaseType> featureBaseTypes = FeatureListConstant.getFeatureInfo(modelId);
        if (featureBaseTypes == null) {
            featureBaseTypes = FeatureBcvrListConstant.getFeatureInfo(modelId);
        }
        fmModel.setFeatureBaseType(featureBaseTypes);
        return fmModel;
    }

    public static FFM getJModelFFM(String modelId, PsTypeEnum psTypeEnum) throws Exception {
        FFMFTRL localFFM = SyncBo.getLocalModelFFM(modelId, psTypeEnum);
        FFM ffmModel = localFFM.toStdFFM();
        ffmModel.setModelId(modelId);
        ffmModel.setUpdateTime(DateUtil.getCurrentTime());
        List<FeatureBaseType> featureBaseTypeList = FeatureListConstant.getFeatureInfo(modelId);
        if (featureBaseTypeList == null) {
            featureBaseTypeList = FeatureBcvrListConstant.getFeatureInfo(modelId);
        }
        ffmModel.setFeatureBaseType(featureBaseTypeList);
        return ffmModel;
    }

    public static List<String> getFeatureCode(String modelId, List<LabeledFeature> rowList) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            FM fmModel = StdModelSaveBo.getModelByKeyFromJedis(modelId);
            System.out.println("fmModel.getUpdateTime() = " + fmModel.getUpdateTime());
            if (fmModel != null && rowList != null) {
                System.out.println("getFeatureCode");
                for (LabeledFeature labeledFeature : rowList) {
                    JSONObject map = JSON.parseObject((String)labeledFeature.feature());
                    map.put("f115001", labeledFeature.labelType() + "");
                    double[] paramsCode = fmModel.getParam2((Map)map);
                    String strTmp = CollectionUtil.toString((double[])paramsCode);
                    if (strTmp == null) continue;
                    String retSub = labeledFeature.label() + strTmp;
                    ret.add(retSub);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static List<String> getFeatureCodeMoe(String modelId, List<LabeledFeature> rowList, String subType) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            FM fmModel = StdModelSaveBo.getModelByKeyFromJedis(modelId);
            System.out.println("fmModel.getUpdateTime() = " + fmModel.getUpdateTime());
            if (rowList != null) {
                System.out.println("getFeatureCode");
                for (LabeledFeature labeledFeature : rowList) {
                    double[] paramsCode;
                    String strTmp;
                    JSONObject map = JSON.parseObject((String)labeledFeature.feature());
                    if (subType.equals("0")) {
                        if (labeledFeature.labelType() == 0) {
                            map.put("f115001", "0");
                        } else if (labeledFeature.labelType() == 1) {
                            map.put("f115001", "1");
                        } else if (labeledFeature.labelType() == 4) {
                            map.put("f115001", "4");
                        } else if (labeledFeature.labelType() == 2 || labeledFeature.labelType() == 3) {
                            continue;
                        }
                    } else if (subType.equals("2")) {
                        if (labeledFeature.labelType() != 2) continue;
                        map.put("f115001", "2");
                    } else if (subType.equals("3")) {
                        if (labeledFeature.labelType() != 3) continue;
                        map.put("f115001", "3");
                    }
                    if ((strTmp = CollectionUtil.toString((double[])(paramsCode = fmModel.getParam2((Map)map)))) == null) continue;
                    String retSub = labeledFeature.label() + strTmp;
                    ret.add(retSub);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static List<String> getFeatureDPAWeightedCode(String modelId, List<LabeledWeightedDpaFeature> rowList, AdvertTypeEnum taskType) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            CODER coder = StdCoderModelSaveBo.getModelCoderByKeyFromJedis(modelId, taskType);
            System.out.println("fmModel.getUpdateTime() = " + coder.getUpdateTime());
            if (coder != null && rowList != null) {
                System.out.println("getFeatureCode");
                for (LabeledWeightedDpaFeature labeledFeature : rowList) {
                    JSONObject map = JSON.parseObject((String)labeledFeature.feature());
                    String paramsCode = coder.getCode((Map)map);
                    if (paramsCode == null) continue;
                    String retSub = labeledFeature.joinCnt() + "," + labeledFeature.fee() + "," + labeledFeature.dCharged() + "," + labeledFeature.dIsExp() + " " + paramsCode;
                    ret.add(retSub);
                    System.out.println(retSub);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static List<String> getFeatureE2ECode(String modelId, List<LabeledFeature> rowList, AdvertTypeEnum taskType) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            CODER coder = StdCoderModelSaveBo.getModelCoderByKeyFromJedis(modelId, taskType);
            System.out.println("fmModel.getUpdateTime() = " + coder.getUpdateTime());
            if (coder != null && rowList != null) {
                System.out.println("getFeatureCode");
                for (LabeledFeature labeledFeature : rowList) {
                    JSONObject map = JSON.parseObject((String)labeledFeature.feature());
                    map.put("f115001", labeledFeature.labelType() + "");
                    String paramsCode = coder.getCode((Map)map);
                    if (paramsCode == null) continue;
                    String retSub = labeledFeature.label() + " " + paramsCode;
                    ret.add(retSub);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static List<String> getFeatureE2ECodeV2(String modelId, List<LabeledFeature> rowList, AdvertTypeEnum taskType) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            CODER2 coder = StdCoderModelSaveBo.getModelCoderV2ByKeyFromJedis(modelId, taskType);
            System.out.println("coder: " + coder);
            System.out.println("coder feature rowList size: " + rowList.size());
            HashMap<Long, Long> retMap = new HashMap<Long, Long>();
            if (coder != null && rowList != null) {
                System.out.println("getFeatureCode");
                for (LabeledFeature labeledFeature : rowList) {
                    JSONObject map = JSON.parseObject((String)labeledFeature.feature());
                    String slot_id = map.getOrDefault("f108001", "-1");
                    String paramsCode = coder.getCode((Map)map);
                    if (paramsCode == null) continue;
                    String retSub = labeledFeature.label() + " " + paramsCode + " " + slot_id;
                    ret.add(retSub);
                    if (labeledFeature.label() > 0.0) {
                        retMap.put(1L, retMap.getOrDefault(1L, 0L) + 1L);
                        continue;
                    }
                    retMap.put(0L, retMap.getOrDefault(0L, 0L) + 1L);
                }
                System.out.println("sampleCnt=" + JSON.toJSONString(retMap));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static List<String> getESMMDcvrFeatureCodeFromRowV2(String modelId, Iterator<Row> partitionOfRecords, AdvertTypeEnum taskType) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            CODER2 coder = StdCoderModelSaveBo.getModelCoderV2ByKeyFromJedis(modelId, taskType);
            System.out.println("fmModel.getUpdateTime() = " + coder.getUpdateTime());
            int i = 0;
            HashMap tmpCoderCache = new HashMap(20000);
            while (partitionOfRecords.hasNext()) {
                Row row = (Row)partitionOfRecords.next();
                try {
                    if (row == null) continue;
                    PsModelSample psModelSample = new PsModelSample();
                    Long cvrLableL = row.getLong(0);
                    Long dcvrLableL = row.getLong(1);
                    String markStr = row.getString(2);
                    String feature = row.getString(3);
                    Integer cvrLable = cvrLableL.intValue();
                    Integer dcvrLable = dcvrLableL.intValue();
                    if (++i < 3) {
                        System.out.println("row_0=" + row.get(0) + ",row_1=" + row.get(1) + ",row_2=" + row.get(2) + ",row_3=" + row.get(3));
                    }
                    if (cvrLable == null || dcvrLable == null || feature == null) continue;
                    if (cvrLable > 1) {
                        cvrLable = 1;
                    }
                    if (dcvrLable > 1) {
                        dcvrLable = 1;
                    }
                    if (cvrLable == 0 && dcvrLable == 1) {
                        dcvrLable = 0;
                    }
                    JSONObject map = JSON.parseObject((String)feature);
                    String paramsCode = coder.getCode((Map)map);
                    String retSub = cvrLable + " " + dcvrLable + " " + markStr + " " + paramsCode;
                    if (i < 3) {
                        System.out.println(retSub);
                    }
                    ret.add(retSub);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            tmpCoderCache.clear();
            tmpCoderCache = null;
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("getESMMDcvrFeatureCode.size=" + ret.size());
        return ret;
    }

    public static List<String> getESMMDcvrFeatureCodeFromRow(String modelId, Iterator<Row> partitionOfRecords, AdvertTypeEnum taskType) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            CODER2 coder = StdCoderModelSaveBo.getModelCoderV2ByKeyFromJedis(modelId, taskType);
            System.out.println("fmModel.getUpdateTime() = " + coder.getUpdateTime());
            int i = 0;
            HashMap tmpCoderCache = new HashMap(20000);
            while (partitionOfRecords.hasNext()) {
                Row row = (Row)partitionOfRecords.next();
                try {
                    if (row == null) continue;
                    PsModelSample psModelSample = new PsModelSample();
                    Long cvrLableL = row.getLong(0);
                    Long dcvrLableL = row.getLong(1);
                    String feature = row.getString(3);
                    Integer cvrLable = cvrLableL.intValue();
                    Integer dcvrLable = dcvrLableL.intValue();
                    if (++i < 3) {
                        System.out.println("row_0=" + row.get(0) + ",row_1=" + row.get(1) + ",row_2=" + row.get(2) + ",row_3=" + row.get(3));
                    }
                    if (cvrLable == null || dcvrLable == null || feature == null) continue;
                    if (cvrLable > 1) {
                        cvrLable = 1;
                    }
                    if (dcvrLable > 1) {
                        dcvrLable = 1;
                    }
                    if (cvrLable == 0 && dcvrLable == 1) {
                        dcvrLable = 0;
                    }
                    JSONObject map = JSON.parseObject((String)feature);
                    String paramsCode = coder.getCode((Map)map);
                    String retSub = cvrLable + " " + dcvrLable + " " + paramsCode;
                    if (i < 3) {
                        System.out.println(retSub);
                    }
                    ret.add(retSub);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            tmpCoderCache.clear();
            tmpCoderCache = null;
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("getESMMDcvrFeatureCode.size=" + ret.size());
        return ret;
    }

    public static List<String> getLaunchPvSample(String modelId, Iterator<Row> partitionOfRecords, AdvertTypeEnum taskType) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            CODER coder = StdCoderModelSaveBo.getModelCoderByKeyFromJedis(modelId, taskType);
            assert (coder != null);
            System.out.println("fmModel.getUpdateTime() = " + coder.getUpdateTime());
            int i = 0;
            while (partitionOfRecords.hasNext()) {
                Row row = (Row)partitionOfRecords.next();
                try {
                    if (row == null) continue;
                    String feature = row.getString(0);
                    Long label = row.getLong(1);
                    Double resource_Id = row.getDouble(2);
                    String ideaId = row.getString(3);
                    if (++i < 3) {
                        System.out.println("row_0=" + row.get(0) + ",row_1=" + row.get(1) + ",row_2=" + row.get(2) + ",row_3=" + row.get(3));
                    }
                    if (label > 5L) {
                        label = 5L;
                    }
                    if (feature == null) continue;
                    JSONObject featureMap = JSON.parseObject((String)feature);
                    String featureCoder = coder.getCode((Map)featureMap);
                    String retSub = label + " " + resource_Id + " " + ideaId + " " + featureCoder;
                    if (i < 3) {
                        System.out.println("retSub: " + retSub);
                    }
                    ret.add(retSub);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("getDpCtrFeatureCode.size==" + ret.size());
        return ret;
    }

    public static List<String> getDpCtrFeatureCodeFromRow(String modelId, Iterator<Row> partitionOfRecords, AdvertTypeEnum taskType) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            CODER2 coder = StdCoderModelSaveBo.getModelCoderV2ByKeyFromJedis(modelId, taskType);
            assert (coder != null);
            System.out.println("fmModel.getUpdateTime() = " + coder.getUpdateTime());
            int i = 0;
            while (partitionOfRecords.hasNext()) {
                Row row = (Row)partitionOfRecords.next();
                try {
                    if (row == null) continue;
                    PsModelSample psModelSample = new PsModelSample();
                    String feature = row.getString(0);
                    Long joinCnt = row.getLong(1);
                    Double chargefee = row.getDouble(2);
                    String slot_id = row.getString(3);
                    if (++i < 3) {
                        System.out.println("row_0=" + row.get(0) + ",row_1=" + row.get(1) + ",row_2=" + row.get(2) + ",row_3=" + row.get(3));
                    }
                    if (feature == null) continue;
                    JSONObject featureMap = JSON.parseObject((String)feature);
                    String featureCoder = coder.getCode((Map)featureMap);
                    String retSub = joinCnt + "," + chargefee + " " + featureCoder + "##" + slot_id;
                    if (i < 3) {
                        System.out.println("retSub: " + retSub);
                    }
                    ret.add(retSub);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("getDpCtrFeatureCode.size==" + ret.size());
        return ret;
    }

    public static List<String> getMaterialCtrFeatureCodeFromRow(String modelId, Iterator<Row> partitionOfRecords, AdvertTypeEnum taskType) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            CODER2 coder = StdCoderModelSaveBo.getModelCoderV2ByKeyFromJedis(modelId, taskType);
            assert (coder != null);
            System.out.println("fmModel.getUpdateTime() = " + coder.getUpdateTime());
            int i = 0;
            while (partitionOfRecords.hasNext()) {
                Row row = (Row)partitionOfRecords.next();
                try {
                    if (row == null) continue;
                    PsModelSample psModelSample = new PsModelSample();
                    String item1_feature = row.getString(0);
                    long ctrLabelL = row.getLong(1);
                    String slot_id = row.getString(2);
                    int ctrLabel = (int)ctrLabelL;
                    if (++i < 3) {
                        System.out.println("row_0=" + row.get(0) + ",row_1=" + row.get(1) + ",row_2=" + row.get(2));
                    }
                    if (item1_feature == null) continue;
                    if (ctrLabel > 1) {
                        ctrLabel = 1;
                    }
                    JSONObject item1_map = JSON.parseObject((String)item1_feature);
                    String item1_paramsCode = coder.getCode((Map)item1_map);
                    String retSub = ctrLabel + "##" + item1_paramsCode + "##" + slot_id;
                    if (i < 3) {
                        System.out.println("retSub: " + retSub);
                    }
                    ret.add(retSub);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("getMaterialCtrFeatureCode.size==" + ret.size());
        return ret;
    }

    public static List<String> getESMMDcvrFeatureCode(String modelId, List<LabeledESMMDcvrFeature> rowList, AdvertTypeEnum taskType) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            CODER2 coder = StdCoderModelSaveBo.getModelCoderV2ByKeyFromJedis(modelId, taskType);
            System.out.println("fmModel.getUpdateTime() = " + coder.getUpdateTime());
            if (coder != null && rowList != null) {
                System.out.println("getFeatureCode");
                for (LabeledESMMDcvrFeature labeledFeature : rowList) {
                    JSONObject map = JSON.parseObject((String)labeledFeature.feature());
                    String paramsCode = coder.getCode((Map)map);
                    if (paramsCode == null) continue;
                    String retSub = labeledFeature.cvrLabel() + " " + labeledFeature.dcvrLabel() + " " + paramsCode;
                    ret.add(retSub);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("getESMMDcvrFeatureCode.size=" + ret.size());
        return ret;
    }

    public static List<String> getESMMFeatureCode(String ctrModelId, String cvrModelId, List<PsModelSample> samples) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            FM ctrFmModel = StdModelSaveBo.getModelByKeyFromJedis(ctrModelId);
            FM cvrFmModel = StdModelSaveBo.getModelByKeyFromJedis(cvrModelId);
            if (ctrFmModel != null && cvrFmModel != null && samples != null) {
                for (PsModelSample sample : samples) {
                    JSONObject map = JSON.parseObject((String)sample.getFeature());
                    double[] ctrParamsCode = ctrFmModel.getParam2((Map)map);
                    double[] cvrParamsCode = cvrFmModel.getParam2((Map)map);
                    String ctrStrTmp = CollectionUtil.toString((double[])ctrParamsCode);
                    String cvrStrTmp = CollectionUtil.toString((double[])cvrParamsCode);
                    if (ctrStrTmp == null || cvrStrTmp == null) continue;
                    String retSub = SampleParse.toLabel(sample.getIsClick()) + "," + SampleParse.toLabel(sample.getIsActClick()) + ctrStrTmp + cvrStrTmp;
                    ret.add(retSub);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static List<String> getESMMFeatureCode2(String ctrModelId, String cvrModelId, List<LabeledESMMFeature> samples) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            FM ctrFmModel = StdModelSaveBo.getModelByKeyFromJedis(ctrModelId);
            FM cvrFmModel = StdModelSaveBo.getModelByKeyFromJedis(cvrModelId);
            if (ctrFmModel != null && cvrFmModel != null && samples != null) {
                for (LabeledESMMFeature sample : samples) {
                    JSONObject map = JSON.parseObject((String)sample.feature());
                    double[] ctrParamsCode = ctrFmModel.getParam2((Map)map);
                    String ctrStrTmp = CollectionUtil.toString((double[])ctrParamsCode);
                    map.put("f115001", sample.labelType() + "");
                    double[] cvrParamsCode = cvrFmModel.getParam2((Map)map);
                    String cvrStrTmp = CollectionUtil.toString((double[])cvrParamsCode);
                    if (ctrStrTmp == null || cvrStrTmp == null) continue;
                    String retSub = sample.hasCvr() + "," + sample.ctrLabel() + "," + sample.cvrLabel() + ctrStrTmp + cvrStrTmp;
                    ret.add(retSub);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void syncFMModel(String onLinemodelId, String psModelId, boolean isSync, double negativeSampleRatio) throws Exception {
        if (isSync) {
            SyncBo.hbase2RedisFM(psModelId);
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sync model,psModelId=" + psModelId + ",onlineModelId=" + onLinemodelId);
            FM fm = SyncBo.getJModel(psModelId, null);
            fm.getParamsDo().setCorrect(Double.valueOf(negativeSampleRatio));
            StdModelSaveBo.saveModelByKeyToJedis(onLinemodelId, fm);
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  save model end ");
        }
    }

    public static void syncADXFMModel(String onLinemodelId, String psModelId, boolean isSync, double negativeSampleRatio) throws Exception {
        if (isSync) {
            SyncBo.hbase2RedisFM(psModelId);
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sync model,psModelId=" + psModelId + ",onlineModelId=" + onLinemodelId);
            FM fm = SyncBo.getJModel(psModelId, null);
            fm.getParamsDo().setCorrect(Double.valueOf(negativeSampleRatio));
            StdModelSaveBo.saveADXModelByKeyToJedis(onLinemodelId, fm);
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  save model end ");
        }
    }

    public static void syncFFMModel(String onLinemodelId, String psModelId, boolean isSync, double negativeSampleRatio) throws Exception {
        if (isSync) {
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sync model,psModelId=" + psModelId + ",onlineModelId=" + onLinemodelId);
            SyncBo.hbase2RedisFFM(psModelId);
            FFM ffm = SyncBo.getJModelFFM(psModelId, null);
            ffm.getParamsDoffm().setCorrect(Double.valueOf(negativeSampleRatio));
            StdModelSaveBo.saveModelByKeyToJedisFFM(onLinemodelId, ffm);
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  save model end ");
        }
    }

    public static void syncModel(ModelKeyEnum modelKeyEnum, boolean isSync) throws Exception {
        if (modelKeyEnum.getType() == 1) {
            SyncBo.syncFMModel(modelKeyEnum.getIndex(), modelKeyEnum.getPsIndex(), isSync, modelKeyEnum.getNegativeSampleRatio());
        }
        if (modelKeyEnum.getType() == 2) {
            SyncBo.syncFFMModel(modelKeyEnum.getIndex(), modelKeyEnum.getPsIndex(), isSync, modelKeyEnum.getNegativeSampleRatio());
        }
    }

    public static void syncMTFMModel(ModelKeyEnum modelKeyEnum, boolean isSync) throws Exception {
        SyncBo.syncFMModel(modelKeyEnum.getIndex(), modelKeyEnum.getPsIndex(), isSync, modelKeyEnum.getNegativeSampleRatio());
    }

    public static void syncADXModel(ModelKeyEnum modelKeyEnum, boolean isSync) throws Exception {
        SyncBo.syncADXFMModel(modelKeyEnum.getIndex(), modelKeyEnum.getPsIndex(), isSync, modelKeyEnum.getNegativeSampleRatio());
    }

    public static void syncModel(ESMMModelKeyEnum modelKeyEnum, boolean isSync, int modelType) throws Exception {
        if (modelType == 3) {
            SyncBo.syncModel(modelKeyEnum.getCvrModel(), isSync);
        } else {
            SyncBo.syncModel(modelKeyEnum.getCtrModel(), isSync);
            SyncBo.syncModel(modelKeyEnum.getCvrModel(), isSync);
        }
    }

    public static void syncMaterialFMModel(String onLinemodelId, String psModelId, boolean isSync, double negativeSampleRatio) throws Exception {
        if (isSync) {
            SyncBo.hbase2RedisFM(psModelId);
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sync model,psModelId=" + psModelId + ",onlineModelId=" + onLinemodelId);
            FM fm = SyncBo.getJModel(psModelId, null);
            fm.getParamsDo().setCorrect(Double.valueOf(negativeSampleRatio));
            StdModelSaveBo.saveMaterialModelByKeyToJedis(onLinemodelId, fm);
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  save model end ");
        }
    }

    public static void syncMaterialFFMModel(String onLinemodelId, String psModelId, boolean isSync, double negativeSampleRatio) throws Exception {
        if (isSync) {
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sync model,psModelId=" + psModelId + ",onlineModelId=" + onLinemodelId);
            SyncBo.hbase2RedisFFM(psModelId);
            FFM ffm = SyncBo.getJModelFFM(psModelId, null);
            ffm.getParamsDoffm().setCorrect(Double.valueOf(negativeSampleRatio));
            StdModelSaveBo.saveMaterialModelByKeyToJedisFFM(onLinemodelId, ffm);
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  save model end ");
        }
    }

    public static void syncStatFMModel(String modelKey, List<String> list) throws Exception {
        StdModelSaveBo.saveListByKeyToJedis(modelKey, list);
    }

    public static void syncBCvrFMModel(String onLinemodelId, String psModelId, boolean isSync, double negativeSampleRatio) throws Exception {
        if (isSync) {
            SyncBo.hbase2RedisFM(psModelId);
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sync model,psModelId=" + psModelId + ",onlineModelId=" + onLinemodelId);
            FM fm = SyncBo.getJModel(psModelId, null);
            fm.getParamsDo().setCorrect(Double.valueOf(negativeSampleRatio));
            StdModelSaveBo.saveModelByKeyToJedis(onLinemodelId, fm);
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  save model end ");
        }
    }

    public static void syncBcvrFFMModel(String onLinemodelId, String psModelId, boolean isSync, double negativeSampleRatio) throws Exception {
        if (isSync) {
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  sync model,psModelId=" + psModelId + ",onlineModelId=" + onLinemodelId);
            SyncBo.hbase2RedisFFM(psModelId);
            FFM ffm = SyncBo.getJModelFFM(psModelId, null);
            ffm.getParamsDoffm().setCorrect(Double.valueOf(negativeSampleRatio));
            StdModelSaveBo.saveModelByKeyToJedisFFM(onLinemodelId, ffm);
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  save model end ");
        }
    }

    public static void syncMaterialModelOffline(ModelKeyEnum modelKeyEnum, boolean isSync) throws Exception {
        System.out.println("isSync: " + isSync);
        if (modelKeyEnum.getType() == 1) {
            System.out.println("modelKeyEnum getType 1: FM model");
            SyncBo.syncMaterialFMModel(modelKeyEnum.getIndex(), modelKeyEnum.getPsIndex(), isSync, modelKeyEnum.getNegativeSampleRatio());
        }
        if (modelKeyEnum.getType() == 2) {
            System.out.println("modelKeyEnum getType 2: FFM model");
            SyncBo.syncMaterialFFMModel(modelKeyEnum.getIndex(), modelKeyEnum.getPsIndex(), isSync, modelKeyEnum.getNegativeSampleRatio());
        }
    }

    public static void syncStatModelOffline(ModelKeyEnum modelKeyEnum, boolean isSync) throws Exception {
        System.out.println("sync stat model ...");
        SyncBo.syncBCvrFMModel(modelKeyEnum.getIndex(), modelKeyEnum.getPsIndex(), isSync, modelKeyEnum.getNegativeSampleRatio());
    }

    public static void syncBCvrModelOffline(ModelKeyEnum modelKeyEnum, boolean isSync) throws Exception {
        System.out.println("isSync: " + isSync);
        if (modelKeyEnum.getType() == 1) {
            System.out.println("modelKeyEnum getType 1: FM model");
            SyncBo.syncBCvrFMModel(modelKeyEnum.getIndex(), modelKeyEnum.getPsIndex(), isSync, modelKeyEnum.getNegativeSampleRatio());
        }
        if (modelKeyEnum.getType() == 2) {
            System.out.println("modelKeyEnum getType 2: FFM model");
            SyncBo.syncBcvrFFMModel(modelKeyEnum.getIndex(), modelKeyEnum.getPsIndex(), isSync, modelKeyEnum.getNegativeSampleRatio());
        }
    }

    public static void syncMaterialModel(ModelKeyEnum modelKeyEnum, boolean isSync) throws Exception {
        SyncBo.syncMaterialFMModel(modelKeyEnum.getIndex(), modelKeyEnum.getPsIndex(), isSync, modelKeyEnum.getNegativeSampleRatio());
    }

    public static void main(String[] args) {
    }
}

