/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo.stat;

import cn.com.duiba.nezha.compute.biz.bo.stat.StatBaseBo;
import cn.com.duiba.nezha.compute.biz.dto.stat.AdBidInfoDo;
import cn.com.duiba.nezha.compute.biz.dto.stat.OrderStatSample;
import cn.com.duiba.nezha.compute.biz.dto.stat.PackageInfo;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatBaseDo;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatDo;
import cn.com.duiba.nezha.compute.biz.dto.stat.SubStatDo;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.core.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;

public class StatBo
extends StatBaseBo {
    public static void stat(StatDo statDo, OrderStatSample sample) {
        if (AssertUtil.isNotEmpty((Object)sample)) {
            StatBo.statBidTimes(statDo, sample);
            StatBo.statBase(statDo, sample);
        }
    }

    public static void statBidTimes(StatDo statDo, OrderStatSample sample) {
        Long slotId = sample.getSlotId();
        String bidAds = sample.getRecomAdIds();
        if (statDo == null) {
            statDo = new StatDo();
        }
        System.out.println(bidAds);
        if (AssertUtil.isNotEmpty((String)bidAds)) {
            List adBidInfoDoList = JSON.parseArray((String)bidAds, AdBidInfoDo.class);
            for (AdBidInfoDo adBidInfoDo : adBidInfoDoList) {
                if (adBidInfoDo == null || adBidInfoDo.getT_tag() == null) continue;
                Long advertId = adBidInfoDo.getAd();
                Long packageId = adBidInfoDo.getPk();
                Long tradeTagId = adBidInfoDo.getT_tag();
                StatBo.init(statDo, tradeTagId, advertId, packageId, slotId);
                StatBo.statBid(statDo.getSlotSubStatDo(slotId).getStatBaseDo(1), adBidInfoDo);
                StatBo.statBid(statDo.getNewTradeSubStatDo(tradeTagId).getStatBaseDo(1), adBidInfoDo);
                StatBo.statBid(statDo.getNewTradeSubStatDo(tradeTagId).getSlotStatBaseDoMap(1), slotId, adBidInfoDo);
                StatBo.statBid(statDo.getAdSubStatDo(advertId).getStatBaseDo(1), adBidInfoDo);
                StatBo.statBid(statDo.getAdSubStatDo(advertId).getSlotStatBaseDo(1, slotId), adBidInfoDo);
                StatBo.statBid(statDo.getAdPackageSubStatDo(advertId, packageId).getStatBaseDo(1), adBidInfoDo);
                StatBo.statBid(statDo.getAdPackageSubStatDo(advertId, packageId).getSlotStatBaseDo(1, slotId), adBidInfoDo);
                StatBo.statBid(statDo.getAdPackageSubStatDo(advertId, packageId).getAtStatBaseDo(1), adBidInfoDo);
                StatBo.statBid(statDo.getAdPackageSubStatDo(advertId, packageId).getStatBaseDo(2), adBidInfoDo);
                StatBo.statBid(statDo.getAdPackageSubStatDo(advertId, packageId).getSlotStatBaseDo(2, slotId), adBidInfoDo);
                StatBo.statBid(statDo.getAdPackageSubStatDo(advertId, packageId).getAtStatBaseDo(2), adBidInfoDo);
            }
        }
    }

    public static void statBase(StatDo statDo, OrderStatSample sample) {
        Long tradeTagId = sample.getNewTradeTagId();
        Long advertId = sample.getAdvertId();
        Long packageId = sample.getPackageId();
        Long slotId = sample.getSlotId();
        Boolean isAutoTarget = sample.getIsAutoTarget();
        if (statDo == null) {
            statDo = new StatDo();
        }
        StatBo.init(statDo, tradeTagId, advertId, packageId, slotId);
        StatBo.packageInfoUpdate(statDo.getPackageInfo(advertId, packageId), sample);
        StatBo.statBase(statDo.getSlotSubStatDo(slotId).getStatBaseDo(1), sample);
        StatBo.statBase(statDo.getNewTradeSubStatDo(tradeTagId).getStatBaseDo(1), sample);
        StatBo.statBase(statDo.getNewTradeSubStatDo(tradeTagId).getSlotStatBaseDo(1, slotId), sample);
        StatBo.statBase(statDo.getAdSubStatDo(advertId).getStatBaseDo(1), sample);
        StatBo.statBase(statDo.getAdSubStatDo(advertId).getSlotStatBaseDo(1, slotId), sample);
        if (sample.isTestData()) {
            StatBo.statBase(statDo.getAdPackageSubStatDo(advertId, packageId).getStatBaseDo(2), sample);
            if (isAutoTarget != null && isAutoTarget.booleanValue()) {
                StatBo.statBase(statDo.getAdPackageSubStatDo(advertId, packageId).getAtStatBaseDo(2), sample);
            }
            StatBo.statBase(statDo.getAdPackageSubStatDo(advertId, packageId).getSlotStatBaseDo(2, slotId), sample);
        } else {
            StatBo.statBase(statDo.getAdPackageSubStatDo(advertId, packageId).getStatBaseDo(1), sample);
            if (isAutoTarget != null && isAutoTarget.booleanValue()) {
                StatBo.statBase(statDo.getAdPackageSubStatDo(advertId, packageId).getAtStatBaseDo(1), sample);
            }
            StatBo.statBase(statDo.getAdPackageSubStatDo(advertId, packageId).getSlotStatBaseDo(1, slotId), sample);
        }
    }

    public static void init(StatDo statDo, Long tradeTagId, Long advertId, Long packageId, Long slotId) {
        SubStatDo subStatDo;
        if (statDo.getSlotSubStatDo(slotId) == null) {
            subStatDo = new SubStatDo();
            statDo.putSlotSubStatDo(slotId, subStatDo);
        }
        if (statDo.getNewTradeSubStatDo(tradeTagId) == null) {
            subStatDo = new SubStatDo();
            subStatDo.setNewTradeTagId(tradeTagId);
            statDo.putNewTradeSubStatDo(tradeTagId, subStatDo);
        }
        if (statDo.getAdSubStatDo(advertId) == null) {
            subStatDo = new SubStatDo();
            subStatDo.setAdvertId(advertId);
            statDo.putAdSubStatDo(advertId, subStatDo);
        }
        if (statDo.getAdPackageSubStatDo(advertId, packageId) == null) {
            subStatDo = new SubStatDo();
            subStatDo.setNewTradeTagId(tradeTagId);
            subStatDo.setAdvertId(advertId);
            subStatDo.setPackageId(packageId);
            statDo.putAdPackageSubStatDo(advertId, packageId, subStatDo);
        }
        if (statDo.getPackageInfo(advertId, packageId) == null) {
            PackageInfo packageInfo = new PackageInfo();
            packageInfo.setNewTradeTagId(tradeTagId);
            packageInfo.setAdvertId(advertId);
            packageInfo.setPackageId(packageId);
            statDo.putPackageInfo(advertId, packageId, packageInfo);
        }
    }

    public static void statBid(Map<Long, StatBaseDo> statMap, Long slotId, AdBidInfoDo adBidInfoDo) {
        if (!statMap.containsKey(slotId)) {
            statMap.put(slotId, new StatBaseDo());
        }
        StatBo.statBid(statMap.get(slotId), adBidInfoDo);
    }

    public static void statBid(StatBaseDo statBaseDo, AdBidInfoDo adBidInfoDo) {
        statBaseDo.addBidCnt(1L);
        if (adBidInfoDo.getPreDcvr() != null) {
            double dcvr = adBidInfoDo.getPreDcvr();
            statBaseDo.addDcvrBidCnt(1L);
            statBaseDo.addDcvrSum(dcvr);
            statBaseDo.addDcvrSum(dcvr * dcvr);
        }
    }

    public static void statBase(Map<Long, StatBaseDo> statMap, OrderStatSample sample, Long slotId) {
        if (!statMap.containsKey(slotId)) {
            statMap.put(slotId, new StatBaseDo());
        }
        StatBo.statBase(statMap.get(slotId), sample);
    }

    public static void statBase(StatBaseDo statBaseDo, OrderStatSample sample) {
        statBaseDo.addExpCnt(sample.getExpCnt());
        statBaseDo.addClickCnt(sample.getChargeCnt());
        statBaseDo.addActCntArray(sample.getConvertCntArray());
        statBaseDo.addFees(sample.getChargeFees());
        statBaseDo.addFees2(sample.getChargeFees2());
        statBaseDo.addFees3(sample.getChargeFees3());
        if (sample.getPreCvr() != null && sample.getChargeCnt() > 0L) {
            double preCvr = DataUtil.formatdouble((double)sample.getPreCvr(), (int)5);
            double preCvrSquare = DataUtil.formatdouble((double)(preCvr * preCvr), (int)5);
            Integer cvrType = sample.getBackendType() == null ? 0 : sample.getBackendType();
            statBaseDo.addCvrSumArray(preCvr, cvrType);
            statBaseDo.addCvrSquareSumArray(preCvrSquare, cvrType);
        }
        if (sample.isOcpcType()) {
            statBaseDo.addOcpcExpCnt(sample.getExpCnt());
            statBaseDo.addOcpcFees(sample.getChargeFees());
            statBaseDo.addOcpcFees2(sample.getChargeFees2());
            statBaseDo.addOcpcFees3(sample.getChargeFees3());
            if (sample.isReserveFeeType()) {
                statBaseDo.addOcpcFloorFees(sample.getChargeFees());
                statBaseDo.addOcpcFloorFees2(sample.getChargeFees2());
                statBaseDo.addOcpcFloorFees3(sample.getChargeFees3());
            }
            if (sample.getFactor() != null) {
                statBaseDo.addOcpcFactorSum(sample.getFactor());
            } else {
                statBaseDo.addOcpcFactorSum(1.0);
            }
            if (sample.getFactor2() != null) {
                statBaseDo.addSecondFactorSum(sample.getFactor2());
            } else {
                statBaseDo.addSecondFactorSum(1.0);
            }
            if (sample.getDeepFactor() != null) {
                statBaseDo.addDeepFactorSum(sample.getDeepFactor());
            } else {
                statBaseDo.addDeepFactorSum(1.0);
            }
        }
    }
}

