/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo.stat;

import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlSubModel;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.compute.biz.bo.stat.StatBaseBo;
import cn.com.duiba.nezha.compute.biz.bo.stat.StatMergeBo;
import cn.com.duiba.nezha.compute.biz.conf.JedisPoolConf;
import cn.com.duiba.nezha.compute.biz.constant.ProjectConstant;
import cn.com.duiba.nezha.compute.biz.dto.stat.PackageInfo;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatDo;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatOffLineDo;
import cn.com.duiba.nezha.compute.biz.utils.jedis.JedisUtil;
import cn.com.duiba.nezha.compute.core.enums.DateStyle;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.core.util.DateUtil;
import cn.com.duiba.nezha.compute.core.util.HashUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StatSyncBo
extends StatBaseBo {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.psJedisConfig);
    public static JedisUtil nezhaJedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);
    public static String PREFIX_STAT_10M_WORK = "alg_stat_10m_w_";
    public static String PREFIX_STAT_10M = "alg_stat_10m_";
    public static String PREFIX_STAT_30M = "alg_stat_30m_";
    public static String PREFIX_STAT_60M = "alg_stat_60m_";
    public static String PREFIX_STAT_DT = "alg_stat_dt_";
    public static String PREFIX_STAT_3DT = "alg_stat_3dt_";
    public static String PREFIX_STAT_7DT = "alg_stat_7dt_";
    public static String PREFIX_STAT_14DT = "alg_stat_14dt_";
    public static String TYPE_TRADE = "trade_";
    public static String TYPE_AD = "ad_";
    public static String TYPE_SLOT = "slot_";

    public static String getModelKey(String modelId, String groupId) {
        String ret = null;
        if (groupId != null) {
            ret = "NZ_K86_nz_alg_s_m_" + modelId + "_" + groupId;
        }
        if (groupId == null) {
            ret = "NZ_K86_nz_alg_s_m_" + modelId;
        }
        return ret;
    }

    public static String getStatGroupKey(String PREFIX, String groupId, String time) {
        return PREFIX + time + "_" + groupId;
    }

    public static String getStatWorkerKey(String PREFIX, String workerId, String time) {
        return PREFIX + time + "_" + workerId;
    }

    public static String getStatSyncKey(String PREFIX, String time) {
        return PREFIX + time + "_";
    }

    public static String getGroupId(String type) {
        String ret = null;
        if (TYPE_TRADE.equals(type)) {
            ret = "t";
        }
        if (TYPE_SLOT.equals(type)) {
            ret = "s";
        }
        return ret;
    }

    public static String getGroupId(String type, Long advertId, int groupNums) {
        String ret = null;
        if (TYPE_TRADE.equals(type)) {
            ret = "t";
        }
        if (TYPE_SLOT.equals(type)) {
            ret = "s";
        }
        if (TYPE_AD.equals(type)) {
            int groupId = HashUtil.hash((Long)advertId, (int)groupNums, (int)0);
            ret = "g" + groupId;
        }
        return ret;
    }

    public static String getWorkerId(String time, int workerNums) {
        String ret = null;
        int groupId = HashUtil.hash((String)time, (int)workerNums, (int)0);
        ret = groupId + "";
        return ret;
    }

    public static StatDo getStatOffLineDo(String currentTime, String adGroupId, String PREFIX) {
        String adKey = StatSyncBo.getStatGroupKey(PREFIX, adGroupId, currentTime);
        StatDo adStatDo = StatSyncBo.readStatDoFromRedis(adKey);
        return adStatDo;
    }

    public static StatDo getStatDo(String currentTime, String adGroupId, String PREFIX) {
        Map<Long, Map<Long, PackageInfo>> adPackageInfoMap;
        StatDo ret = new StatDo();
        String tradeGroupId = StatSyncBo.getGroupId(TYPE_TRADE);
        String slotGroupId = StatSyncBo.getGroupId(TYPE_SLOT);
        String adKey = StatSyncBo.getStatGroupKey(PREFIX, adGroupId, currentTime);
        String slotKey = StatSyncBo.getStatGroupKey(PREFIX, slotGroupId, currentTime);
        String tradeKey = StatSyncBo.getStatGroupKey(PREFIX, tradeGroupId, currentTime);
        StatDo adStatDo = StatSyncBo.readStatDoFromRedis(adKey);
        StatDo slotStatDo = StatSyncBo.readStatDoFromRedis(slotKey);
        StatDo tradeStatDo = StatSyncBo.readStatDoFromRedis(tradeKey);
        if (slotStatDo != null) {
            ret.setSlotSubStatDoMap(slotStatDo.getSlotSubStatDoMap());
        }
        if (tradeStatDo != null) {
            ret.setNewTradeSubStatDoMap(tradeStatDo.getNewTradeSubStatDoMap());
        }
        if (adStatDo != null && AssertUtil.isNotEmpty(adPackageInfoMap = adStatDo.getAdPackageInfoMap())) {
            HashMap<Long, Map<Long, PackageInfo>> adPackageInfoMapTmp = new HashMap<Long, Map<Long, PackageInfo>>();
            for (Map.Entry<Long, Map<Long, PackageInfo>> entry : adPackageInfoMap.entrySet()) {
                Long advertId = entry.getKey();
                Map<Long, PackageInfo> packageInfoSubMap = entry.getValue();
                for (Map.Entry<Long, PackageInfo> entrySub : packageInfoSubMap.entrySet()) {
                    Long pkId = entrySub.getKey();
                    PackageInfo packageInfo = entrySub.getValue();
                    if (packageInfo == null || packageInfo.getOcpcType() == null || !packageInfo.getOcpcType().booleanValue()) continue;
                    if (!adPackageInfoMapTmp.containsKey(advertId)) {
                        adPackageInfoMapTmp.put(advertId, new HashMap());
                    }
                    if (((Map)adPackageInfoMapTmp.get(advertId)).containsKey(pkId)) continue;
                    ((Map)adPackageInfoMapTmp.get(advertId)).put(pkId, packageInfo);
                }
            }
            ret.setAdPackageInfoMap(adPackageInfoMapTmp);
            ret.setAdPackageSubStatDoMap(adStatDo.getAdPackageSubStatDoMap());
            ret.setAdSubStatDoMap(adStatDo.getAdSubStatDoMap());
        }
        return ret;
    }

    public static void mergeHiveStatHistory(String currentTime, int groupNums) {
        String cDt = currentTime.substring(0, 10);
    }

    public static void mergeStat3Dt(String currentTime, String groupId) {
        String cDt = currentTime.substring(0, 10);
        List<String> dtList = StatSyncBo.getDtDiff(cDt, -1, 3);
        System.out.println("3dtList=" + dtList);
        ArrayList<StatDo> statDoDtList = new ArrayList<StatDo>();
        for (String dt : dtList) {
            String statDtKey = StatSyncBo.getStatGroupKey(PREFIX_STAT_DT, groupId, dt);
            StatDo statDoDt = StatSyncBo.readStatDoFromRedis(statDtKey);
            statDoDtList.add(statDoDt);
        }
        StatDo statDo3DtNew = StatMergeBo.statMerge(statDoDtList);
        String stat3DtKey = StatSyncBo.getStatGroupKey(PREFIX_STAT_3DT, groupId, cDt);
        StatSyncBo.saveStatDoToRedis(statDo3DtNew, stat3DtKey, ProjectConstant.WEEK_2_EXPIRE);
    }

    public static void mergeStat7Dt(String currentTime, String groupId) {
        String cDt = currentTime.substring(0, 10);
        List<String> dtList = StatSyncBo.getDtDiff(cDt, -1, 7);
        System.out.println("7dtList=" + dtList);
        ArrayList<StatDo> statDoDtList = new ArrayList<StatDo>();
        for (String dt : dtList) {
            String statDtKey = StatSyncBo.getStatGroupKey(PREFIX_STAT_DT, groupId, dt);
            StatDo statDoDt = StatSyncBo.readStatDoFromRedis(statDtKey);
            statDoDtList.add(statDoDt);
        }
        StatDo statDo7DtNew = StatMergeBo.statMerge(statDoDtList);
        String stat7DtKey = StatSyncBo.getStatGroupKey(PREFIX_STAT_7DT, groupId, cDt);
        StatSyncBo.saveStatDoToRedis(statDo7DtNew, stat7DtKey, ProjectConstant.WEEK_2_EXPIRE);
    }

    public static void mergeStatDt(String currentTime, String groupId) {
        String dt = currentTime.substring(0, 10);
        String stat10MKey = StatSyncBo.getStatGroupKey(PREFIX_STAT_10M, groupId, currentTime);
        String statDtKey = StatSyncBo.getStatGroupKey(PREFIX_STAT_DT, groupId, dt);
        StatDo statDo10M = StatSyncBo.readStatDoFromRedis(stat10MKey);
        StatDo statDoDt = StatSyncBo.readStatDoFromRedis(statDtKey);
        ArrayList<StatDo> statDoDtList = new ArrayList<StatDo>();
        if (statDo10M != null) {
            statDoDtList.add(statDo10M);
        }
        if (statDoDt != null) {
            statDoDtList.add(statDoDt);
        }
        StatDo statDoDtNew = StatMergeBo.statMerge(statDoDtList);
        StatSyncBo.saveStatDoToRedis(statDoDtNew, statDtKey, ProjectConstant.WEEK_2_EXPIRE);
    }

    public static void mergeStat60M(String currentTime, String groupId) {
        List<String> time60mList = StatSyncBo.getMinuteDiff(currentTime, -10, 6);
        System.out.println("time60mList=" + time60mList);
        ArrayList<StatDo> statDo60MList = new ArrayList<StatDo>();
        for (String time : time60mList) {
            String stat10MKey = StatSyncBo.getStatGroupKey(PREFIX_STAT_10M, groupId, time);
            StatDo statDo = StatSyncBo.readStatDoFromRedis(stat10MKey);
            if (statDo == null) continue;
            statDo60MList.add(statDo);
        }
        StatDo statDo60M = StatMergeBo.statMerge(statDo60MList);
        String stat60MKey = StatSyncBo.getStatGroupKey(PREFIX_STAT_60M, groupId, currentTime);
        StatSyncBo.saveStatDoToRedis(statDo60M, stat60MKey, ProjectConstant.HOUR_3_EXPIRE);
    }

    public static void mergeStat30M(String currentTime, String groupId) {
        List<String> timeMinuteList = StatSyncBo.getMinuteDiff(currentTime, -10, 3);
        System.out.println("timeMinuteList=" + timeMinuteList);
        ArrayList<StatDo> statDo60MList = new ArrayList<StatDo>();
        for (String time : timeMinuteList) {
            String stat10MKey = StatSyncBo.getStatGroupKey(PREFIX_STAT_10M, groupId, time);
            StatDo statDo = StatSyncBo.readStatDoFromRedis(stat10MKey);
            if (statDo == null) continue;
            statDo60MList.add(statDo);
        }
        StatDo statDo60M = StatMergeBo.statMerge(statDo60MList);
        String stat60MKey = StatSyncBo.getStatGroupKey(PREFIX_STAT_30M, groupId, currentTime);
        StatSyncBo.saveStatDoToRedis(statDo60M, stat60MKey, ProjectConstant.HOUR_3_EXPIRE);
    }

    public static void mergeStatForWorker(String time, String groupId, int workNums, boolean isSync) {
        ArrayList<StatDo> statDoList = new ArrayList<StatDo>();
        for (int i = 0; i < workNums; ++i) {
            String wokerKey = StatSyncBo.getStatWorkerKey(PREFIX_STAT_10M_WORK, i + "", time);
            StatDo statDo = StatSyncBo.readStatDoHashFromRedis(wokerKey, groupId);
            if (statDo == null) continue;
            statDoList.add(statDo);
        }
        StatDo statDo = StatMergeBo.statMerge(statDoList);
        if (isSync) {
            String statKey = StatSyncBo.getStatGroupKey(PREFIX_STAT_10M, groupId, time);
            StatSyncBo.saveStatDoToRedis(statDo, statKey, ProjectConstant.HOUR_3_EXPIRE);
        }
    }

    public static void saveStat(StatDo statDo, String time, int groupNums, String workerId) {
        HashMap<String, StatDo> statDoMap = new HashMap<String, StatDo>();
        StatDo tradeStatDo = new StatDo();
        tradeStatDo.setNewTradeSubStatDoMap(statDo.getNewTradeSubStatDoMap());
        String tradeGroupId = StatSyncBo.getGroupId(TYPE_TRADE);
        statDoMap.put(tradeGroupId, tradeStatDo);
        StatDo slotStatDo = new StatDo();
        slotStatDo.setSlotSubStatDoMap(statDo.getSlotSubStatDoMap());
        String slotGroupId = StatSyncBo.getGroupId(TYPE_SLOT);
        statDoMap.put(slotGroupId, slotStatDo);
        Set<Long> advertIdSet = statDo.getAdPackageInfoMap().keySet();
        for (Long advertId : advertIdSet) {
            String groupId = StatSyncBo.getGroupId(TYPE_AD, advertId, groupNums);
            if (!statDoMap.containsKey(groupId)) {
                statDoMap.put(groupId, new StatDo());
            }
            ((StatDo)statDoMap.get(groupId)).getAdPackageInfoMap().put(advertId, statDo.getAdPackageInfoMap().get(advertId));
            ((StatDo)statDoMap.get(groupId)).getAdSubStatDoMap().put(advertId, statDo.getAdSubStatDoMap().get(advertId));
            ((StatDo)statDoMap.get(groupId)).getAdPackageSubStatDoMap().put(advertId, statDo.getAdPackageSubStatDoMap().get(advertId));
        }
        String wokerKey = StatSyncBo.getStatWorkerKey(PREFIX_STAT_10M_WORK, workerId, time);
        StatSyncBo.savedStatDoHashToRedis(statDoMap, wokerKey, ProjectConstant.HOUR_3_EXPIRE);
        System.gc();
    }

    public static void saveStatDoToRedis(StatDo statDo, String key, int ttl) {
        System.out.println("saveStatDoToRedis key=" + key);
        try {
            String value = JSON.toJSONString((Object)statDo);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((cn.com.duiba.nezha.alg.common.enums.DateStyle)cn.com.duiba.nezha.alg.common.enums.DateStyle.YYYY_MM_DD_HH_MM_SS);
            jedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveStatOffLineDoToRedis(StatOffLineDo statDo, String key, int ttl) {
        System.out.println("saveStatOffLineDoToRedis key=" + key);
        try {
            String value = JSON.toJSONString((Object)statDo);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((cn.com.duiba.nezha.alg.common.enums.DateStyle)cn.com.duiba.nezha.alg.common.enums.DateStyle.YYYY_MM_DD_HH_MM_SS);
            jedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveModelToRedis(OcpxControlModel ocpxControlModel, String modelId, String groupId, int ttl) {
        String key = StatSyncBo.getModelKey(modelId, groupId);
        System.out.println("saveModelToRedis key=" + key);
        try {
            String value = JSON.toJSONString((Object)ocpxControlModel);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((cn.com.duiba.nezha.alg.common.enums.DateStyle)cn.com.duiba.nezha.alg.common.enums.DateStyle.YYYY_MM_DD_HH_MM_SS);
            jedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveModelToRedis(OcpxControlModel ocpxControlModel, String modelId, int ttl) {
        String key = StatSyncBo.getModelKey(modelId, null);
        System.out.println("saveModelToRedis key=" + key);
        try {
            String value = JSON.toJSONString((Object)ocpxControlModel);
            String value2 = StringZIP.zipString((String)value);
            nezhaJedisUtil.setex(key, value2, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((cn.com.duiba.nezha.alg.common.enums.DateStyle)cn.com.duiba.nezha.alg.common.enums.DateStyle.YYYY_MM_DD_HH_MM_SS);
            nezhaJedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveOcpxControlSubModelToRedis(OcpxControlSubModel ocpxControlModel, String key, int ttl) {
        System.out.println("saveOcpxControlSubModelToRedis key=" + key);
        try {
            String value = JSON.toJSONString((Object)ocpxControlModel);
            String value2 = StringZIP.zipString((String)value);
            nezhaJedisUtil.setex(key, value2, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((cn.com.duiba.nezha.alg.common.enums.DateStyle)cn.com.duiba.nezha.alg.common.enums.DateStyle.YYYY_MM_DD_HH_MM_SS);
            nezhaJedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveToRedis(String value, String key, int ttl) {
        System.out.println("saveToRedis key=" + key);
        try {
            nezhaJedisUtil.setex(key, value, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((cn.com.duiba.nezha.alg.common.enums.DateStyle)cn.com.duiba.nezha.alg.common.enums.DateStyle.YYYY_MM_DD_HH_MM_SS);
            nezhaJedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static StatDo readStatDoFromRedis(String key) {
        StatDo ret = null;
        System.out.println("readStatDoFromRedis key=" + key);
        try {
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (StatDo)JSON.parseObject((String)ret2, StatDo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static StatOffLineDo readStatOffLineDoFromRedis(String key) {
        StatOffLineDo ret = null;
        System.out.println("readStatOffLineDoFromRedis key=" + key);
        try {
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (StatOffLineDo)JSON.parseObject((String)ret2, StatOffLineDo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static OcpxControlModel readModelFromRedis(String modelId, String groupId) {
        String key = StatSyncBo.getModelKey(modelId, groupId);
        OcpxControlModel ret = null;
        System.out.println("readModelFromRedis key=" + key);
        try {
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (OcpxControlModel)JSON.parseObject((String)ret2, OcpxControlModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static OcpxControlModel readModelFromRedis(String modelId) {
        String key = StatSyncBo.getModelKey(modelId, null);
        OcpxControlModel ret = null;
        System.out.println("readModelFromRedis key=" + key);
        try {
            String ret1 = nezhaJedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (OcpxControlModel)JSON.parseObject((String)ret2, OcpxControlModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Boolean existsKey(String key) {
        return jedisUtil.exists(key);
    }

    public static Boolean setMarkKey(String key, String value, int ttl) {
        return jedisUtil.setex(key, value, ttl);
    }

    public static StatDo readStatDoHashFromRedis(String key, String field) {
        StatDo ret = null;
        System.out.println("readStatDoHashFromRedis with key=" + key + ",field=" + field);
        try {
            String ret1 = jedisUtil.hget(key, field);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (StatDo)JSON.parseObject((String)ret2, StatDo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Map<String, StatDo> readStatDoHashFromRedis(String key, List<String> fields) {
        HashMap<String, StatDo> ret = new HashMap<String, StatDo>();
        System.out.println("readStatDoHashFromRedis key=" + key);
        try {
            for (String field : fields) {
                String ret1 = jedisUtil.hget(key, field);
                String ret2 = StringZIP.unzipString((String)ret1);
                StatDo ret3 = (StatDo)JSON.parseObject((String)ret2, StatDo.class);
                ret.put(field, ret3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void savedStatDoHashToRedis(Map<String, StatDo> statDoMap, String key, int ttl) {
        System.out.println("savedStatDoHashToRedis key=" + key);
        try {
            Map<String, String> value = StatSyncBo.toStringMapWithZip(statDoMap);
            jedisUtil.hmSetEx(key, value, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((cn.com.duiba.nezha.alg.common.enums.DateStyle)cn.com.duiba.nezha.alg.common.enums.DateStyle.YYYY_MM_DD_HH_MM_SS);
            jedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> Map<String, String> toStringMapWithZip(Map<String, T> map) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (map != null) {
            for (Map.Entry<String, T> entry : map.entrySet()) {
                String key = entry.getKey();
                T value = entry.getValue();
                String vStr = JSON.toJSONString(value);
                String vStrZip = StringZIP.zipString((String)vStr);
                ret.put(key, vStrZip);
            }
        }
        return ret;
    }

    public static List<String> getMinuteDiff(String baseTime, int diffSize, int nums) {
        ArrayList<String> dateList = new ArrayList<String>();
        Date baseDate = DateUtil.getDate((String)baseTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM);
        for (int i = 0; i < nums; ++i) {
            int diff = diffSize * i;
            Date baseDate2 = DateUtil.addMinute((Date)baseDate, (int)diff);
            String diffTime = DateUtil.getDate((Date)baseDate2, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM);
            dateList.add(diffTime);
        }
        return dateList;
    }

    public static List<String> getDtDiff(String baseTime, int diffSize, int nums) {
        ArrayList<String> dateList = new ArrayList<String>();
        Date baseDate = DateUtil.getDate((String)baseTime, (DateStyle)DateStyle.YYYY_MM_DD);
        for (int i = 0; i < nums; ++i) {
            int diff = diffSize * i;
            Date baseDate2 = DateUtil.addDay((Date)baseDate, (int)diff);
            String diffTime = DateUtil.getDate((Date)baseDate2, (DateStyle)DateStyle.YYYY_MM_DD);
            dateList.add(diffTime);
        }
        return dateList;
    }

    public static String getDtDiff(String baseTime, int diffSize) {
        String ret = null;
        Date baseDate = DateUtil.getDate((String)baseTime, (DateStyle)DateStyle.YYYY_MM_DD);
        Date baseDate2 = DateUtil.addDay((Date)baseDate, (int)diffSize);
        ret = DateUtil.getDate((Date)baseDate2, (DateStyle)DateStyle.YYYY_MM_DD);
        return ret;
    }
}

