/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.conf;

import cn.com.duiba.nezha.compute.biz.conf.JedisConfig;
import cn.com.duiba.nezha.compute.biz.constant.ProjectConstant;
import cn.com.duiba.nezha.compute.biz.utils.conf.ConfigFactory;
import redis.clients.jedis.JedisPoolConfig;

public class JedisPoolConf {
    public static JedisPoolConfig poolConfig;
    public static JedisConfig jedisConfig;
    public static JedisConfig actJedisConfig;
    public static JedisConfig psJedisConfig;
    public static JedisConfig dpaActJedisConfig;
    public static JedisConfig materialJedisConfig;

    private static void initJedisPoolConfig() {
        poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(ProjectConstant.MAX_IDLE);
        poolConfig.setMinIdle(ProjectConstant.MIN_IDLE);
        poolConfig.setMaxTotal(ProjectConstant.MAX_TOTAL);
        poolConfig.setMaxWaitMillis((long)ProjectConstant.MAX_WAIT_MILLIS);
        poolConfig.setTestOnBorrow(ProjectConstant.TEST_ON_BORROW.booleanValue());
        poolConfig.setTestOnReturn(ProjectConstant.TEST_ON_RETURN.booleanValue());
    }

    private static void initConfig() throws Exception {
        jedisConfig = JedisPoolConf.initJedisConfig(ProjectConstant.REDIS_IP, ProjectConstant.REDIS_PW, ProjectConstant.REDIS_PORT);
        actJedisConfig = JedisPoolConf.initJedisConfig(ProjectConstant.REDIS_ACT_IP, ProjectConstant.REDIS_ACT_PW, ProjectConstant.REDIS_ACT_PORT);
        psJedisConfig = JedisPoolConf.initJedisConfig(ProjectConstant.REDIS_PS_IP, ProjectConstant.REDIS_PS_PW, ProjectConstant.REDIS_PS_PORT);
        dpaActJedisConfig = JedisPoolConf.initJedisConfig(ProjectConstant.REDIS_DPA_ACT_IP, ProjectConstant.REDIS_DPA_ACT_PW, ProjectConstant.REDIS_DPA_ACT_PORT);
        materialJedisConfig = JedisPoolConf.initJedisConfig(ProjectConstant.REDIS_MATERIAL_IP, ProjectConstant.REDIS_MATERIAL_PW, ProjectConstant.REDIS_MATERIAL_PORT);
    }

    private static JedisConfig initJedisConfig(String ip, String pw, String port) throws Exception {
        JedisConfig ret = new JedisConfig();
        ret.setIp(ConfigFactory.getInstance().getConfigProperties("/application.properties").getProperty(ip));
        ret.setPassWord(ConfigFactory.getInstance().getConfigProperties("/application.properties").getProperty(pw));
        ret.setPort(ConfigFactory.getInstance().getConfigProperties("/application.properties").getInt(port, ProjectConstant.REDIS_PORT_DEAFULT));
        return ret;
    }

    static {
        try {
            JedisPoolConf.initJedisPoolConfig();
            JedisPoolConf.initConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

