/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.dto;

import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.compute.core.CollectionUtil;
import cn.com.duiba.nezha.compute.core.model.local.LocalModel;
import cn.com.duiba.nezha.compute.core.model.local.LocalVector;
import cn.com.duiba.nezha.compute.core.model.ops.CollectionOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.mllib.linalg.SparseVector;

public class SparceCoderStatDo {
    public static int VSIZE = 100000000;
    public static int MULTIPLES = 1000000;
    public static String SLT_KRY_PREFIX = "slt_";
    public static String SC_KRY_PREFIX = "sc_";
    public List<FeatureBaseType> featureList = new ArrayList<FeatureBaseType>();
    public Map<String, Map<Long, Long>> sparceLastTime = new HashMap<String, Map<Long, Long>>();
    public Map<String, Map<Long, Long>> sparceCount = new HashMap<String, Map<Long, Long>>();
    public LocalModel sparceLastTimeLocalModel = null;
    public LocalModel sparceCountLocalModel = null;

    public List<FeatureBaseType> getFeatureList() {
        return this.featureList;
    }

    public void setFeatureList(List<FeatureBaseType> featureList) {
        this.featureList = featureList;
    }

    public Map<String, Map<Long, Long>> getSparceLastTime() {
        return this.sparceLastTime;
    }

    public void setSparceLastTime(Map<String, Map<Long, Long>> sparceLastTime) {
        this.sparceLastTime = sparceLastTime;
    }

    public Map<String, Map<Long, Long>> getSparceCount() {
        return this.sparceCount;
    }

    public void setSparceCount(Map<String, Map<Long, Long>> sparceCount) {
        this.sparceCount = sparceCount;
    }

    public void setSparceLastTimeLocalModel(LocalModel sparceLastTimeLocalModel) {
        this.sparceLastTimeLocalModel = sparceLastTimeLocalModel;
    }

    public void setSparceCountLocalModel(LocalModel sparceCountLocalModel) {
        this.sparceCountLocalModel = sparceCountLocalModel;
    }

    public LocalModel sparceLastTimeToLocalModel() {
        return this.toLocalModel(this.sparceLastTime, SLT_KRY_PREFIX);
    }

    public LocalModel sparceCountToLocalModel() {
        return this.toLocalModel(this.sparceCount, SC_KRY_PREFIX);
    }

    public Map<String, Map<Long, Long>> sparceLastTimeToMap() {
        return this.toMap(this.sparceLastTimeLocalModel, this.featureList, SLT_KRY_PREFIX);
    }

    public Map<String, Map<Long, Long>> sparceCountToMap() {
        return this.toMap(this.sparceCountLocalModel, this.featureList, SC_KRY_PREFIX);
    }

    public LocalModel getSearchSparceLastTimeLocalModel() {
        return this.getSearchLocalModel(this.featureList, SLT_KRY_PREFIX);
    }

    public LocalModel getSearchSparceCountLocalModel() {
        return this.getSearchLocalModel(this.featureList, SC_KRY_PREFIX);
    }

    public LocalModel getSearchLocalModel(List<FeatureBaseType> featureList, String keyPrefix) {
        HashMap<String, Map<Long, Long>> map = new HashMap<String, Map<Long, Long>>();
        for (int i = 0; i < featureList.size(); ++i) {
            map.put(featureList.get(i).getName(), new HashMap());
        }
        return this.toLocalModel(map, keyPrefix);
    }

    public LocalModel toLocalModel(Map<String, Map<Long, Long>> map, String keyPrefix) {
        int fieldSize = map.size();
        Set<String> keySet = map.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keySet);
        String[] fieldArray = new String[fieldSize];
        LocalVector[] valueArray = new LocalVector[fieldSize];
        for (int i = 0; i < fieldSize; ++i) {
            String field = (String)keyList.get(i);
            Map<Long, Long> values = map.get(field);
            SparseVector sparseVector = SparceCoderStatDo.toSparseVector(values, VSIZE);
            fieldArray[i] = keyPrefix + field;
            valueArray[i] = new LocalVector(sparseVector);
        }
        LocalModel localModel = new LocalModel(null, CollectionOps.toMap((Object)fieldArray, (Object)valueArray), null);
        return localModel;
    }

    public Map<String, Map<Long, Long>> toMap(LocalModel localModel, List<FeatureBaseType> featureList, String keyPrefix) {
        HashMap<String, Map<Long, Long>> retMap = new HashMap<String, Map<Long, Long>>();
        if (localModel == null) {
            System.out.println("input invalid ");
        }
        for (int i = 0; i < featureList.size(); ++i) {
            String field = featureList.get(i).getName();
            LocalVector localVector = localModel.getVector(keyPrefix + field);
            if (localVector == null) continue;
            int[] indices = localVector.vector().indices();
            double[] values = localVector.vector().values();
            Map subMap = CollectionUtil.toMap((int[])indices, (double[])values, (int)MULTIPLES);
            retMap.put(field, subMap);
        }
        return retMap;
    }

    public static SparseVector toSparseVector(Map<Long, Long> map, int size) {
        int rsize = map.size();
        int[] indices = new int[rsize];
        double[] values = new double[rsize];
        Set<Long> keySet = map.keySet();
        ArrayList<Long> keyList = new ArrayList<Long>(keySet);
        Collections.sort(keyList);
        for (int i = 0; i < rsize; ++i) {
            indices[i] = ((Long)keyList.get(i)).intValue();
            values[i] = (double)map.getOrDefault(keyList.get(i), 0L).intValue() * 1.0 / (double)MULTIPLES;
        }
        SparseVector sparseVector = new SparseVector(size, indices, values);
        return sparseVector;
    }
}

