/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.ocpx.control;

import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlSubModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.SlotControlParams;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.compute.biz.dto.stat.AdStatusVo;
import cn.com.duiba.nezha.compute.biz.dto.stat.OcpxControlInputParams;
import cn.com.duiba.nezha.compute.biz.dto.stat.PackageInfo;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatBaseDo;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatDo;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatOffLineBaseDo;
import cn.com.duiba.nezha.compute.biz.dto.stat.SubStatDo;
import cn.com.duiba.nezha.compute.biz.ocpx.control.OcpxModelBaseBo2;
import cn.com.duiba.nezha.compute.biz.ocpx.control.PID;
import cn.com.duiba.nezha.compute.core.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpxModelBo2
extends OcpxModelBaseBo2 {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<Long> tradeList = Arrays.asList(6L, 9L, 15L, 16L, 21L);
    private List<Long> adList = Arrays.asList(67472L, 72943L, 73122L, 72943L, 73208L, 63533L, 71525L, 71589L, 71934L, 73064L, 73422L, 73557L, 67210L, 71809L, 71525L);
    private List<Long> adList2 = Arrays.asList(72637L, 73015L, 72517L, 72906L, 62556L);
    private static List<Long> deepPlList = Arrays.asList(174946L, 174313L, 176920L, 174127L, 175151L);
    private List<Long> pkList2 = Arrays.asList(170958L, 166949L, 174313L, 176920L, 174554L, 175775L, 177699L, 174946L, 162748L, 175371L, 17900L, 176082L, 174127L, 176975L, 174796L, 17974L, 176538L, 176683L, 174469L, 163453L, 175457L, 152056L, 177568L, 17565L, 177247L, 177246L, 177802L, 176662L, 176695L, 177183L, 177427L, 170421L, 176690L);
    private Boolean isSync;
    private OcpxControlModel ocpxControlModel = new OcpxControlModel();
    private PID pidController;

    public void setIsSync(Boolean isSync) {
        this.isSync = isSync;
    }

    public void setOcpxControlModel(OcpxControlModel ocpxControlModel) {
        if (ocpxControlModel != null) {
            this.ocpxControlModel = ocpxControlModel;
        }
    }

    public OcpxControlModel getOcpxControlModel() {
        return this.ocpxControlModel;
    }

    public void update(String time, OcpxControlInputParams ocpxControlInputParams) {
        this.pidController = new PID();
        if (ocpxControlInputParams != null) {
            this.run(time, ocpxControlInputParams);
        }
    }

    public void run(String time, OcpxControlInputParams ocpxControlInputParams) {
        Map<Long, Map<Long, PackageInfo>> adPackageInfoMap = ocpxControlInputParams.getAdPackageInfoMap();
        StatDo statDo0 = ocpxControlInputParams.getStatDo0();
        StatDo statDo1 = ocpxControlInputParams.getStatDo1();
        StatDo statDo3 = ocpxControlInputParams.getStatDo3();
        StatDo statDo4 = ocpxControlInputParams.getStatDo4();
        if (adPackageInfoMap != null) {
            for (Map.Entry<Long, Map<Long, PackageInfo>> entry : adPackageInfoMap.entrySet()) {
                Long advertId = entry.getKey();
                this.runColdStart(advertId, statDo4);
                this.runStat(statDo4, advertId);
                Map<Long, PackageInfo> packageInfoMap = entry.getValue();
                for (Map.Entry<Long, PackageInfo> pkEntry : packageInfoMap.entrySet()) {
                    Long packageId = pkEntry.getKey();
                    PackageInfo packageInfo = pkEntry.getValue();
                    if (!packageInfo.getOcpcType().booleanValue()) continue;
                    String prefix = time + packageInfo.print();
                    if (packageInfo.getPackageId().equals(174796L) || packageInfo.getPackageId().equals(176974L)) {
                        System.out.println("pk    =" + prefix);
                    }
                    this.runFactor(prefix, statDo0, statDo1, statDo3, statDo4, advertId, packageId, packageInfo);
                    this.runFloorPrice(statDo3, advertId, packageId, packageInfo);
                    this.runDeepFactor(statDo3, advertId, packageId, packageInfo);
                }
            }
        }
    }

    public void runColdStart(Long advertId, StatDo statDo) {
        SubStatDo subStatDo = statDo.getAdSubStatDo(advertId);
        if (subStatDo != null) {
            Map<Long, StatBaseDo> slotStatBaseDoMap = subStatDo.getSlotStatBaseDoMap();
            slotStatBaseDoMap.forEach((slotId, statBaseDo) -> {
                if (statDo.getSlotSubStatDo((Long)slotId) == null) {
                    return;
                }
                StatBaseDo slotStatBaseDo = statDo.getSlotSubStatDo((Long)slotId).getStatBaseDo();
                AdControlParams adAndSlotControlParams = this.ocpxControlModel.getAdSlotControlParams(advertId, slotId);
                SlotControlParams slotControlParams = this.ocpxControlModel.getSlotControlParams(slotId);
                OcpxModelBo2.getColdStart(statBaseDo, slotStatBaseDo, adAndSlotControlParams, slotControlParams);
            });
        }
    }

    public void runFactor(String prefix, StatDo statDoMin, StatDo statDoHour, StatDo statDoDay, StatDo statDo3Day, Long advertId, Long packageId, PackageInfo adPackageInfo) {
        SubStatDo subStatDoMin = statDoMin.getAdPackageSubStatDo(advertId, packageId);
        SubStatDo subStatDoHour = statDoHour.getAdPackageSubStatDo(advertId, packageId);
        SubStatDo subStatDoDay = statDoDay.getAdPackageSubStatDo(advertId, packageId);
        OcpxControlSubModel ocpxControlSubModel = this.ocpxControlModel.getOcpxControlSubModel(advertId, packageId);
        int controlType = adPackageInfo.getReleaseTarget() != null ? adPackageInfo.getReleaseTarget().intValue() : 0;
        this.runControlFactor(prefix, ocpxControlSubModel, 1, 1, controlType, subStatDoMin, subStatDoHour, subStatDoDay, adPackageInfo);
        if (adPackageInfo.getIsTest() != null && adPackageInfo.getIsTest().booleanValue()) {
            if (adPackageInfo.getBidControlType() != null && adPackageInfo.getBidControlType() == 2) {
                controlType = 2;
            }
            this.runControlFactor(prefix, ocpxControlSubModel, 2, 2, controlType, subStatDoMin, subStatDoHour, subStatDoDay, adPackageInfo);
            this.runControlFactor(prefix, ocpxControlSubModel, 3, 2, controlType, subStatDoMin, subStatDoHour, subStatDoDay, adPackageInfo);
        }
        ocpxControlSubModel.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
    }

    public void runControlFactor(String prefixO, OcpxControlSubModel ocpxControlSubModel, int paramsType, int dataType, int controlType, SubStatDo subStatDoMin, SubStatDo subStatDoHour, SubStatDo subStatDoDay, PackageInfo adPackageInfo) {
        String str = ",params=" + paramsType + ",data=" + dataType + ",ctrl=" + controlType + ",dCtrl=" + adPackageInfo.getDeepControlType();
        String prefix2 = prefixO + str;
        Map<Long, StatBaseDo> pkSlotStatBaseDoDayMap = subStatDoDay.getSlotStatBaseDoMap(dataType);
        OcpxControlParams ocpxControlParams = ocpxControlSubModel.getOcpxControlParams(paramsType);
        this.runCostFactorWithPrint(controlType, 1, prefix2, subStatDoMin.getStatBaseDo(dataType), subStatDoHour.getStatBaseDo(dataType), subStatDoDay.getStatBaseDo(dataType), ocpxControlParams, null, adPackageInfo, 100000L);
        OcpxControlParams atOcpxControlParams = ocpxControlSubModel.getAtOcpxControlParams(paramsType);
        this.runCostFactorWithPrint(controlType, 3, prefix2, subStatDoMin.getAtStatBaseDo(dataType), subStatDoHour.getAtStatBaseDo(dataType), subStatDoDay.getAtStatBaseDo(dataType), atOcpxControlParams, ocpxControlParams, adPackageInfo, 100000L);
        pkSlotStatBaseDoDayMap.forEach((slotId, pkSlotStatBaseDoDay) -> {
            OcpxControlParams slotParams = ocpxControlSubModel.getOcpxControlParams(paramsType, slotId);
            StatBaseDo pkSlotStatBaseDoHour = subStatDoHour.getSlotStatBaseDo(dataType, (Long)slotId);
            StatBaseDo pkSlotStatBaseDoMin = subStatDoMin.getSlotStatBaseDo(dataType, (Long)slotId);
            String prefixSlot = prefix2 + ",slot=" + slotId;
            this.runCostFactorWithPrint(controlType, 2, prefixSlot, pkSlotStatBaseDoMin, pkSlotStatBaseDoHour, (StatBaseDo)pkSlotStatBaseDoDay, slotParams, ocpxControlParams, adPackageInfo, 100000L);
        });
    }

    public void runCostFactorWithPrint(int controlType, int dimType, String prefix, StatBaseDo statBaseDoMin, StatBaseDo statBaseDoHour, StatBaseDo statBaseDoDay, OcpxControlParams params, OcpxControlParams baseParams, PackageInfo adPackageInfo, long fees) {
        if (dimType == 1) {
            prefix = prefix + ",dim=pk1";
        }
        if (dimType == 2) {
            prefix = prefix + ",dim=slot2";
        }
        if (dimType == 3) {
            prefix = prefix + ",dim=auto3";
        }
        String paramsOld = ",{conf=" + params.getCConf() + ",pcF=" + params.getPcFactor() + ",cF=" + params.getCFactor() + ",fcF=" + params.getFcFactor() + "}";
        OcpxModelBo2.getPidFactor(controlType, dimType, this.pidController, statBaseDoMin, statBaseDoHour, statBaseDoDay, params, baseParams, adPackageInfo);
        String paramsNew = ",{conf=" + params.getCConf() + ",pcF=" + params.getPcFactor() + ",cF=" + params.getCFactor() + ",fcF=" + params.getFcFactor() + "}";
        String printStr = this.print(controlType, prefix, adPackageInfo, statBaseDoMin, statBaseDoHour, statBaseDoDay, null, fees, dimType);
        if (printStr != null) {
            if (this.isSync.booleanValue()) {
                System.out.println(printStr + ",paramsO=" + paramsOld + ",paramsN=" + paramsNew);
                System.out.println("");
            } else {
                System.out.println(printStr);
                System.out.println("paramsO=" + paramsOld + ",paramsN=" + paramsNew);
                System.out.println("paramsNN=" + JSON.toJSONString((Object)params));
                System.out.println("");
            }
        }
    }

    public void runFloorPrice(StatDo statDo, Long advertId, Long packageId, PackageInfo adPackageInfo) {
        SubStatDo subStatDo = statDo.getAdPackageSubStatDo(advertId, packageId);
        Map<Long, StatBaseDo> pkSlotStatBaseDoMap = subStatDo.getSlotStatBaseDoMap();
        StatBaseDo pkStatBaseDo = subStatDo.getStatBaseDo();
        OcpxControlSubModel ocpxControlSubModel = this.ocpxControlModel.getOcpxControlSubModel(advertId, packageId);
        OcpxControlParams ocpxControlParams = ocpxControlSubModel.getOcpxControlParams();
        OcpxModelBo2.getFloorPriceParams(pkStatBaseDo, ocpxControlParams, adPackageInfo.getOldConvertCost());
        pkSlotStatBaseDoMap.forEach((slotId, pkslotStatBaseDo) -> {
            OcpxControlParams priceProtectParams = ocpxControlSubModel.getOcpxControlParams(1, slotId);
            OcpxModelBo2.getFloorPriceParams(pkslotStatBaseDo, priceProtectParams, adPackageInfo.getOldConvertCost());
        });
    }

    public void runDeepFactor(StatDo statDo, Long advertId, Long packageId, PackageInfo adPackageInfo) {
        SubStatDo pkSubStatDoDay = statDo.getAdPackageSubStatDo(advertId, packageId);
        Map<Long, StatBaseDo> pkSlotStatBaseDoMap2 = pkSubStatDoDay.getSlotStatBaseDoMap2();
        StatBaseDo pkStatBaseDo2 = pkSubStatDoDay.getStatBaseDo2();
        Map<Long, StatOffLineBaseDo> pkSlotStatOffLineBaseDoMap = pkSubStatDoDay.getSlotStatOffLineBaseDoMap();
        StatOffLineBaseDo pkStatOffLineBaseDo = pkSubStatDoDay.getStatOffLineBaseDo();
        SubStatDo adSubStatDoDay = statDo.getAdSubStatDo(advertId);
        if (adSubStatDoDay == null) {
            return;
        }
        Map<Long, StatBaseDo> adSlotStatBaseDoMap = adSubStatDoDay.getSlotStatBaseDoMap();
        StatBaseDo adStatBaseDo = adSubStatDoDay.getStatBaseDo();
        Map<Long, StatOffLineBaseDo> adSlotStatOffLineBaseDoMap = adSubStatDoDay.getSlotStatOffLineBaseDoMap();
        StatOffLineBaseDo adStatOffLineBaseDo = adSubStatDoDay.getStatOffLineBaseDo();
        OcpxControlSubModel pkControlSubModel = this.ocpxControlModel.getOcpxControlSubModel(advertId, packageId);
        pkSlotStatBaseDoMap2.forEach((slotId, pkSlotStatBaseDo) -> {
            DeepControlParams pkSlotParams = pkControlSubModel.getDeepControlParams(slotId);
            StatBaseDo adSlotStatBaseDo = (StatBaseDo)adSlotStatBaseDoMap.get(slotId);
            StatOffLineBaseDo pkSlotStatOffLineBaseDo = (StatOffLineBaseDo)pkSlotStatOffLineBaseDoMap.get(slotId);
            StatOffLineBaseDo adSlotStatOffLineBaseDo = (StatOffLineBaseDo)adSlotStatOffLineBaseDoMap.get(slotId);
            OcpxModelBo2.getDeepFactor(2, pkSlotStatBaseDo, pkStatBaseDo2, adSlotStatBaseDo, adStatBaseDo, pkSlotStatOffLineBaseDo, pkStatOffLineBaseDo, adSlotStatOffLineBaseDo, adStatOffLineBaseDo, pkSlotParams, adPackageInfo);
            if (deepPlList.contains(adPackageInfo.getPackageId()) && pkSlotParams.getDeepFactor() != null || adPackageInfo.getAdvertId().equals(62556L)) {
                System.out.println("2 deepLog ad=" + adPackageInfo.getAdvertId() + ",pk=" + adPackageInfo.getPackageId() + ",slot_id=" + slotId + " ,deepFactor=" + pkSlotParams.getDeepFactor());
            }
        });
        DeepControlParams pkParams = pkControlSubModel.getDeepControlParams();
        OcpxModelBo2.getDeepFactor(1, pkStatBaseDo2, pkStatBaseDo2, adStatBaseDo, adStatBaseDo, pkStatOffLineBaseDo, pkStatOffLineBaseDo, adStatOffLineBaseDo, adStatOffLineBaseDo, pkParams, adPackageInfo);
        if (adStatOffLineBaseDo != null && adStatOffLineBaseDo.getExpCnt() > 0L) {
            System.out.println("1 deepLog ad=" + adPackageInfo.getAdvertId() + ",pk=" + adPackageInfo.getPackageId() + ",deepFactor=" + pkParams.getDeepFactor() + ",adStatOffLineBaseDo=" + JSON.toJSONString((Object)adStatOffLineBaseDo));
            this.printDeepData(1, pkStatBaseDo2, pkStatBaseDo2, adStatBaseDo, adStatBaseDo, pkStatOffLineBaseDo, pkStatOffLineBaseDo, adStatOffLineBaseDo, adStatOffLineBaseDo, pkParams, adPackageInfo);
        }
    }

    public void runStat(StatDo statDo, Long advertId) {
        SubStatDo adSubStatDo = statDo.getAdSubStatDo(advertId);
        if (adSubStatDo == null) {
            return;
        }
        Map<Long, StatBaseDo> adSlotStatBaseDoMap = adSubStatDo.getSlotStatBaseDoMap();
        StatBaseDo adStatBaseDo = adSubStatDo.getStatBaseDo();
        adSlotStatBaseDoMap.forEach((slotId, adSlotStatBaseDo) -> {
            AdControlParams adSlotControlParams = this.ocpxControlModel.getAdSlotControlParams(advertId, slotId);
            OcpxModelBo2.runStat(adSlotStatBaseDo, adSlotControlParams);
        });
        AdControlParams adControlParams = this.ocpxControlModel.getAdControlParams(advertId);
        OcpxModelBo2.runStat(adStatBaseDo, adControlParams);
    }

    public String print(int controlType, String prefix, PackageInfo adPackageInfo, StatBaseDo statBaseDoMin, StatBaseDo statBaseDoHour, StatBaseDo statBaseDoDay, StatBaseDo statBaseDo3Day, long fees, int dimType) {
        String print = null;
        if (adPackageInfo == null) {
            return print;
        }
        if (!this.isSync.booleanValue()) {
            this.tradeList = new ArrayList<Long>();
        }
        if (this.pkList2.contains(adPackageInfo.getPackageId()) || adPackageInfo.getPackageId() == 0L && this.adList2.contains(adPackageInfo.getAdvertId()) || this.adList.contains(adPackageInfo.getAdvertId()) || this.tradeList.contains(adPackageInfo.getNewTradeTagId())) {
            Double dayCostBias = StatBaseDo.getCostBias(statBaseDoDay, adPackageInfo.getOldConvertCost(), 0.0);
            long feeDiff = Math.abs(StatBaseDo.getCostDiff(statBaseDoDay));
            AdStatusVo dayPrintDo = OcpxModelBo2.getStatusVo(statBaseDoDay, adPackageInfo.getOldConvertCost(), adPackageInfo.getBackendType().intValue(), 200);
            AdStatusVo hourPrintDo = OcpxModelBo2.getStatusVo(statBaseDoHour, adPackageInfo.getOldConvertCost(), adPackageInfo.getBackendType().intValue(), 100);
            AdStatusVo minPrintDo = OcpxModelBo2.getStatusVo(statBaseDoMin, adPackageInfo.getOldConvertCost(), adPackageInfo.getBackendType().intValue(), 100);
            if (controlType > 1 && controlType != 4) {
                double fastTarget = controlType == 2 ? 0.0 : (controlType == 3 ? 0.01 : 0.0);
                long fastAFee = DataUtil.multiply((Long)adPackageInfo.getOldConvertCost(), (Double)(1.0 + fastTarget));
                dayPrintDo = OcpxModelBo2.getStatusVo2(statBaseDoDay, adPackageInfo.getOldConvertCost(), adPackageInfo.getBackendType().intValue(), 200, fastAFee, fastTarget, dimType);
                hourPrintDo = OcpxModelBo2.getStatusVo2(statBaseDoHour, adPackageInfo.getOldConvertCost(), adPackageInfo.getBackendType().intValue(), 100, fastAFee, fastTarget, dimType);
                minPrintDo = OcpxModelBo2.getStatusVo2(statBaseDoMin, adPackageInfo.getOldConvertCost(), adPackageInfo.getBackendType().intValue(), 100, fastAFee, fastTarget, dimType);
            }
            String printStr = prefix + ",day=" + dayPrintDo.getString() + ",30min=" + hourPrintDo.getString() + ",10min=" + minPrintDo.getString();
            if (statBaseDoDay == null) {
                statBaseDoDay = new StatBaseDo();
            }
            if (this.isSync.booleanValue() || Math.abs(dayCostBias) > 0.09 && statBaseDoDay.getOcpcFees() > fees) {
                print = printStr;
            }
            if (!this.isSync.booleanValue() && dimType == 1) {
                print = printStr;
            }
            if (statBaseDoDay.getExpCnt() < 100L) {
                print = null;
            }
            if (print != null && statBaseDoDay.getOcpcFees() > 100000L && Math.abs(dayCostBias) > 0.1 && dimType == 1) {
                System.out.println("***\u3010WARN\u3011***");
            }
            if (print != null && statBaseDoDay.getOcpcFees() < 100000L && feeDiff > 10000L) {
                System.out.println("***\u3010INFO\u3011***");
            }
            if (print != null || adPackageInfo.getPackageId().equals(176690L)) {
                System.out.println(prefix + ",data_10m " + JSON.toJSONString((Object)statBaseDoMin));
                System.out.println(prefix + ",data_30m " + JSON.toJSONString((Object)statBaseDoHour));
                System.out.println(prefix + ",data_day " + JSON.toJSONString((Object)statBaseDoDay));
            }
        }
        return print;
    }

    public void printDeepData(int dimType, StatBaseDo pkSlotStatBaseDo, StatBaseDo pkStatBaseDo, StatBaseDo adSlotStatBaseDo, StatBaseDo adStatBaseDo, StatOffLineBaseDo pkSlotStatOffLineBaseDo, StatOffLineBaseDo pkStatOffLineBaseDo, StatOffLineBaseDo adSlotStatOffLineBaseDo, StatOffLineBaseDo adStatOffLineBaseDo, DeepControlParams params, PackageInfo adPackageInfo) {
        if (adPackageInfo == null || adPackageInfo.getNewTradeTagId() == null) {
            return;
        }
        Double factor = null;
        int startType = 0;
        int endType = 0;
        if (adPackageInfo.getBackendType() != null) {
            startType = adPackageInfo.getBackendType().intValue();
        }
        if (adPackageInfo.getDeepCvrType() != null) {
            endType = adPackageInfo.getDeepCvrType().intValue();
        }
        if ((adPackageInfo.getNewTradeTagId().equals(21L) || adPackageInfo.getNewTradeTagId().equals(15L)) && adPackageInfo.getDeepFee() != null) {
            endType = 3;
            if (adPackageInfo.getPackageId().equals(174946L) || adPackageInfo.getPackageId().equals(175371L)) {
                endType = 8;
            }
            Double adDcvrOffLine = StatOffLineBaseDo.getDcvr(adStatOffLineBaseDo, startType, endType, null);
            Double adSlotDcvrOffLine = StatOffLineBaseDo.getDcvr(adSlotStatOffLineBaseDo, startType, endType, adDcvrOffLine);
            Double pkDcvrOffLine = StatOffLineBaseDo.getDcvr(pkStatOffLineBaseDo, startType, endType, adDcvrOffLine);
            Double pkSlotDcvrOffLine = StatOffLineBaseDo.getDcvr(pkSlotStatOffLineBaseDo, startType, endType, adSlotDcvrOffLine);
            Double adDcvr = StatBaseDo.getDcvr(adStatBaseDo, startType, endType, adDcvrOffLine);
            Double adSlotDcvr = StatBaseDo.getDcvr(adSlotStatBaseDo, startType, endType, adSlotDcvrOffLine);
            Double pkDcvr = StatBaseDo.getDcvr(pkStatBaseDo, startType, endType, pkDcvrOffLine);
            Double pkSlotDcvr = StatBaseDo.getDcvr(pkSlotStatBaseDo, startType, endType, pkSlotDcvrOffLine);
            Double adFactor2 = null;
            Double pkFactor2 = null;
            if (adDcvr != null && adSlotDcvr != null && adPackageInfo.getDeepFee() != null) {
                adFactor2 = (double)adPackageInfo.getDeepFee().longValue() * adSlotDcvr / (double)adPackageInfo.getOldConvertCost().longValue();
            }
            if (pkDcvr != null && pkSlotDcvr != null && adPackageInfo.getDeepFee() != null) {
                pkFactor2 = (double)adPackageInfo.getDeepFee().longValue() * pkSlotDcvr / (double)adPackageInfo.getOldConvertCost().longValue();
            }
            if (adFactor2 != null && pkFactor2 == null) {
                factor = adFactor2;
            }
            if (adFactor2 != null && pkFactor2 != null) {
                factor = adFactor2 * 0.5 + pkFactor2 * 0.5;
            }
            System.out.println("adDcvrOffLine=" + adDcvrOffLine + ",adSlotDcvrOffLineo=" + adSlotDcvrOffLine + ",pkDcvrOffLine=" + pkDcvrOffLine + ",pkSlotDcvrOffLine=" + pkSlotDcvrOffLine);
            System.out.println("adDcvr=" + adDcvr + ",adStatOffLineBaseDo=" + JSON.toJSONString((Object)adStatOffLineBaseDo) + ",adStatBaseDo=" + JSON.toJSONString((Object)adStatBaseDo));
            System.out.println("adSlotDcvr=" + adSlotDcvr + ",adSlotStatOffLineBaseDo=" + JSON.toJSONString((Object)adSlotStatOffLineBaseDo) + ",adSlotStatBaseDo=" + JSON.toJSONString((Object)adSlotStatBaseDo));
            System.out.println("pkDcvr=" + pkDcvr + ",pkStatOffLineBaseDo=" + JSON.toJSONString((Object)pkStatOffLineBaseDo));
            System.out.println("pkSlotDcvr=" + pkSlotDcvr + ",pkSlotStatOffLineBaseDo=" + JSON.toJSONString((Object)pkSlotStatOffLineBaseDo));
            System.out.println("deepFee=" + adPackageInfo.getDeepFee() + ",aFee=" + adPackageInfo.getOldConvertCost() + ",adFactor2=" + adFactor2 + ",pkFactor2=" + pkFactor2);
        }
    }
}

