/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.ocpx.control;

import cn.com.duiba.nezha.alg.common.util.MathUtil;

public class PID {
    private double P;
    private double I;
    private double D;
    private static double LEARNING_RATE = 0.25;

    public PID(double p, double i, double d, double learn_ratio) {
        this.P = p;
        this.I = i;
        this.D = d;
        LEARNING_RATE = learn_ratio;
    }

    public PID() {
        this.P = 1.0;
        this.I = 0.5;
        this.D = 0.0;
    }

    public double getAdaptLearnRatio(double factor) {
        double ret = factor > 1.0 ? 2.0 - factor : 3.0 - 2.0 * factor;
        ret = MathUtil.stdwithBoundary((double)ret, (double)0.5, (double)2.0);
        return ret;
    }

    public double update(double target, double actualMin, double actualHour, double actualDay, double factor, double baseLearnRatio) {
        double learnRatio = baseLearnRatio * this.getAdaptLearnRatio(factor);
        return this.update2(target, actualMin, actualHour, actualDay, 3.0, learnRatio);
    }

    public double update(double target, double actual, double actualSum, double factor, double baseLearnRatio) {
        double learnRatio = baseLearnRatio * this.getAdaptLearnRatio(factor);
        return this.update2(target, actual, actualSum, 3.0, learnRatio);
    }

    public double update(double target, double actualSum, double factor, double baseLearnRatio) {
        double learnRatio = baseLearnRatio * this.getAdaptLearnRatio(factor);
        return this.update2(target, actualSum, learnRatio);
    }

    public double update2(double target, double actualSum, double learnRatio) {
        double singalHistory;
        double singal = 0.0;
        singal = singalHistory = target - actualSum;
        singal = learnRatio * singal;
        singal = MathUtil.stdwithBoundary((double)singal, (double)-0.15, (double)0.15);
        return singal;
    }

    public double update2(double target, double actual, double actualSum, double accWeight, double learnRatio) {
        double singal = 0.0;
        double singalCurrent = 1.0 * (target - actual);
        double singalHistory = accWeight * (target - actualSum);
        singal = (singalCurrent + singalHistory) / (1.0 + accWeight);
        if (singalCurrent * singalHistory < 0.0) {
            if (actual <= -0.4) {
                singal = -0.4 - actual;
            }
            if (actual >= 0.2) {
                singal = 0.2 - actual;
            }
        }
        singal = learnRatio * singal;
        singal = MathUtil.stdwithBoundary((double)singal, (double)-0.15, (double)0.15);
        return singal;
    }

    public double update2(double target, double actualMin, double actualHour, double actualDay, double accWeight, double learnRatio) {
        double singal = 0.0;
        double singalMin = 0.5 * (target - actualMin);
        double singalHour = 1.0 * (target - actualHour);
        double singalHistory = accWeight * (target - actualDay);
        singal = (singalMin + singalHour + singalHistory) / (1.5 + accWeight);
        if (singalHour * singalHistory < 0.0) {
            if (actualHour <= -0.4) {
                singal = -0.4 - actualHour;
            }
            if (actualHour >= 0.2) {
                singal = 0.2 - actualHour;
            }
        }
        singal = learnRatio * singal;
        singal = MathUtil.stdwithBoundary((double)singal, (double)-0.15, (double)0.15);
        return singal;
    }
}

