/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.spark.explore;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.compute.biz.bo.PsBo;
import cn.com.duiba.nezha.compute.biz.conf.JedisPoolConf;
import cn.com.duiba.nezha.compute.biz.constant.ProjectConstant;
import cn.com.duiba.nezha.compute.biz.dto.OrderDo;
import cn.com.duiba.nezha.compute.biz.dto.stat.ExpOrderSample;
import cn.com.duiba.nezha.compute.biz.params.EXPSTATParams;
import cn.com.duiba.nezha.compute.biz.utils.jedis.JedisUtil;
import cn.com.duiba.nezha.compute.core.enums.DateStyle;
import cn.com.duiba.nezha.compute.core.util.DateUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import scala.collection.Iterator;

public class AppAdvertStat {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    public static void statExpOnMsg(EXPSTATParams params, Iterator<OrderDo> partitionOfRecords) throws Exception {
        Map<String, String> iBuffer;
        Map<String, String> fBuffer;
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            orderIdList.add(order.getOrderId());
        }
        List<ExpOrderSample> samples = PsBo.getExpStatSample(orderIdList);
        System.out.println("samples.size()=" + samples.size());
        samples = samples.stream().filter(s -> s.getTime() != null).collect(Collectors.toList());
        System.out.println("After filter samples.size()=" + samples.size());
        if (samples.size() == 0) {
            return;
        }
        samples.sort(Comparator.comparing(ExpOrderSample::getTime));
        Map<String, String> rBuffer = AppAdvertStat.getDataByKeyToJedis(params.key0());
        if (rBuffer == null) {
            rBuffer = new HashMap<String, String>();
        }
        if ((fBuffer = AppAdvertStat.getDataByKeyToJedis(params.key1())) == null) {
            fBuffer = new HashMap<String, String>();
        }
        if ((iBuffer = AppAdvertStat.getDataByKeyToJedis(params.key2())) == null) {
            iBuffer = new HashMap<String, String>();
        }
        System.out.println("rBuffer.size: " + rBuffer.size());
        System.out.println("fBuffer.size: " + fBuffer.size());
        System.out.println("iBuffer.size: " + iBuffer.size());
        for (ExpOrderSample expOrderSample : samples) {
            String string = expOrderSample.getAppId() + "#" + expOrderSample.getAdvertId();
        }
        AppAdvertStat.saveDataByKeyToJedis(params.key0(), rBuffer);
        AppAdvertStat.saveDataByKeyToJedis(params.key1(), fBuffer);
        AppAdvertStat.saveDataByKeyToJedis(params.key2(), iBuffer);
    }

    private static Map<Long, Double> merge1(Map<Long, Double> map1, Map<Long, Double> map2) {
        if (map1 == null) {
            return map2;
        }
        if (map2 == null) {
            return map1;
        }
        for (Map.Entry<Long, Double> entry : map2.entrySet()) {
            map1.put(entry.getKey(), map1.getOrDefault(entry.getKey(), 0.0) + entry.getValue());
        }
        return map1;
    }

    private static Map<Long, Long> merge2(Map<Long, Long> map1, Map<Long, Long> map2) {
        if (map1 == null) {
            return map2;
        }
        if (map2 == null) {
            return map1;
        }
        for (Map.Entry<Long, Long> entry : map2.entrySet()) {
            map1.put(entry.getKey(), map1.getOrDefault(entry.getKey(), 0L) + entry.getValue());
        }
        return map1;
    }

    public static boolean isTargetConvert(ExpOrderSample expOrderSample) {
        return expOrderSample.getConvert0Cnt() > 0L || expOrderSample.getConvert2Cnt() > 0L || expOrderSample.getConvert3Cnt() > 0L || expOrderSample.getConvert4Cnt() > 0L || expOrderSample.getConvert5Cnt() > 0L || expOrderSample.getConvert6Cnt() > 0L || expOrderSample.getConvert7Cnt() > 0L || expOrderSample.getConvert8Cnt() > 0L;
    }

    public static void saveDataByKeyToJedis(String modelKey, Map<String, String> model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            System.out.println("save model with key " + modelKey);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(modelKey, value2, ProjectConstant.WEEK_1_EXPIRE);
            AppAdvertStat.updateTime(modelKey, jedisUtil);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getDataByKeyToJedis(String modelKey) {
        Map ret = null;
        try {
            String ret1 = jedisUtil.get(modelKey);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (Map)JSON.parseObject((String)ret2, Map.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void updateTime(String modelKey, JedisUtil jedisUtil) {
        String updateTimeKey = modelKey + "_update_time";
        String updateTime = LocalDateUtil.getCurrentLocalDateTime((cn.com.duiba.nezha.alg.common.enums.DateStyle)cn.com.duiba.nezha.alg.common.enums.DateStyle.YYYY_MM_DD_HH_MM_SS);
        jedisUtil.setex(updateTimeKey, updateTime, ProjectConstant.WEEK_1_EXPIRE);
    }
}

