/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.support;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder;
import cn.com.duiba.nezha.alg.feature.coder.FeatureNewCoder2;
import cn.com.duiba.nezha.alg.feature.coder.FeatureUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCode;
import cn.com.duiba.nezha.compute.biz.app.FeatureCoderApp;
import cn.com.duiba.nezha.compute.biz.constant.feature.FeatureBcvrListConstant;
import cn.com.duiba.nezha.compute.biz.constant.feature.FeatureListConstant;
import cn.com.duiba.nezha.compute.biz.dto.PsModelSample;
import cn.com.duiba.nezha.compute.core.FeatureValue;
import cn.com.duiba.nezha.compute.core.LabeledDpFeature;
import cn.com.duiba.nezha.compute.core.LabeledESMMFeature;
import cn.com.duiba.nezha.compute.core.LabeledESMMSparsePoint;
import cn.com.duiba.nezha.compute.core.LabeledFeature;
import cn.com.duiba.nezha.compute.core.LabeledPoint;
import cn.com.duiba.nezha.compute.core.LabeledSparseDpaFeature;
import cn.com.duiba.nezha.compute.core.LabeledSparsePoint;
import cn.com.duiba.nezha.compute.core.LabeledWeightedDpaFeature;
import cn.com.duiba.nezha.compute.core.SlotLabeledPoint;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.core.util.DataUtil;
import cn.com.duiba.nezha.compute.core.vo.Feature;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vectors;

public class SampleParse {
    public static Map<Double, Long> cntMap = new HashMap<Double, Long>();

    public static List<LabeledESMMSparsePoint> parseESMM(List<PsModelSample> psModelSampleList, String ctrModelId, String cvrModelId) {
        List<Object> labeledPointList = new ArrayList<LabeledESMMSparsePoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseSparseESMM(s, ctrModelId, cvrModelId)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledESMMSparsePoint> parseESMM(List<PsModelSample> psModelSampleList, String ctrModelId, String cvrModelId, boolean isBcvr) {
        List<Object> labeledPointList = new ArrayList<LabeledESMMSparsePoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseSparseESMM(s, ctrModelId, cvrModelId, isBcvr)).flatMap(list -> list.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledSparsePoint> parseSparse(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr) {
        List<Object> labeledPointList = new ArrayList<LabeledSparsePoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseSparse(s, modelId, isCtr)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parseAdxIdea(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseAdxIdea(s, modelId, isCtr)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parse(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parse(s, modelId, isCtr)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parseAdxPd(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                System.out.println("===parseAdxPd_pre, size=" + psModelSampleList.size());
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseAdxPd(s, modelId, isCtr)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("===parseAdxPd_after, size=" + labeledPointList.size());
        return labeledPointList;
    }

    public static List<LabeledPoint> parseMaterial(List<PsModelSample> psModelSampleList, String modelId, HashMap<String, Double> PosNegMap) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                System.out.println("===parseMaterial_pre, size=" + psModelSampleList.size());
                labeledPointList = psModelSampleList.stream().filter(s -> SampleParse.SlotNegSample(s, PosNegMap)).map(s -> SampleParse.parseMaterial(s, modelId)).filter(l -> l != null).collect(Collectors.toList());
            }
            double ctr = labeledPointList.stream().mapToDouble(LabeledPoint::label).average().getAsDouble();
            System.out.println("total ctr : " + ctr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("===parseMaterial_after, size=" + labeledPointList.size());
        return labeledPointList;
    }

    public static List<SlotLabeledPoint> parseMaterialSlot(List<PsModelSample> psModelSampleList, String modelId, HashMap<String, Double> PosNegMap) {
        List<Object> labeledPointList = new ArrayList<SlotLabeledPoint>();
        try {
            if (psModelSampleList != null) {
                System.out.println("===parseMaterial_pre, size=" + psModelSampleList.size());
                labeledPointList = psModelSampleList.stream().filter(s -> SampleParse.SlotNegSample(s, PosNegMap)).map(s -> SampleParse.parseMaterialSlot(s, modelId)).filter(l -> l != null).collect(Collectors.toList());
            }
            double ctr = labeledPointList.stream().mapToDouble(SlotLabeledPoint::label).average().getAsDouble();
            System.out.println("total ctr : " + ctr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("===parseMaterial_after, size=" + labeledPointList.size());
        return labeledPointList;
    }

    public static List<SlotLabeledPoint> parseDpSlot(List<PsModelSample> psModelSampleList, String modelId) {
        List<Object> labeledPointList = new ArrayList<SlotLabeledPoint>();
        try {
            if (psModelSampleList != null) {
                System.out.println("===parseDp_pre, size=" + psModelSampleList.size());
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseMaterialSlot(s, modelId)).filter(l -> l != null).collect(Collectors.toList());
            }
            double ctr = labeledPointList.stream().mapToDouble(SlotLabeledPoint::label).average().getAsDouble();
            System.out.println("total ctr : " + ctr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("===parseDp_after, size=" + labeledPointList.size());
        return labeledPointList;
    }

    public static List<SlotLabeledPoint> parseMaterialSlot(List<PsModelSample> nonAdSamples, List<PsModelSample> adSamples, String modelId, HashMap<String, Double> nonAdPosNegMap, HashMap<String, Double> adPosNegMap) {
        List<Object> nonAdLabeledPointList = new ArrayList();
        List<Object> adLabeledPointList = new ArrayList();
        ArrayList<SlotLabeledPoint> labeledPointList = new ArrayList<SlotLabeledPoint>();
        try {
            if (nonAdSamples != null) {
                System.out.println("===parseMaterial_pre, nonAdSamples size=" + nonAdSamples.size());
                nonAdLabeledPointList = nonAdSamples.stream().filter(s -> SampleParse.SlotNegSample(s, nonAdPosNegMap)).map(s -> SampleParse.parseMaterialSlot(s, modelId)).filter(l -> l != null).collect(Collectors.toList());
            }
            if (nonAdLabeledPointList.size() > 0) {
                labeledPointList.addAll(nonAdLabeledPointList);
            }
            if (adSamples != null) {
                System.out.println("===parseMaterial_pre, adSamples size=" + adSamples.size());
                adLabeledPointList = adSamples.stream().filter(s -> SampleParse.SlotNegSample(s, adPosNegMap)).map(s -> SampleParse.parseMaterialSlotAdWeighted(s, modelId)).filter(l -> l != null).collect(Collectors.toList());
            }
            if (adLabeledPointList.size() > 0) {
                labeledPointList.addAll(adLabeledPointList);
            }
            double ctr = labeledPointList.stream().mapToDouble(SlotLabeledPoint::label).average().getAsDouble();
            System.out.println("total ctr : " + ctr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("===parseMaterial_after, size=" + labeledPointList.size());
        return labeledPointList;
    }

    public static boolean SlotNegSample(PsModelSample psModelSample, HashMap<String, Double> PosNegMap) {
        boolean ret = true;
        String feature = psModelSample.getFeature();
        JSONObject featureMap = JSONObject.parseObject((String)feature);
        String slotID = (String)featureMap.get("f108001");
        double negativeSampleRatio = PosNegMap.get(slotID);
        if (feature == null) {
            ret = false;
        }
        if (SampleParse.toLabel(psModelSample.getIsClick()) < 0.5 && Math.random() > negativeSampleRatio) {
            ret = false;
        }
        return ret;
    }

    public static List<LabeledPoint> parseMaterial1(List<PsModelSample> psModelSampleList, String modelId) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                System.out.println("===parseMaterial_pre, size=" + psModelSampleList.size());
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseMaterial1(s, modelId)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("===parseMaterial_after, size=" + labeledPointList.size());
        return labeledPointList;
    }

    public static List<LabeledPoint> parseWithMissingFilter(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr, String[] checkFieldIds) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseFilterMissing(s, modelId, isCtr, checkFieldIds)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parseWithDelayFilter(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr, Long delayMinutes) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseWithDelayFilter(s, modelId, isCtr, delayMinutes)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parse(PsModelSample psModelSample, String modelId) {
        ArrayList<LabeledPoint> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            Set<Long> backTypeSet;
            if (psModelSample == null) {
                return labeledPointList;
            }
            if (SampleParse.parseMap(psModelSample) && AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && SampleParse.valid(psModelSample.getIsClick())) {
                int maxType = 0;
                for (int i = 0; i <= maxType; ++i) {
                    if (!backTypeSet.contains(i)) continue;
                    psModelSample.getFeatureMap().put("f115001", i + "");
                    CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    LabeledPoint labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                    labeledPointList.add(labeledPoint);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parseDCvr(List<PsModelSample> psModelSampleList, String modelId) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseDcvr(s, modelId)).flatMap(list -> list.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parse(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr, boolean isCvrType0) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parse(s, modelId, isCtr, isCvrType0)).flatMap(list -> list.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parseWithSdkFilter(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr, boolean isCvrType0) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseSdkFilter(s, modelId, isCtr, isCvrType0)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
            }
            System.out.println(labeledPointList.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parseWithTradeFilter(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr, boolean isCvrType0, Set<Integer> tradeCodes) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseFilterTrade(s, modelId, isCtr, isCvrType0, tradeCodes)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parseWithMissingFilter(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr, boolean isCvrType0, String[] checkFieldIds) {
        List<Object> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSampleList != null) {
                labeledPointList = psModelSampleList.stream().map(s -> SampleParse.parseFilterMissing(s, modelId, isCtr, isCvrType0, checkFieldIds)).flatMap(list -> list.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledSparsePoint> parseWithField(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr) {
        List<Object> labeledSparsePointList = new ArrayList<LabeledSparsePoint>();
        try {
            if (psModelSampleList != null) {
                labeledSparsePointList = psModelSampleList.stream().map(s -> SampleParse.parseWithFiled(s, modelId, isCtr)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledSparsePointList;
    }

    public static List<LabeledSparsePoint> parseWithFieldOffline(List<LabeledSparsePoint> psModelSampleList, String modelId, boolean isCtr) {
        List<Object> labeledSparsePointList = new ArrayList<LabeledSparsePoint>();
        try {
            if (psModelSampleList != null) {
                labeledSparsePointList = psModelSampleList.stream().filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledSparsePointList;
    }

    public static List<FeatureValue> parseFieldFeatures(List<PsModelSample> psModelSampleList, List<FeatureBaseType> featureList) {
        ArrayList<FeatureValue> featureValueList = new ArrayList<FeatureValue>();
        try {
            if (psModelSampleList != null) {
                HashMap ret = new HashMap();
                int size = psModelSampleList.size();
                for (int i = 0; i < size; ++i) {
                    PsModelSample psModelSample = psModelSampleList.get(i);
                    if (!SampleParse.parseMap(psModelSample)) continue;
                    for (FeatureBaseType featureBaseType : featureList) {
                        String value = psModelSample.getFeatureMap().get(featureBaseType.getName());
                        Set<String> retSub = SampleParse.parseFeatureValues(value, featureBaseType.getCodeType(), featureBaseType.getSeq());
                        if (!ret.containsKey(featureBaseType.getName())) {
                            ret.put(featureBaseType.getName(), new HashSet());
                        }
                        ((Set)ret.get(featureBaseType.getName())).addAll(retSub);
                    }
                }
                for (Map.Entry entry : ret.entrySet()) {
                    String field = (String)entry.getKey();
                    Set value = (Set)entry.getValue();
                    if (!AssertUtil.isNotEmpty((Collection)value)) continue;
                    value.stream().forEach(v -> {
                        FeatureValue featureValue = new FeatureValue(field, v, 0L);
                        featureValueList.add(featureValue);
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return featureValueList;
    }

    public static Set<String> parseFeatureValues(String featureValue, int codeType, String seq) throws Exception {
        String[] features;
        HashSet<String> ret = new HashSet<String>();
        if (codeType == 10 || codeType == 20 || codeType == 30) {
            ret.add(featureValue);
        }
        if ((codeType == 11 || codeType == 21 || codeType == 31) && (features = FeatureUtil.toFeatures((String)featureValue, (String)seq)) != null && features.length > 0) {
            for (int i = 0; i < features.length; ++i) {
                ret.add(features[i]);
            }
        }
        return ret;
    }

    public static List<LabeledDpFeature> dpParseOfEachField(List<PsModelSample> psModelSampleList, List<FeatureBaseType> featureList) {
        List<Object> labeledDpFeatures = new ArrayList<LabeledDpFeature>();
        try {
            if (psModelSampleList != null) {
                System.out.println("dpParseOfEachField start");
                labeledDpFeatures = psModelSampleList.stream().map(s -> SampleParse.dpParseOfEachField(s, featureList)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledDpFeatures;
    }

    public static List<LabeledSparsePoint> parseOfEachField(List<PsModelSample> psModelSampleList, List<FeatureBaseType> featureList) {
        List<Object> labeledSparsePointList = new ArrayList<LabeledSparsePoint>();
        try {
            if (psModelSampleList != null) {
                labeledSparsePointList = psModelSampleList.stream().map(s -> SampleParse.parseOfEachField(s, featureList)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledSparsePointList;
    }

    public static List<Map<String, FeatureCode>> parseOfEachFieldV2(List<PsModelSample> psModelSampleList, List<FeatureBaseType> featureList) {
        List<Map<String, Object>> labeledSparsePointList = new ArrayList<Map<String, FeatureCode>>();
        HashMap tmpCoderCache = new HashMap();
        try {
            if (psModelSampleList != null) {
                labeledSparsePointList = psModelSampleList.stream().map(s -> SampleParse.parseOfEachFieldV2(s, featureList, tmpCoderCache)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledSparsePointList;
    }

    public static List<LabeledSparseDpaFeature> parseOfEachField2(List<PsModelSample> psModelSampleList, List<FeatureBaseType> featureList) {
        List<Object> labeledSparseDpaFeatures = new ArrayList<LabeledSparseDpaFeature>();
        try {
            if (psModelSampleList != null) {
                labeledSparseDpaFeatures = psModelSampleList.stream().map(s -> SampleParse.parseOfEachField2(s, featureList)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledSparseDpaFeatures;
    }

    public static List<LabeledSparsePoint> parseWithField(List<PsModelSample> psModelSampleList, String modelId, boolean isCtr, boolean isCvrType0) {
        List<Object> labeledSparsePointList = new ArrayList<LabeledSparsePoint>();
        try {
            if (psModelSampleList != null) {
                labeledSparsePointList = psModelSampleList.stream().map(s -> SampleParse.parseWithField(s, modelId, isCtr, isCvrType0)).flatMap(list -> list.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledSparsePointList;
    }

    public static List<LabeledFeature> parse(List<PsModelSample> psModelSampleList, boolean isCtr) {
        List<Object> labeledFeatureList = new ArrayList<LabeledFeature>();
        System.out.println("isCtr: " + isCtr);
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().filter(SampleParse::validSample1).map(s -> SampleParse.parse(s, isCtr)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseBcvr(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseBcvr(s)).flatMap(s -> s.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseBcvrAdx(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().filter(FeatureCoderApp::validSample).map(s -> SampleParse.parseBcvr(s)).flatMap(Collection::stream).filter(l -> l != null).collect(Collectors.toList());
                System.out.println("filter samples list size: " + labeledFeatureList.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static boolean validSample1(PsModelSample psModelSample) {
        boolean ret = false;
        String feature = psModelSample.getFeature();
        JSONObject featureMap = JSONObject.parseObject((String)feature);
        if (featureMap == null) {
            return false;
        }
        String app_id = featureMap.getOrDefault("f201001", "-1");
        if (app_id.equals("67018")) {
            ret = true;
        }
        return ret;
    }

    public static List<LabeledFeature> parseADXIdea(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseADXIdea(s)).flatMap(s -> s.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseADXLaunchPV(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseADXLaunchPV(s)).flatMap(s -> s.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseADXChargePV(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseADXChargePV(s)).flatMap(s -> s.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseACT(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseACT(s)).flatMap(s -> s.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseACTTITLE(List<PsModelSample> psModelSampleList) {
        ArrayList<LabeledFeature> labeledFeatureList = new ArrayList();
        try {
            cntMap.clear();
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseACTTITLE(s)).flatMap(s -> s.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\u8ba1\u6570=" + JSON.toJSONString(cntMap));
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseACTINTER(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseACTINTER(s)).flatMap(s -> s.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parsePLUGINTER(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parsePLUGINTER(s)).flatMap(s -> s.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledWeightedDpaFeature> parseDPAACT(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledWeightedDpaFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseDPAACT(s)).flatMap(s -> s.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledWeightedDpaFeature> parseDPANonSdkACT(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledWeightedDpaFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseDPANonSdkACT(s)).flatMap(s -> s.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static boolean negativeSampleFilter(LabeledWeightedDpaFeature labeledWeightedDpaFeature, double negativeSampleRatio) {
        boolean ret = false;
        if (labeledWeightedDpaFeature != null && (labeledWeightedDpaFeature.joinCnt() == 0.0 && Math.random() < negativeSampleRatio || labeledWeightedDpaFeature.joinCnt() > 0.0)) {
            ret = true;
        }
        return ret;
    }

    public static List<LabeledWeightedDpaFeature> parseDPAIntercept(List<PsModelSample> psModelSampleList, Double negativeSampleRatio) {
        List<Object> labeledFeatureList = new ArrayList<LabeledWeightedDpaFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseDPAIntercept(s)).flatMap(s -> s.stream()).filter(l -> SampleParse.negativeSampleFilter(l, negativeSampleRatio)).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledWeightedDpaFeature> parseDPAACT(List<PsModelSample> psModelSampleList, Double negativeSampleRatio) {
        List<Object> labeledFeatureList = new ArrayList<LabeledWeightedDpaFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseDPAACT(s)).flatMap(s -> s.stream()).filter(l -> SampleParse.negativeSampleFilter(l, negativeSampleRatio)).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledWeightedDpaFeature> parseDPANonSdkACT(List<PsModelSample> psModelSampleList, Double negativeSampleRatio) {
        List<Object> labeledFeatureList = new ArrayList<LabeledWeightedDpaFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseDPANonSdkACT(s)).flatMap(s -> s.stream()).filter(l -> SampleParse.negativeSampleFilter(l, negativeSampleRatio)).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledESMMFeature> parseESMM(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledESMMFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseESMM(s)).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static LabeledESMMFeature parseESMM(PsModelSample psModelSample) {
        LabeledESMMFeature labeledFeature = null;
        try {
            if (psModelSample == null) {
                return labeledFeature;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Set<Long> backTypeSet = psModelSample.getBackSubTypeSet();
                if (AssertUtil.isNotEmpty(backTypeSet)) {
                    if (SampleParse.valid(psModelSample.getIsClick())) {
                        int maxType = 0;
                        for (int i = 0; i <= maxType; ++i) {
                            if (!backTypeSet.contains(i)) continue;
                            labeledFeature = SampleParse.toLabeledESMMFeature(psModelSample.getFeature(), psModelSample.getIsClick(), psModelSample.getActClickList().get(i), i, 1);
                        }
                    }
                } else {
                    labeledFeature = SampleParse.toLabeledESMMFeature(psModelSample.getFeature(), psModelSample.getIsClick(), psModelSample.getActClickList().get(0), 0, 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeature;
    }

    public static List<LabeledESMMFeature> parseESMMBcvr(List<PsModelSample> psModelSampleList) {
        List<Object> labeledFeatureList = new ArrayList<LabeledESMMFeature>();
        try {
            if (psModelSampleList != null) {
                labeledFeatureList = psModelSampleList.stream().map(s -> SampleParse.parseESMMBcvr(s)).flatMap(s -> s.stream()).filter(l -> l != null).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledESMMFeature> parseESMMBcvr(PsModelSample psModelSample) {
        ArrayList<LabeledESMMFeature> labeledFeature = new ArrayList<LabeledESMMFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeature;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Set<Long> backTypeSet = psModelSample.getBackSubTypeSet();
                if (AssertUtil.isNotEmpty(backTypeSet)) {
                    if (SampleParse.valid(psModelSample.getIsClick())) {
                        int maxType = 8;
                        for (int i = 0; i <= maxType; ++i) {
                            if (!backTypeSet.contains(i)) continue;
                            LabeledESMMFeature lf = SampleParse.toLabeledESMMFeature(psModelSample.getFeature(), psModelSample.getIsClick(), psModelSample.getActClickList().get(i), i, 1);
                            labeledFeature.add(lf);
                        }
                    }
                } else {
                    LabeledESMMFeature lf = SampleParse.toLabeledESMMFeature(psModelSample.getFeature(), psModelSample.getIsClick(), psModelSample.getActClickList().get(0), 0, 0);
                    labeledFeature.add(lf);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeature;
    }

    public static LabeledFeature parse(PsModelSample psModelSample, boolean isCtr) {
        LabeledFeature labeledFeature = null;
        try {
            if (psModelSample == null) {
                return labeledFeature;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    labeledFeature = SampleParse.toLabeledFeature(psModelSample.getFeature(), psModelSample.getIsClick());
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = 0;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        labeledFeature = SampleParse.toLabeledFeature(psModelSample.getFeature(), psModelSample.getActClickList().get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeature;
    }

    public static List<LabeledFeature> parseBcvr(PsModelSample psModelSample) {
        ArrayList<LabeledFeature> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            Set<Long> backTypeSet;
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseMap(psModelSample) && AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet())) {
                for (int i = 0; i <= 8; ++i) {
                    if (!backTypeSet.contains(i)) continue;
                    LabeledFeature labeledFeature = SampleParse.toLabeledFeature(psModelSample.getFeature(), psModelSample.getActClickList().get(i), i);
                    labeledFeatureList.add(labeledFeature);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseADXIdea(PsModelSample psModelSample) {
        ArrayList<LabeledFeature> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Long adxCost = psModelSample.getAdxFee();
                Long adFee = psModelSample.getFee();
                if (adxCost == null) {
                    adxCost = 0L;
                }
                if (adFee == null) {
                    adFee = 0L;
                }
                Double ret = 0.0;
                if ((double)adxCost.longValue() > 0.0) {
                    Double retP1 = DataUtil.division((Long)adFee, (Double)1.0, (int)6);
                    ret = DataUtil.formatdouble((double)retP1, (int)6);
                }
                Double label = DataUtil.formatDouble((Double)ret, (int)5);
                LabeledFeature labeledFeature = new LabeledFeature(label.doubleValue(), psModelSample.getFeature(), 0);
                labeledFeatureList.add(labeledFeature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseADXLaunchPV(PsModelSample psModelSample) {
        ArrayList<LabeledFeature> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Long adLaunch = psModelSample.getAdvertLaunch();
                if (adLaunch == null) {
                    adLaunch = 0L;
                }
                Double ret = 0.0;
                if ((double)adLaunch.longValue() > 0.0) {
                    Double retP1 = DataUtil.division((Long)adLaunch, (Double)1.0, (int)6);
                    ret = DataUtil.formatdouble((double)retP1, (int)6);
                }
                Double label = DataUtil.formatDouble((Double)ret, (int)5);
                LabeledFeature labeledFeature = new LabeledFeature(label.doubleValue(), psModelSample.getFeature(), 0);
                labeledFeatureList.add(labeledFeature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseADXChargePV(PsModelSample psModelSample) {
        ArrayList<LabeledFeature> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Long adCharge = psModelSample.getAdClickCnt();
                if (adCharge == null) {
                    adCharge = 0L;
                }
                Double ret = 0.0;
                if ((double)adCharge.longValue() > 0.0) {
                    Double retP1 = DataUtil.division((Long)adCharge, (Double)1.0, (int)6);
                    ret = DataUtil.formatdouble((double)retP1, (int)6);
                }
                Double label = DataUtil.formatDouble((Double)ret, (int)5);
                LabeledFeature labeledFeature = new LabeledFeature(label.doubleValue(), psModelSample.getFeature(), 0);
                labeledFeatureList.add(labeledFeature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseACT(PsModelSample psModelSample) {
        ArrayList<LabeledFeature> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Long actFee = psModelSample.getActFee();
                Long plFee = psModelSample.getPlFee();
                if (actFee == null) {
                    actFee = 0L;
                }
                if (plFee == null) {
                    plFee = 0L;
                }
                Double ret = (double)(actFee + plFee) + 0.0;
                Double label = DataUtil.formatDouble((Double)ret, (int)5);
                LabeledFeature labeledFeature = new LabeledFeature(label.doubleValue(), psModelSample.getFeature(), 0);
                labeledFeatureList.add(labeledFeature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseACTTITLE(PsModelSample psModelSample) {
        ArrayList<LabeledFeature> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseActTitleMap(psModelSample)) {
                Long fee = psModelSample.getFee();
                Long feeCnt = psModelSample.getFeeCnt();
                if (fee == null) {
                    fee = 0L;
                }
                if (feeCnt == null) {
                    feeCnt = 0L;
                }
                Double ret = (double)feeCnt.longValue() + 0.0;
                Double label = DataUtil.formatDouble((Double)ret, (int)5);
                LabeledFeature labeledFeature = new LabeledFeature(label.doubleValue(), psModelSample.getFeature(), 0);
                labeledFeatureList.add(labeledFeature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parseACTINTER(PsModelSample psModelSample) {
        ArrayList<LabeledFeature> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Long fee = psModelSample.getFee();
                if (fee == null) {
                    fee = 0L;
                }
                Double ret = (double)fee.longValue() + 0.0;
                Double label = DataUtil.formatDouble((Double)ret, (int)5);
                LabeledFeature labeledFeature = new LabeledFeature(label.doubleValue(), psModelSample.getFeature(), 0);
                labeledFeatureList.add(labeledFeature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledFeature> parsePLUGINTER(PsModelSample psModelSample) {
        ArrayList<LabeledFeature> labeledFeatureList = new ArrayList<LabeledFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Long fee = psModelSample.getFee();
                if (fee == null) {
                    fee = 0L;
                }
                Double ret = (double)fee.longValue() + 0.0;
                Double label = DataUtil.formatDouble((Double)ret, (int)5);
                LabeledFeature labeledFeature = new LabeledFeature(label.doubleValue(), psModelSample.getFeature(), 0);
                labeledFeatureList.add(labeledFeature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledWeightedDpaFeature> parseDPA(PsModelSample psModelSample) {
        ArrayList<LabeledWeightedDpaFeature> labeledFeatureList = new ArrayList<LabeledWeightedDpaFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Long fee = psModelSample.getFee();
                Long joinCnt = psModelSample.getJoinCnt();
                Long dCharged = psModelSample.getdCharged();
                Long dIsExp = psModelSample.getdIsExp();
                Long dPlgJoin = psModelSample.getdPlgJoin();
                Long dSdk = psModelSample.getdSdk();
                if (joinCnt == null) {
                    joinCnt = 0L;
                }
                Double ret1 = (double)joinCnt.longValue() + 0.0;
                if (fee == null) {
                    fee = 0L;
                }
                Double ret2 = (double)fee.longValue() + 0.0;
                if (dCharged == null) {
                    dCharged = 0L;
                }
                Double ret3 = (double)dCharged.longValue() + 0.0;
                if (dIsExp == null) {
                    dIsExp = 0L;
                }
                Double ret4 = (double)dIsExp.longValue() + 0.0;
                if (dPlgJoin == null) {
                    dPlgJoin = 0L;
                }
                Double ret5 = (double)dPlgJoin.longValue() + 0.0;
                ret1 = ret1 + (double)dPlgJoin.longValue();
                if (dSdk == null) {
                    dSdk = 2L;
                }
                if (dSdk != 2L) {
                    return labeledFeatureList;
                }
                Double ret6 = (double)dSdk.longValue() + 0.0;
                Double label1 = DataUtil.formatDouble((Double)ret1, (int)5);
                Double label2 = DataUtil.formatDouble((Double)ret2, (int)5);
                Double label3 = DataUtil.formatDouble((Double)ret3, (int)5);
                Double label4 = DataUtil.formatDouble((Double)ret4, (int)5);
                Double label5 = DataUtil.formatDouble((Double)ret5, (int)5);
                Double label6 = DataUtil.formatDouble((Double)ret6, (int)5);
                LabeledWeightedDpaFeature labeledFeature = new LabeledWeightedDpaFeature(label1.doubleValue(), label2.doubleValue(), label3.doubleValue(), label4.doubleValue(), label5.doubleValue(), label6.doubleValue(), psModelSample.getF());
                labeledFeatureList.add(labeledFeature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledWeightedDpaFeature> parseDPAIntercept(PsModelSample psModelSample) {
        ArrayList<LabeledWeightedDpaFeature> labeledFeatureList = new ArrayList<LabeledWeightedDpaFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Long fee = psModelSample.getFee();
                Long joinCnt = psModelSample.getJoinCnt();
                Long dCharged = psModelSample.getdCharged();
                Long dIsExp = psModelSample.getdIsExp();
                Long dPlgJoin = psModelSample.getdPlgJoin();
                Long dSdk = psModelSample.getdSdk();
                Long dsm2A = psModelSample.getDsm2A();
                Long activityPage = psModelSample.getActPage();
                Long joinTimes = psModelSample.getJoinTimes();
                if (joinCnt == null) {
                    joinCnt = 0L;
                }
                Double ret1 = (double)joinCnt.longValue() + 0.0;
                if (fee == null) {
                    fee = 0L;
                }
                Double ret2 = (double)fee.longValue() + 0.0;
                if (dCharged == null) {
                    dCharged = 0L;
                }
                Double ret3 = (double)dCharged.longValue() + 0.0;
                if (dIsExp == null) {
                    dIsExp = 0L;
                }
                Double ret4 = (double)dIsExp.longValue() + 0.0;
                if (dPlgJoin == null) {
                    dPlgJoin = 0L;
                }
                Double ret5 = (double)dPlgJoin.longValue() + 0.0;
                ret1 = ret1 + (double)dPlgJoin.longValue();
                if (dSdk == null) {
                    dSdk = 2L;
                }
                Double ret6 = (double)dSdk.longValue() + 0.0;
                if (dsm2A == null) {
                    dsm2A = 1L;
                }
                if (dsm2A != 4L) {
                    return labeledFeatureList;
                }
                if (activityPage == null) {
                    activityPage = 0L;
                }
                if (joinTimes == null) {
                    joinTimes = 0L;
                }
                String f = psModelSample.getF();
                Map fMap = (Map)JSON.parseObject((String)f, Map.class);
                fMap.put("f311001", activityPage.toString());
                fMap.put("f311002", joinTimes.toString());
                f = JSON.toJSONString((Object)fMap);
                Double label1 = DataUtil.formatDouble((Double)ret1, (int)5);
                Double label2 = DataUtil.formatDouble((Double)ret2, (int)5);
                Double label3 = DataUtil.formatDouble((Double)ret3, (int)5);
                Double label4 = DataUtil.formatDouble((Double)ret4, (int)5);
                Double label5 = DataUtil.formatDouble((Double)ret5, (int)5);
                Double label6 = DataUtil.formatDouble((Double)ret6, (int)5);
                LabeledWeightedDpaFeature labeledFeature = new LabeledWeightedDpaFeature(label1.doubleValue(), label2.doubleValue(), label3.doubleValue(), label4.doubleValue(), label5.doubleValue(), label6.doubleValue(), f);
                labeledFeatureList.add(labeledFeature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledWeightedDpaFeature> parseDPAACT(PsModelSample psModelSample) {
        ArrayList<LabeledWeightedDpaFeature> labeledFeatureList = new ArrayList<LabeledWeightedDpaFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Long fee = psModelSample.getFee();
                Long joinCnt = psModelSample.getJoinCnt();
                Long dCharged = psModelSample.getdCharged();
                Long dIsExp = psModelSample.getdIsExp();
                Long dPlgJoin = psModelSample.getdPlgJoin();
                Long dSdk = psModelSample.getdSdk();
                Long dsm2A = psModelSample.getDsm2A();
                if (joinCnt == null) {
                    joinCnt = 0L;
                }
                Double ret1 = (double)joinCnt.longValue() + 0.0;
                if (fee == null) {
                    fee = 0L;
                }
                Double ret2 = (double)fee.longValue() + 0.0;
                if (dCharged == null) {
                    dCharged = 0L;
                }
                Double ret3 = (double)dCharged.longValue() + 0.0;
                if (dIsExp == null) {
                    dIsExp = 0L;
                }
                Double ret4 = (double)dIsExp.longValue() + 0.0;
                if (dPlgJoin == null) {
                    dPlgJoin = 0L;
                }
                Double ret5 = (double)dPlgJoin.longValue() + 0.0;
                ret1 = ret1 + (double)dPlgJoin.longValue();
                if (dSdk == null) {
                    dSdk = 2L;
                }
                if (dSdk != 2L) {
                    return labeledFeatureList;
                }
                Double ret6 = (double)dSdk.longValue() + 0.0;
                if (dsm2A == null) {
                    dsm2A = 1L;
                }
                if (dsm2A != 4L) {
                    return labeledFeatureList;
                }
                Double label1 = DataUtil.formatDouble((Double)ret1, (int)5);
                Double label2 = DataUtil.formatDouble((Double)ret2, (int)5);
                Double label3 = DataUtil.formatDouble((Double)ret3, (int)5);
                Double label4 = DataUtil.formatDouble((Double)ret4, (int)5);
                Double label5 = DataUtil.formatDouble((Double)ret5, (int)5);
                Double label6 = DataUtil.formatDouble((Double)ret6, (int)5);
                LabeledWeightedDpaFeature labeledFeature = new LabeledWeightedDpaFeature(label1.doubleValue(), label2.doubleValue(), label3.doubleValue(), label4.doubleValue(), label5.doubleValue(), label6.doubleValue(), psModelSample.getF());
                labeledFeatureList.add(labeledFeature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static List<LabeledWeightedDpaFeature> parseDPANonSdkACT(PsModelSample psModelSample) {
        ArrayList<LabeledWeightedDpaFeature> labeledFeatureList = new ArrayList<LabeledWeightedDpaFeature>();
        try {
            if (psModelSample == null) {
                return labeledFeatureList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Long fee = psModelSample.getFee();
                Long joinCnt = psModelSample.getJoinCnt();
                Long dCharged = psModelSample.getdCharged();
                Long dIsExp = psModelSample.getdIsExp();
                Long dPlgJoin = psModelSample.getdPlgJoin();
                Long dSdk = psModelSample.getdSdk();
                Long dsm2A = psModelSample.getDsm2A();
                if (joinCnt == null) {
                    joinCnt = 0L;
                }
                Double ret1 = (double)joinCnt.longValue() + 0.0;
                if (fee == null) {
                    fee = 0L;
                }
                Double ret2 = (double)fee.longValue() + 0.0;
                if (dCharged == null) {
                    dCharged = 0L;
                }
                Double ret3 = (double)dCharged.longValue() + 0.0;
                if (dIsExp == null) {
                    dIsExp = 0L;
                }
                Double ret4 = (double)dIsExp.longValue() + 0.0;
                if (dPlgJoin == null) {
                    dPlgJoin = 0L;
                }
                Double ret5 = (double)dPlgJoin.longValue() + 0.0;
                ret1 = ret1 + (double)dPlgJoin.longValue();
                if (dSdk == null) {
                    dSdk = 2L;
                }
                if (dSdk == 2L) {
                    return labeledFeatureList;
                }
                if (dsm2A == null) {
                    dsm2A = 1L;
                }
                if (dsm2A != 4L) {
                    return labeledFeatureList;
                }
                System.out.println("dSdk++++" + dSdk);
                Double ret6 = (double)dSdk.longValue() + 0.0;
                Double label1 = DataUtil.formatDouble((Double)ret1, (int)5);
                Double label2 = DataUtil.formatDouble((Double)ret2, (int)5);
                Double label3 = DataUtil.formatDouble((Double)ret3, (int)5);
                Double label4 = DataUtil.formatDouble((Double)ret4, (int)5);
                Double label5 = DataUtil.formatDouble((Double)ret5, (int)5);
                Double label6 = DataUtil.formatDouble((Double)ret6, (int)5);
                LabeledWeightedDpaFeature labeledFeature = new LabeledWeightedDpaFeature(label1.doubleValue(), label2.doubleValue(), label3.doubleValue(), label4.doubleValue(), label5.doubleValue(), label6.doubleValue(), psModelSample.getF());
                labeledFeatureList.add(labeledFeature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeatureList;
    }

    public static LabeledPoint parseMaterial(PsModelSample psModelSample, String modelId) {
        LabeledPoint labeledFeature = null;
        try {
            if (psModelSample == null) {
                return labeledFeature;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Double fee = psModelSample.getChargeFee();
                if (fee == null) {
                    fee = 0.0;
                }
                Double fee1 = Math.min(Math.log10(fee + 1.0), 200.0) + 1.0;
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                cn.com.duiba.nezha.alg.feature.vo.Feature feature = codeResult.getFeature();
                if (feature != null) {
                    double label = SampleParse.toLabel(psModelSample.getIsClick());
                    labeledFeature = SampleParse.toLabeledPoint(feature, label * fee1);
                }
                return labeledFeature;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeature;
    }

    public static SlotLabeledPoint parseMaterialSlot(PsModelSample psModelSample, String modelId) {
        SlotLabeledPoint labeledFeature = null;
        String slotKey = "f108001";
        try {
            if (psModelSample == null) {
                return labeledFeature;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Double fee = psModelSample.getChargeFee();
                if (fee == null) {
                    fee = 0.0;
                }
                Double fee1 = Math.min(Math.log10(fee + 1.0), 200.0) + 1.0;
                String slotId = psModelSample.getFeatureMap().get(slotKey);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                cn.com.duiba.nezha.alg.feature.vo.Feature feature = codeResult.getFeature();
                if (feature != null) {
                    double label = SampleParse.toLabel(psModelSample.getIsClick());
                    labeledFeature = SampleParse.toSlotLabeledPoint(feature, label * fee1, slotId);
                }
                return labeledFeature;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeature;
    }

    public static SlotLabeledPoint parseMaterialSlotAdWeighted(PsModelSample psModelSample, String modelId) {
        SlotLabeledPoint labeledFeature = null;
        String slotKey = "f108001";
        try {
            if (psModelSample == null) {
                return labeledFeature;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Double fee = psModelSample.getChargeFee();
                if (fee == null) {
                    fee = 0.0;
                }
                Double fee1 = Math.min(Math.log10(5.0 * fee + 1.0), 200.0) + 1.0;
                String slotId = psModelSample.getFeatureMap().get(slotKey);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                cn.com.duiba.nezha.alg.feature.vo.Feature feature = codeResult.getFeature();
                if (feature != null) {
                    double label = SampleParse.toLabel(psModelSample.getIsClick());
                    labeledFeature = SampleParse.toSlotLabeledPoint(feature, label * fee1, slotId);
                }
                return labeledFeature;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeature;
    }

    public static LabeledPoint parseMaterial1(PsModelSample psModelSample, String modelId) {
        LabeledPoint labeledFeature = null;
        try {
            if (psModelSample == null) {
                return labeledFeature;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Double fee = psModelSample.getChargeFee();
                if (fee == null) {
                    fee = 0.0;
                }
                Double fee1 = Math.min(Math.log10(fee + 1.0), 200.0) + 1.0;
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                cn.com.duiba.nezha.alg.feature.vo.Feature feature = codeResult.getFeature();
                if (feature != null) {
                    double label = SampleParse.toLabel(psModelSample.getIsClick());
                    labeledFeature = SampleParse.toLabeledPoint(feature, label);
                }
                return labeledFeature;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeature;
    }

    public static LabeledSparsePoint parseSparse(PsModelSample psModelSample, String modelId, boolean isCtr) {
        LabeledSparsePoint labeledPoint = null;
        try {
            if (psModelSample == null) {
                return labeledPoint;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    labeledPoint = SampleParse.toLabeledSparsePoint(codeResult.getFeature(), psModelSample.getIsClick());
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = 0;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        labeledPoint = SampleParse.toLabeledSparsePoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    public static LabeledESMMSparsePoint parseSparseESMM(PsModelSample psModelSample, String ctrModelId, String cvrModelId) {
        LabeledESMMSparsePoint labeledPoint = null;
        List<LabeledESMMSparsePoint> retTmp = SampleParse.parseSparseESMM(psModelSample, ctrModelId, cvrModelId, false);
        if (retTmp != null) {
            labeledPoint = retTmp.get(0);
        }
        return labeledPoint;
    }

    public static List<LabeledESMMSparsePoint> parseSparseESMM(PsModelSample psModelSample, String ctrModelId, String cvrModelId, Boolean isBcvr) {
        ArrayList<LabeledESMMSparsePoint> labeledPointList = new ArrayList<LabeledESMMSparsePoint>();
        try {
            if (psModelSample == null) {
                return labeledPointList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                CodeResult ctrCodeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(ctrModelId), psModelSample.getFeatureMap());
                LabeledSparsePoint ctrLabeledPoint = SampleParse.toLabeledSparsePoint(ctrCodeResult.getFeature(), psModelSample.getIsClick());
                Set<Long> backTypeSet = psModelSample.getBackSubTypeSet();
                if (AssertUtil.isNotEmpty(backTypeSet)) {
                    if (SampleParse.valid(psModelSample.getIsClick())) {
                        int maxType = isBcvr != false ? 8 : 0;
                        for (int i = 0; i <= maxType; ++i) {
                            if (!backTypeSet.contains(i)) continue;
                            psModelSample.getFeatureMap().put("f115001", i + "");
                            CodeResult cvrCodeResult0 = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(cvrModelId), psModelSample.getFeatureMap());
                            LabeledSparsePoint cvrLabeledPoint0 = SampleParse.toLabeledSparsePoint(cvrCodeResult0.getFeature(), psModelSample.getActClickList().get(i));
                            LabeledESMMSparsePoint labeledPoint0 = new LabeledESMMSparsePoint(true, isBcvr.booleanValue(), ctrLabeledPoint, cvrLabeledPoint0);
                            labeledPointList.add(labeledPoint0);
                        }
                    }
                } else {
                    psModelSample.getFeatureMap().put("f115001", "0");
                    CodeResult cvrCodeResult0 = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(cvrModelId), psModelSample.getFeatureMap());
                    LabeledSparsePoint cvrLabeledPoint0 = SampleParse.toLabeledSparsePoint(cvrCodeResult0.getFeature(), psModelSample.getActClickList().get(0));
                    LabeledESMMSparsePoint labeledPoint0 = new LabeledESMMSparsePoint(false, isBcvr.booleanValue(), ctrLabeledPoint, cvrLabeledPoint0);
                    labeledPointList.add(labeledPoint0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static LabeledPoint parse(PsModelSample psModelSample, String modelId, boolean isCtr) {
        LabeledPoint labeledPoint = null;
        try {
            if (psModelSample == null) {
                return labeledPoint;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getIsClick());
                }
                if (!isCtr && SampleParse.valid(psModelSample.getIsClick()) && AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet())) {
                    int maxType = 0;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    public static LabeledPoint parseAdxPd(PsModelSample psModelSample, String modelId, boolean isCtr) {
        LabeledPoint labeledPoint = null;
        try {
            List<LabeledPoint> retList = SampleParse.parse(psModelSample, modelId, isCtr, true);
            if (psModelSample == null) {
                return labeledPoint;
            }
            if (SampleParse.parseMap(psModelSample) && psModelSample.getPmpType() != null && psModelSample.getPmpType().equals(1L)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getIsClick());
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = 0;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LabeledPoint parseAdxIdea(PsModelSample psModelSample, String modelId, boolean isCtr) {
        LabeledPoint labeledPoint = null;
        try {
            if (psModelSample == null) {
                return labeledPoint;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getIsClick());
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = 0;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                    }
                }
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                Long actCost = psModelSample.getActFee();
                Long plFee = psModelSample.getPlFee();
                if (actCost == null) {
                    actCost = 0L;
                }
                if (plFee == null) {
                    plFee = 0L;
                }
                Double ret = (double)(actCost + plFee) + 0.0;
                Double label = DataUtil.formatDouble((Double)ret, (int)5);
                labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), label);
            }
            if (!SampleParse.parseMap(psModelSample)) return labeledPoint;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    public static LabeledPoint parseFilterMissing(PsModelSample psModelSample, String modelId, boolean isCtr, String[] checkFieldIds) {
        LabeledPoint labeledPoint = null;
        try {
            List<LabeledPoint> retList = SampleParse.parse(psModelSample, modelId, isCtr, true);
            if (psModelSample == null) {
                return labeledPoint;
            }
            if (SampleParse.parseMapFilterMissing2(psModelSample, checkFieldIds)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getIsClick());
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = 0;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    public static LabeledPoint parseWithDelayFilter(PsModelSample psModelSample, String modelId, boolean isCtr, Long delayMinutes) {
        LabeledPoint labeledPoint = null;
        try {
            List<LabeledPoint> retList = SampleParse.parse(psModelSample, modelId, isCtr, true);
            if (psModelSample == null) {
                return labeledPoint;
            }
            if (SampleParse.parseMap(psModelSample) && SampleParse.validDelay(psModelSample.getFeatureMap().get("time"), delayMinutes)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getIsClick());
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = 0;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    public static List<LabeledPoint> parse(PsModelSample psModelSample, String modelId, boolean isCtr, boolean isCvrType0) {
        ArrayList<LabeledPoint> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSample == null) {
                return labeledPointList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    LabeledPoint labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getIsClick());
                    labeledPointList.add(labeledPoint);
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = isCvrType0 ? 0 : 8;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        LabeledPoint labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                        labeledPointList.add(labeledPoint);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parseDcvr(PsModelSample psModelSample, String modelId) {
        ArrayList<LabeledPoint> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSample == null) {
                return labeledPointList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getIsActClick11());
                labeledPointList.add(labeledPoint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parseSdkFilter(PsModelSample psModelSample, String modelId, boolean isCtr, boolean isCvrType0) {
        ArrayList<LabeledPoint> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSample == null) {
                return labeledPointList;
            }
            if (SampleParse.parseMapFilterSdk(psModelSample)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    LabeledPoint labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getIsClick());
                    labeledPointList.add(labeledPoint);
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = isCvrType0 ? 0 : 8;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        LabeledPoint labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                        labeledPointList.add(labeledPoint);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parseFilterTrade(PsModelSample psModelSample, String modelId, boolean isCtr, boolean isCvrType0, Set<Integer> tradeCodes) {
        ArrayList<LabeledPoint> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSample == null) {
                return labeledPointList;
            }
            if (SampleParse.parseMapFilterTrade(psModelSample, tradeCodes)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    LabeledPoint labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getIsClick());
                    labeledPointList.add(labeledPoint);
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = isCvrType0 ? 0 : 8;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        LabeledPoint labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                        labeledPointList.add(labeledPoint);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static List<LabeledPoint> parseFilterMissing(PsModelSample psModelSample, String modelId, boolean isCtr, boolean isCvrType0, String[] checkFieldIds) {
        ArrayList<LabeledPoint> labeledPointList = new ArrayList<LabeledPoint>();
        try {
            if (psModelSample == null) {
                return labeledPointList;
            }
            if (SampleParse.parseMapFilterMissing2(psModelSample, checkFieldIds)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    LabeledPoint labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getIsClick());
                    labeledPointList.add(labeledPoint);
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = isCvrType0 ? 0 : 8;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        LabeledPoint labeledPoint = SampleParse.toLabeledPoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                        labeledPointList.add(labeledPoint);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPointList;
    }

    public static LabeledDpFeature dpParseOfEachField(PsModelSample psModelSample, List<FeatureBaseType> featureList) {
        LabeledDpFeature ret = null;
        try {
            if (psModelSample == null) {
                return ret;
            }
            if (SampleParse.parseMap(psModelSample)) {
                CodeResult codeResult = FeatureCoder.codeOfEachField(featureList, psModelSample.getFeatureMap());
                ret = SampleParse.toLabeledDpSparsePoint(codeResult.getFeature(), psModelSample.getJoinCnt(), psModelSample.getFee());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static LabeledSparsePoint parseOfEachField(PsModelSample psModelSample, List<FeatureBaseType> featureList) {
        LabeledSparsePoint ret = null;
        try {
            if (psModelSample == null) {
                return ret;
            }
            if (SampleParse.parseMap(psModelSample)) {
                CodeResult codeResult = FeatureCoder.codeOfEachField(featureList, psModelSample.getFeatureMap());
                ret = SampleParse.toLabeledSparsePoint(codeResult.getFeature(), psModelSample.getIsClick());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Map<String, FeatureCode> parseOfEachFieldV2(PsModelSample psModelSample, List<FeatureBaseType> featureList, Map<String, Map<String, FeatureCode>> tmpCoderCache) {
        Map ret = null;
        try {
            if (psModelSample == null) {
                return ret;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Map feature2Map;
                ret = feature2Map = FeatureNewCoder2.codeOfEachFieldWithSeq(featureList, psModelSample.getFeatureMap(), null, tmpCoderCache);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static LabeledSparseDpaFeature parseOfEachField2(PsModelSample psModelSample, List<FeatureBaseType> featureList) {
        LabeledSparseDpaFeature ret = null;
        try {
            if (psModelSample == null) {
                return ret;
            }
            if (SampleParse.parseMap(psModelSample)) {
                CodeResult codeResult = FeatureCoder.codeOfEachField(featureList, psModelSample.getFeatureMap());
                ret = SampleParse.toLabeledSparsePoint2(codeResult.getFeature(), psModelSample.getJoinCnt(), psModelSample.getFee());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static LabeledSparsePoint parseWithFiled(PsModelSample psModelSample, String modelId, boolean isCtr) {
        LabeledSparsePoint labeledSparsePoint = null;
        try {
            if (psModelSample == null) {
                return labeledSparsePoint;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    labeledSparsePoint = SampleParse.toLabeledSparsePoint(codeResult.getFeature(), psModelSample.getIsClick());
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = 0;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        labeledSparsePoint = SampleParse.toLabeledSparsePoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledSparsePoint;
    }

    public static List<LabeledSparsePoint> parseWithField(PsModelSample psModelSample, String modelId, boolean isCtr, boolean isCvrType0) {
        ArrayList<LabeledSparsePoint> labeledSparsePointList = new ArrayList<LabeledSparsePoint>();
        try {
            if (psModelSample == null) {
                return labeledSparsePointList;
            }
            if (SampleParse.parseMap(psModelSample)) {
                Set<Long> backTypeSet;
                if (isCtr) {
                    CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                    LabeledSparsePoint labeledSparsePoint = SampleParse.toLabeledSparsePoint(codeResult.getFeature(), psModelSample.getIsClick());
                    labeledSparsePointList.add(labeledSparsePoint);
                }
                if (AssertUtil.isNotEmpty(backTypeSet = psModelSample.getBackSubTypeSet()) && !isCtr && SampleParse.valid(psModelSample.getIsClick())) {
                    int maxType = isCvrType0 ? 0 : 8;
                    for (int i = 0; i <= maxType; ++i) {
                        if (!backTypeSet.contains(i)) continue;
                        psModelSample.getFeatureMap().put("f115001", i + "");
                        CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelId), psModelSample.getFeatureMap());
                        LabeledSparsePoint labeledSparsePoint = SampleParse.toLabeledSparsePoint(codeResult.getFeature(), psModelSample.getActClickList().get(i));
                        labeledSparsePointList.add(labeledSparsePoint);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledSparsePointList;
    }

    public static LabeledFeature toLabeledFeature(String feature, Long isClick) {
        LabeledFeature labeledFeature = null;
        try {
            if (feature != null) {
                double label = 0.0;
                if (SampleParse.valid(isClick)) {
                    label = 1.0;
                }
                labeledFeature = new LabeledFeature(label, feature, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeature;
    }

    public static LabeledESMMFeature toLabeledESMMFeature(String feature, Long ctrLabel, Long cvrLabel, int labelType, int hasCvr) {
        LabeledESMMFeature labeledFeature = null;
        try {
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{feature})) {
                double label = 0.0;
                if (ctrLabel == null) {
                    ctrLabel = 0L;
                }
                if (cvrLabel == null) {
                    cvrLabel = 0L;
                }
                labeledFeature = new LabeledESMMFeature((double)ctrLabel.longValue(), (double)cvrLabel.longValue(), feature, hasCvr, labelType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeature;
    }

    public static LabeledFeature toLabeledFeature(String feature, Long isClick, int labelType) {
        LabeledFeature labeledFeature = null;
        try {
            if (feature != null) {
                double label = 0.0;
                if (SampleParse.valid(isClick)) {
                    label = 1.0;
                }
                labeledFeature = new LabeledFeature(label, feature, labelType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledFeature;
    }

    public static double toLabel(Long isClick) {
        double label = 0.0;
        if (SampleParse.valid(isClick)) {
            label = 1.0;
        }
        return label;
    }

    public static LabeledPoint toLabeledPoint(cn.com.duiba.nezha.alg.feature.vo.Feature feature, Long isClick) {
        LabeledPoint labeledPoint = null;
        try {
            if (feature != null) {
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = SampleParse.toLabel(isClick);
                labeledPoint = new LabeledPoint(label, sv);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    public static LabeledPoint toLabeledPoint(cn.com.duiba.nezha.alg.feature.vo.Feature feature, double label) {
        LabeledPoint labeledPoint = null;
        try {
            if (feature != null) {
                SparseVector sv = SampleParse.toSparseVector(feature);
                labeledPoint = new LabeledPoint(label, sv);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    public static SlotLabeledPoint toSlotLabeledPoint(cn.com.duiba.nezha.alg.feature.vo.Feature feature, double label, String slotId) {
        SlotLabeledPoint labeledPoint = null;
        try {
            if (feature != null) {
                SparseVector sv = SampleParse.toSparseVector(feature);
                labeledPoint = new SlotLabeledPoint(label, sv, slotId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    public static LabeledDpFeature toLabeledDpSparsePoint(cn.com.duiba.nezha.alg.feature.vo.Feature feature, Long joinCnt, Long fee) {
        LabeledDpFeature labeledPoint = null;
        try {
            if (feature != null) {
                double label1 = SampleParse.toLabel(joinCnt);
                double label2 = SampleParse.toLabel(fee);
                labeledPoint = new LabeledDpFeature(label1, label2, SampleParse.toFeature(feature));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    public static LabeledSparsePoint toLabeledSparsePoint(cn.com.duiba.nezha.alg.feature.vo.Feature feature, Long isClick) {
        LabeledSparsePoint labeledPoint = null;
        try {
            if (feature != null) {
                double label = SampleParse.toLabel(isClick);
                labeledPoint = new LabeledSparsePoint(label, SampleParse.toFeature(feature));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    public static LabeledSparseDpaFeature toLabeledSparsePoint2(cn.com.duiba.nezha.alg.feature.vo.Feature feature, Long joinCnt, Long fee) {
        LabeledSparseDpaFeature labeledPoint = null;
        try {
            if (feature != null) {
                double label1 = joinCnt == null ? 0.0 : joinCnt.doubleValue();
                double label2 = fee == null ? 0.0 : fee.doubleValue();
                labeledPoint = new LabeledSparseDpaFeature(label1, label2, SampleParse.toFeature(feature));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labeledPoint;
    }

    public static boolean valid(Long val) {
        boolean ret = false;
        if (val != null && (double)val.longValue() > 0.1) {
            ret = true;
        }
        return ret;
    }

    public static boolean validDelay(String logTime, Long delayMinutes) {
        String currentTime;
        Long timeInterval;
        boolean ret = true;
        if (logTime != null && delayMinutes != null && (timeInterval = LocalDateUtil.getIntervalMinutes((String)(currentTime = LocalDateUtil.getCurrentLocalDateTime((String)DateStyle.YYYYMMDDHHMMSS.getValue())), (String)logTime, (DateStyle)DateStyle.YYYYMMDDHHMMSS, (DateStyle)DateStyle.YYYYMMDDHHMMSS)) != null && timeInterval > delayMinutes) {
            ret = false;
        }
        return ret;
    }

    public static boolean parseMap(PsModelSample psModelSample) {
        boolean ret = false;
        try {
            if (psModelSample != null) {
                String feature = psModelSample.getFeature();
                JSONObject featureMap = JSONObject.parseObject((String)feature);
                if (feature == null && psModelSample.getF() != null) {
                    feature = psModelSample.getF();
                    featureMap = JSONObject.parseObject((String)feature);
                }
                if (AssertUtil.isNotEmpty((Map)featureMap)) {
                    featureMap.put("f99021", featureMap.get("f9902"));
                    featureMap.put("f98011", featureMap.get("f9801"));
                    featureMap.put("f97011", featureMap.get("f9701"));
                    featureMap.put("f7010012", featureMap.get("f7010010"));
                    featureMap.put("f7020012", featureMap.get("f7020010"));
                    featureMap.put("f7030012", featureMap.get("f7030010"));
                    if (featureMap.get("f108002") == null) {
                        featureMap.put("f108002", featureMap.get("f108001"));
                    }
                    if (featureMap.get("f108003") == null) {
                        featureMap.put("f108003", featureMap.get("f108001"));
                    }
                }
                if (AssertUtil.isNotEmpty((Map)featureMap)) {
                    psModelSample.setFeatureMap((Map<String, String>)featureMap);
                    ret = true;
                }
                psModelSample.init();
                if (psModelSample.getPriceType() != null && psModelSample.getPriceType().equals(2L)) {
                    ret = false;
                }
                if (psModelSample.getF() != null) {
                    ret = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean parseMapFilterSdk(PsModelSample psModelSample) {
        try {
            if (psModelSample != null && psModelSample.getFeature() != null) {
                String feature = psModelSample.getFeature();
                JSONObject featureMap = JSONObject.parseObject((String)feature);
                psModelSample.setFeatureMap((Map<String, String>)featureMap);
                if (feature == null && psModelSample.getF() != null) {
                    feature = psModelSample.getF();
                    featureMap = JSONObject.parseObject((String)feature);
                    psModelSample.setFeatureMap((Map<String, String>)featureMap);
                }
                psModelSample.init();
                return psModelSample.getdSdk() == 2L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean parseActTitleMap(PsModelSample psModelSample) {
        boolean ret = false;
        try {
            if (psModelSample != null && psModelSample.getFeature() != null) {
                String feature = psModelSample.getFeature();
                JSONObject featureMap = JSONObject.parseObject((String)feature);
                psModelSample.setFeatureMap((Map<String, String>)featureMap);
                psModelSample.init();
                ret = true;
                if (psModelSample.getPriceType() != null && psModelSample.getPriceType().equals(2L)) {
                    ret = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean parseMapFilterTrade(PsModelSample psModelSample, Set<Integer> tradeCodes) {
        try {
            if (psModelSample != null && psModelSample.getFeature() != null) {
                String feature = psModelSample.getFeature();
                JSONObject featureMap = JSONObject.parseObject((String)feature);
                psModelSample.setFeatureMap((Map<String, String>)featureMap);
                if (feature == null) {
                    String feature2 = psModelSample.getF();
                    featureMap = JSONObject.parseObject((String)feature2);
                }
                if (featureMap == null) {
                    System.out.println("****** featureMap is null");
                    return false;
                }
                psModelSample.init();
                return featureMap.get("f660001") == null || featureMap.get("f660001").toString().equals("") || tradeCodes.contains(Integer.parseInt(featureMap.get("f660001").toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean parseMapFilterMissing2(PsModelSample psModelSample, String[] checkFieldIds) {
        boolean ret = false;
        try {
            if (psModelSample != null && psModelSample.getFeature() != null) {
                String feature = psModelSample.getFeature();
                JSONObject featureMap = JSONObject.parseObject((String)feature);
                psModelSample.setFeatureMap((Map<String, String>)featureMap);
                if (feature == null) {
                    String feature2 = psModelSample.getF();
                    featureMap = JSONObject.parseObject((String)feature2);
                }
                if (featureMap == null) {
                    System.out.println("****** featureMap is null");
                    return false;
                }
                boolean isFilter = true;
                for (String fid : checkFieldIds) {
                    if (featureMap.get(fid) == null) {
                        return false;
                    }
                    isFilter = isFilter && featureMap.get(fid).equals("9");
                }
                ret = isFilter;
                if (AssertUtil.isNotEmpty((Map)featureMap)) {
                    psModelSample.setFeatureMap((Map<String, String>)featureMap);
                    psModelSample.init();
                    ret = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static SparseVector toSparseVector(cn.com.duiba.nezha.alg.feature.vo.Feature feature) {
        SparseVector ret = null;
        try {
            if (feature != null) {
                int[] indices = new int[feature.indices.size()];
                for (int i = 0; i < feature.indices.size(); ++i) {
                    indices[i] = (Integer)feature.indices.get(i);
                }
                ret = Vectors.sparse((int)feature.size, (int[])indices, (double[])feature.values).toSparse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Feature toFeature(cn.com.duiba.nezha.alg.feature.vo.Feature feature) {
        Feature ret = null;
        try {
            if (feature != null) {
                int[] indices = new int[feature.indices.size()];
                String[] fields = new String[feature.indices.size()];
                for (int i = 0; i < feature.indices.size(); ++i) {
                    indices[i] = (Integer)feature.indices.get(i);
                    fields[i] = (String)feature.fields.get(i);
                }
                ret = new Feature(feature.size, indices, feature.values, fields);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

