/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.utils.hbase;

import cn.com.duiba.nezha.compute.biz.constant.ProjectConstant;
import cn.com.duiba.nezha.compute.biz.utils.conf.ConfigFactory;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class HbaseUtil {
    private static Connection connection = null;
    private Admin admin = null;
    private static String zk = null;
    private static Object tablelock = new Object();
    private static Map<String, Table> tableMap = new HashMap<String, Table>();
    private static HbaseUtil instance;

    public static void setZK(String newZK) {
        zk = newZK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HbaseUtil getInstance() throws IOException {
        if (instance != null) return instance;
        Class<HbaseUtil> clazz = HbaseUtil.class;
        synchronized (HbaseUtil.class) {
            if (instance != null) return instance;
            instance = new HbaseUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private HbaseUtil() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hbase.zookeeper.quorum", zk);
        conf.set("hbase.client.username", "root");
        conf.set("hbase.client.password", "root");
        connection = ConnectionFactory.createConnection((Configuration)conf);
        this.admin = connection.getAdmin();
    }

    public void close() throws IOException {
        connection.close();
    }

    public boolean createTableBySplitKeys(String tableName, List<String> columnFamily, String[] sKeys) throws Exception {
        try {
            if (StringUtils.isBlank((String)tableName) || columnFamily == null || columnFamily.size() < 0 || sKeys == null || sKeys.length < 0) {
                // empty if block
            }
            if (this.admin.tableExists(TableName.valueOf((String)tableName))) {
                return true;
            }
            HTableDescriptor tableDescriptor = new HTableDescriptor(TableName.valueOf((String)tableName));
            for (String cf : columnFamily) {
                tableDescriptor.addFamily(new HColumnDescriptor(cf));
            }
            byte[][] splitKeys = this.getSplitKeys(sKeys);
            this.admin.createTable(tableDescriptor, splitKeys);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private byte[][] getSplitKeys(String[] keys) {
        byte[][] splitKeys = new byte[keys.length][];
        TreeSet<byte[]> rows = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < keys.length; ++i) {
            rows.add(Bytes.toBytes((String)keys[i]));
        }
        Iterator rowKeyIter = rows.iterator();
        int i = 0;
        while (rowKeyIter.hasNext()) {
            byte[] tempRow = (byte[])rowKeyIter.next();
            rowKeyIter.remove();
            splitKeys[i] = tempRow;
            ++i;
        }
        return splitKeys;
    }

    public void createTable(String tablename, String[] cfs) {
        try {
            if (!this.admin.tableExists(TableName.valueOf((String)tablename))) {
                HTableDescriptor descriptor = new HTableDescriptor(TableName.valueOf((String)tablename));
                if (cfs != null) {
                    for (String cf : cfs) {
                        descriptor.addFamily(new HColumnDescriptor(cf.getBytes()));
                    }
                }
                this.admin.createTable(descriptor);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createTable(String tablename, List<String> cfs) {
        try {
            if (!this.admin.tableExists(TableName.valueOf((String)tablename))) {
                HTableDescriptor descriptor = new HTableDescriptor(TableName.valueOf((String)tablename));
                if (cfs != null) {
                    for (String cf : cfs) {
                        descriptor.addFamily(new HColumnDescriptor(cf.getBytes()));
                    }
                }
                this.admin.createTable(descriptor);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addColumnFamily(String tableName, String[] cfs) {
        try {
            HTableDescriptor descriptor = new HTableDescriptor(TableName.valueOf((String)tableName));
            if (cfs != null) {
                for (String cf : cfs) {
                    descriptor.addFamily(new HColumnDescriptor(cf.getBytes()));
                }
            }
            this.admin.disableTable(TableName.valueOf((String)tableName));
            this.admin.modifyTable(TableName.valueOf((String)tableName), descriptor);
            this.admin.enableTable(TableName.valueOf((String)tableName));
            this.admin.createTable(descriptor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deleteTable(String tablename) {
        try {
            if (this.admin.tableExists(TableName.valueOf((String)tablename))) {
                this.admin.disableTable(TableName.valueOf((String)tablename));
                this.admin.deleteTable(TableName.valueOf((String)tablename));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deleteFamily(String tableName, String[] cfs) {
        try {
            HTableDescriptor descriptor = new HTableDescriptor(TableName.valueOf((String)tableName));
            if (cfs != null) {
                for (String cf : cfs) {
                    descriptor.addFamily(new HColumnDescriptor(cf.getBytes()));
                    this.admin.deleteColumn(TableName.valueOf((String)tableName), cf.getBytes());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Table getHTable(String tableName) {
        Table tableRet = null;
        try {
            Table tableTmp = tableMap.get(tableName);
            if (tableTmp == null) {
                this.setHTable(tableName, false, null);
            }
            tableRet = tableMap.get(tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHTable(String tableName, boolean isCreate, String[] cfs) {
        Object object = tablelock;
        synchronized (object) {
            try {
                if (isCreate) {
                    this.createTable(tableName, cfs);
                }
                if (this.admin.tableExists(TableName.valueOf((String)tableName))) {
                    Table tableTmp = connection.getTable(TableName.valueOf((String)tableName));
                    tableMap.put(tableName, tableTmp);
                    System.out.println("setHTable by name = " + tableName);
                } else {
                    System.out.println("setHTable not exists by name = " + tableName);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void insert(String tableName, String rowKey, String family, String quailifer, String value) {
        try {
            Put put = new Put(rowKey.getBytes());
            put.addColumn(family.getBytes(), quailifer.getBytes(), value.getBytes());
            this.getHTable(tableName).put(put);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert(String tableName, String rowKey, String family, Map<String, String> rValues) {
        try {
            Put p = new Put(Bytes.toBytes((String)rowKey));
            for (String qkey : rValues.keySet()) {
                String value = rValues.get(qkey);
                if (value == null) continue;
                p.addColumn(family.getBytes(), qkey.getBytes(), value.getBytes());
            }
            this.getHTable(tableName).put(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert(String tableName, String rowKey, Map<String, Map<String, String>> rValues) {
        try {
            Put p = new Put(Bytes.toBytes((String)rowKey));
            for (Map.Entry<String, Map<String, String>> entry : rValues.entrySet()) {
                String family = entry.getKey();
                Map<String, String> fValues = entry.getValue();
                for (String qkey : fValues.keySet()) {
                    String value = fValues.get(qkey);
                    if (value == null) continue;
                    p.addColumn(family.getBytes(), qkey.getBytes(), value.getBytes());
                }
            }
            this.getHTable(tableName).put(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert(String tableName, Map<String, Map<String, Map<String, String>>> kvMap) {
        try {
            ArrayList<Put> puts = new ArrayList<Put>();
            for (String rowKey : kvMap.keySet()) {
                Map<String, Map<String, String>> rValues = kvMap.get(rowKey);
                Put p = new Put(Bytes.toBytes((String)rowKey));
                for (Map.Entry<String, Map<String, String>> entry : rValues.entrySet()) {
                    String family = entry.getKey();
                    Map<String, String> fValues = entry.getValue();
                    for (String qkey : fValues.keySet()) {
                        String value = fValues.get(qkey);
                        p.addColumn(family.getBytes(), qkey.getBytes(), value.getBytes());
                    }
                }
                puts.add(p);
            }
            this.getHTable(tableName).put(puts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertColumeValues(String tableName, String rowKey, String family, int[] quailifer, long[] value) {
        try {
            if (quailifer != null && value != null && family != null && quailifer.length == value.length) {
                Put p = new Put(Bytes.toBytes((String)rowKey));
                for (int i = 0; i < quailifer.length; ++i) {
                    p.addColumn(family.getBytes(), Bytes.toBytes((int)quailifer[i]), Bytes.toBytes((long)value[i]));
                }
                this.getHTable(tableName).put(p);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void insertColumeValues(String tableName, String rowKey, String family, String[] quailifer, long[] value) {
        try {
            if (quailifer != null && value != null && family != null && quailifer.length == value.length) {
                Put p = new Put(Bytes.toBytes((String)rowKey));
                for (int i = 0; i < quailifer.length; ++i) {
                    p.addColumn(family.getBytes(), quailifer[i].getBytes(), Bytes.toBytes((long)value[i]));
                }
                this.getHTable(tableName).put(p);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void insertColumeValues(String tableName, String rowKey, String family, String[] quailifer, String[] value) {
        try {
            if (quailifer != null && value != null && family != null && quailifer.length == value.length) {
                Put p = new Put(Bytes.toBytes((String)rowKey));
                for (int i = 0; i < quailifer.length; ++i) {
                    p.addColumn(family.getBytes(), quailifer[i].getBytes(), value[i].getBytes());
                }
                this.getHTable(tableName).put(p);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void incrementColumeValue(String tableName, String rowKey, String family, String quailifer, Long value) {
        try {
            if (rowKey != null) {
                this.getHTable(tableName).incrementColumnValue(rowKey.getBytes(), family.getBytes(), quailifer.getBytes(), value.longValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void incrementColumeValues(String tableName, String rowKey, Map<String, Map<String, Long>> fcvMap) {
        try {
            if (rowKey != null && fcvMap != null) {
                Increment increment = new Increment(rowKey.getBytes());
                for (String familyName : fcvMap.keySet()) {
                    Map<String, Long> colValMap = fcvMap.get(familyName);
                    for (String col : colValMap.keySet()) {
                        Long val = colValMap.get(col);
                        increment.addColumn(Bytes.toBytes((String)familyName), Bytes.toBytes((String)col), val.longValue());
                    }
                }
                if (!increment.isEmpty()) {
                    this.getHTable(tableName).increment(increment);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void incrementColumeValues(String tableName, String rowKey, String family, String[] quailifer, Long[] value) {
        try {
            if (quailifer != null && value != null && family != null && quailifer.length == value.length) {
                Increment increment = new Increment(rowKey.getBytes());
                for (int i = 0; i < quailifer.length; ++i) {
                    if (value[i] == null) continue;
                    increment.addColumn(family.getBytes(), quailifer[i].getBytes(), value[i].longValue());
                }
                this.getHTable(tableName).increment(increment);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void incrementColumeValues(String tableName, String rowKey, String family, int[] quailifer, long[] value) {
        try {
            if (quailifer != null && value != null && family != null && quailifer.length == value.length && quailifer.length > 0) {
                Increment increment = new Increment(rowKey.getBytes());
                for (int i = 0; i < quailifer.length; ++i) {
                    increment.addColumn(family.getBytes(), Bytes.toBytes((String)(quailifer[i] + "")), value[i]);
                }
                this.getHTable(tableName).increment(increment);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void incrementColumeValues(String tableName, String rowKey, String[] family, String[] quailifer, Long[] value) {
        try {
            if (quailifer != null && value != null && family != null && family.length == quailifer.length && quailifer.length == value.length && quailifer.length > 0) {
                Increment increment = new Increment(rowKey.getBytes());
                for (int i = 0; i < quailifer.length; ++i) {
                    increment.addColumn(family[i].getBytes(), quailifer[i].getBytes(), value[i].longValue());
                }
                this.getHTable(tableName).increment(increment);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void getOneRow(String tableName, String rowKey, QueryCallback callback) throws Exception {
        ArrayList<Result> list = new ArrayList<Result>();
        Result rsResult = null;
        try {
            Get get = new Get(rowKey.getBytes());
            rsResult = this.getHTable(tableName).get(get);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        list.add(rsResult);
        callback.process(list);
    }

    public void getOneRow(String tableName, String rowKey, String familyName, Set<String> cSet, QueryCallback callback) throws Exception {
        ArrayList<Result> list = new ArrayList<Result>();
        Result rsResult = null;
        try {
            Get get = new Get(rowKey.getBytes());
            if (familyName != null && AssertUtil.isNotEmpty(cSet)) {
                for (String columnName : cSet) {
                    get.addColumn(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName));
                }
            }
            rsResult = this.getHTable(tableName).get(get);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        list.add(rsResult);
        callback.process(list);
    }

    public void getRows(String tableName, List<String> rowKeyList, String familyName, Set<String> cSet, QueryCallback callback) throws Exception {
        ArrayList<Result> list = new ArrayList<Result>();
        try {
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{rowKeyList, cSet})) {
                ArrayList batch = new ArrayList();
                ArrayList<Get> getList = new ArrayList<Get>();
                for (String rowKey : rowKeyList) {
                    Get get = new Get(rowKey.getBytes());
                    for (String columnName : cSet) {
                        get.addColumn(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName));
                    }
                    getList.add(get);
                    if (getList.size() <= 1000) continue;
                    batch.addAll(getList);
                    Object[] results = new Object[batch.size()];
                    this.getHTable(tableName).batch(batch, results);
                    list.addAll(HbaseUtil.toResult(results));
                    getList.clear();
                    batch.clear();
                }
                if (getList.size() > 0) {
                    batch.addAll(getList);
                    Object[] results = new Object[batch.size()];
                    this.getHTable(tableName).batch(batch, results);
                    list.addAll(HbaseUtil.toResult(results));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        callback.process(list);
    }

    public void getRows(String tableName, List<String> rowKeyList, String familyName, QueryCallback callback) throws Exception {
        ArrayList<Result> list = new ArrayList<Result>();
        try {
            if (rowKeyList != null && rowKeyList.size() > 0) {
                ArrayList batch = new ArrayList();
                ArrayList<Get> getList = new ArrayList<Get>();
                for (String rowKey : rowKeyList) {
                    Get get = new Get(rowKey.getBytes());
                    get.addFamily(Bytes.toBytes((String)familyName));
                    getList.add(get);
                    if (getList.size() <= 1000) continue;
                    batch.addAll(getList);
                    Object[] results = new Object[batch.size()];
                    this.getHTable(tableName).batch(batch, results);
                    list.addAll(HbaseUtil.toResult(results));
                    getList.clear();
                    batch.clear();
                }
                if (getList.size() > 0) {
                    batch.addAll(getList);
                    Object[] results = new Object[batch.size()];
                    this.getHTable(tableName).batch(batch, results);
                    list.addAll(HbaseUtil.toResult(results));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        callback.process(list);
    }

    public static List<Result> toResult(Object[] results) {
        ArrayList<Result> list = new ArrayList<Result>();
        if (results != null) {
            for (Object object : results) {
                Result r = (Result)object;
                list.add(r);
            }
        }
        return list;
    }

    public void getOneRow(String tableName, String rowKey, String familyName, QueryCallback callback) throws Exception {
        ArrayList<Result> list = new ArrayList<Result>();
        Result rsResult = null;
        try {
            Get get = new Get(rowKey.getBytes());
            get.addFamily(Bytes.toBytes((String)familyName));
            rsResult = this.getHTable(tableName).get(get);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        list.add(rsResult);
        callback.process(list);
    }

    public void getOneRow(String tableName, String rowKey, String familyName, String columnName, QueryCallback callback) throws Exception {
        ArrayList<Result> list = new ArrayList<Result>();
        Result rsResult = null;
        try {
            Get get = new Get(rowKey.getBytes());
            get.addColumn(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName));
            rsResult = this.getHTable(tableName).get(get);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        list.add(rsResult);
        callback.process(list);
    }

    public void getOneRow(String tableName, String rowKey, Map<String, Set<String>> fcMap, QueryCallback callback) throws Exception {
        ArrayList<Result> list = new ArrayList<Result>();
        Result rsResult = null;
        try {
            Get get = new Get(rowKey.getBytes());
            if (fcMap != null) {
                for (String familyName : fcMap.keySet()) {
                    Set<String> columnNameSet = fcMap.get(familyName);
                    for (String columnName : columnNameSet) {
                        get.addColumn(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName));
                    }
                }
            }
            rsResult = this.getHTable(tableName).get(get);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        list.add(rsResult);
        callback.process(list);
    }

    public void getRows(String tableName, String rowKeyLike, QueryCallback callback) throws Exception {
        ArrayList<Result> list = new ArrayList<Result>();
        try {
            Scan scan = new Scan();
            if (rowKeyLike != null) {
                PrefixFilter filter = new PrefixFilter(rowKeyLike.getBytes());
                scan.setFilter((Filter)filter);
            }
            ResultScanner scanner = this.getHTable(tableName).getScanner(scan);
            for (Result rs : scanner) {
                list.add(rs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        callback.process(list);
    }

    public void getRows(String tableName, String rowKeyLike, String[] famls, String[] cols, QueryCallback callback) throws Exception {
        ArrayList<Result> list = new ArrayList<Result>();
        try {
            PrefixFilter filter = new PrefixFilter(rowKeyLike.getBytes());
            Scan scan = new Scan();
            for (String faml : famls) {
                for (int i = 0; i < cols.length; ++i) {
                    scan.addColumn(faml.getBytes(), cols[i].getBytes());
                }
            }
            scan.setFilter((Filter)filter);
            ResultScanner scanner = this.getHTable(tableName).getScanner(scan);
            for (Result rs : scanner) {
                list.add(rs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        callback.process(list);
    }

    public void deleteRows(String tableName, String[] rows) {
        if (rows != null && rows.length > 0) {
            ArrayList<Delete> list = new ArrayList<Delete>();
            for (String row : rows) {
                Delete delete = new Delete(row.getBytes());
                list.add(delete);
            }
            try {
                this.getHTable(tableName).delete(list);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteRow(String tableName, String row) {
        if (row != null) {
            Delete delete = new Delete(row.getBytes());
            try {
                this.getHTable(tableName).delete(delete);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Result getResultByColumn(String tableName, String rowKey, String familyName, String columnName) throws IOException {
        Result result = null;
        try {
            Get get = new Get(Bytes.toBytes((String)rowKey));
            get.addColumn(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName));
            result = this.getHTable(tableName).get(get);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    static {
        try {
            zk = ConfigFactory.getInstance().getConfigProperties("/application.properties").getProperty(ProjectConstant.ZK_LIST);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        instance = null;
    }

    public static interface QueryCallback {
        public void process(List<Result> var1) throws Exception;
    }
}

