/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.app;

import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.compute.biz.bo.SampleBo;
import cn.com.duiba.nezha.compute.biz.bo.SyncBo;
import cn.com.duiba.nezha.compute.biz.bo.TrainOpt;
import cn.com.duiba.nezha.compute.biz.constant.feature.FeatureBcvrListConstant;
import cn.com.duiba.nezha.compute.biz.constant.feature.FeatureListConstant;
import cn.com.duiba.nezha.compute.biz.constant.model.HParamsConstant;
import cn.com.duiba.nezha.compute.biz.constant.model.ModelConstant;
import cn.com.duiba.nezha.compute.biz.dto.PsModelSample;
import cn.com.duiba.nezha.compute.biz.ps.PsAgent;
import cn.com.duiba.nezha.compute.core.LabeledPoint;
import cn.com.duiba.nezha.compute.core.LabeledPointPairWise;
import cn.com.duiba.nezha.compute.core.LabeledSparsePoint;
import cn.com.duiba.nezha.compute.core.SlotLabeledPoint;
import cn.com.duiba.nezha.compute.core.enums.DateStyle;
import cn.com.duiba.nezha.compute.core.model.local.LocalModel;
import cn.com.duiba.nezha.compute.core.util.DateUtil;
import cn.com.duiba.nezha.compute.mllib.evaluate.Evaluater;
import cn.com.duiba.nezha.compute.mllib.ffm.ftrl.FFM;
import cn.com.duiba.nezha.compute.mllib.ffm.ftrl.FFMFTRL;
import cn.com.duiba.nezha.compute.mllib.ffm.ftrl.FFMFTRLHyperParams;
import cn.com.duiba.nezha.compute.mllib.ffm.ftrl.SparseFFMWithFTRL;
import cn.com.duiba.nezha.compute.mllib.ffm.ftrl.SparseFFMWithFTRLBatch2;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.FM;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.FMFTRL;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.FMFTRLHyperParams;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.SparseFMRegWithFTRLBatch;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.SparseFMWithFTRLBatch;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.SparseFMWithFTRLWeighted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import scala.collection.Iterator;

public class SparseFMWithFTRLApp {
    public static final String[] checkFieldIds = new String[]{"f660001"};

    public static void runOnMsg(String psModelId, boolean isCtr, Iterator<String> partitionOfRecords, double sampleRatio, boolean isReplay, int partNums, double negativeSampleRatio) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start,sampleRatio=" + sampleRatio + ",parNums=" + partNums);
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            if (!(Math.random() < sampleRatio) || orderId == null) continue;
            orderIdList.add(orderId);
        }
        LabeledPoint[] dataArray = SampleBo.getSampleByOrderIdListWithFilter(psModelId, isCtr, orderIdList, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, 1);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void run(String psModelId, boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getSampleWithFilter(psModelId, isCtr, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runAdxPd(String psModelId, boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getPdSampleWithFilter(psModelId, isCtr, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runMaterial(String psModelId, boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize, HashMap<String, Double> PosNegMap) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getMaterialWithFilter(psModelId, isCtr, samples, negativeSampleRatio, PosNegMap);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train_weighted(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runMaterialSlot(String psModelId, boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize, HashMap<String, Double> PosNegMap) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        SlotLabeledPoint[] dataArray = SampleBo.getMaterialWithFilterSlot(psModelId, isCtr, samples, negativeSampleRatio, PosNegMap);
        if (isReplay) {
            SparseFMWithFTRLApp.replaySlot(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train_weighted_slot(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runMergedMaterialSlot(String psModelId, boolean isCtr, List<PsModelSample> nonAdSamples, List<PsModelSample> adSamples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize, HashMap<String, Double> nonAdPosNegMap, HashMap<String, Double> adPosNegMap) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        SlotLabeledPoint[] dataArray = SampleBo.getMaterialWithFilterSlot(psModelId, isCtr, nonAdSamples, adSamples, negativeSampleRatio, nonAdPosNegMap, adPosNegMap);
        if (isReplay) {
            SparseFMWithFTRLApp.replaySlot(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train_weighted_slot(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runDpSlot(String psModelId, boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        SlotLabeledPoint[] dataArray = SampleBo.getDpWithFilterSlot(psModelId, isCtr, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replaySlot(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train_weighted_slot(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runMaterial1(String psModelId, boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getMaterialWithFilter1(psModelId, isCtr, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runFilterMissingSample(String psModelId, boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getSampleWithMissingFilter(psModelId, isCtr, samples, negativeSampleRatio, checkFieldIds);
        System.out.println("dataArray_Size= " + dataArray.length);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runAdxReg(String psModelId, boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = new LabeledPoint[]{};
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runReg(String psModelId, boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getSampleWithFilter(psModelId, isCtr, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void run(String psModelId, boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize, Long delayMinutes) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getSampleWithDelayFilter(psModelId, isCtr, samples, negativeSampleRatio, delayMinutes);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runDCvr(String psModelId, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getDCvrSampleWithFilter(psModelId, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runDCvrOffline(String psModelId, List<LabeledPoint> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = samples.toArray(new LabeledPoint[samples.size()]);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runMatrialOffline(String psModelId, List<LabeledPoint> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getMaterialWithFilterOffline(psModelId, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train_weighted(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runADXOffline(String psModelId, List<LabeledPoint> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getMaterialWithFilterOffline(psModelId, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train_weighted(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runBCvrOffline(String psModelId, List<LabeledPoint> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, samples.toArray(new LabeledPoint[samples.size()]));
        } else {
            SparseFMWithFTRLApp.train_weighted(psModelId, samples.toArray(new LabeledPoint[samples.size()]), partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runMatrialPairWiseOffline(String psModelId, List<LabeledPointPairWise> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPointPairWise[] dataArray = SampleBo.getMaterialWithFilterPairOffline(psModelId, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replayPairwise(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train_pairwise(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void run(String psModelId, boolean isCtr, List<PsModelSample> samples, List<PsModelSample> bCvrSamples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getSampleWithFilter(psModelId, isCtr, samples, bCvrSamples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runOffline(String psModelId, Boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getSampleOffline(psModelId, isCtr, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runWithSDK(String psModelId, boolean isCtr, List<PsModelSample> samples, List<PsModelSample> bCvrSamples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getSdkSample(psModelId, isCtr, samples, bCvrSamples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runFilterWithTradeSample(String psModelId, boolean isCtr, List<PsModelSample> samples, List<PsModelSample> bCvrSamples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize, Set<Integer> tradeCodes) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getSampleWithFilterTradeSample(psModelId, isCtr, samples, bCvrSamples, negativeSampleRatio, tradeCodes);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runFilterMissingSample(String psModelId, boolean isCtr, List<PsModelSample> samples, List<PsModelSample> bCvrSamples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledPoint[] dataArray = SampleBo.getSampleWithFilterMissingSample(psModelId, isCtr, samples, bCvrSamples, negativeSampleRatio, checkFieldIds);
        if (isReplay) {
            SparseFMWithFTRLApp.replay(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.train(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runWithFiled(String psModelId, boolean isCtr, List<PsModelSample> samples, List<PsModelSample> bCvrSamples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledSparsePoint[] dataArray = SampleBo.getSampleWithFilterWithField(psModelId, isCtr, samples, bCvrSamples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replayWithField(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.trainWithField(psModelId, dataArray, partNums, negativeSampleRatio);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runWithField(String psModelId, boolean isCtr, List<PsModelSample> samples, boolean isReplay, int partNums, double negativeSampleRatio) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledSparsePoint[] dataArray = SampleBo.getSampleWithFilterField(psModelId, isCtr, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replayWithField(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.trainWithField(psModelId, dataArray, partNums, negativeSampleRatio);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void runMaterialAdvertWithField(String psModelId, boolean isCtr, List<LabeledSparsePoint> samples, boolean isReplay, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run start ");
        LabeledSparsePoint[] dataArray = SampleBo.getMaterialSampleWithFilterField(psModelId, isCtr, samples, negativeSampleRatio);
        if (isReplay) {
            SparseFMWithFTRLApp.replayWithField(psModelId, dataArray);
        } else {
            SparseFMWithFTRLApp.trainWithFieldOffline(psModelId, dataArray, partNums, negativeSampleRatio, batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  batch run end");
    }

    public static void replay(String modelId, LabeledPoint[] data) throws Exception {
        if (data == null || data.length < 1) {
            return;
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelId, null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        for (LabeledPoint point : data) {
            double prePsVal = PsModel2.predict(point.feature());
            if (Math.random() > 0.1) {
                System.out.println("prePSVal=" + prePsVal + ",label=" + point.label());
            }
            evaluater.add(point.label(), prePsVal, 1.0);
        }
        evaluater.getLevelMap("PsModel replay");
        evaluater.print();
    }

    public static void replayPairwise(String modelId, LabeledPointPairWise[] data) throws Exception {
        if (data == null || data.length < 1) {
            return;
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelId, null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        for (LabeledPointPairWise point : data) {
            double prePsVal1 = PsModel2.predict(point.feature1());
            double prePsVal2 = PsModel2.predict(point.feature2());
            if (Math.random() > 0.1) {
                System.out.println("label=" + point.label() + ", prePSVal1=" + prePsVal1 + ", prePSVal2=" + prePsVal2);
            }
            evaluater.add(point.label(), prePsVal1, 1.0);
            evaluater.add(0.0, prePsVal2, 1.0);
        }
        evaluater.getLevelMap("PsModel replay");
        evaluater.print();
    }

    public static void replaySlot(String modelId, SlotLabeledPoint[] data) throws Exception {
        if (data == null || data.length < 1) {
            return;
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelId, null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        for (SlotLabeledPoint point : data) {
            double prePsVal = PsModel2.predict(point.feature());
            if (Math.random() > 0.1) {
                System.out.println("prePSVal=" + prePsVal + ",label=" + point.label());
            }
            evaluater.add(point.label(), prePsVal, 1.0);
        }
        evaluater.getLevelMap("PsModel replay");
        evaluater.print();
    }

    public static void replayWithField(String modelId, LabeledSparsePoint[] data) throws Exception {
        if (data == null || data.length < 1) {
            return;
        }
        FFMFTRL ffmftrl = SyncBo.getLocalModelFFM(modelId, null);
        FFM PsModel2 = ffmftrl.toFFM();
        Evaluater evaluater = new Evaluater();
        for (LabeledSparsePoint point : data) {
            double prePsVal = PsModel2.predict(point.feature());
            if (Math.random() > 0.1) {
                System.out.println("prePSVal=" + prePsVal + ",label=" + point.label());
            }
            evaluater.add(point.label(), prePsVal, 1.0);
        }
        evaluater.getLevelMap("PsModel replayWithField");
        evaluater.print();
    }

    public static void trainReg(String modelId, LabeledPoint[] dataArray, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        if (dataArray == null || dataArray.length < 1) {
            return;
        }
        int dim = dataArray[0].feature().size();
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + " start, prepare hyperParams \uff0cdim=" + dim);
        FMFTRLHyperParams hyperParams = HParamsConstant.getHParams(modelId);
        PsAgent psAgent = new PsAgent(modelId, ModelConstant.MODEL_PAR_SIZE, dim, hyperParams.factorNum());
        System.out.println("model=" + modelId + ",hyperParams=" + hyperParams.alpha());
        LocalModel searchLocalModel = SparseFMWithFTRLBatch.searchModel((LabeledPoint[])dataArray, (int)dim, (int)hyperParams.factorNum());
        psAgent.pull(searchLocalModel, false);
        LocalModel localModel = psAgent.getLocalModel();
        SparseFMRegWithFTRLBatch model = new SparseFMRegWithFTRLBatch();
        model.setModelId(modelId).setAlpha(hyperParams.alpha()).setBeta(hyperParams.beta()).setLambda1(hyperParams.lambda1()).setLambda2(hyperParams.lambda2()).setRho1(hyperParams.rho1()).setRho2(hyperParams.rho2()).setBatchSize(batchSize).setLearnRatio2(hyperParams.learnRatio2()).setNegativeSampleRatio(negativeSampleRatio).setLocalModel(localModel);
        model.setDim(dim).setFacotrNum(hyperParams.factorNum());
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  model.train(dataArray)");
        model.train(dataArray, partNums);
        LocalModel incrModel = model.getLocalIncrModel();
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  psAgent.push(incrModel)");
        psAgent.push(incrModel, partNums);
    }

    public static void train(String modelId, LabeledPoint[] dataArray, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        if (dataArray == null || dataArray.length < 1) {
            return;
        }
        int dim = dataArray[0].feature().size();
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + " start, prepare hyperParams \uff0cdim=" + dim);
        FMFTRLHyperParams hyperParams = HParamsConstant.getHParams(modelId);
        PsAgent psAgent = new PsAgent(modelId, ModelConstant.MODEL_PAR_SIZE, dim, hyperParams.factorNum());
        System.out.println("model=" + modelId + ",hyperParams=" + hyperParams.alpha());
        LocalModel searchLocalModel = SparseFMWithFTRLBatch.searchModel((LabeledPoint[])dataArray, (int)dim, (int)hyperParams.factorNum());
        psAgent.pull(searchLocalModel, false);
        LocalModel localModel = psAgent.getLocalModel();
        SparseFMWithFTRLBatch model = new SparseFMWithFTRLBatch();
        model.setModelId(modelId).setAlpha(hyperParams.alpha()).setBeta(hyperParams.beta()).setLambda1(hyperParams.lambda1()).setLambda2(hyperParams.lambda2()).setRho1(hyperParams.rho1()).setRho2(hyperParams.rho2()).setBatchSize(batchSize).setLearnRatio2(hyperParams.learnRatio2()).setNegativeSampleRatio(negativeSampleRatio).setLocalModel(localModel);
        model.setDim(dim).setFacotrNum(hyperParams.factorNum());
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  model.train(dataArray)");
        model.train(dataArray, partNums);
        LocalModel incrModel = model.getLocalIncrModel();
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  psAgent.push(incrModel)");
        psAgent.push(incrModel, partNums);
    }

    public static void trainWithField(String modelId, LabeledSparsePoint[] dataArray, int partNums, double negativeSampleRatio) throws Exception {
        if (dataArray == null || dataArray.length < 1) {
            return;
        }
        List<FeatureBaseType> featureBaseTypeList = FeatureListConstant.getFeatureInfo(modelId);
        if (featureBaseTypeList == null) {
            featureBaseTypeList = FeatureBcvrListConstant.getFeatureInfo(modelId);
        }
        ArrayList<String> featureFieldList = new ArrayList<String>();
        for (FeatureBaseType featureBaseType : featureBaseTypeList) {
            featureFieldList.add(featureBaseType.getName());
        }
        Object[] featureFieldArray = new String[featureFieldList.size()];
        featureFieldList.toArray(featureFieldArray);
        int dim = dataArray[0].feature().size;
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + " start, prepare hyperParams \uff0cdim=" + dim);
        FFMFTRLHyperParams hyperParams = HParamsConstant.getHParamsFFM(modelId);
        PsAgent psAgent = new PsAgent(modelId, ModelConstant.MODEL_PAR_SIZE * 100, dim, hyperParams.factorNum());
        System.out.println("model=" + modelId + ",hyperParams=" + hyperParams.alpha());
        System.out.println("featureFieldArray=" + Arrays.toString(featureFieldArray));
        LocalModel searchLocalModel = SparseFFMWithFTRL.searchModel((String[])featureFieldArray, (LabeledSparsePoint[])dataArray, (int)dim, (int)hyperParams.factorNum());
        psAgent.pull(searchLocalModel, false);
        LocalModel localModel = psAgent.getLocalModel();
        System.out.println("ps2LocalModel w_z  size: " + localModel.getVector("w_z").toMap().size());
        System.out.println("ps2LocalModel_f501001_v_z  size: " + localModel.getMatrix("v_z_f501001").toMap().size());
        System.out.println("ps2LocalModel_f501001_v_n  size: " + localModel.getMatrix("v_n_f501001").toMap().size());
        SparseFFMWithFTRLBatch2 model = new SparseFFMWithFTRLBatch2();
        int batchSize = TrainOpt.getBatchSizeFFM(partNums, hyperParams.batchSize());
        model.setAlpha(hyperParams.alpha()).setBeta(hyperParams.beta()).setLambda1(hyperParams.lambda1()).setLambda2(hyperParams.lambda2()).setRho1(hyperParams.rho1()).setRho2(hyperParams.rho2()).setBatchSize(batchSize).setLearnRatio2(hyperParams.learnRatio2()).setNegativeSampleRatio(negativeSampleRatio).setLocalModel((String[])featureFieldArray, localModel);
        model.setDim(dim).setFacotrNum(hyperParams.factorNum());
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  model.train(dataArray)");
        model.train(dataArray, partNums);
        LocalModel incrModel = model.getLocalIncrModel();
        System.out.println("get_w0_z= " + incrModel.getValue("w0_z"));
        System.out.println("get_w_z size:  " + incrModel.getVector("w_z").toMap().size());
        System.out.println("get_v_z_f501001 size:  " + incrModel.getMatrix("v_z_f501001").toMap().size());
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  psAgent.push(incrModel)");
        psAgent.push(incrModel, partNums);
    }

    public static void trainWithFieldOffline(String modelId, LabeledSparsePoint[] dataArray, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        if (dataArray == null || dataArray.length < 1) {
            return;
        }
        List<FeatureBaseType> featureBaseTypeList = FeatureListConstant.getFeatureInfo(modelId);
        if (featureBaseTypeList == null) {
            featureBaseTypeList = FeatureBcvrListConstant.getFeatureInfo(modelId);
        }
        ArrayList<String> featureFieldList = new ArrayList<String>();
        for (FeatureBaseType featureBaseType : featureBaseTypeList) {
            featureFieldList.add(featureBaseType.getName());
        }
        Object[] featureFieldArray = new String[featureFieldList.size()];
        featureFieldList.toArray(featureFieldArray);
        int dim = dataArray[0].feature().size;
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + " start, prepare hyperParams \uff0cdim=" + dim);
        FFMFTRLHyperParams hyperParams = HParamsConstant.getHParamsFFM(modelId);
        PsAgent psAgent = new PsAgent(modelId, ModelConstant.MODEL_PAR_SIZE * 100, dim, hyperParams.factorNum());
        System.out.println("model=" + modelId + ",hyperParams=" + hyperParams.alpha());
        System.out.println("featureFieldArray=" + Arrays.toString(featureFieldArray));
        LocalModel searchLocalModel = SparseFFMWithFTRL.searchModel((String[])featureFieldArray, (LabeledSparsePoint[])dataArray, (int)dim, (int)hyperParams.factorNum());
        psAgent.pull(searchLocalModel, false);
        LocalModel localModel = psAgent.getLocalModel();
        System.out.println("ps2LocalModel w_z  size: " + localModel.getVector("w_z").toMap().size());
        System.out.println("ps2LocalModel_f501001_v_z  size: " + localModel.getMatrix("v_z_f501001").toMap().size());
        System.out.println("ps2LocalModel_f501001_v_n  size: " + localModel.getMatrix("v_n_f501001").toMap().size());
        SparseFFMWithFTRLBatch2 model = new SparseFFMWithFTRLBatch2();
        model.setAlpha(hyperParams.alpha()).setBeta(hyperParams.beta()).setLambda1(hyperParams.lambda1()).setLambda2(hyperParams.lambda2()).setRho1(hyperParams.rho1()).setRho2(hyperParams.rho2()).setBatchSize(batchSize).setLearnRatio2(hyperParams.learnRatio2()).setNegativeSampleRatio(negativeSampleRatio).setLocalModel((String[])featureFieldArray, localModel);
        model.setDim(dim).setFacotrNum(hyperParams.factorNum());
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  model.train(dataArray)");
        model.train(dataArray, partNums);
        LocalModel incrModel = model.getLocalIncrModel();
        System.out.println("get_w0_z= " + incrModel.getValue("w0_z"));
        System.out.println("get_w_z size:  " + incrModel.getVector("w_z").toMap().size());
        System.out.println("get_v_z_f501001 size:  " + incrModel.getMatrix("v_z_f501001").toMap().size());
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  psAgent.push(incrModel)");
        psAgent.push(incrModel, partNums);
    }

    public static void train_weighted(String modelId, LabeledPoint[] dataArray, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        if (dataArray == null || dataArray.length < 1) {
            return;
        }
        int dim = dataArray[0].feature().size();
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + " start, prepare hyperParams \uff0cdim=" + dim);
        FMFTRLHyperParams hyperParams = HParamsConstant.getHParams(modelId);
        PsAgent psAgent = new PsAgent(modelId, ModelConstant.MODEL_PAR_SIZE, dim, hyperParams.factorNum());
        System.out.println("model=" + modelId + ",hyperParams=" + hyperParams.alpha());
        LocalModel searchLocalModel = SparseFMWithFTRLWeighted.searchModel((LabeledPoint[])dataArray, (int)dim, (int)hyperParams.factorNum());
        psAgent.pull(searchLocalModel, false);
        LocalModel localModel = psAgent.getLocalModel();
        SparseFMWithFTRLWeighted model = new SparseFMWithFTRLWeighted();
        model.setModelId(modelId).setAlpha(hyperParams.alpha()).setBeta(hyperParams.beta()).setLambda1(hyperParams.lambda1()).setLambda2(hyperParams.lambda2()).setRho1(hyperParams.rho1()).setRho2(hyperParams.rho2()).setBatchSize(batchSize).setLearnRatio2(hyperParams.learnRatio2()).setNegativeSampleRatio(negativeSampleRatio).setLocalModel(localModel);
        model.setDim(dim).setFacotrNum(hyperParams.factorNum());
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  model.train(dataArray)");
        model.train(dataArray, partNums);
        LocalModel incrModel = model.getLocalIncrModel();
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  psAgent.push(incrModel)");
        psAgent.push(incrModel, partNums);
    }

    public static void train_weighted_slot(String modelId, SlotLabeledPoint[] dataArray, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        if (dataArray == null || dataArray.length < 1) {
            return;
        }
        int dim = dataArray[0].feature().size();
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + " start, prepare hyperParams \uff0cdim=" + dim);
        FMFTRLHyperParams hyperParams = HParamsConstant.getHParams(modelId);
        PsAgent psAgent = new PsAgent(modelId, ModelConstant.MODEL_PAR_SIZE, dim, hyperParams.factorNum());
        System.out.println("model=" + modelId + ",hyperParams=" + hyperParams.alpha());
        LocalModel searchLocalModel = SparseFMWithFTRLWeighted.searchModelSlot((SlotLabeledPoint[])dataArray, (int)dim, (int)hyperParams.factorNum());
        psAgent.pull(searchLocalModel, false);
        LocalModel localModel = psAgent.getLocalModel();
        SparseFMWithFTRLWeighted model = new SparseFMWithFTRLWeighted();
        model.setModelId(modelId).setAlpha(hyperParams.alpha()).setBeta(hyperParams.beta()).setLambda1(hyperParams.lambda1()).setLambda2(hyperParams.lambda2()).setRho1(hyperParams.rho1()).setRho2(hyperParams.rho2()).setBatchSize(batchSize).setLearnRatio2(hyperParams.learnRatio2()).setNegativeSampleRatio(negativeSampleRatio).setLocalModel(localModel);
        model.setDim(dim).setFacotrNum(hyperParams.factorNum());
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  model.train(dataArray)");
        model.trainSlot(dataArray, partNums);
        LocalModel incrModel = model.getLocalIncrModel();
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  psAgent.push(incrModel)");
        psAgent.push(incrModel, partNums);
    }

    public static void train_pairwise(String modelId, LabeledPointPairWise[] dataArray, int partNums, double negativeSampleRatio, int batchSize) throws Exception {
        if (dataArray == null || dataArray.length < 1) {
            return;
        }
        int dim = dataArray[0].feature1().size();
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + " start, prepare hyperParams \uff0cdim=" + dim);
        FMFTRLHyperParams hyperParams = HParamsConstant.getHParams(modelId);
        PsAgent psAgent = new PsAgent(modelId, ModelConstant.MODEL_PAR_SIZE, dim, hyperParams.factorNum());
        System.out.println("model=" + modelId + ",hyperParams=" + hyperParams.alpha());
        LocalModel searchLocalModel = SparseFMWithFTRLWeighted.searchModelPairwise((LabeledPointPairWise[])dataArray, (int)dim, (int)hyperParams.factorNum());
        psAgent.pull(searchLocalModel, false);
        LocalModel localModel = psAgent.getLocalModel();
        SparseFMWithFTRLWeighted model = new SparseFMWithFTRLWeighted();
        model.setModelId(modelId).setAlpha(hyperParams.alpha()).setBeta(hyperParams.beta()).setLambda1(hyperParams.lambda1()).setLambda2(hyperParams.lambda2()).setRho1(hyperParams.rho1()).setRho2(hyperParams.rho2()).setBatchSize(batchSize).setLearnRatio2(hyperParams.learnRatio2()).setNegativeSampleRatio(negativeSampleRatio).setLocalModel(localModel);
        model.setDim(dim).setFacotrNum(hyperParams.factorNum());
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  model.train(dataArray)");
        model.trainPairwise(dataArray, partNums);
        LocalModel incrModel = model.getLocalIncrModel();
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  psAgent.push(incrModel)");
        psAgent.push(incrModel, partNums);
    }
}

