/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.app;

import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlSubModel;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.compute.biz.bo.PsBo;
import cn.com.duiba.nezha.compute.biz.bo.SampleBo;
import cn.com.duiba.nezha.compute.biz.bo.stat.OcpxControlModelBo;
import cn.com.duiba.nezha.compute.biz.bo.stat.StatBo;
import cn.com.duiba.nezha.compute.biz.bo.stat.StatMergeBo;
import cn.com.duiba.nezha.compute.biz.bo.stat.StatSampleBo;
import cn.com.duiba.nezha.compute.biz.bo.stat.StatSyncBo;
import cn.com.duiba.nezha.compute.biz.constant.ProjectConstant;
import cn.com.duiba.nezha.compute.biz.dto.stat.OcpxControlInputParams;
import cn.com.duiba.nezha.compute.biz.dto.stat.OrderStatSample;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatDo;
import cn.com.duiba.nezha.compute.biz.dto.stat.StatOffLineBaseDo;
import cn.com.duiba.nezha.compute.biz.dto.stat.SubStatDo;
import cn.com.duiba.nezha.compute.biz.enums.AdvertTypeEnum;
import cn.com.duiba.nezha.compute.biz.ocpx.control.OcpxModelBo2;
import cn.com.duiba.nezha.compute.biz.support.LoggerUtil;
import cn.com.duiba.nezha.compute.core.enums.DateStyle;
import cn.com.duiba.nezha.compute.core.util.DateUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterator;

public class StatApp
extends StatSyncBo {
    static Long nullMark = -1L;
    static Logger logger = LoggerFactory.getLogger(StatApp.class);

    public static Boolean train(String time, Iterator<String> partitionOfRecords, String modelId, Boolean isSync) throws Exception {
        while (partitionOfRecords.hasNext()) {
            String groupId = (String)partitionOfRecords.next();
            try {
                if (groupId == null || groupId == "t" || groupId == "s") continue;
                OcpxControlInputParams params = StatApp.getStatDataByGroup(time, groupId, isSync);
                OcpxControlModel lastOcpxControlModel = StatSyncBo.readModelFromRedis(modelId, groupId);
                System.gc();
                OcpxModelBo2 ocpxModelBo = new OcpxModelBo2();
                ocpxModelBo.setOcpxControlModel(lastOcpxControlModel);
                ocpxModelBo.setIsSync(isSync);
                ocpxModelBo.update(time, params);
                OcpxControlModel ocpxControlModel = ocpxModelBo.getOcpxControlModel();
                if (isSync != null && isSync.booleanValue()) {
                    System.out.println("ocpxControlModel.getSlotControlParamsMap().size()=" + ocpxControlModel.getSlotControlParamsMap().size());
                    System.out.println("ocpxControlModel.getOcpxControlSubModelMap().size()=" + ocpxControlModel.getOcpxControlSubModelMap().size());
                    System.out.println("ocpxControlModel.getAdSlotControlParamsHashMap().size()=" + ocpxControlModel.getAdSlotControlParamsHashMap().size());
                    System.out.println("ocpxControlModel.getAdControlParamsMap().size()=" + ocpxControlModel.getAdControlParamsMap().size());
                    OcpxControlModelBo.expire(ocpxControlModel, ProjectConstant.DAY_3_EXPIRE);
                    System.out.println("2 ocpxControlModel.getSlotControlParamsMap().size()=" + ocpxControlModel.getSlotControlParamsMap().size());
                    System.out.println("2 ocpxControlModel.getOcpxControlSubModelMap().size()=" + ocpxControlModel.getOcpxControlSubModelMap().size());
                    System.out.println("2 ocpxControlModel.getAdSlotControlParamsHashMap().size()=" + ocpxControlModel.getAdSlotControlParamsHashMap().size());
                    System.out.println("2 ocpxControlModel.getAdControlParamsMap().size()=" + ocpxControlModel.getAdControlParamsMap().size());
                    StatSyncBo.saveModelToRedis(ocpxControlModel, modelId, groupId, ProjectConstant.WEEK_1_EXPIRE);
                }
                System.gc();
            }
            catch (Exception e) {
                logger.error("train happend error ", (Throwable)e);
            }
        }
        System.gc();
        return null;
    }

    public static OcpxControlInputParams getStatDataByGroup(String currentTime, String adGroupId, boolean isSync) throws Exception {
        OcpxControlInputParams ret = new OcpxControlInputParams();
        String dt = currentTime.substring(0, 10);
        StatDo statDo10M = StatSyncBo.getStatDo(currentTime, adGroupId, PREFIX_STAT_10M);
        StatDo statDo30M = StatSyncBo.getStatDo(currentTime, adGroupId, PREFIX_STAT_30M);
        StatDo statDo1Dt = StatSyncBo.getStatDo(dt, adGroupId, PREFIX_STAT_DT);
        StatDo statDo3Dt = new StatDo();
        if (isSync) {
            statDo3Dt = StatSyncBo.getStatDo(dt, adGroupId, PREFIX_STAT_3DT);
        }
        StatDo statDo14Dt = StatSyncBo.getStatOffLineDo(null, adGroupId, PREFIX_STAT_14DT);
        ArrayList<StatDo> statDoDtList = new ArrayList<StatDo>();
        if (statDo1Dt != null) {
            statDoDtList.add(statDo1Dt);
        }
        if (statDo30M != null) {
            statDoDtList.add(statDo30M);
        }
        if (statDo14Dt != null) {
            statDoDtList.add(statDo14Dt);
        }
        StatDo statDoDtNew = StatMergeBo.statMerge(statDoDtList);
        ArrayList<StatDo> statDo3DtList = new ArrayList<StatDo>();
        if (statDo3Dt != null) {
            statDo3DtList.add(statDo3Dt);
        }
        if (statDoDtNew != null) {
            statDo3DtList.add(statDoDtNew);
        }
        StatDo statDo3DtNew = StatMergeBo.statMerge(statDo3DtList);
        ret.setStatDo0(statDo10M);
        ret.setStatDo1(statDo30M);
        ret.setStatDo3(statDoDtNew);
        ret.setStatDo4(statDo3DtNew);
        if (statDo1Dt != null && statDo10M != null) {
            StatMergeBo.statMergePkInfoMap(statDo1Dt.getAdPackageInfoMap(), statDo10M.getAdPackageInfoMap());
            ret.setAdPackageInfoMap(statDo1Dt.getAdPackageInfoMap());
        } else if (statDo10M != null) {
            ret.setAdPackageInfoMap(statDo10M.getAdPackageInfoMap());
        }
        return ret;
    }

    public static Boolean statNearLine(Iterator<String> partitionOfRecords, AdvertTypeEnum advertTypeEnum, String currentParseTime, int stepSize, int groupNums, int workerNums, boolean isSync) throws Exception {
        logger.info("start");
        List<String> secondInterval = SampleBo.getMinuteSecondInterval(currentParseTime, stepSize);
        while (partitionOfRecords.hasNext()) {
            String workerId = (String)partitionOfRecords.next();
            try {
                if (workerId == null) continue;
                List<String> secondIntervalWorker = StatApp.getTimeListWithHash(secondInterval, workerId, workerNums);
                StatApp.statWorker(secondIntervalWorker, advertTypeEnum, currentParseTime, groupNums, workerId, isSync);
                System.gc();
            }
            catch (Exception e) {
                logger.error("statNearLine happend error", (Throwable)e);
            }
        }
        logger.info("end");
        System.gc();
        return null;
    }

    public static Boolean statWorker(List<String> timeList, AdvertTypeEnum advertTypeEnum, String time, int groupNums, String workerId, boolean isSync) throws Exception {
        LoggerUtil.info("statWorker", "start");
        if (!isSync) {
            timeList = timeList.subList(0, 20);
        }
        List<String> orderList = PsBo.getOrderList(timeList, advertTypeEnum);
        List<OrderStatSample> sampleList = StatSampleBo.getStatSample(orderList);
        StatDo statDo = new StatDo();
        int i = 0;
        for (OrderStatSample sample : sampleList) {
            if (StatApp.valid(sample)) {
                StatBo.stat(statDo, sample);
            }
            if (++i <= 1000 || i % 10000 != 0) continue;
            System.gc();
        }
        if (statDo.getAdPackageSubStatDo(73041L, 177565L) != null) {
            System.out.println("statDo.getAdPackageSubStatDo(71589L,174313L) 1=" + JSON.toJSONString((Object)statDo.getAdPackageSubStatDo(73041L, 177565L).getStatBaseDo(1)));
            System.out.println("statDo.getAdPackageSubStatDo(71589L,174313L) 2=" + JSON.toJSONString((Object)statDo.getAdPackageSubStatDo(73041L, 177565L).getStatBaseDo(2)));
            System.out.println("statDo.getPackageInfo(71589L,174313L) =" + JSON.toJSONString((Object)statDo.getPackageInfo(73041L, 177565L)));
        }
        if (isSync) {
            StatSyncBo.saveStat(statDo, time, groupNums, workerId);
        }
        LoggerUtil.info("statWorker", "end");
        return null;
    }

    public static Boolean statOffLine(Iterator<Row> partitionOfRecords, String time, int groupNums, boolean isSync) throws Exception {
        logger.info("statOffLine start");
        String dt = time.substring(0, 10);
        int i = 0;
        HashMap<String, StatDo> statDoMap = new HashMap<String, StatDo>();
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                Long newTrade = row.getLong(0);
                Long accountId = row.getLong(1);
                Long advertId = row.getLong(2);
                Long slotId = row.getLong(3);
                Long orientationId = row.getLong(4);
                Long exposureCnt = row.getLong(5);
                Long chargeCnt = row.getLong(6);
                Long convert0 = row.getLong(7);
                Long convert2 = row.getLong(8);
                Long convert3 = row.getLong(9);
                Long convert7 = row.getLong(10);
                Long convert8 = row.getLong(11);
                Long convert9 = row.getLong(12);
                Long convert10 = row.getLong(13);
                Long convert14 = row.getLong(14);
                if (i < 2) {
                    System.out.println("row=" + row);
                }
                String groupId = StatApp.getGroupId(TYPE_AD, advertId, groupNums);
                StatOffLineBaseDo statOffLineBaseDo = new StatOffLineBaseDo();
                statOffLineBaseDo.setExpCnt(exposureCnt);
                statOffLineBaseDo.setClickCnt(chargeCnt);
                statOffLineBaseDo.setAct0Cnt(convert0);
                statOffLineBaseDo.setAct2Cnt(convert2);
                statOffLineBaseDo.setAct3Cnt(convert3);
                statOffLineBaseDo.setAct7Cnt(convert7);
                statOffLineBaseDo.setAct8Cnt(convert8);
                statOffLineBaseDo.setAct9Cnt(convert9);
                statOffLineBaseDo.setAct10Cnt(convert10);
                statOffLineBaseDo.setAct14Cnt(convert14);
                if (!statDoMap.containsKey(groupId)) {
                    statDoMap.put(groupId, new StatDo());
                }
                SubStatDo subStatDo = null;
                if (nullMark.equals(orientationId)) {
                    subStatDo = ((StatDo)statDoMap.get(groupId)).getAdSubStatDo(advertId);
                    if (subStatDo == null) {
                        subStatDo = new SubStatDo();
                        subStatDo.setAdvertId(advertId);
                        subStatDo.setNewTradeTagId(newTrade);
                        ((StatDo)statDoMap.get(groupId)).putAdSubStatDo(advertId, subStatDo);
                    }
                } else {
                    subStatDo = ((StatDo)statDoMap.get(groupId)).getAdPackageSubStatDo(advertId, orientationId);
                    if (subStatDo == null) {
                        subStatDo = new SubStatDo();
                        subStatDo.setAdvertId(advertId);
                        subStatDo.setPackageId(orientationId);
                        subStatDo.setNewTradeTagId(newTrade);
                        ((StatDo)statDoMap.get(groupId)).putAdPackageSubStatDo(advertId, orientationId, subStatDo);
                    }
                }
                if (nullMark.equals(slotId)) {
                    subStatDo.setStatOffLineBaseDo(statOffLineBaseDo);
                } else {
                    subStatDo.getSlotStatOffLineBaseDoMap().put(slotId, statOffLineBaseDo);
                }
                if (i > 1000 && i % 10000 == 0) {
                    System.gc();
                }
                ++i;
            }
            catch (Exception e) {
                logger.error("statOffLine happend error", (Throwable)e);
            }
        }
        if (isSync) {
            System.out.println("group_set=" + statDoMap.keySet());
            for (Map.Entry entry : statDoMap.entrySet()) {
                String groupId = (String)entry.getKey();
                StatDo statDo = (StatDo)entry.getValue();
                String statKey = StatApp.getStatGroupKey(PREFIX_STAT_14DT, groupId, null);
                StatApp.saveStatDoToRedis(statDo, statKey, ProjectConstant.DAY_2_EXPIRE);
            }
            StatApp.hiveSyncMark(time);
        }
        logger.info("end");
        System.gc();
        return null;
    }

    public static Boolean resetControlModel(OcpxControlModel model, String modelId, String groupId, Long ad, Long pk) throws Exception {
        OcpxControlSubModel subModel = model.getOcpxControlSubModel(ad, pk);
        if (subModel != null) {
            OcpxControlParams ocpxControlParams = subModel.getOcpxControlParams();
            if (ocpxControlParams != null) {
                System.out.println("ocpxControlParams.origin =" + JSON.toJSONString((Object)ocpxControlParams));
                ocpxControlParams.setCFactor(Double.valueOf(1.0));
                System.out.println("ocpxControlParams.new =" + JSON.toJSONString((Object)ocpxControlParams));
                StatSyncBo.saveModelToRedis(model, modelId, groupId, ProjectConstant.WEEK_2_EXPIRE);
            }
            Map slotOcpxControlParams = subModel.getOcpxControlParamsMap();
            for (Map.Entry entry : slotOcpxControlParams.entrySet()) {
                OcpxControlParams params = (OcpxControlParams)entry.getValue();
                if (params == null) continue;
                ocpxControlParams.setCFactor(Double.valueOf(1.0));
            }
        }
        System.gc();
        return null;
    }

    public static Boolean resetControlModel(String modelId, int groupNums, Boolean isSync) throws Exception {
        try {
            Long ad = 65550L;
            Long pk = 164863L;
            String groupId = StatApp.getGroupId(TYPE_AD, ad, groupNums);
            OcpxControlModel lastOcpxControlModel = StatSyncBo.readModelFromRedis(modelId, groupId);
            StatApp.resetControlModel(lastOcpxControlModel, modelId, groupId, ad, pk);
            System.gc();
        }
        catch (Exception e) {
            logger.error("train happend error ", (Throwable)e);
        }
        System.gc();
        return null;
    }

    public static Boolean mergeControlModel(int groupNums, String modelId, boolean isSync) throws Exception {
        try {
            ArrayList<OcpxControlModel> modelList = new ArrayList<OcpxControlModel>();
            for (int i = 0; i < groupNums; ++i) {
                String groupId = "g" + i;
                OcpxControlModel subModel = StatSyncBo.readModelFromRedis(modelId, groupId);
                if (subModel == null) continue;
                modelList.add(subModel);
            }
            OcpxControlModel ocpxControlModel = StatMergeBo.modelMerge(modelList);
            ocpxControlModel.setUpdateTime(DateUtil.getCurrentTime());
            OcpxControlModel ocpxControlModel2 = new OcpxControlModel();
            ocpxControlModel2.setAdControlParamsMap(ocpxControlModel.getAdControlParamsMap());
            ocpxControlModel2.setSlotControlParamsMap(ocpxControlModel.getSlotControlParamsMap());
            ocpxControlModel2.setAdSlotControlParamsHashMap(ocpxControlModel.getAdSlotControlParamsHashMap());
            if (isSync) {
                Map ocpxControlSubModelMap;
                StatSyncBo.saveModelToRedis(ocpxControlModel2, "strategy_stat_model_v002", ProjectConstant.WEEK_2_EXPIRE);
                if (ocpxControlModel != null && (ocpxControlSubModelMap = ocpxControlModel.getOcpxControlSubModelMap()) != null) {
                    for (Map.Entry entry : ocpxControlSubModelMap.entrySet()) {
                        Long advertId = (Long)entry.getKey();
                        Map mapTmp = (Map)entry.getValue();
                        if (mapTmp == null) continue;
                        for (Map.Entry entry2 : mapTmp.entrySet()) {
                            Long pkId = (Long)entry2.getKey();
                            OcpxControlSubModel params = (OcpxControlSubModel)entry2.getValue();
                            String key = "NZ_K112_1_" + advertId + "_" + pkId;
                            StatSyncBo.saveOcpxControlSubModelToRedis(params, key, ProjectConstant.WEEK_2_EXPIRE);
                        }
                    }
                }
                System.gc();
            }
        }
        catch (Exception e) {
            logger.error("mergeControlModel happend error ", (Throwable)e);
        }
        System.gc();
        return null;
    }

    public static Boolean mergeStatCurrentHour(String time, Iterator<String> partitionOfRecords, boolean isSync) throws Exception {
        while (partitionOfRecords.hasNext()) {
            String groupId = (String)partitionOfRecords.next();
            try {
                if (groupId == null) continue;
                StatSyncBo.mergeStat30M(time, groupId);
                StatSyncBo.mergeStat60M(time, groupId);
                System.gc();
            }
            catch (Exception e) {
                logger.error("mergeStat happend error ", (Throwable)e);
            }
        }
        System.gc();
        return null;
    }

    public static Boolean mergeHiveStatHistory(String time, int groupNums, boolean isSync) throws Exception {
        StatSyncBo.mergeHiveStatHistory(time, groupNums);
        return true;
    }

    public static Boolean mergeStatHistory(String time, Iterator<String> partitionOfRecords, boolean isSync) throws Exception {
        while (partitionOfRecords.hasNext()) {
            String groupId = (String)partitionOfRecords.next();
            try {
                if (groupId == null) continue;
                StatSyncBo.mergeStatDt(time, groupId);
                System.gc();
                StatSyncBo.mergeStat3Dt(time, groupId);
                System.gc();
                StatSyncBo.mergeStat7Dt(time, groupId);
                System.gc();
            }
            catch (Exception e) {
                logger.error("mergeStat happend error ", (Throwable)e);
            }
        }
        System.gc();
        return null;
    }

    public static Boolean mergeStatWorker(String time, Iterator<String> partitionOfRecords, int workerNums, boolean isSync) {
        while (partitionOfRecords.hasNext()) {
            String groupId = (String)partitionOfRecords.next();
            try {
                if (groupId == null) continue;
                StatSyncBo.mergeStatForWorker(time, groupId, workerNums, isSync);
                System.gc();
            }
            catch (Exception e) {
                logger.error("mergeStatWorker happend error ", (Throwable)e);
            }
        }
        System.gc();
        return null;
    }

    public static void mergeOffLineStatForWorker(String time, String groupId, int workerNums, boolean isSync) {
        System.gc();
    }

    public static List<String> getTimeListWithHash(List<String> secondInterval, String workerId, int workerNums) {
        ArrayList<String> secondIntervalWithHash = new ArrayList<String>();
        for (String time : secondInterval) {
            String workerIdTmp = StatSyncBo.getWorkerId(time, workerNums);
            if (!workerIdTmp.equals(workerId)) continue;
            secondIntervalWithHash.add(time);
        }
        return secondIntervalWithHash;
    }

    public static boolean valid(OrderStatSample sample) {
        boolean ret = true;
        if (sample == null) {
            return false;
        }
        if (sample.getFee() == null || sample.getNewTradeTagId() == null) {
            return false;
        }
        if (sample.getAdBidPrintDoStr() == null) {
            return false;
        }
        sample.init();
        return ret;
    }

    public static String hiveSyncHasMark(String time) {
        String hiveKey;
        Boolean retTmp;
        String ret = null;
        String dt = time.substring(0, 10);
        if (!(LocalDateUtil.getHour((String)time, (String)DateStyle.YYYY_MM_DD_HH_MM.getValue()) <= 12 || (retTmp = StatSyncBo.existsKey(hiveKey = StatApp.getStatSyncKey(PREFIX_STAT_14DT, dt))) != null && retTmp.booleanValue())) {
            ret = StatSyncBo.getDtDiff(dt, -1);
        }
        return ret;
    }

    public static String hiveSyncMark(String time) {
        String ret = null;
        String dt = time.substring(0, 10);
        String hiveKey = StatApp.getStatSyncKey(PREFIX_STAT_14DT, dt);
        StatSyncBo.setMarkKey(hiveKey, DateUtil.getCurrentTime(), ProjectConstant.HOUR_3_EXPIRE);
        return ret;
    }
}

