/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ActFeatureParse {
    public static String[] expFeature = new String[]{"appSckExpPV14D", "appSckExpUV14D", "appSckExpPV7D", "appSckExpUV7D", "appSckExpPV3D", "appSckExpUV3D", "sckExpUV14D", "sckExpUV7D", "sckExpUV3D", "slotSckExpUV14D", "slotSckExpUV7D", "slotSckExpUV3D"};
    public static String[] clkFeature = new String[]{"appSckClkPV14D", "appSckClkUV14D", "appSckClkPV7D", "appSckClkUV7D", "appSckClkPV3D", "appSckClkUV3D", "sckClkUV14D", "sckClkUV7D", "sckClkUV3D", "slotSckClkUV14D", "slotSckClkUV7D", "slotSckClkUV3D"};
    public static String[] ctrFeatureCode = new String[]{"f215112", "f215113", "f215114", "f215115", "f215116", "f215117", "f390062", "f390063", "f390064", "f390065", "f390066", "f390067"};
    public static int[] cntBucket = new int[]{0, 1, 3, 5, 10, 15, 20};
    public static int[] appSckExpPvBucket = new int[]{3, 16, 128, 512, 2048, 8192, 20480, 40960, 81920, 163840};
    public static int[] appSckExpUvBucket = new int[]{2, 8, 32, 256, 1024, 4096, 16384, 32768, 65536, 98304};
    public static int[] appSckClkBucket = new int[]{0, 2, 8, 32, 128, 256, 512, 1024, 4096, 8192};
    public static int[] sckExpUvBucket = new int[]{3, 16, 128, 512, 2048, 8192, 20480, 40960, 81920, 163840};
    public static int[] sckClkUvBucket = new int[]{0, 4, 16, 64, 256, 1024, 4096, 8192, 16384, 32768};
    public static int[] slotSckExpUvBucket = new int[]{2, 8, 32, 256, 512, 1024, 4096, 16384, 65536};
    public static int[] slotSckClkUvBucket = new int[]{0, 2, 8, 32, 128, 256, 512, 1024, 2048, 3072};
    public static double[] SckCtrBucket = new double[]{0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 1.0};
    public static Map<String, String> appSckExpPvGroup = new HashMap<String, String>(){
        {
            this.put("appSckExpPV14D", "f215000");
            this.put("appSckExpPV7D", "f215104");
            this.put("appSckExpPV3D", "f215108");
        }
    };
    public static Map<String, String> appSckExpUvGroup = new HashMap<String, String>(){
        {
            this.put("appSckExpUV14D", "f215102");
            this.put("appSckExpUV7D", "f215106");
            this.put("appSckExpUV3D", "f215110");
        }
    };
    public static Map<String, String> appSckClkGroup = new HashMap<String, String>(){
        {
            this.put("appSckClkPV14D", "f215101");
            this.put("appSckClkUV14D", "f215103");
            this.put("appSckClkPV7D", "f215105");
            this.put("appSckClkUV7D", "f215107");
            this.put("appSckClkPV3D", "f215109");
            this.put("appSckClkUV3D", "f215111");
        }
    };
    public static Map<String, String> sckExpUVGroup = new HashMap<String, String>(){
        {
            this.put("sckExpUV14D", "f390050");
            this.put("sckExpUV7D", "f390052");
            this.put("sckExpUV3D", "f390054");
        }
    };
    public static Map<String, String> sckClkUvGroup = new HashMap<String, String>(){
        {
            this.put("sckClkUV14D", "f390051");
            this.put("sckClkUV7D", "f390053");
            this.put("sckClkUV3D", "f390055");
        }
    };
    public static Map<String, String> slotSckExpUvGroup = new HashMap<String, String>(){
        {
            this.put("slotSckExpUV14D", "f390056");
            this.put("slotSckExpUV7D", "f390058");
            this.put("slotSckExpUV3D", "f390060");
        }
    };
    public static Map<String, String> slotSckClkUvGroup = new HashMap<String, String>(){
        {
            this.put("slotSckClkUV14D", "f390057");
            this.put("slotSckClkUV7D", "f390059");
            this.put("slotSckClkUV3D", "f390061");
        }
    };
    public static Map<String, Integer> tradeCodes = new HashMap<String, Integer>(){
        {
            this.put("8", 0);
            this.put("14", 1);
            this.put("15", 2);
            this.put("21", 3);
            this.put("20", 4);
            this.put("3", 5);
            this.put("5", 6);
            this.put("12", 7);
            this.put("2", 8);
            this.put("1", 9);
            this.put("24", 10);
            this.put("6", 11);
            this.put("7", 12);
            this.put("11", 13);
            this.put("13", 14);
            this.put("18", 15);
            this.put("22", 16);
            this.put("4", 17);
            this.put("17", 18);
            this.put("25", 19);
            this.put("10", 20);
            this.put("23", 21);
            this.put("9", 22);
            this.put("19", 23);
            this.put("16", 24);
        }
    };
    public static Map<String, String> featureIdMap = new HashMap<String, String>(){
        {
            this.put("a_r", "f411001");
            this.put("w_a_r", "f411002");
            this.put("i_a_r", "f411004");
            this.put("p_a_r", "f411005");
            this.put("a_j", "f412001");
            this.put("w_a_j", "f412002");
            this.put("i_a_j", "f412004");
            this.put("p_a_j", "f412005");
            this.put("c_t", "f414001");
            this.put("w_c_t", "f414002");
            this.put("i_c_t", "f414004");
            this.put("p_c_t", "f414005");
            this.put("l_c_t", "f414007");
            this.put("e_t", "f415001");
            this.put("w_e_t", "f415002");
            this.put("i_e_t", "f415004");
            this.put("p_e_t", "f415005");
            this.put("l_e_t", "f415007");
            this.put("appSckExpPV14D", "f215000");
            this.put("appSckClkPV14D", "f215101");
            this.put("appSckExpUV14D", "f215102");
            this.put("appSckClkUV14D", "f215103");
            this.put("appSckExpPV7D", "f215104");
            this.put("appSckClkPV7D", "f215105");
            this.put("appSckExpUV7D", "f215106");
            this.put("appSckClkUV7D", "f215107");
            this.put("appSckExpPV3D", "f215108");
            this.put("appSckClkPV3D", "f215109");
            this.put("appSckExpUV3D", "f215110");
            this.put("appSckClkUV3D", "f215111");
            this.put("sckExpUV14D", "f390050");
            this.put("sckClkUV14D", "f390051");
            this.put("sckExpUV7D", "f390052");
            this.put("sckClkUV7D", "f390053");
            this.put("sckExpUV3D", "f390054");
            this.put("sckClkUV3D", "f390055");
            this.put("slotSckExpUV14D", "f390056");
            this.put("slotSckClkUV14D", "f390057");
            this.put("slotSckExpUV7D", "f390058");
            this.put("slotSckClkUV7D", "f390059");
            this.put("slotSckExpUV3D", "f390060");
            this.put("slotSckClkUV3D", "f390061");
        }
    };
    public static int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();

    private static double calWilsonScore(Integer exposeCnt, Integer clickCnt) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{exposeCnt, clickCnt})) {
            return 0.0;
        }
        if (exposeCnt == 0) {
            return 0.0;
        }
        double ratio = (double)clickCnt.intValue() * 1.0 / (double)exposeCnt.intValue();
        double faithLevel = 1.645;
        double faithSquare = faithLevel * faithLevel;
        return (ratio + faithSquare / (double)(2 * exposeCnt) - faithLevel * Math.sqrt((double)(4 * exposeCnt) * ratio * (1.0 - ratio) + faithSquare) / (double)(2 * exposeCnt)) / (1.0 + faithSquare / (double)exposeCnt.intValue());
    }

    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static String getUserCategoryActLevelByBucket(Map<String, Integer> actMap, Map<String, Integer> category, int[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (Map.Entry<String, Integer> entry : actMap.entrySet()) {
                String cateKey = entry.getKey();
                Integer cateValue = entry.getValue();
                if (!category.containsKey(cateKey)) continue;
                Integer i = category.get(cateKey);
                long value = (long)(i * limit) + ActFeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static void insertIntoMap(String key, Map<String, String> resultMap) {
        Map map = (Map)JSON.parseObject((String)key, Map.class);
        for (Map.Entry entry : map.entrySet()) {
            int num;
            String rawKey = (String)entry.getKey();
            Object value = entry.getValue();
            if (!featureIdMap.containsKey(rawKey)) continue;
            String featureCode = featureIdMap.get(rawKey);
            if (featureCode.startsWith("f411")) {
                if (featureCode.endsWith("5")) {
                    resultMap.put(featureCode, value.toString());
                }
                if (!featureCode.endsWith("5")) {
                    num = Integer.parseInt(value.toString());
                    resultMap.put(featureCode, ActFeatureParse.bucket(num, cntBucket).toString());
                }
            }
            if (featureCode.startsWith("f412")) {
                if (featureCode.endsWith("5")) {
                    resultMap.put(featureCode, value.toString());
                }
                if (!featureCode.endsWith("5")) {
                    num = Integer.parseInt(value.toString());
                    resultMap.put(featureCode, ActFeatureParse.bucket(num, cntBucket).toString());
                }
            }
            if (featureCode.startsWith("f414")) {
                if (featureCode.equalsIgnoreCase("f414001") || featureCode.equalsIgnoreCase("f414002")) {
                    Map actMap = DataUtil.stringToMap((String)value.toString(), (Object)0);
                    resultMap.put(featureCode, ActFeatureParse.getUserCategoryActLevelByBucket(actMap, tradeCodes, cntBucket));
                }
                if (featureCode.equalsIgnoreCase("f414004")) {
                    int num2 = Integer.parseInt(value.toString());
                    resultMap.put(featureCode, ActFeatureParse.bucket(num2, cntBucket).toString());
                }
                if (featureCode.equalsIgnoreCase("f414005") || featureCode.equalsIgnoreCase("f414007")) {
                    resultMap.put(featureCode, value.toString());
                }
            }
            if (!featureCode.startsWith("f415")) continue;
            if (featureCode.equalsIgnoreCase("f415001") || featureCode.equalsIgnoreCase("f415002")) {
                Map actMap = DataUtil.stringToMap((String)value.toString(), (Object)0);
                resultMap.put(featureCode, ActFeatureParse.getUserCategoryActLevelByBucket(actMap, tradeCodes, cntBucket));
            }
            if (featureCode.equalsIgnoreCase("f415004")) {
                int num3 = Integer.parseInt(value.toString());
                resultMap.put(featureCode, ActFeatureParse.bucket(num3, cntBucket).toString());
            }
            if (!featureCode.equalsIgnoreCase("f415005") && !featureCode.equalsIgnoreCase("f415007")) continue;
            resultMap.put(featureCode, value.toString());
        }
    }

    public static void insertIntoMapNew(String key, Map<String, String> resultMap, Map<String, Integer> actMap) {
        Map map = (Map)JSON.parseObject((String)key, Map.class);
        for (Map.Entry entry : map.entrySet()) {
            int num;
            String featureCode;
            String rawKey = (String)entry.getKey();
            Object value = entry.getValue();
            actMap.put(rawKey, Integer.parseInt(value.toString()));
            if (appSckExpPvGroup.containsKey(rawKey)) {
                featureCode = appSckExpPvGroup.get(rawKey);
                num = Integer.parseInt(value.toString());
                resultMap.put(featureCode, ActFeatureParse.bucket(num, appSckExpPvBucket).toString());
                continue;
            }
            if (appSckExpUvGroup.containsKey(rawKey)) {
                featureCode = appSckExpUvGroup.get(rawKey);
                num = Integer.parseInt(value.toString());
                resultMap.put(featureCode, ActFeatureParse.bucket(num, appSckExpUvBucket).toString());
                continue;
            }
            if (appSckClkGroup.containsKey(rawKey)) {
                featureCode = appSckClkGroup.get(rawKey);
                num = Integer.parseInt(value.toString());
                resultMap.put(featureCode, ActFeatureParse.bucket(num, appSckClkBucket).toString());
                continue;
            }
            if (sckExpUVGroup.containsKey(rawKey)) {
                featureCode = sckExpUVGroup.get(rawKey);
                num = Integer.parseInt(value.toString());
                resultMap.put(featureCode, ActFeatureParse.bucket(num, sckExpUvBucket).toString());
                continue;
            }
            if (sckClkUvGroup.containsKey(rawKey)) {
                featureCode = sckClkUvGroup.get(rawKey);
                num = Integer.parseInt(value.toString());
                resultMap.put(featureCode, ActFeatureParse.bucket(num, sckClkUvBucket).toString());
                continue;
            }
            if (slotSckExpUvGroup.containsKey(rawKey)) {
                featureCode = slotSckExpUvGroup.get(rawKey);
                num = Integer.parseInt(value.toString());
                resultMap.put(featureCode, ActFeatureParse.bucket(num, slotSckExpUvBucket).toString());
                continue;
            }
            if (!slotSckClkUvGroup.containsKey(rawKey)) continue;
            featureCode = slotSckClkUvGroup.get(rawKey);
            num = Integer.parseInt(value.toString());
            resultMap.put(featureCode, ActFeatureParse.bucket(num, slotSckClkUvBucket).toString());
        }
        if (expFeature.length == clkFeature.length && clkFeature.length == ctrFeatureCode.length) {
            for (int i = 0; i < ctrFeatureCode.length; ++i) {
                if (!actMap.containsKey(expFeature[i]) || !actMap.containsKey(clkFeature[i])) continue;
                Double SckCtr = ActFeatureParse.calWilsonScore(actMap.get(expFeature[i]), actMap.get(clkFeature[i]));
                resultMap.put(ctrFeatureCode[i], DataUtil.Long2String((Long)ActFeatureParse.bucket(SckCtr, SckCtrBucket)));
            }
        } else {
            System.out.println("sck statistics feature list length error !!!");
        }
    }

    public static <T> Map<String, T> stringToMap(String src, T cls) {
        if (src == null) {
            return null;
        }
        try {
            return (Map)JSON.parseObject((String)src, Map.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

