/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo;

import avro.shaded.com.google.common.collect.Sets;
import cn.com.duiba.nezha.compute.biz.utils.hbase.HbaseUtil;
import cn.com.duiba.nezha.compute.core.CollectionUtil;
import cn.com.duiba.nezha.compute.core.ObjectDynamicCreator;
import cn.com.duiba.nezha.compute.core.model.ops.VectorOps;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.core.util.DataUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.mllib.linalg.SparseVector;

public class HbaseBaseBo {
    public static long MULTIPLES = 1000000L;
    public static int NEW_SCALA = 6;

    public static void insertSparseVector(String tableName, String rowKey, String family, SparseVector object) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{tableName, rowKey, family, object})) {
            HbaseUtil hbaseUtil = HbaseUtil.getInstance();
            Object[] indices = VectorOps.toStrIndex((SparseVector)object);
            long[] values = CollectionUtil.double2long((double[])object.values(), (long)MULTIPLES);
            if (AssertUtil.isNotEmpty((Object[])indices)) {
                hbaseUtil.insertColumeValues(tableName, rowKey, family, (String[])indices, values);
            }
        }
    }

    public static void deleteSparseVector(String tableName, String rowKey) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{tableName, rowKey})) {
            HbaseUtil hbaseUtil = HbaseUtil.getInstance();
            hbaseUtil.deleteRow(tableName, rowKey);
        }
    }

    public static void incrementSparseVector(String tableName, String rowKey, String family, SparseVector object) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{tableName, rowKey, family, object})) {
            HbaseUtil hbaseUtil = HbaseUtil.getInstance();
            Object[] indices = VectorOps.toStrIndex((SparseVector)object);
            Long[] values = CollectionUtil.double2Long((double[])object.values(), (Long)MULTIPLES);
            if (AssertUtil.isNotEmpty((Object[])indices)) {
                hbaseUtil.incrementColumeValues(tableName, rowKey, family, (String[])indices, values);
            }
        }
    }

    public static SparseVector searchSparseVector(String tableName, String rowKey, String family, SparseVector object) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{tableName, rowKey, family, object})) {
            HbaseUtil hbaseUtil = HbaseUtil.getInstance();
            Object[] cols = VectorOps.toStrIndex((SparseVector)object);
            HashSet fieldSet = Sets.newHashSet((Object[])cols);
            ArrayList idx = new ArrayList();
            ArrayList val = new ArrayList();
            hbaseUtil.getOneRow(tableName, rowKey, family, fieldSet, new HbaseUtil.QueryCallback((String[])cols, family, idx, object, val){
                final /* synthetic */ String[] val$cols;
                final /* synthetic */ String val$family;
                final /* synthetic */ List val$idx;
                final /* synthetic */ SparseVector val$object;
                final /* synthetic */ List val$val;
                {
                    this.val$cols = stringArray;
                    this.val$family = string;
                    this.val$idx = list;
                    this.val$object = sparseVector;
                    this.val$val = list2;
                }

                @Override
                public void process(List<Result> retList) throws Exception {
                    if (retList != null) {
                        Result ret = retList.get(0);
                        for (int i = 0; i < this.val$cols.length; ++i) {
                            byte[] fieldValueB = ret.getValue(Bytes.toBytes((String)this.val$family), Bytes.toBytes((String)this.val$cols[i]));
                            if (fieldValueB == null) continue;
                            this.val$idx.add(Long.valueOf(this.val$object.indices()[i]));
                            this.val$val.add(Bytes.toLong((byte[])fieldValueB));
                        }
                    }
                }
            });
            double[] valuesDouble = CollectionUtil.long22double(val, (long)MULTIPLES, (int)NEW_SCALA);
            int[] indices = CollectionUtil.toArray(idx);
            return VectorOps.toVector((int)object.size(), (int[])indices, (double[])valuesDouble);
        }
        return null;
    }

    public static SparseVector searchSparseVector(String tableName, final String rowKey, final String family, int vSize) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{tableName, rowKey, family})) {
            HbaseUtil hbaseUtil = HbaseUtil.getInstance();
            final HashMap mapV = new HashMap();
            hbaseUtil.getOneRow(tableName, rowKey, family, new HbaseUtil.QueryCallback(){

                @Override
                public void process(List<Result> retList) throws Exception {
                    if (retList != null) {
                        Result ret = retList.get(0);
                        List cs = ret.listCells();
                        String row = Bytes.toString((byte[])ret.getRow());
                        if (null != cs && cs.size() > 0) {
                            for (Cell cell : cs) {
                                String rowKeyC = Bytes.toString((byte[])CellUtil.cloneRow((Cell)cell));
                                Long timestampC = cell.getTimestamp();
                                String familyC = Bytes.toString((byte[])CellUtil.cloneFamily((Cell)cell));
                                String qualifierC = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                                Long valueC = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell));
                                if (!rowKey.equals(rowKeyC) || !family.equals(familyC) || qualifierC == null) continue;
                                mapV.put(Long.valueOf(qualifierC), DataUtil.long2double((long)valueC, (long)MULTIPLES, (int)NEW_SCALA));
                            }
                        }
                    }
                }
            });
            ArrayList ids = new ArrayList(mapV.keySet());
            int[] indices = new int[ids.size()];
            double[] values = new double[ids.size()];
            if (ids.size() > 0) {
                Collections.sort(ids);
                for (int i = 0; i < ids.size(); ++i) {
                    indices[i] = ((Long)ids.get(i)).intValue();
                    values[i] = DataUtil.todouble((Double)((Double)mapV.get(ids.get(i))));
                }
            }
            return VectorOps.toVector((int)vSize, (int[])indices, (double[])values);
        }
        return null;
    }

    public static void insertSingleValue(String tableName, String rowKey, String family, String[] indices, double[] values) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{tableName, rowKey, family, indices, values}) && indices.length == values.length) {
            HbaseUtil hbaseUtil = HbaseUtil.getInstance();
            long[] valueLong = CollectionUtil.double2long((double[])values, (long)MULTIPLES);
            if (AssertUtil.isNotEmpty((Object[])indices)) {
                hbaseUtil.insertColumeValues(tableName, rowKey, family, indices, valueLong);
            }
        }
    }

    public static void deleteSingleValue(String tableName, String rowKey) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{tableName, rowKey})) {
            HbaseUtil hbaseUtil = HbaseUtil.getInstance();
            hbaseUtil.deleteRow(tableName, rowKey);
        }
    }

    public static void incrementSingleValue(String tableName, String rowKey, String family, String[] indices, double[] values) throws Exception {
        HbaseBaseBo.incrementSingleValue(tableName, rowKey, family, indices, values, MULTIPLES);
    }

    public static void incrementSingleValue(String tableName, String rowKey, String family, String[] indices, double[] values, long multiples) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{tableName, rowKey, family, indices, values}) && indices.length == values.length) {
            HbaseUtil hbaseUtil = HbaseUtil.getInstance();
            Long[] valueLong = CollectionUtil.double2Long((double[])values, (Long)multiples);
            if (AssertUtil.isNotEmpty((Object[])indices)) {
                hbaseUtil.incrementColumeValues(tableName, rowKey, family, indices, valueLong);
            }
        }
    }

    public static Map<String, Double> searchSingleValue(String tableName, String rowKey, final String family, Set<String> keySet) throws Exception {
        final HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, keySet})) {
            return new HashMap<String, Double>();
        }
        HbaseUtil hbaseUtil = HbaseUtil.getInstance();
        final Set<String> fieldSet = keySet;
        hbaseUtil.getOneRow(tableName, rowKey, family, fieldSet, new HbaseUtil.QueryCallback(){

            @Override
            public void process(List<Result> retList) throws Exception {
                if (retList != null) {
                    Result ret = retList.get(0);
                    for (String field : fieldSet) {
                        Long fieldValue;
                        byte[] fieldValueB = ret.getValue(Bytes.toBytes((String)family), Bytes.toBytes((String)field));
                        if (fieldValueB == null || (fieldValue = Long.valueOf(Bytes.toLong((byte[])fieldValueB))) == null) continue;
                        retMap.put(field, DataUtil.long2double((long)fieldValue, (long)MULTIPLES, (int)NEW_SCALA));
                    }
                }
            }
        });
        return retMap;
    }

    public static <T> void insert(String tableName, String rowKey, String family, T object) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{tableName, rowKey, family, object})) {
            HbaseUtil hbaseUtil = HbaseUtil.getInstance();
            Map value = ObjectDynamicCreator.getFieldVlaue(object, null);
            if (AssertUtil.isNotEmpty((Map)value)) {
                hbaseUtil.insert(tableName, rowKey, family, value);
            }
        }
    }

    public static <T> void insert(String tableName, String rowKey, String family, String col, String value) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{tableName, rowKey, family, value})) {
            HbaseUtil hbaseUtil = HbaseUtil.getInstance();
            if (AssertUtil.isNotEmpty((String)value)) {
                hbaseUtil.insert(tableName, rowKey, family, col, value);
            }
        }
    }

    public static <T> List<T> mget(String tableName, List<String> rowKey, String family, Class<T> clazz) throws Exception {
        ArrayList<Object> retT = new ArrayList<Object>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, clazz})) {
            return retT;
        }
        Set fieldSet = ObjectDynamicCreator.getFieldSet(clazz);
        Map<String, Map<String, String>> retMap = HbaseBaseBo.mget(tableName, rowKey, family, fieldSet);
        if (!retMap.isEmpty()) {
            for (String rk : retMap.keySet()) {
                Object tmp;
                Map<String, String> vMap = retMap.get(rk);
                if (vMap == null || (tmp = JSONObject.parseObject((String)JSONObject.toJSONString(vMap), clazz)) == null) continue;
                retT.add(tmp);
            }
        }
        return retT;
    }

    public static <T> List<T> aqyMGet(String tableName, List<String> rowKey, String family, Class<T> clazz) throws Exception {
        ArrayList<Object> retT = new ArrayList<Object>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, clazz})) {
            return retT;
        }
        Set fieldSet = ObjectDynamicCreator.getFieldSet(clazz);
        Map<String, Map<String, String>> retMap = HbaseBaseBo.mget(tableName, rowKey, family, fieldSet);
        if (!retMap.isEmpty()) {
            for (String rk : retMap.keySet()) {
                Object tmp;
                JSONObject feature;
                Map<String, String> vMap = retMap.get(rk);
                if (vMap == null) continue;
                System.out.println(vMap);
                String feat = vMap.get("feature");
                if (feat == null || !(feature = JSONObject.parseObject((String)feat)).containsKey("f451011") || (tmp = JSONObject.parseObject((String)JSONObject.toJSONString(vMap), clazz)) == null) continue;
                retT.add(tmp);
            }
        }
        return retT;
    }

    public static <T> List<T> aqyAgeMGet(String tableName, List<String> rowKey, String family, Class<T> clazz) throws Exception {
        ArrayList<Object> retT = new ArrayList<Object>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, clazz})) {
            return retT;
        }
        Set fieldSet = ObjectDynamicCreator.getFieldSet(clazz);
        Map<String, Map<String, String>> retMap = HbaseBaseBo.mget(tableName, rowKey, family, fieldSet);
        if (!retMap.isEmpty()) {
            for (String rk : retMap.keySet()) {
                Object tmp;
                JSONObject feature;
                Map<String, String> vMap = retMap.get(rk);
                if (vMap == null) continue;
                System.out.println(vMap);
                String feat = vMap.get("feature");
                if (feat == null || !(feature = JSONObject.parseObject((String)feat)).containsKey("f451012") || (tmp = JSONObject.parseObject((String)JSONObject.toJSONString(vMap), clazz)) == null) continue;
                retT.add(tmp);
            }
        }
        return retT;
    }

    public static <T> List<T> sdkMGet(String tableName, List<String> rowKey, String family, Class<T> clazz) throws Exception {
        ArrayList<Object> retT = new ArrayList<Object>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, clazz})) {
            return retT;
        }
        Set fieldSet = ObjectDynamicCreator.getFieldSet(clazz);
        Map<String, Map<String, String>> retMap = HbaseBaseBo.mget(tableName, rowKey, family, fieldSet);
        if (!retMap.isEmpty()) {
            for (String rk : retMap.keySet()) {
                Object tmp;
                Map<String, String> vMap = retMap.get(rk);
                if (vMap == null || !vMap.getOrDefault("dSdk", "").equals("2") || (tmp = JSONObject.parseObject((String)JSONObject.toJSONString(vMap), clazz)) == null) continue;
                retT.add(tmp);
            }
        }
        return retT;
    }

    public static <T> List<T> exploreMGet(String tableName, List<String> rowKey, String family, Class<T> clazz) throws Exception {
        ArrayList<Object> retT = new ArrayList<Object>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, clazz})) {
            return retT;
        }
        Set fieldSet = ObjectDynamicCreator.getFieldSet(clazz);
        Map<String, Map<String, String>> retMap = HbaseBaseBo.mget(tableName, rowKey, family, fieldSet);
        if (!retMap.isEmpty()) {
            for (String rk : retMap.keySet()) {
                Object tmp;
                Map<String, String> vMap = retMap.get(rk);
                if (vMap == null || vMap.getOrDefault("adExplore", "").equals("2") || (tmp = JSONObject.parseObject((String)JSONObject.toJSONString(vMap), clazz)) == null) continue;
                retT.add(tmp);
            }
        }
        return retT;
    }

    public static <T> List<T> nExploreMGet(String tableName, List<String> rowKey, String family, Class<T> clazz) throws Exception {
        ArrayList<Object> retT = new ArrayList<Object>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, clazz})) {
            return retT;
        }
        Set fieldSet = ObjectDynamicCreator.getFieldSet(clazz);
        Map<String, Map<String, String>> retMap = HbaseBaseBo.mget(tableName, rowKey, family, fieldSet);
        if (!retMap.isEmpty()) {
            for (String rk : retMap.keySet()) {
                Object tmp;
                Map<String, String> vMap = retMap.get(rk);
                if (vMap == null || !vMap.getOrDefault("adExplore", "").equals("0") || (tmp = JSONObject.parseObject((String)JSONObject.toJSONString(vMap), clazz)) == null) continue;
                retT.add(tmp);
            }
        }
        return retT;
    }

    public static <T> List<T> exploreMgetBCvr(String tableName, List<String> rowKey, String family, Class<T> clazz) throws Exception {
        ArrayList<Object> retT = new ArrayList<Object>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, clazz})) {
            return retT;
        }
        Set fieldSet = ObjectDynamicCreator.getFieldSet(clazz);
        Map<String, Map<String, String>> retMap = HbaseBaseBo.mget(tableName, rowKey, family, fieldSet);
        if (!retMap.isEmpty()) {
            for (String rk : retMap.keySet()) {
                Object tmp;
                Map<String, String> vMap = retMap.get(rk);
                if (vMap == null || vMap.getOrDefault("adExplore", "").equals("2") || (tmp = JSONObject.parseObject((String)JSONObject.toJSONString(vMap), clazz)) == null) continue;
                retT.add(tmp);
            }
        }
        return retT;
    }

    public static <T> List<T> nExploreMgetBCvr(String tableName, List<String> rowKey, String family, Class<T> clazz) throws Exception {
        ArrayList<Object> retT = new ArrayList<Object>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, clazz})) {
            return retT;
        }
        Set fieldSet = ObjectDynamicCreator.getFieldSet(clazz);
        Map<String, Map<String, String>> retMap = HbaseBaseBo.mget(tableName, rowKey, family, fieldSet);
        if (!retMap.isEmpty()) {
            for (String rk : retMap.keySet()) {
                Object tmp;
                Map<String, String> vMap = retMap.get(rk);
                if (vMap == null || vMap.getOrDefault("adExplore", "").equals("1") || vMap.getOrDefault("adExplore", "").equals("2") || (tmp = JSONObject.parseObject((String)JSONObject.toJSONString(vMap), clazz)) == null) continue;
                retT.add(tmp);
            }
        }
        return retT;
    }

    public static <T> List<T> sdkMgetBCvr(String tableName, List<String> rowKey, String family, Class<T> clazz) throws Exception {
        ArrayList<Object> retT = new ArrayList<Object>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, clazz})) {
            return retT;
        }
        Set fieldSet = ObjectDynamicCreator.getFieldSet(clazz);
        Map<String, Map<String, String>> retMap = HbaseBaseBo.mget(tableName, rowKey, family, fieldSet);
        if (!retMap.isEmpty()) {
            for (String rk : retMap.keySet()) {
                Object tmp;
                Map<String, String> vMap = retMap.get(rk);
                if (vMap == null || !vMap.getOrDefault("dSdk", "").equals("2") || vMap.get("isClick") == null || (tmp = JSONObject.parseObject((String)JSONObject.toJSONString(vMap), clazz)) == null) continue;
                retT.add(tmp);
            }
        }
        return retT;
    }

    public static Map<String, Map<String, String>> mget(String tableName, List<String> rowKeyList, String family) throws Exception {
        final HashMap<String, Map<String, String>> retMap = new HashMap<String, Map<String, String>>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKeyList, family})) {
            return new HashMap<String, Map<String, String>>();
        }
        HbaseUtil hbaseUtil = HbaseUtil.getInstance();
        hbaseUtil.getRows(tableName, rowKeyList, family, new HbaseUtil.QueryCallback(){

            @Override
            public void process(List<Result> retList) throws Exception {
                if (retList != null) {
                    for (Result ret : retList) {
                        HashMap<String, String> tmpMap = new HashMap<String, String>();
                        String row = Bytes.toString((byte[])ret.getRow());
                        if (ret.listCells() != null) {
                            for (Cell kv : ret.listCells()) {
                                tmpMap.put(Bytes.toString((byte[])kv.getQualifier()), Bytes.toString((byte[])kv.getValue()));
                            }
                        }
                        if (row == null) continue;
                        retMap.put(row, tmpMap);
                    }
                }
            }
        });
        return retMap;
    }

    public static Map<String, Map<String, String>> mget(String tableName, List<String> rowKeyList, final String family, Set<String> fSet) throws Exception {
        final HashMap<String, Map<String, String>> retMap = new HashMap<String, Map<String, String>>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKeyList, family, fSet})) {
            return new HashMap<String, Map<String, String>>();
        }
        HbaseUtil hbaseUtil = HbaseUtil.getInstance();
        final Set<String> fieldSet = fSet;
        hbaseUtil.getRows(tableName, rowKeyList, family, fieldSet, new HbaseUtil.QueryCallback(){

            @Override
            public void process(List<Result> retList) throws Exception {
                if (retList != null) {
                    for (Result ret : retList) {
                        HashMap<String, String> tmpMap = new HashMap<String, String>();
                        String row = Bytes.toString((byte[])ret.getRow());
                        for (String field : fieldSet) {
                            byte[] fieldValueB = ret.getValue(Bytes.toBytes((String)family), Bytes.toBytes((String)field));
                            String fieldValue = Bytes.toString((byte[])fieldValueB);
                            if (fieldValue == null) continue;
                            tmpMap.put(field, fieldValue);
                        }
                        if (row == null) continue;
                        retMap.put(row, tmpMap);
                    }
                }
            }
        });
        return retMap;
    }

    public static <T> T get(String tableName, String rowKey, String family, Class<T> clazz) throws Exception {
        Object retT = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, clazz})) {
            return (T)retT;
        }
        Set fieldSet = ObjectDynamicCreator.getFieldSet(clazz);
        Map<String, String> retMap = HbaseBaseBo.get(tableName, rowKey, family, fieldSet);
        if (!retMap.isEmpty()) {
            retT = JSONObject.parseObject((String)JSONObject.toJSONString(retMap), clazz);
        }
        return (T)retT;
    }

    public static <T> T get(String tableName, String rowKey, String family, String col, Class<T> clazz) throws Exception {
        String retS;
        Object retT = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, clazz})) {
            return (T)retT;
        }
        HashSet<String> fieldSet = new HashSet<String>();
        fieldSet.add(col);
        Map<String, String> retMap = HbaseBaseBo.get(tableName, rowKey, family, fieldSet);
        if (!retMap.isEmpty() && (retS = (String)retMap.getOrDefault(col, null)) != null) {
            retT = JSONObject.parseObject((String)retS, clazz);
        }
        return (T)retT;
    }

    public static Map<String, String> get(String tableName, String rowKey, final String family, Set<String> keySet) throws Exception {
        final HashMap<String, String> retMap = new HashMap<String, String>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{tableName, rowKey, family, keySet})) {
            return new HashMap<String, String>();
        }
        HbaseUtil hbaseUtil = HbaseUtil.getInstance();
        final Set<String> fieldSet = keySet;
        hbaseUtil.getOneRow(tableName, rowKey, family, fieldSet, new HbaseUtil.QueryCallback(){

            @Override
            public void process(List<Result> retList) throws Exception {
                if (retList != null) {
                    Result ret = retList.get(0);
                    for (String field : fieldSet) {
                        byte[] fieldValueB = ret.getValue(Bytes.toBytes((String)family), Bytes.toBytes((String)field));
                        String fieldValue = Bytes.toString((byte[])fieldValueB);
                        if (fieldValue == null) continue;
                        retMap.put(field, fieldValue);
                    }
                }
            }
        });
        return retMap;
    }
}

