/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo;

import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.Feature;
import cn.com.duiba.nezha.compute.biz.app.SparseESMMFMWithFTRLApp;
import cn.com.duiba.nezha.compute.biz.app.SparseFMWithFTRLApp;
import cn.com.duiba.nezha.compute.biz.bo.ActFeatureParse;
import cn.com.duiba.nezha.compute.biz.bo.PsBo;
import cn.com.duiba.nezha.compute.biz.bo.SyncBo;
import cn.com.duiba.nezha.compute.biz.constant.feature.FeatureBcvrListConstant;
import cn.com.duiba.nezha.compute.biz.constant.feature.FeatureListConstant;
import cn.com.duiba.nezha.compute.biz.dto.OrderDo;
import cn.com.duiba.nezha.compute.biz.dto.PsModelSample;
import cn.com.duiba.nezha.compute.biz.enums.AdvertTypeEnum;
import cn.com.duiba.nezha.compute.biz.enums.feature.FeatureEnumC1;
import cn.com.duiba.nezha.compute.biz.enums.model.ESMMModelKeyEnum;
import cn.com.duiba.nezha.compute.biz.enums.model.ModelKeyEnum;
import cn.com.duiba.nezha.compute.biz.support.SampleParse;
import cn.com.duiba.nezha.compute.core.LabeledPoint;
import cn.com.duiba.nezha.compute.core.LabeledPointPairWise;
import cn.com.duiba.nezha.compute.core.LabeledSparsePoint;
import cn.com.duiba.nezha.compute.core.enums.DateStyle;
import cn.com.duiba.nezha.compute.core.util.DateUtil;
import cn.com.duiba.nezha.compute.mllib.evaluate.Evaluater;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.FM;
import cn.com.duiba.nezha.compute.mllib.fm.ftrl.FMFTRL;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.misc.Triple;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.sql.Row;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;

public class ModelBo {
    public static void runOnMsg(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, double sampleRatio, boolean isReplay, int partNums) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start,sampleRatio=" + sampleRatio + ",parNums=" + partNums);
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            if (!(Math.random() < sampleRatio) || orderId == null) continue;
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), 1);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.runWithField(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio());
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsg(ESMMModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int type, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        SparseESMMFMWithFTRLApp.run(modelKeyEnum.getCtrModel().getPsIndex(), modelKeyEnum.getCvrModel().getPsIndex(), samples, isReplay, partNums, type, batchSize);
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsg(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        if (samples.size() > 0) {
            System.out.println("o=" + JSON.toJSONString((Object)samples.get(0)));
            SampleParse.parseMap(samples.get(0));
            System.out.println("n=" + JSON.toJSONString((Object)samples.get(0)));
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.gc();
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgSDK(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getPsSDKSample(orderIdList);
        if (samples.size() > 0) {
            System.out.println(samples.get(0));
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgExplore(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getPsExploreSample(orderIdList);
        if (samples.size() > 0) {
            System.out.println(samples.get(0));
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgNExplore(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getPsNExploreSample(orderIdList);
        if (samples.size() > 0) {
            System.out.println(samples.get(0));
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgFilterMissingSample(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runFilterMissingSample(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.runFilterMissingSample(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgOffline(ModelKeyEnum modelKeyEnum, Iterator<PsModelSample> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsgADX  start");
        ArrayList<PsModelSample> samples = new ArrayList<PsModelSample>();
        while (partitionOfRecords.hasNext()) {
            PsModelSample sample = (PsModelSample)partitionOfRecords.next();
            samples.add(sample);
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsgADX  end");
    }

    public static void runOnMsgADX(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsgADX  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getADXPsSample(orderIdList);
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsgADX  end");
    }

    public static void runOnMsgADXPd(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsgADXPd  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getADXPsSample(orderIdList);
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runAdxPd(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsgADXPd  end");
    }

    public static void runOnMsgADXReg(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsgADX  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList, AdvertTypeEnum.ADX_IDEA);
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runAdxReg(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsgADX  end");
    }

    public static void runOnMsgZZ(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsgZZ  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getZZPsSample(orderIdList);
        System.out.println("samples.size()=" + samples.size());
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize, 60L);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsgZZ  end");
    }

    public static void runOnMsgZZBcvr(ModelKeyEnum modelKeyEnum, Iterator<OrderDo> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsgZZBcvr  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        ArrayList<String> orderIdBCvrList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            if (order.getBcvr().booleanValue()) {
                orderIdBCvrList.add(order.getOrderId());
                continue;
            }
            orderIdList.add(order.getOrderId());
        }
        List<PsModelSample> samples = PsBo.getZZPsSample(orderIdList);
        List<PsModelSample> bCvrSamples = PsBo.getZZPsSample(orderIdBCvrList);
        System.out.println("samples.size()=" + samples.size());
        System.out.println("bCvrSamples.size()=" + bCvrSamples.size());
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.runWithFiled(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsgZZBcvr  end");
    }

    public static void runOnMsgBcvr(ESMMModelKeyEnum modelKeyEnum, Iterator<OrderDo> partitionOfRecords, boolean isReplay, int partNums, int type, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        ArrayList<String> orderIdBCvrList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            if (order.getBcvr().booleanValue()) {
                orderIdBCvrList.add(order.getOrderId());
                continue;
            }
            orderIdList.add(order.getOrderId());
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        List<PsModelSample> bCvrSamples = PsBo.getPsSample(orderIdBCvrList);
        SparseESMMFMWithFTRLApp.run(modelKeyEnum.getCtrModel().getPsIndex(), modelKeyEnum.getCvrModel().getPsIndex(), samples, bCvrSamples, isReplay, partNums, type, batchSize);
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgBcvr(ModelKeyEnum modelKeyEnum, Iterator<OrderDo> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        ArrayList<String> orderIdBCvrList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            if (order.getBcvr().booleanValue()) {
                orderIdBCvrList.add(order.getOrderId());
                continue;
            }
            orderIdList.add(order.getOrderId());
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        List<PsModelSample> bCvrSamples = PsBo.getPsSample(orderIdBCvrList);
        if (bCvrSamples.size() > 0) {
            System.out.println(bCvrSamples.get(0).getIsClick() + "," + bCvrSamples.get(0).getFeature());
        }
        System.out.println("samples.size()=" + samples.size());
        System.out.println("bCvrSamples.size()=" + bCvrSamples.size());
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.runWithFiled(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgAqyBcvr(ModelKeyEnum modelKeyEnum, Iterator<OrderDo> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        ArrayList<String> orderIdBCvrList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            if (order.getBcvr().booleanValue()) {
                orderIdBCvrList.add(order.getOrderId());
                continue;
            }
            orderIdList.add(order.getOrderId());
        }
        List<PsModelSample> samples = PsBo.getPsAqySample(orderIdList);
        List<PsModelSample> bCvrSamples = PsBo.getPsAqySample(orderIdBCvrList);
        if (bCvrSamples.size() > 0) {
            System.out.println(bCvrSamples.get(0).getIsClick() + "," + bCvrSamples.get(0).getFeature());
        }
        System.out.println("samples.size()=" + samples.size());
        System.out.println("bCvrSamples.size()=" + bCvrSamples.size());
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.runWithFiled(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgAqyAgeBcvr(ModelKeyEnum modelKeyEnum, Iterator<OrderDo> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        ArrayList<String> orderIdBCvrList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            if (order.getBcvr().booleanValue()) {
                orderIdBCvrList.add(order.getOrderId());
                continue;
            }
            orderIdList.add(order.getOrderId());
        }
        List<PsModelSample> samples = PsBo.getPsAqyAgeSample(orderIdList);
        List<PsModelSample> bCvrSamples = PsBo.getPsAqyAgeSample(orderIdBCvrList);
        if (bCvrSamples.size() > 0) {
            System.out.println(bCvrSamples.get(0).getIsClick() + "," + bCvrSamples.get(0).getFeature());
        }
        System.out.println("samples.size()=" + samples.size());
        System.out.println("bCvrSamples.size()=" + bCvrSamples.size());
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.runWithFiled(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgBcvrFilterWithTrade(ModelKeyEnum modelKeyEnum, Iterator<OrderDo> partitionOfRecords, boolean isReplay, int partNums, int batchSize, Set<Integer> tradeCodes) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        ArrayList<String> orderIdBCvrList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            if (order.getBcvr().booleanValue()) {
                orderIdBCvrList.add(order.getOrderId());
                continue;
            }
            orderIdList.add(order.getOrderId());
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        List<PsModelSample> bCvrSamples = PsBo.getPsSample(orderIdBCvrList);
        System.out.println("samples.size()=" + samples.size());
        System.out.println("bCvrSamples.size()=" + bCvrSamples.size());
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runFilterWithTradeSample(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize, tradeCodes);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.runWithFiled(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgBcvrOnExplore(ModelKeyEnum modelKeyEnum, Iterator<OrderDo> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        ArrayList<String> orderIdBCvrList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            if (order.getBcvr().booleanValue()) {
                orderIdBCvrList.add(order.getOrderId());
                continue;
            }
            orderIdList.add(order.getOrderId());
        }
        List<PsModelSample> samples = PsBo.getExploreBCvrSample(orderIdList);
        List<PsModelSample> bCvrSamples = PsBo.getExploreBCvrSample(orderIdBCvrList);
        System.out.println("samples.size()=" + samples.size());
        System.out.println("bCvrSamples.size()=" + bCvrSamples.size());
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgBcvrOnNExplore(ModelKeyEnum modelKeyEnum, Iterator<OrderDo> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        ArrayList<String> orderIdBCvrList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            if (order.getBcvr().booleanValue()) {
                orderIdBCvrList.add(order.getOrderId());
                continue;
            }
            orderIdList.add(order.getOrderId());
        }
        List<PsModelSample> samples = PsBo.getNExploreBCvrSample(orderIdList);
        List<PsModelSample> bCvrSamples = PsBo.getNExploreBCvrSample(orderIdBCvrList);
        System.out.println("samples.size()=" + samples.size());
        System.out.println("bCvrSamples.size()=" + bCvrSamples.size());
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgBcvrOnSDK(ModelKeyEnum modelKeyEnum, Iterator<OrderDo> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        ArrayList<String> orderIdBCvrList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            if (order.getBcvr().booleanValue()) {
                orderIdBCvrList.add(order.getOrderId());
                continue;
            }
            orderIdList.add(order.getOrderId());
        }
        List<PsModelSample> samples = PsBo.getSDKBCvrSample(orderIdList);
        List<PsModelSample> bCvrSamples = PsBo.getSDKBCvrSample(orderIdBCvrList);
        if (bCvrSamples.size() > 0) {
            System.out.println(bCvrSamples.get(0).getIsClick() + "," + JSON.toJSONString(bCvrSamples.get(0).getActClickList()));
        }
        System.out.println("samples.size()=" + samples.size());
        System.out.println("bCvrSamples.size()=" + bCvrSamples.size());
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.run(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgBcvrOffline(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<PsModelSample> samples = new ArrayList<PsModelSample>();
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            PsModelSample psModelSample = new PsModelSample();
            psModelSample.setOrderId(row.getString(0));
            psModelSample.setF(row.getString(1));
            psModelSample.setIsActClick(row.getLong(2));
            psModelSample.setIsClick(1L);
            samples.add(psModelSample);
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runOffline(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgBcvrFilterMissingSample(ModelKeyEnum modelKeyEnum, Iterator<OrderDo> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        ArrayList<String> orderIdBCvrList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            if (order.getBcvr().booleanValue()) {
                orderIdBCvrList.add(order.getOrderId());
                continue;
            }
            orderIdList.add(order.getOrderId());
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        List<PsModelSample> bCvrSamples = PsBo.getPsSample(orderIdBCvrList);
        System.out.println("samples.size()=" + samples.size());
        System.out.println("bCvrSamples.size()=" + bCvrSamples.size());
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runFilterMissingSample(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.runWithFiled(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, bCvrSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMsgMaterial(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize, int PosNegRation, boolean isAdvertMaterial) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsgMaterial  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        Map<String, Map<String, String>> map = PsBo.getMaterialPsSampleHbaseData(orderIdList);
        List<PsModelSample> samples = PsBo.getMaterialPsSampleHbase(map, isAdvertMaterial);
        HashMap<String, Double> PosNegMap = ModelBo.getPosNegMap(map, PosNegRation, isAdvertMaterial);
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runMaterialSlot(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize, PosNegMap);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsgMaterial end");
    }

    public static void runOnMsgDp(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsgMaterial  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        Map<String, Map<String, String>> map = PsBo.getDpPsSampleHbaseData(orderIdList);
        List<PsModelSample> samples = PsBo.getDpPsSampleHbase(map);
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runDpSlot(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsgMaterial end");
    }

    public static void runOnMsgMaterial001(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize, int posNegRation, int adPosNegRation) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsgMaterial  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        Map<String, Map<String, String>> map = PsBo.getMaterialPsSampleHbaseData(orderIdList);
        List<PsModelSample> samples = PsBo.getMaterialPsSampleHbase1(map);
        ArrayList<PsModelSample> adSamples = new ArrayList<PsModelSample>();
        ArrayList<PsModelSample> nonAdSamples = new ArrayList<PsModelSample>();
        for (PsModelSample sample : samples) {
            String advertFlag = JSON.parseObject((String)sample.getFeature()).getString("advertFlag");
            if ("1".equals(advertFlag)) {
                adSamples.add(sample);
                continue;
            }
            nonAdSamples.add(sample);
        }
        HashMap<String, Double> nonAdPosNegMap = ModelBo.getMergedPosNegMap(nonAdSamples, posNegRation);
        HashMap<String, Double> adPosNegMap = ModelBo.getMergedPosNegMap(adSamples, adPosNegRation);
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runMergedMaterialSlot(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), nonAdSamples, adSamples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize, nonAdPosNegMap, adPosNegMap);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsgMaterial end");
    }

    public static HashMap<String, Double> getMergedPosNegMap(List<PsModelSample> samples, int PosNegRation) {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  getPosNegMap start ...");
        HashMap<String, Double> PosNegMap = new HashMap<String, Double>();
        HashMap<String, Integer> PosMap = new HashMap<String, Integer>();
        HashMap<String, Integer> NegMap = new HashMap<String, Integer>();
        boolean idx = false;
        for (PsModelSample sample : samples) {
            String slotId = JSON.parseObject((String)sample.getFeature()).getString("f108001");
            if (!PosMap.containsKey(slotId)) {
                PosMap.put(slotId, 0);
            }
            if (!NegMap.containsKey(slotId)) {
                NegMap.put(slotId, 0);
            }
            if (sample.getIsClick() != null) {
                PosMap.put(slotId, (Integer)PosMap.get(slotId) + 1);
                continue;
            }
            NegMap.put(slotId, (Integer)NegMap.get(slotId) + 1);
        }
        for (String key : PosMap.keySet()) {
            float needNegSample = (Integer)PosMap.get(key) * PosNegRation;
            if (needNegSample < (float)((Integer)NegMap.get(key)).intValue()) {
                double negativeSampleRatio = (double)needNegSample / Math.max((double)((Integer)NegMap.get(key)).intValue(), 1.0);
                if (negativeSampleRatio == 0.0) {
                    negativeSampleRatio = 0.1;
                }
                PosNegMap.put(key, negativeSampleRatio);
                continue;
            }
            PosNegMap.put(key, 1.0);
        }
        System.out.println("PosMap: " + PosMap + ", NegMap: " + NegMap);
        return PosNegMap;
    }

    public static HashMap<String, Double> getPosNegMap(Map<String, Map<String, String>> map, int PosNegRation, boolean isAdvertMaterial) {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  getPosNegMap start ...");
        HashMap<String, Double> PosNegMap = new HashMap<String, Double>();
        HashMap<String, Integer> PosMap = new HashMap<String, Integer>();
        HashMap<String, Integer> NegMap = new HashMap<String, Integer>();
        int idx = 0;
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            String slotID;
            Map<String, String> map1 = entry.getValue();
            if (!map1.containsKey("feature")) continue;
            ++idx;
            JSONObject featureMap = JSONObject.parseObject((String)map1.get("feature"));
            if (isAdvertMaterial) {
                if (!featureMap.containsKey("advertFlag")) continue;
                slotID = (String)featureMap.get("f108001");
                if (!PosMap.containsKey(slotID)) {
                    PosMap.put(slotID, 0);
                }
                if (!NegMap.containsKey(slotID)) {
                    NegMap.put(slotID, 0);
                }
                if (map1.containsKey("isClick")) {
                    PosMap.put(slotID, (Integer)PosMap.get(slotID) + 1);
                    continue;
                }
                NegMap.put(slotID, (Integer)NegMap.get(slotID) + 1);
                continue;
            }
            if (featureMap.containsKey("advertFlag")) continue;
            slotID = (String)featureMap.get("f108001");
            if (!PosMap.containsKey(slotID)) {
                PosMap.put(slotID, 0);
            }
            if (!NegMap.containsKey(slotID)) {
                NegMap.put(slotID, 0);
            }
            if (map1.containsKey("isClick")) {
                PosMap.put(slotID, (Integer)PosMap.get(slotID) + 1);
                continue;
            }
            NegMap.put(slotID, (Integer)NegMap.get(slotID) + 1);
        }
        for (String key : PosMap.keySet()) {
            float needNegSample = (Integer)PosMap.get(key) * PosNegRation;
            if (needNegSample < (float)((Integer)NegMap.get(key)).intValue()) {
                double negativeSampleRatio = (double)needNegSample / Math.max((double)((Integer)NegMap.get(key)).intValue(), 1.0);
                if (negativeSampleRatio == 0.0) {
                    negativeSampleRatio = 0.05;
                }
                PosNegMap.put(key, negativeSampleRatio);
                continue;
            }
            PosNegMap.put(key, 1.0);
        }
        System.out.println("PosMap: " + PosMap + ", NegMap: " + NegMap);
        return PosNegMap;
    }

    public static void runOnMsgMaterial1(ModelKeyEnum modelKeyEnum, Iterator<String> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsgMaterial  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String orderId = (String)partitionOfRecords.next();
            orderIdList.add(orderId);
        }
        List<PsModelSample> samples = PsBo.getMaterialPsSample1(orderIdList);
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runMaterial1(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsgMaterial end");
    }

    public static void runOnMsgDcvr(ModelKeyEnum modelKeyEnum, Iterator<OrderDo> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> orderIdList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            OrderDo order = (OrderDo)partitionOfRecords.next();
            orderIdList.add(order.getOrderId());
        }
        List<PsModelSample> samples = PsBo.getPsSample(orderIdList);
        System.out.println("samples.size()=" + samples.size());
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runDCvr(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            // empty if block
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnDCvr(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                JSONObject featureMap = JSONObject.parseObject((String)row.getString(1));
                psModelSample.setFeatureMap((Map<String, String>)featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runDCvrOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        if (modelKeyEnum.getType() == 2) {
            // empty if block
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMaterial(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                JSONObject featureMap = JSONObject.parseObject((String)row.getString(1));
                psModelSample.setFeatureMap((Map<String, String>)featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double fee = Math.min(Math.log10(row.getDouble(3) + 1.0), 200.0) + 1.0;
                double label = (double)row.getLong(2) * fee;
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runMatrialOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMaterial1(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                JSONObject featureMap = JSONObject.parseObject((String)row.getString(1));
                psModelSample.setFeatureMap((Map<String, String>)featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runDCvrOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMaterialPlusNewFeature(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                psModelSample.setFeatureMap(featureMap);
                if (++idx < 5 || idx % 100000 == 0) {
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double fee = Math.min(Math.log10(row.getDouble(3) + 1.0), 200.0) + 1.0;
                double label = (double)row.getLong(2) * fee;
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runMatrialOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnADXPlusNewFeature(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                psModelSample.setFeatureMap(featureMap);
                if (idx < 3 || idx % 1000000 == 0) {
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                ++idx;
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runADXOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnBcvrOffline(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                CodeResult codeResult;
                Feature feature;
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                psModelSample.setFeatureMap(featureMap);
                if (++idx < 5 || idx % 100000 == 0) {
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                if ((feature = (codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap())).getFeature()) == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                LabeledPoint labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runBCvrOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMaterialFeatureMerged(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                ++idx;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                if (!StringUtils.isEmpty((CharSequence)row.getString(4)) && !"NULL".equals(row.getString(4))) {
                    Map<String, String> adMap = ModelBo.parseFeatureMerged(row.getString(4));
                    featureMap.putAll(adMap);
                }
                psModelSample.setFeatureMap(featureMap);
                if (idx % 10000 == 0) {
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double fee = Math.min(Math.log10(row.getDouble(3) + 1.0), 200.0) + 1.0;
                Long joinCnt = row.getLong(2);
                double label = (double)row.getLong(2) * fee;
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runMatrialOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMaterialFeatureMerged001(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                psModelSample.setFeatureMap(featureMap);
                if (++idx % 10000 == 0) {
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                long advertFlag = row.getLong(4);
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double fee = Math.min(Math.log10(row.getDouble(3) + 1.0), 200.0) + 1.0;
                if (advertFlag == 1L) {
                    fee = Math.min(5.0 * Math.log10(row.getDouble(3) + 1.0), 200.0) + 1.0;
                }
                double label = (double)row.getLong(2) * fee;
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runMatrialOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMaterialAdvertFeature(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        String advertKey = "f109002";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                ++idx;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                String SecondTagNum = row.getString(3);
                featureMap.put(advertKey, SecondTagNum);
                psModelSample.setFeatureMap(featureMap);
                if (idx % 100000 == 0) {
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runMatrialOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMaterialAdvertFeaturePairWise(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPointPairWise> samples = new ArrayList<LabeledPointPairWise>();
        int idx = 0;
        String advertKey = "f109002";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                CodeResult codeResult2;
                Feature Item2Feature;
                if (row == null) continue;
                PsModelSample psModelSample1 = new PsModelSample();
                psModelSample1.setOrderId(row.getString(0));
                Map<String, String> Item1FeatureMap = ModelBo.parseAllFeature(row.getString(1));
                psModelSample1.setFeatureMap(Item1FeatureMap);
                if (++idx % 100000 == 0) {
                    System.out.println("idx: " + idx + "Item1FeatureMap: " + Item1FeatureMap.toString());
                }
                CodeResult codeResult1 = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample1.getFeatureMap());
                Feature Item1Feature = codeResult1.getFeature();
                PsModelSample psModelSample2 = new PsModelSample();
                Map<String, String> Item2FeatureMap = ModelBo.parseAllFeature(row.getString(2));
                psModelSample2.setFeatureMap(Item2FeatureMap);
                if (!(Item1Feature != null & (Item2Feature = (codeResult2 = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample2.getFeatureMap())).getFeature()) != null)) continue;
                SparseVector sv1 = SampleParse.toSparseVector(Item1Feature);
                SparseVector sv2 = SampleParse.toSparseVector(Item2Feature);
                double label = row.getLong(3);
                LabeledPointPairWise labeledPoint = new LabeledPointPairWise(label, sv1, sv2);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runMatrialPairWiseOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMaterialAdvertFeatureFFM(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledSparsePoint> samples = new ArrayList<LabeledSparsePoint>();
        int idx = 0;
        String advertKey = "f109002";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                ++idx;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                String SecondTagNum = row.getString(3);
                featureMap.put(advertKey, SecondTagNum);
                psModelSample.setFeatureMap(featureMap);
                if (idx % 100000 == 0) {
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledSparsePoint labeledSparsePoint = null;
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                Long label = row.getLong(2);
                labeledSparsePoint = SampleParse.toLabeledSparsePoint(codeResult.getFeature(), label);
                samples.add(labeledSparsePoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 2) {
            SparseFMWithFTRLApp.runMaterialAdvertWithField(modelKeyEnum.getPsIndex(), modelKeyEnum.getIsCtr(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static Map<String, String> parseAllFeature(String rawFeature) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        HashMap<String, Integer> actMap = new HashMap<String, Integer>();
        String[] features = rawFeature.split("##");
        String oldFeature = features[0];
        Map map = (Map)JSON.parseObject((String)oldFeature, Map.class);
        resultMap.putAll(map);
        int size = features.length;
        if (size > 1) {
            for (int i = 1; i < size; ++i) {
                String rawStr = features[i];
                if (rawStr.equals("!!")) continue;
                ActFeatureParse.insertIntoMapNew(rawStr, resultMap, actMap);
            }
        }
        return resultMap;
    }

    public static Map<String, String> parseAdxMeituanFeature(String rawFeature) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        HashMap actMap = new HashMap();
        String[] features = rawFeature.split("##");
        String oldFeature = features[0];
        Map map = (Map)JSON.parseObject((String)oldFeature, Map.class);
        resultMap.putAll(map);
        int size = features.length;
        if (size > 1) {
            for (int idx = 1; idx < size; ++idx) {
                String rawStr = features[idx];
                if (rawStr.equals("!!")) continue;
                Map cross_feat = (Map)JSON.parseObject((String)rawStr, Map.class);
                for (Map.Entry entry : cross_feat.entrySet()) {
                    String rawKey = (String)entry.getKey();
                    Object value = entry.getValue();
                    resultMap.put(rawKey, value.toString());
                }
            }
        }
        return resultMap;
    }

    public static Map<String, String> insertIdFeature(String rawFeature, String exposeStr, Set<String> advertSet) {
        StringBuilder sb;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Map map = (Map)JSON.parseObject((String)rawFeature, Map.class);
        resultMap.putAll(map);
        String defaultStr = "0000";
        String sep = "_";
        String clickStr = map.getOrDefault("f830001", "");
        String advertId = map.getOrDefault("f101001", "");
        String convertStr = map.getOrDefault("f830011", "");
        Set<Object> convertSet = new HashSet();
        if (convertStr.length() > 0) {
            convertSet = ModelBo.getConvertAdvertSet(convertStr, advertSet);
        }
        HashSet<String> clickSet = new HashSet<String>(Arrays.asList(clickStr.split(",")));
        if (exposeStr.length() > 0 && advertSet.contains(advertId)) {
            String[] tmpStr;
            sb = new StringBuilder();
            for (String tmp : tmpStr = exposeStr.split(",")) {
                String tt;
                if (!advertSet.contains(tmp)) continue;
                if (clickSet.size() > 0) {
                    if (clickSet.contains(tmp)) continue;
                    tt = tmp + sep + advertId;
                    sb.append(tt + ",");
                    continue;
                }
                tt = tmp + sep + advertId;
                sb.append(tt + ",");
            }
            String string = sb.toString();
            if (string.length() > 0) {
                resultMap.put("f911001", string.substring(0, string.length() - 1));
            }
        }
        if (advertSet.contains(advertId) && clickSet.size() > 0) {
            String raw2;
            sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            for (String click : clickSet) {
                if (!advertSet.contains(click)) continue;
                String tt = click + sep + advertId;
                sb.append(tt + ",");
                if (convertSet.contains(click)) continue;
                sb2.append(tt + ",");
            }
            String string = sb.toString();
            if (string.length() > 0) {
                resultMap.put("f911002", string.substring(0, string.length() - 1));
            }
            if ((raw2 = sb2.toString()).length() > 0) {
                resultMap.put("f911003", raw2.substring(0, raw2.length() - 1));
            }
        }
        if (convertSet.size() > 0 && advertSet.contains(advertId)) {
            sb = new StringBuilder();
            for (String string : convertSet) {
                String tt = string + sep + advertId;
                sb.append(tt + ",");
            }
            String raw2 = sb.toString();
            if (raw2.length() > 0) {
                resultMap.put("f911004", raw2.substring(0, raw2.length() - 1));
            }
        }
        return resultMap;
    }

    public static Map<String, String> parseFeatureMerged(String adFeature) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Map adMap = (Map)JSON.parseObject((String)adFeature, Map.class);
        List<FeatureEnumC1> adList = FeatureListConstant.getAdMaterialNew();
        for (int i = 0; i < adList.size(); ++i) {
            if (!adMap.containsKey(adList.get(i).getName())) continue;
            resultMap.put(adList.get(i).getName(), (String)adMap.get(adList.get(i).getName()));
        }
        return resultMap;
    }

    public static List<Tuple2<Double, Double>> predMaterialPlusNewFeature(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        ArrayList<Triple> samples = new ArrayList<Triple>();
        int idx = 0;
        String slotKey = "f108001";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                if (idx % 100000 == 0) {
                    System.out.println("idx: " + idx + ", featureMap: " + featureMap.toString());
                }
                ++idx;
                String slotId = featureMap.get(slotKey);
                psModelSample.setFeatureMap(featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(new Triple((Object)psModelSample.getOrderId(), (Object)labeledPoint, (Object)slotId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelKeyEnum.getPsIndex(), null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        ArrayList<Tuple2<Double, Double>> result = new ArrayList<Tuple2<Double, Double>>();
        int index = 0;
        ArrayList<Double> preds = new ArrayList<Double>();
        ArrayList<Integer> labels = new ArrayList<Integer>();
        ArrayList<String> slots = new ArrayList<String>();
        for (Triple order_point : samples) {
            String order_id = (String)order_point.a;
            LabeledPoint point = (LabeledPoint)order_point.b;
            String slotId = (String)order_point.c;
            double prePsVal = PsModel2.predict(point.feature());
            evaluater.add(point.label(), prePsVal, 1.0);
            result.add(new Tuple2((Object)point.label(), (Object)prePsVal));
            if (index % 100000 == 0) {
                System.out.println("index: " + index + ", point feature: " + point.feature() + ", label= " + point.label() + ", prePsVal: " + prePsVal);
            }
            ++index;
            preds.add(prePsVal);
            labels.add((int)point.label());
            slots.add(slotId);
        }
        System.out.println("start evaluater predict task.....");
        evaluater.getLoss();
        System.out.println("end evaluater predict task.");
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  start cal slot auc ....");
        Map<String, Double> aucMap = ModelBo.calSlotAuc(preds, labels, slots);
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  scal slot end ....");
        System.out.println("slot auc map : " + JSON.toJSONString(aucMap));
        return result;
    }

    public static List<Tuple2<Double, Double>> MaterialFeatureSelect(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize, String featid) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("current feature id: " + featid);
        ArrayList<Triple> samples = new ArrayList<Triple>();
        int idx = 0;
        String slotKey = "f108001";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                featureMap.put(featid, "0");
                if (idx % 100000 == 0) {
                    System.out.println("idx: " + idx + ", featureMap: " + featureMap.toString());
                }
                ++idx;
                String slotId = featureMap.get(slotKey);
                psModelSample.setFeatureMap(featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(new Triple((Object)psModelSample.getOrderId(), (Object)labeledPoint, (Object)slotId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelKeyEnum.getPsIndex(), null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        ArrayList<Tuple2<Double, Double>> result = new ArrayList<Tuple2<Double, Double>>();
        int index = 0;
        ArrayList<Double> preds = new ArrayList<Double>();
        ArrayList<Integer> labels = new ArrayList<Integer>();
        ArrayList<String> slots = new ArrayList<String>();
        for (Triple order_point : samples) {
            String order_id = (String)order_point.a;
            LabeledPoint point = (LabeledPoint)order_point.b;
            String slotId = (String)order_point.c;
            double prePsVal = PsModel2.predict(point.feature());
            evaluater.add(point.label(), prePsVal, 1.0);
            result.add(new Tuple2((Object)point.label(), (Object)prePsVal));
            if (index % 100000 == 0) {
                System.out.println("index: " + index + ", point feature: " + point.feature() + ", label= " + point.label() + ", prePsVal: " + prePsVal);
            }
            ++index;
            preds.add(prePsVal);
            labels.add((int)point.label());
            slots.add(slotId);
        }
        System.out.println("start evaluater predict task.....");
        evaluater.getLoss();
        System.out.println("end evaluater predict task.");
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  start cal slot auc ....");
        Map<String, Double> aucMap = ModelBo.calSlotAuc(preds, labels, slots);
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  scal slot end ....");
        System.out.println("featid: " + featid + ", slot auc map : " + JSON.toJSONString(aucMap));
        return result;
    }

    public static List<Tuple2<Double, Double>> ADXFeatureSelect(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize, String featid) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("current feature id: " + featid);
        ArrayList<Triple> samples = new ArrayList<Triple>();
        int idx = 0;
        String slotKey = "f2010010";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                featureMap.put(featid, "0");
                if (idx % 1000000 == 0) {
                    System.out.println("idx: " + idx + ", featureMap: " + featureMap.toString());
                }
                ++idx;
                String slotId = featureMap.get(slotKey);
                psModelSample.setFeatureMap(featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(new Triple((Object)psModelSample.getOrderId(), (Object)labeledPoint, (Object)slotId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelKeyEnum.getPsIndex(), null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        ArrayList<Tuple2<Double, Double>> result = new ArrayList<Tuple2<Double, Double>>();
        int index = 0;
        ArrayList<Double> preds = new ArrayList<Double>();
        ArrayList<Integer> labels = new ArrayList<Integer>();
        ArrayList<String> slots = new ArrayList<String>();
        for (Triple order_point : samples) {
            String order_id = (String)order_point.a;
            LabeledPoint point = (LabeledPoint)order_point.b;
            String slotId = (String)order_point.c;
            double prePsVal = PsModel2.predict(point.feature());
            evaluater.add(point.label(), prePsVal, 1.0);
            result.add(new Tuple2((Object)point.label(), (Object)prePsVal));
            if (index % 1000000 == 0) {
                System.out.println("index: " + index + ", point feature: " + point.feature() + ", label= " + point.label() + ", prePsVal: " + prePsVal);
            }
            ++index;
            preds.add(prePsVal);
            labels.add((int)point.label());
            slots.add(slotId);
        }
        System.out.println("start evaluater predict task.....");
        evaluater.getLoss();
        System.out.println("end evaluater predict task.");
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  start cal slot auc ....");
        Map<String, Double> aucMap = ModelBo.calSlotAuc(preds, labels, slots);
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  scal slot end ....");
        System.out.println("featid: " + featid + ", slot auc map : " + JSON.toJSONString(aucMap));
        return result;
    }

    public static List<Tuple2<Double, Double>> MeiTuanFeatureSelect(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize, String featid) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("current feature id: " + featid);
        ArrayList<Triple> samples = new ArrayList<Triple>();
        int idx = 0;
        String slotKey = "f999999";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAdxMeituanFeature(row.getString(1));
                featureMap.put(featid, "0");
                if (idx % 1000000 == 0) {
                    System.out.println("idx: " + idx + ", featureMap: " + featureMap.toString());
                }
                ++idx;
                String slotId = featureMap.get(slotKey);
                psModelSample.setFeatureMap(featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(new Triple((Object)psModelSample.getOrderId(), (Object)labeledPoint, (Object)slotId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelKeyEnum.getPsIndex(), null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        ArrayList<Tuple2<Double, Double>> result = new ArrayList<Tuple2<Double, Double>>();
        int index = 0;
        ArrayList<Double> preds = new ArrayList<Double>();
        ArrayList<Integer> labels = new ArrayList<Integer>();
        ArrayList<String> slots = new ArrayList<String>();
        for (Triple order_point : samples) {
            String order_id = (String)order_point.a;
            LabeledPoint point = (LabeledPoint)order_point.b;
            String slotId = (String)order_point.c;
            double prePsVal = PsModel2.predict(point.feature());
            evaluater.add(point.label(), prePsVal, 1.0);
            result.add(new Tuple2((Object)point.label(), (Object)prePsVal));
            if (index % 1000000 == 0) {
                System.out.println("index: " + index + ", point feature: " + point.feature() + ", label= " + point.label() + ", prePsVal: " + prePsVal);
            }
            ++index;
            preds.add(prePsVal);
            labels.add((int)point.label());
            slots.add(slotId);
        }
        System.out.println("start evaluater predict task.....");
        evaluater.getLoss();
        System.out.println("end evaluater predict task.");
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  start cal slot auc ....");
        Map<String, Double> aucMap = ModelBo.calSlotAuc(preds, labels, slots);
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  scal slot end ....");
        System.out.println("featid: " + featid + ", slot auc map : " + JSON.toJSONString(aucMap));
        return result;
    }

    public static List<Tuple3<String, Double, Double>> MaterialMergedFeatureSelect(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize, String featid) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("current feature id: " + featid);
        ArrayList<Triple> samples = new ArrayList<Triple>();
        int idx = 0;
        String slotKey = "f108001";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                featureMap.put(featid, "0");
                if (idx % 100000 == 0) {
                    System.out.println("idx: " + idx + ", featureMap: " + featureMap.toString());
                }
                ++idx;
                String slotId = featureMap.get(slotKey);
                psModelSample.setFeatureMap(featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(new Triple((Object)psModelSample.getOrderId(), (Object)labeledPoint, (Object)slotId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelKeyEnum.getPsIndex(), null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        ArrayList<Tuple3<String, Double, Double>> result = new ArrayList<Tuple3<String, Double, Double>>();
        int index = 0;
        ArrayList<Double> preds = new ArrayList<Double>();
        ArrayList<Integer> labels = new ArrayList<Integer>();
        ArrayList<String> slots = new ArrayList<String>();
        for (Triple order_point : samples) {
            String order_id = (String)order_point.a;
            LabeledPoint point = (LabeledPoint)order_point.b;
            String slotId = (String)order_point.c;
            double prePsVal = PsModel2.predict(point.feature());
            evaluater.add(point.label(), prePsVal, 1.0);
            result.add(new Tuple3((Object)order_id, (Object)point.label(), (Object)prePsVal));
            if (index % 100000 == 0) {
                System.out.println("index: " + index + ", point feature: " + point.feature() + ", label= " + point.label() + ", prePsVal: " + prePsVal);
            }
            ++index;
            preds.add(prePsVal);
            labels.add((int)point.label());
            slots.add(slotId);
        }
        System.out.println("start evaluater predict task.....");
        evaluater.getLoss();
        System.out.println("end evaluater predict task.");
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  start cal slot auc ....");
        Map<String, Double> aucMap = ModelBo.calSlotAuc(preds, labels, slots);
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  scal slot end ....");
        System.out.println("featid: " + featid + ", slot auc map : " + JSON.toJSONString(aucMap));
        return result;
    }

    public static void AdvertNewAuc(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize, Row[] advertRow) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        ArrayList<Triple> samples = new ArrayList<Triple>();
        int idx = 0;
        String slotKey = "f660001";
        String convertType = "f115001";
        Set<String> advertSet = ModelBo.getAdvertSet(advertRow);
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                Map<String, String> featureMap = ModelBo.insertIdFeature(row.getString(1), row.getString(2), advertSet);
                if (idx % 100000 == 0) {
                    System.out.println("idx: " + idx + ", featureMap: " + featureMap.toString());
                }
                ++idx;
                String slotId = featureMap.get(slotKey);
                String type = featureMap.getOrDefault(convertType, "+");
                psModelSample.setFeatureMap(featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(0);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(new Triple((Object)"", (Object)labeledPoint, (Object)(slotId + "_" + type)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelKeyEnum.getPsIndex(), null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        ArrayList result = new ArrayList();
        int index = 0;
        ArrayList<Double> preds = new ArrayList<Double>();
        ArrayList<Integer> labels = new ArrayList<Integer>();
        ArrayList<String> slots = new ArrayList<String>();
        for (Triple order_point : samples) {
            LabeledPoint point = (LabeledPoint)order_point.b;
            String slotId = (String)order_point.c;
            double prePsVal = PsModel2.predict(point.feature());
            evaluater.add(point.label(), prePsVal, 1.0);
            if (index % 100000 == 0) {
                System.out.println("index: " + index + ", point feature: " + point.feature() + ", label= " + point.label() + ", prePsVal: " + prePsVal);
            }
            ++index;
            preds.add(prePsVal);
            labels.add((int)point.label());
            slots.add(slotId);
        }
        System.out.println("start evaluater predict task.....");
        evaluater.getLoss();
        System.out.println("end evaluater predict task.");
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  start cal slot auc ....");
        Map<String, Double> aucMap = ModelBo.calSlotAuc(preds, labels, slots);
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  scal slot end ....");
        System.out.println("slot auc map : " + JSON.toJSONString(aucMap));
    }

    public static void AdvertNewRawAuc(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize, Row[] advertRow) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        ArrayList<Triple> samples = new ArrayList<Triple>();
        int idx = 0;
        String slotKey = "f660001";
        String convertType = "f115001";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                Map featureMap = (Map)JSON.parseObject((String)row.getString(1), Map.class);
                if (idx % 100000 == 0) {
                    System.out.println("idx: " + idx + ", featureMap: " + featureMap.toString());
                }
                ++idx;
                String slotId = (String)featureMap.get(slotKey);
                String type = featureMap.getOrDefault(convertType, "+");
                psModelSample.setFeatureMap(featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(0);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(new Triple((Object)"", (Object)labeledPoint, (Object)(slotId + "_" + type)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelKeyEnum.getPsIndex(), null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        ArrayList result = new ArrayList();
        int index = 0;
        ArrayList<Double> preds = new ArrayList<Double>();
        ArrayList<Integer> labels = new ArrayList<Integer>();
        ArrayList<String> slots = new ArrayList<String>();
        for (Triple order_point : samples) {
            LabeledPoint point = (LabeledPoint)order_point.b;
            String slotId = (String)order_point.c;
            double prePsVal = PsModel2.predict(point.feature());
            evaluater.add(point.label(), prePsVal, 1.0);
            if (index % 100000 == 0) {
                System.out.println("index: " + index + ", point feature: " + point.feature() + ", label= " + point.label() + ", prePsVal: " + prePsVal);
            }
            ++index;
            preds.add(prePsVal);
            labels.add((int)point.label());
            slots.add(slotId);
        }
        System.out.println("start evaluater predict task.....");
        evaluater.getLoss();
        System.out.println("end evaluater predict task.");
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  start cal slot auc ....");
        Map<String, Double> aucMap = ModelBo.calSlotAuc(preds, labels, slots);
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  scal slot end ....");
        System.out.println("slot auc map : " + JSON.toJSONString(aucMap));
    }

    public static List<Tuple2<Double, Double>> MaterialAdvertFeature(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize, String featid) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("current feature id: " + featid);
        ArrayList<Triple> samples = new ArrayList<Triple>();
        int idx = 0;
        String slotKey = "f108001";
        String advertKey = "f109002";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                Map<String, String> featureMap = ModelBo.parseAllFeature(row.getString(1));
                String SecondTagNum = row.getString(3);
                featureMap.put(advertKey, SecondTagNum);
                featureMap.put(featid, "0");
                if (idx % 100000 == 0) {
                    System.out.println("idx: " + idx + ", featureMap: " + featureMap.toString());
                }
                ++idx;
                String slotId = featureMap.get(slotKey);
                psModelSample.setFeatureMap(featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(new Triple((Object)psModelSample.getOrderId(), (Object)labeledPoint, (Object)slotId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelKeyEnum.getPsIndex(), null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        ArrayList<Tuple2<Double, Double>> result = new ArrayList<Tuple2<Double, Double>>();
        int index = 0;
        ArrayList<Double> preds = new ArrayList<Double>();
        ArrayList<Integer> labels = new ArrayList<Integer>();
        ArrayList<String> slots = new ArrayList<String>();
        for (Triple order_point : samples) {
            String order_id = (String)order_point.a;
            LabeledPoint point = (LabeledPoint)order_point.b;
            String slotId = (String)order_point.c;
            double prePsVal = PsModel2.predict(point.feature());
            evaluater.add(point.label(), prePsVal, 1.0);
            result.add(new Tuple2((Object)point.label(), (Object)prePsVal));
            if (index % 100000 == 0) {
                System.out.println("index: " + index + ", point feature: " + point.feature() + ", label= " + point.label() + ", prePsVal: " + prePsVal);
            }
            ++index;
            preds.add(prePsVal);
            labels.add((int)point.label());
            slots.add(slotId);
        }
        System.out.println("start evaluater predict task.....");
        evaluater.getLoss();
        System.out.println("end evaluater predict task.");
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  start cal slot auc ....");
        Map<String, Double> aucMap = ModelBo.calSlotAuc(preds, labels, slots);
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  scal slot end ....");
        System.out.println("featid: " + featid + ", slot auc map : " + JSON.toJSONString(aucMap));
        return result;
    }

    public static Map<String, Double> calSlotAuc(List<Double> preds, List<Integer> labels, List<String> slots) {
        HashMap<String, Double> aucMap = new HashMap<String, Double>();
        if (labels.size() != preds.size() || labels.size() != slots.size()) {
            System.out.println("wrong size !! ");
            return aucMap;
        }
        long size = labels.size();
        HashMap<String, MutablePair> slotMap = new HashMap<String, MutablePair>();
        int i = 0;
        while ((long)i < size) {
            String slot = slots.get(i);
            MutablePair value = slotMap.getOrDefault(slot, new MutablePair(new HashMap(), new HashMap()));
            ((Map)value.left).put(i, preds.get(i));
            ((Map)value.right).put(i, labels.get(i));
            slotMap.put(slot, value);
            ++i;
        }
        double slotAuc = 0.0;
        for (Map.Entry entry : slotMap.entrySet()) {
            MutablePair value = (MutablePair)entry.getValue();
            double auc = ModelBo.calAuc((Map)value.left, (Map)value.right);
            aucMap.put((String)entry.getKey(), auc);
            slotAuc += auc;
        }
        aucMap.put("SAUC", slotAuc / (double)slotMap.keySet().size());
        return aucMap;
    }

    public static double calAuc(Map<Integer, Double> predMap, Map<Integer, Integer> labelMap) {
        LinkedHashMap predMap2 = new LinkedHashMap();
        int sum = labelMap.values().stream().reduce(Integer::sum).orElse(0);
        System.out.println("pos count : " + sum);
        long negCount = labelMap.size() - sum;
        long total = (long)sum * negCount;
        predMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEachOrdered(e -> {
            Double cfr_ignored_0 = (Double)predMap2.put(e.getKey(), e.getValue());
        });
        long accumulateNeg = 0L;
        long satisfierPair = 0L;
        for (Map.Entry entry : predMap2.entrySet()) {
            Integer index = (Integer)entry.getKey();
            int label = labelMap.get(index);
            if (label == 1) {
                satisfierPair += accumulateNeg;
                continue;
            }
            ++accumulateNeg;
        }
        return (double)satisfierPair / (double)total;
    }

    public static List<Triple<String, Double, String>> predDCvr(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        ArrayList<Triple> samples = new ArrayList<Triple>();
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                psModelSample.setOrderId(row.getString(0));
                JSONObject featureMap = JSONObject.parseObject((String)row.getString(1));
                String dt = row.getString(3);
                psModelSample.setFeatureMap((Map<String, String>)featureMap);
                CodeResult codeResult = FeatureCoder.code(FeatureBcvrListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                codeResult.getFeature();
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(2);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(new Triple((Object)psModelSample.getOrderId(), (Object)labeledPoint, (Object)dt));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FMFTRL fmftrl = SyncBo.getLocalModel(modelKeyEnum.getPsIndex(), null);
        FM PsModel2 = fmftrl.toFM();
        Evaluater evaluater = new Evaluater();
        ArrayList<Triple<String, Double, String>> result = new ArrayList<Triple<String, Double, String>>();
        for (Triple order_point : samples) {
            String order_id = (String)order_point.a;
            LabeledPoint point = (LabeledPoint)order_point.b;
            String dt = (String)order_point.c;
            double prePsVal = PsModel2.predict(point.feature());
            evaluater.add(point.label(), prePsVal, 1.0);
            result.add((Triple<String, Double, String>)new Triple((Object)order_id, (Object)prePsVal, (Object)dt));
        }
        return result;
    }

    public static void runOnMaterialPlusNewFeatureAdvert(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize, Row[] advertRow) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        Set<String> advertSet = ModelBo.getAdvertSet(advertRow);
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                Map<String, String> featureMap = ModelBo.insertIdFeature(row.getString(1), row.getString(2), advertSet);
                psModelSample.setFeatureMap(featureMap);
                if (++idx < 5 || idx % 100000 == 0) {
                    System.out.println("fea : " + row.getString(1));
                    System.out.println("expose  : " + row.getString(2));
                    System.out.println("advert set : " + JSON.toJSONString(advertSet));
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(0);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runDCvrOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMaterialPlusNewFeatureAdvertWeight(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize, Row[] advertRow) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        Set<String> advertSet = ModelBo.getAdvertSet(advertRow);
        String convertType = "f115001";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                Map<String, String> featureMap = ModelBo.insertIdFeature(row.getString(1), row.getString(2), advertSet);
                psModelSample.setFeatureMap(featureMap);
                if (++idx < 5 || idx % 100000 == 0) {
                    System.out.println("fea : " + row.getString(1));
                    System.out.println("expose  : " + row.getString(2));
                    System.out.println("advert set : " + JSON.toJSONString(advertSet));
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(0);
                String type = featureMap.getOrDefault(convertType, "");
                if (type.equalsIgnoreCase("2") || type.equalsIgnoreCase("3")) {
                    label *= 5.0;
                }
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runMatrialOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runBcvrOfflineV0(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        List<FeatureBaseType> featureBaseTypeList;
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        List<FeatureBaseType> list = featureBaseTypeList = FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()) != null ? FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()) : FeatureBcvrListConstant.getFeatureInfo(modelKeyEnum.getPsIndex());
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                if (++idx < 5 || idx % 100000 == 0) {
                    System.out.println("fea : " + row.getString(1));
                }
                Map featureMap = (Map)JSON.parseObject((String)row.getString(1), Map.class);
                psModelSample.setFeatureMap(featureMap);
                if (idx < 5 || idx % 100000 == 0) {
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(featureBaseTypeList, psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(0);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runDCvrOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runBcvrOfflineV1(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        List<FeatureBaseType> featureBaseTypeList;
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        List<FeatureBaseType> list = featureBaseTypeList = FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()) != null ? FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()) : FeatureBcvrListConstant.getFeatureInfo(modelKeyEnum.getPsIndex());
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                if (++idx < 5 || idx % 100000 == 0) {
                    System.out.println("fea : " + row.getString(1));
                }
                Map featureMap = (Map)JSON.parseObject((String)row.getString(1), Map.class);
                featureMap.put("f451011", row.getString(2));
                psModelSample.setFeatureMap(featureMap);
                if (idx < 5 || idx % 100000 == 0) {
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(featureBaseTypeList, psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(0);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runDCvrOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runBcvrOfflineV2(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize) throws Exception {
        List<FeatureBaseType> featureBaseTypeList;
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        List<FeatureBaseType> list = featureBaseTypeList = FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()) != null ? FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()) : FeatureBcvrListConstant.getFeatureInfo(modelKeyEnum.getPsIndex());
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                if (++idx < 5 || idx % 100000 == 0) {
                    System.out.println("fea : " + row.getString(1));
                }
                Map featureMap = (Map)JSON.parseObject((String)row.getString(1), Map.class);
                featureMap.put("f451012", row.getString(2));
                psModelSample.setFeatureMap(featureMap);
                if (idx < 5 || idx % 100000 == 0) {
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(featureBaseTypeList, psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(0);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runDCvrOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMaterialPlusNewFeatureAdvertRaw(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize, Row[] advertRow) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                Map featureMap = (Map)JSON.parseObject((String)row.getString(1), Map.class);
                psModelSample.setFeatureMap(featureMap);
                if (++idx < 5 || idx % 100000 == 0) {
                    System.out.println("fea : " + row.getString(1));
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(0);
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runDCvrOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    public static void runOnMaterialPlusNewFeatureAdvertRawWeighted(ModelKeyEnum modelKeyEnum, Iterator<Row> partitionOfRecords, boolean isReplay, int partNums, int batchSize, Row[] advertRow) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        System.out.println("aaaaaaaaaaaaa");
        ArrayList<LabeledPoint> samples = new ArrayList<LabeledPoint>();
        int idx = 0;
        String convertType = "f115001";
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                PsModelSample psModelSample = new PsModelSample();
                Map featureMap = (Map)JSON.parseObject((String)row.getString(1), Map.class);
                psModelSample.setFeatureMap(featureMap);
                if (++idx < 5 || idx % 100000 == 0) {
                    System.out.println("fea : " + row.getString(1));
                    System.out.println("idx: " + idx + "featureMap: " + featureMap.toString());
                }
                CodeResult codeResult = FeatureCoder.code(FeatureListConstant.getFeatureInfo(modelKeyEnum.getPsIndex()), psModelSample.getFeatureMap());
                LabeledPoint labeledPoint = null;
                Feature feature = codeResult.getFeature();
                if (feature == null) continue;
                SparseVector sv = SampleParse.toSparseVector(feature);
                double label = row.getLong(0);
                String type = featureMap.getOrDefault(convertType, "");
                if (type.equalsIgnoreCase("2") || type.equalsIgnoreCase("3")) {
                    label *= 5.0;
                }
                labeledPoint = new LabeledPoint(label, sv);
                samples.add(labeledPoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelKeyEnum.getType() == 1) {
            SparseFMWithFTRLApp.runMatrialOffline(modelKeyEnum.getPsIndex(), samples, isReplay, partNums, modelKeyEnum.getNegativeSampleRatio(), batchSize);
        }
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "   ModelBo.runOnMsg  end");
    }

    private static Set<String> getAdvertSet(Row[] advertRow) {
        HashSet<String> advertSet = new HashSet<String>();
        for (Row row : advertRow) {
            advertSet.add(String.valueOf(row.getLong(0)));
        }
        return advertSet;
    }

    private static Set<String> getConvertAdvertSet(String convertStr, Set<String> rawSet) {
        HashSet<String> advertSet = new HashSet<String>();
        if (convertStr.length() > 0) {
            String[] tmpArray;
            String tmp = convertStr.replaceAll("[{}]", "");
            for (String arr : tmpArray = tmp.split(",")) {
                String[] tmpArray2;
                if (!arr.contains("=") && rawSet.contains(arr)) {
                    advertSet.add(arr);
                }
                if (!arr.contains("=") || (tmpArray2 = arr.split("=")).length < 2 || !rawSet.contains(tmpArray2[1])) continue;
                advertSet.add(tmpArray2[1]);
            }
        }
        return advertSet;
    }

    public static void main(String[] args) {
        try {
            String tmp = "{\"f832002\":\"\",\"f832001\":\"\",\"f832004\":\"\",\"f832003\":\"\",\"f213001\":\"157,109,97,169,205,27,289,271,37\",\"f213002\":\"2617,2761,1945,193,205,85,2197,25,1861,253,2797,565,1,517,289,157,1405,2857,2833,277,1069,301,181,1201,421,169,433,37,229,1465,121,313\",\"f213003\":\"157,109,28,289,270,37\",\"f213004\":\"2617,277,1945,193,1069,205,301,182,1201,421,85,253,433,37,565,1,517,121,2857\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f809001\":\"6\",\"f809002\":\"10\",\"f144009\":\"0\",\"f224004\":\"7204,694,564\",\"f224005\":\"64967,67607,67472,72116,69529,71809,66090,70854,71362,72290\",\"f144007\":\"0\",\"f224002\":\"2617,253,205\",\"f144008\":\"0\",\"f224003\":\"3,34,202,68\",\"f144005\":\"0\",\"f144006\":\"0\",\"f224001\":\"10,13,73,25\",\"f144003\":\"0\",\"f144004\":\"0\",\"f144001\":\"0\",\"f144002\":\"0\",\"f201001\":\"76401\",\"f660001\":\"21\",\"f660003\":\"0\",\"f660004\":\"0\",\"f144010\":\"0\",\"f810001\":\"12\",\"f810002\":\"8\",\"f306001\":\"2\",\"chargeType\":\"2\",\"f601001\":\"-1\",\"f601002\":\"9\",\"f223003\":\"10,13,73\",\"f223004\":\"253\",\"f223001\":\"10,13,73,25\",\"f223002\":\"2617,253,1405,157,205\",\"f410001\":\"0\",\"f223009\":\"64967,67607,66090,66206,70854,71362,72290,65521,69529,71809,67472,72116\",\"f811001\":\"102,302,402\",\"f223007\":\"4,36,208\",\"f223008\":\"702\",\"f223005\":\"9,35,210,69\",\"f223006\":\"7206,696,3870,430,566\",\"f212004\":\"4155,4373,452,3092,4248,318,1694,490,300,1903,1941,680,147,3491,2960,414,699,71,4452,4430,896,15,831,376,466,205,4533,507\",\"f212003\":\"250,183,156,98,44,467,245,433,67\",\"f212002\":\"4156,4374,3092,4250,318,338,1941,147,3491,52,2960,1233,413,1651,4456,4431,896,15,832,470,261,2237,4527,4493,447,1694,489,300,4471,1903,679,1246,3376,4395,280,691,71,376,2332,996,204,508\",\"f212001\":\"250,278,50,466,185,156,98,335,241,432,89,386,63\",\"f602001\":\"9\",\"f211003\":\"157,109,97,61,26,289,145,270,39\",\"f211002\":\"2617,2761,1945,2677,193,205,1225,85,2197,25,1861,769,253,1033,2809,2797,565,1,517,289,157,1405,2857,2833,277,1069,301,182,2821,1201,421,781,2125,2773,169,433,37,229,1465,625,121,313\",\"f211001\":\"157,169,26,289,109,97,61,205,145,270,49,241,38\",\"f811002\":\"102,302,402\",\"f670001\":\"39ac7ff65e31a528cb2f1449cbe41cf6\",\"f670002\":\"0\",\"f660201\":\"0\",\"f211004\":\"2617,2761,277,1945,2677,193,1069,301,182,1201,1225,421,85,2197,1861,253,433,37,2809,2797,565,1,517,229,289,121,2857,313\",\"f112001\":\"05.02.0001,05.02.0018,05.02.0008,05.02.0019\",\"f101001\":\"69965\",\"f602002\":\"9\",\"f222001\":\"61,9,13,73,25\",\"f222003\":\"124,10,32,144,53\",\"f222002\":\"10,13,73,25\",\"orderId\":\"taw-2417565643690177\",\"f113001\":\"04.01.0006,04.03.0001,04.03.0005,04.03.0017,04.03.0007,04.03.0018\",\"f812001\":\"0\",\"f812002\":\"0\",\"f222005\":\"63912,67472,68524,71964,72116,67607,72351,72623,72763,72847,65806,65930,68810,71362,72506,72814,52921,65273,68809,68837,69529,71809,72093,72321,72481,72485,72505,72513\",\"f222004\":\"9,33,145\",\"f360005\":\"4\",\"f812010\":\"0\",\"f502001\":\"1\",\"f502002\":\"1\",\"f502004\":\"6\",\"f812007\":\"0\",\"f812008\":\"0\",\"f812009\":\"0\",\"f812003\":\"0\",\"f812004\":\"0\",\"f812005\":\"0\",\"f812006\":\"0\",\"f770501\":\"0\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f102001\":\"02.01.0003\",\"f301001\":\"22854\",\"f221002\":\"10,13,73\",\"f221001\":\"61,9,14,73,25\",\"f221004\":\"15,34,128\",\"f221003\":\"110,15,33,127,52\",\"advertId\":\"69965\",\"f210001\":\"157,169,25,289,277,109,97,63,205,145,267,49,241,39\",\"f210002\":\"2617,2761,1945,733,2677,193,205,1227,85,2197,25,1861,769,253,1033,2809,2797,566,1,517,289,157,1405,2857,2833,277,1069,301,181,2821,1201,421,781,2125,2773,169,433,37,229,1465,625,121,313\",\"f770401\":\"0\",\"f210003\":\"157,109,97,62,205,27,289,145,267,241,39\",\"f770402\":\"0\",\"f210004\":\"2617,2761,277,1945,2677,193,1069,301,181,2821,1201,1226,421,85,2197,1861,2773,253,433,37,2809,2797,566,1,517,229,289,121,2857,313\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f312001\":\"4\",\"f303001\":\"28\",\"consumerId\":\"25307076785\",\"f406001\":\"0\",\"f220001\":\"61,9,14,73,25\",\"f115001\":\"2\",\"f220002\":\"10,13,73\",\"f605001\":\"1\",\"f605002\":\"1\",\"f302001\":\"22854\",\"f608001\":\"0\",\"f104001\":\"104485\",\"f414003\":\"22,33\",\"f414004\":\"0\",\"f414007\":\"null\",\"f414005\":\"null\",\"f311001\":\"22854\",\"f505001\":\"1700-2699\",\"f770102\":\"1\",\"f413003\":\"23,242,224,33\",\"f413006\":\"0\",\"f413007\":\"null\",\"f413004\":\"0\",\"f413005\":\"null\",\"f609001\":\"0\",\"f804004\":\"8\",\"f804003\":\"12\",\"f804002\":\"14\",\"f804001\":\"18\",\"f770001\":\"07.19.0019\",\"f415004\":\"0\",\"f415005\":\"null\",\"f415003\":\"22,32\",\"f415007\":\"null\",\"f206001\":\"293\",\"f504001\":\"OPPO R9sk\",\"f607001\":\"1\",\"f680001\":\"0\",\"f680002\":\"0\",\"f680003\":\"0\",\"f206002\":\"28\",\"f403004\":\"0\",\"f805001\":\"27\",\"f805002\":\"19\",\"f805003\":\"14\",\"f805004\":\"11\",\"f9702\":\"0\",\"f205002\":\"268\",\"f205001\":\"27\",\"f701001\":\"3069965\",\"f404003\":\"workother\",\"f106001\":\"19316\",\"f701002\":\"1076401\",\"f9607\":\"null\",\"f9608\":\"null\",\"f9609\":\"null\",\"f503001\":\"1401\",\"time\":\"20201123010625\",\"f9601\":\"null\",\"f9602\":\"null\",\"f9603\":\"null\",\"f411001\":\"0\",\"f411003\":\"6\",\"f411002\":\"0\",\"f411005\":\"null\",\"f411004\":\"0\",\"f331001\":\"2\",\"f508002\":\"R9sk\",\"f806001\":\"29\",\"f508001\":\"OPPO\",\"f806002\":\"17\",\"f806003\":\"15\",\"f830101\":\"null,71761_69965,72063_69965,71589_69965\",\"f9916\":\"02.01.0003&3,02.23.0001&3,02.06&5\",\"f806004\":\"10\",\"f830102\":\"null,36927_19316,14164_19316,27605_19316\",\"f508006\":\"Oppo\",\"f9917\":\"02.01.0003&11,02.23.0001&2,02.06&1\",\"f830103\":\"null,07.09.0014_07.19.0019,07.19.0275_07.19.0019,07.19.0273_07.19.0019\",\"f508005\":\"OPPO\",\"f9918\":\"02.01.0003&2,02.23.0001&2,02.06&1\",\"f830104\":\"null,15_21,21_21,21_21\",\"f508004\":\"R9sk\",\"f9919\":\"02.01.0003&10,02.23.0001&10,02.06&6\",\"f508003\":\"OPPO\",\"f611001\":\"8\",\"f9903\":\"0\",\"f141016\":\"0\",\"f141018\":\"0\",\"f830001\":\"71761,72063,71589\",\"f830002\":\"36927,14164,27605\",\"f830003\":\"07.09.0014,07.19.0275,07.19.0273\",\"f830004\":\"15,21,21\",\"f9930\":\"1\",\"f108001\":\"353013\",\"f807002\":\"15\",\"f9924\":\"02.06\",\"f807001\":\"26\",\"f507001\":\"1\",\"f807004\":\"9\",\"f830111\":\"null\",\"f807003\":\"14\",\"f830112\":\"null\",\"f9927\":\"0\",\"f830113\":\"null\",\"f9928\":\"2\",\"f830114\":\"null\",\"f9929\":\"0\",\"f507003\":\"Android6.0.1\",\"f9921\":\"\",\"f9922\":\"02.01.0003,02.23.0001\",\"f9923\":\"\",\"f9802\":\"0\",\"f226007\":\"1\",\"f226006\":\"1\",\"f226005\":\"1\",\"f226004\":\"1\",\"f226003\":\"1\",\"f226002\":\"1\",\"f226001\":\"1\",\"f610001\":\"0\",\"f143010\":\"0\",\"f226008\":\"1\",\"f108003\":\"353013\",\"f830011\":\"{0=71761,71589, 2=, 3=, 2_3_11=}\",\"f830012\":\"{0=36927,27605, 2=, 3=, 2_3_11=}\",\"f830013\":\"{0=07.09.0014,07.19.0273, 2=, 3=, 2_3_11=}\",\"f830014\":\"{0=15,21, 2=, 3=, 2_3_11=}\",\"f109001\":\"8\",\"f808002\":\"0_10,02.01.0003_8,02.23.0001_13,02.06_0\",\"f506001\":\"2\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"0_6,02.01.0003_12,02.23.0001_7,02.06_1\",\"f8803\":\"1\",\"f143007\":\"0\",\"f225006\":\"10\",\"f143006\":\"0\",\"f250302\":\"536,376,584,354,2319,815,493,838,76,1089,4,996,240\",\"f225005\":\"10\",\"f143009\":\"0\",\"f412002\":\"0\",\"f250301\":\"318,62,558,515,76\",\"f225004\":\"10\",\"f143008\":\"0\",\"f412001\":\"0\",\"f225003\":\"10\",\"f143003\":\"0\",\"f412004\":\"0\",\"f225002\":\"2\",\"f143002\":\"0\",\"f412003\":\"5\",\"f225001\":\"10,13\",\"f143005\":\"0\",\"f412006\":\"0\",\"f143004\":\"0\",\"f412005\":\"null\",\"f143001\":\"0\",\"f831001\":\"71761,71589\",\"f831002\":\"36927,27605\",\"f831003\":\"07.09.0014,07.19.0273\",\"f831004\":\"15,21\",\"f214001\":\"318,215,187,326,393,61,558,515,76\",\"f214002\":\"5022,5293,3733,377,399,165,4213,51,3567,493,5361,1089,5,996,562,308,2700,5493,5443,536,2049,583,354,2319,815,331,838,76,438,2810,240,606\",\"f214003\":\"318,214,62,558,515,76\",\"f214004\":\"5022,536,3732,376,2049,584,354,2319,815,164,493,838,76,1089,4,996,240,5495\"}";
            Map map = (Map)JSON.parseObject((String)tmp, Map.class);
            String con = map.getOrDefault("f830011", "");
            System.out.println("con : " + con);
            System.out.println(con.replaceAll("[{}]", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String setStr = "[0,3,7]";
        Set backTypeSet = (Set)JSON.parseObject((String)setStr, Set.class);
        backTypeSet.add(2L);
        System.out.println("backTypeSet=" + JSON.toJSONString((Object)backTypeSet));
        System.out.println("i=3," + backTypeSet.contains(3));
        System.out.println("i=3," + backTypeSet.contains(3L));
        for (int i = 0; i < 4; ++i) {
            Long key = (long)i + 0L;
            System.out.println("i=" + i + "," + backTypeSet.contains(key));
        }
    }
}

