/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo;

import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.compute.biz.bo.HbaseBaseBo;
import cn.com.duiba.nezha.compute.biz.bo.IPsBo;
import cn.com.duiba.nezha.compute.biz.constant.ps.PsConstant;
import cn.com.duiba.nezha.compute.biz.dto.PsModelBaseInfo;
import cn.com.duiba.nezha.compute.biz.dto.PsModelSample;
import cn.com.duiba.nezha.compute.biz.dto.stat.ExpOrderSample;
import cn.com.duiba.nezha.compute.biz.dto.stat.MatchOrderSample;
import cn.com.duiba.nezha.compute.biz.dto.stat.OrderStatSample;
import cn.com.duiba.nezha.compute.biz.enums.AdvertTypeEnum;
import cn.com.duiba.nezha.compute.biz.enums.hbase.HbaseOpsEnum;
import cn.com.duiba.nezha.compute.biz.utils.cachekey.PsKey;
import cn.com.duiba.nezha.compute.core.CollectionUtil;
import cn.com.duiba.nezha.compute.core.model.ops.CollectionOps;
import cn.com.duiba.nezha.compute.core.model.ps.PsMatrix;
import cn.com.duiba.nezha.compute.core.model.ps.PsModel;
import cn.com.duiba.nezha.compute.core.model.ps.PsVector;
import cn.com.duiba.nezha.compute.core.util.DataUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.spark.mllib.linalg.SparseVector;
import scala.collection.Iterator;
import scala.collection.immutable.Map;

public class PsBo
extends HbaseBaseBo
implements IPsBo {
    public static FM getModel(String modelId) throws Exception {
        FM fmModel = null;
        if (modelId != null) {
            String rowKey = PsKey.getRowKeyOfModel(modelId);
            fmModel = PsBo.get(PsConstant.TABLE_NAME_MODEL, rowKey, PsConstant.FAMILY_MODEL, PsConstant.COL_MODEL, FM.class);
        }
        return fmModel;
    }

    public static List<String> getOrderList(List<String> timeList, AdvertTypeEnum taskType) throws Exception {
        List<String> rowKeyList;
        ArrayList<String> ret = new ArrayList<String>();
        java.util.Map<String, java.util.Map<String, String>> retTmp = null;
        if (taskType == null || AdvertTypeEnum.HD_STAT.equals((Object)taskType)) {
            rowKeyList = PsKey.getRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.TABLE_NAME_STAT_INDEX_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (taskType == null || AdvertTypeEnum.HD_AD.equals((Object)taskType)) {
            rowKeyList = PsKey.getRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.DISPLAY_AD.equals((Object)taskType)) {
            rowKeyList = PsKey.getRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.V_ADD_AD.equals((Object)taskType)) {
            rowKeyList = PsKey.getADXRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.ZZ_TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.ADX_AD.equals((Object)taskType)) {
            rowKeyList = PsKey.getADXRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.ADX_TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.ADX_IDEA.equals((Object)taskType)) {
            rowKeyList = PsKey.getADXRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.ADX_IDEA_TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.ACT_RES_PLUG.equals((Object)taskType)) {
            rowKeyList = PsKey.getADXRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.ACT_RESPLUG_TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.ACT_TITLE.equals((Object)taskType)) {
            rowKeyList = PsKey.getADXRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.ACT_TITLE_TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.ACT_INTER.equals((Object)taskType)) {
            rowKeyList = PsKey.getADXRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.ACT_INTER_TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.PLUG_INTER.equals((Object)taskType)) {
            rowKeyList = PsKey.getADXRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.PLUG_INTER_TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.DPA_ACT.equals((Object)taskType) || AdvertTypeEnum.DPA_ACT_NON_SDK.equals((Object)taskType) || AdvertTypeEnum.DPA_INTERCEPT.equals((Object)taskType)) {
            rowKeyList = PsKey.getADXRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.DPA_ACT_TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.MATERIAL.equals((Object)taskType)) {
            rowKeyList = PsKey.getADXRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.MATERIAL_TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.API_MATERIAL.equals((Object)taskType)) {
            rowKeyList = PsKey.getADXRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.API_MATERIAL_TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (AdvertTypeEnum.DP.equals((Object)taskType)) {
            rowKeyList = PsKey.getADXRowKeyOfOrderIds(timeList);
            retTmp = PsBo.mget(PsConstant.DP_TABLE_NAME_ORDER_MSG_LIST, rowKeyList, PsConstant.FAMILY_ORDER_LIST);
        }
        if (retTmp != null) {
            for (java.util.Map<String, String> kv : retTmp.values()) {
                if (kv == null) continue;
                ret.addAll(kv.keySet());
            }
        }
        return ret;
    }

    public static List<String> getOrderList(List<String> timeList) throws Exception {
        return PsBo.getOrderList(timeList, AdvertTypeEnum.HD_AD);
    }

    public static List<String> getOrderListTest(List<String> timeList) throws Exception {
        return PsBo.getOrderList(timeList, AdvertTypeEnum.HD_AD);
    }

    public static List<String> getADXOrderList(List<String> timeList) throws Exception {
        return PsBo.getOrderList(timeList, AdvertTypeEnum.ADX_AD);
    }

    public static List<String> getADXIDEAOrderList(List<String> timeList) throws Exception {
        return PsBo.getOrderList(timeList, AdvertTypeEnum.ADX_IDEA);
    }

    public static List<String> getZZOrderList(List<String> timeList) throws Exception {
        return PsBo.getOrderList(timeList, AdvertTypeEnum.V_ADD_AD);
    }

    public static List<PsModelSample> getPsSample(List<String> orderIdList, AdvertTypeEnum advertTypeEnum) throws Exception {
        List<PsModelSample> ret = null;
        if (AdvertTypeEnum.ADX_AD.equals((Object)advertTypeEnum) || AdvertTypeEnum.ADX_IDEA.equals((Object)advertTypeEnum)) {
            ret = PsBo.getADXPsSample(orderIdList);
        }
        if (AdvertTypeEnum.DISPLAY_AD.equals((Object)advertTypeEnum)) {
            ret = PsBo.getPsSample(orderIdList);
        }
        if (advertTypeEnum == null || AdvertTypeEnum.HD_AD.equals((Object)advertTypeEnum)) {
            ret = PsBo.getPsSample(orderIdList);
        }
        if (AdvertTypeEnum.V_ADD_AD.equals((Object)advertTypeEnum)) {
            ret = PsBo.getZZPsSample(orderIdList);
        }
        if (AdvertTypeEnum.ACT_RES_PLUG.equals((Object)advertTypeEnum)) {
            ret = PsBo.getACTPsSample(orderIdList);
        }
        if (AdvertTypeEnum.ACT_TITLE.equals((Object)advertTypeEnum)) {
            ret = PsBo.getACTTitlePsSample(orderIdList);
        }
        if (AdvertTypeEnum.ACT_INTER.equals((Object)advertTypeEnum)) {
            ret = PsBo.getACTInterceptPsSample(orderIdList);
        }
        if (AdvertTypeEnum.PLUG_INTER.equals((Object)advertTypeEnum)) {
            ret = PsBo.getPLUGInterceptPsSample(orderIdList);
        }
        if (AdvertTypeEnum.DPA_ACT.equals((Object)advertTypeEnum) || AdvertTypeEnum.DPA_ACT_NON_SDK.equals((Object)advertTypeEnum) || AdvertTypeEnum.DPA_INTERCEPT.equals((Object)advertTypeEnum)) {
            ret = PsBo.getDPAACTPsSample(orderIdList);
        }
        if (AdvertTypeEnum.MATERIAL.equals((Object)advertTypeEnum)) {
            ret = PsBo.getMaterialPsSample(orderIdList);
        }
        return ret;
    }

    public static List<ExpOrderSample> getExpStatSample(List<String> orderIdList) throws Exception {
        List<ExpOrderSample> ret = PsBo.mget(PsConstant.TABLE_NAME_STAT_SAMPLE_LIST, orderIdList, PsConstant.FAMILY_SAMPLE, ExpOrderSample.class);
        return ret;
    }

    public static List<PsModelSample> getPsSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.mget(PsConstant.TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getPsAqySample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.aqyMGet(PsConstant.TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getPsAqyAgeSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.aqyAgeMGet(PsConstant.TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getPsSDKSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.sdkMGet(PsConstant.TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getPsExploreSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.exploreMGet(PsConstant.TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getPsNExploreSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.nExploreMGet(PsConstant.TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getExploreBCvrSample(List<String> orderIdList) throws Exception {
        return PsBo.exploreMgetBCvr(PsConstant.TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
    }

    public static List<PsModelSample> getNExploreBCvrSample(List<String> orderIdList) throws Exception {
        return PsBo.nExploreMgetBCvr(PsConstant.TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
    }

    public static List<PsModelSample> getSDKBCvrSample(List<String> orderIdList) throws Exception {
        return PsBo.sdkMgetBCvr(PsConstant.TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
    }

    public static List<OrderStatSample> getStatSample(List<String> orderIdList) throws Exception {
        List<OrderStatSample> ret = PsBo.mget(PsConstant.TABLE_NAME_STAT_SAMPLE_LIST, orderIdList, PsConstant.FAMILY_SAMPLE, OrderStatSample.class);
        return ret;
    }

    public static List<MatchOrderSample> getStatSample2(List<String> orderIdList) throws Exception {
        List<MatchOrderSample> ret = PsBo.mget(PsConstant.TABLE_NAME_STAT_SAMPLE_LIST, orderIdList, PsConstant.FAMILY_SAMPLE, MatchOrderSample.class);
        return ret;
    }

    public static List<PsModelSample> getADXPsSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.mget(PsConstant.ADX_TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getACTPsSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.mget(PsConstant.ACT_TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getACTTitlePsSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.mget(PsConstant.ACT_TITLE_TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getACTInterceptPsSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.mget(PsConstant.ACT_INTER_TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getPLUGInterceptPsSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.mget(PsConstant.PLUG_INTER_TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getDPAACTPsSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.mget(PsConstant.DPA_ACT_TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static java.util.Map<String, java.util.Map<String, String>> getDpPsSampleHbaseData(List<String> orderIdList) throws Exception {
        java.util.Map<String, java.util.Map<String, String>> map = PsBo.mget(PsConstant.DP_TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE);
        return map;
    }

    public static List<PsModelSample> getDpPsSampleHbase(java.util.Map<String, java.util.Map<String, String>> map) throws Exception {
        ArrayList<PsModelSample> list = new ArrayList<PsModelSample>();
        for (Map.Entry<String, java.util.Map<String, String>> entry : map.entrySet()) {
            PsModelSample sample = PsBo.getPsModelSampleDp(entry.getValue());
            if (sample == null) continue;
            list.add(sample);
        }
        return list;
    }

    private static PsModelSample getPsModelSampleDp(java.util.Map<String, String> map) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        PsModelSample sample = new PsModelSample();
        if (map.containsKey("f")) {
            sample.setFeature(map.get("f"));
        }
        if (map.containsKey("joinCnt")) {
            Long joinCnt = Long.parseLong(map.get("joinCnt"));
            sample.setIsClick(Long.valueOf(joinCnt > 0L ? 1 : 0));
        }
        if (map.containsKey("fee")) {
            Long fee = Long.parseLong(map.get("fee"));
            sample.setChargeFee((double)fee);
        }
        return sample;
    }

    public static List<PsModelSample> getMaterialPsSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.mget(PsConstant.MATERIAL_TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static java.util.Map<String, java.util.Map<String, String>> getMaterialPsSampleHbaseData(List<String> orderIdList) throws Exception {
        java.util.Map<String, java.util.Map<String, String>> map = PsBo.mget(PsConstant.MATERIAL_TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE);
        return map;
    }

    public static List<PsModelSample> getMaterialPsSampleHbase(java.util.Map<String, java.util.Map<String, String>> map, boolean isAdvertMaterial) throws Exception {
        ArrayList<PsModelSample> list = new ArrayList<PsModelSample>();
        for (Map.Entry<String, java.util.Map<String, String>> entry : map.entrySet()) {
            PsModelSample sample = PsBo.getPsModelSampleMaterial(entry.getValue(), isAdvertMaterial);
            if (sample == null) continue;
            list.add(sample);
        }
        return list;
    }

    public static List<PsModelSample> getMaterialPsSampleHbase1(java.util.Map<String, java.util.Map<String, String>> map) throws Exception {
        ArrayList<PsModelSample> list = new ArrayList<PsModelSample>();
        for (Map.Entry<String, java.util.Map<String, String>> entry : map.entrySet()) {
            PsModelSample sample = PsBo.getPsModelSample(entry.getValue());
            if (sample == null) continue;
            list.add(sample);
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PsModelSample getPsModelSampleMaterial(java.util.Map<String, String> map, boolean isAdvertMaterial) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        PsModelSample sample = new PsModelSample();
        if (map.containsKey("feature")) {
            if (isAdvertMaterial) {
                if (!JSONObject.parseObject((String)map.get("feature")).containsKey((Object)"advertFlag")) return null;
                sample.setFeature(map.get("feature"));
            } else {
                if (JSONObject.parseObject((String)map.get("feature")).containsKey((Object)"advertFlag")) {
                    return null;
                }
                sample.setFeature(map.get("feature"));
            }
        }
        if (map.containsKey("isClick")) {
            sample.setIsClick(Long.parseLong(map.get("isClick")));
        }
        long fee = 0L;
        int count = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String column = entry.getKey();
            String columnValue = entry.getValue();
            if (!column.matches("[0-9]*")) continue;
            fee += Long.parseLong(columnValue);
            ++count;
        }
        if (fee <= 0L) return sample;
        sample.setChargeFee(DataUtil.formatDouble((Double)((double)fee / (double)count), (int)4));
        return sample;
    }

    public static List<PsModelSample> getMaterialPsSample1(List<String> orderIdList) throws Exception {
        java.util.Map<String, java.util.Map<String, String>> map = PsBo.mget(PsConstant.MATERIAL_TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE);
        ArrayList<PsModelSample> list = new ArrayList<PsModelSample>();
        for (Map.Entry<String, java.util.Map<String, String>> entry : map.entrySet()) {
            PsModelSample sample = PsBo.getPsModelSample(entry.getValue());
            if (sample == null) continue;
            list.add(sample);
        }
        return list;
    }

    private static PsModelSample getPsModelSample(java.util.Map<String, String> map) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        PsModelSample sample = new PsModelSample();
        if (map.containsKey("feature")) {
            sample.setFeature(map.get("feature"));
        }
        if (map.containsKey("isClick")) {
            sample.setIsClick(Long.parseLong(map.get("isClick")));
        }
        long fee = 0L;
        int count = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String column = entry.getKey();
            String columnValue = entry.getValue();
            if (!column.matches("[0-9]*")) continue;
            fee += Long.parseLong(columnValue);
            ++count;
        }
        if (fee > 0L) {
            sample.setChargeFee(DataUtil.formatDouble((Double)((double)fee / (double)count), (int)4));
        }
        return sample;
    }

    public static List<PsModelSample> getZZPsSample(List<String> orderIdList) throws Exception {
        List<PsModelSample> ret = PsBo.mget(PsConstant.ZZ_TABLE_NAME_SAMPLE, orderIdList, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    public static List<PsModelSample> getPsSample(Iterator<String> partitionOfRecords) throws Exception {
        return PsBo.getPsSample(CollectionUtil.toList(partitionOfRecords));
    }

    public PsModelSample getPsSample(String orderId) throws Exception {
        String rowKey = PsKey.getRowKeyOfPsSample(orderId);
        PsModelSample ret = PsBo.get(PsConstant.TABLE_NAME_SAMPLE, rowKey, PsConstant.FAMILY_SAMPLE, PsModelSample.class);
        return ret;
    }

    @Override
    public PsModelBaseInfo getPsBaseInfo(String modelId) throws Exception {
        String rowKey = PsKey.getRowKeyOfPsBaseInfo(modelId);
        PsModelBaseInfo ret = PsBo.get(PsConstant.TABLE_NAME_BASE_INFO, rowKey, PsConstant.FAMILY_BASE_INFO, PsModelBaseInfo.class);
        return ret;
    }

    @Override
    public void deletePsBaseInfo(String modelId) throws Exception {
        String rowKey = PsKey.getRowKeyOfPsBaseInfo(modelId);
        PsBo.deleteSingleValue(PsConstant.TABLE_NAME_BASE_INFO, rowKey);
    }

    @Override
    public void updatePsBaseInfo(String modelId, PsModelBaseInfo psModelBaseInfo) throws Exception {
        String rowKey = PsKey.getRowKeyOfPsBaseInfo(modelId);
        if (psModelBaseInfo != null) {
            PsBo.insert(PsConstant.TABLE_NAME_BASE_INFO, rowKey, PsConstant.FAMILY_BASE_INFO, psModelBaseInfo);
        }
    }

    @Override
    public PsModel searchPsModel(PsModel psModel, PsModelBaseInfo psModelBaseInfo, boolean isAll) throws Exception {
        if (psModel == null) {
            return null;
        }
        Map valMap = psModel.getValueMap();
        String valRowKey = PsKey.getValKey(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion());
        Map<String, Object> valNewMap = this.searchSingleValue(CollectionOps.getStringKeys((Map)valMap), valRowKey);
        Map vMap = psModel.getVectorMap();
        String[] vMapKeys = CollectionOps.getPsVectorMapKeys((Map)vMap);
        PsVector[] vMapValues = CollectionOps.getPsVectorMapValues((Map)vMap, (String[])vMapKeys);
        PsVector[] vMapNewValues = new PsVector[vMapKeys.length];
        for (int i = 0; i < vMapKeys.length; ++i) {
            String vRowKeyPrefix = PsKey.getVectorParRowKeyPrefix(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion(), vMapKeys[i]);
            vMapNewValues[i] = this.searchPsVector(vMapValues[i], vRowKeyPrefix, isAll);
        }
        Map mMap = psModel.getMatrixMap();
        String[] mMapKeys = CollectionOps.getPsMatrixMapKeys((Map)mMap);
        PsMatrix[] mMapValues = CollectionOps.getPsMatrixMapValues((Map)mMap, (String[])mMapKeys);
        PsMatrix[] mMapNewValues = new PsMatrix[mMapKeys.length];
        for (int i = 0; i < mMapKeys.length; ++i) {
            String mRowKeySubPrefix = PsKey.getMatrixParRowKeySubPrefix(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion(), mMapKeys[i]);
            mMapNewValues[i] = this.searchPsMatrix(mMapValues[i], mRowKeySubPrefix, isAll);
        }
        PsModel ret = new PsModel(valNewMap, CollectionOps.toPsVectorMap((String[])vMapKeys, (PsVector[])vMapNewValues), CollectionOps.toPsMatrixMap((String[])mMapKeys, (PsMatrix[])mMapNewValues), psModelBaseInfo.getParSize());
        return ret;
    }

    @Override
    public void updatePsModel(PsModel psModel, PsModelBaseInfo psModelBaseInfo, HbaseOpsEnum hbaseOpsEnum) throws Exception {
        if (psModel == null) {
            return;
        }
        Map valMap = psModel.getValueMap();
        String valRowKey = PsKey.getValKey(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion());
        this.updateSingleValue(valRowKey, (Map<String, Object>)valMap, hbaseOpsEnum);
        Map vMap = psModel.getVectorMap();
        String[] vMapKeys = CollectionOps.getPsVectorMapKeys((Map)vMap);
        PsVector[] vMapValues = CollectionOps.getPsVectorMapValues((Map)vMap, (String[])vMapKeys);
        for (int i = 0; i < vMapKeys.length; ++i) {
            String vRowKeyPrefix = PsKey.getVectorParRowKeyPrefix(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion(), vMapKeys[i]);
            this.updatePsVector(vMapValues[i], vRowKeyPrefix, hbaseOpsEnum);
        }
        Map mMap = psModel.getMatrixMap();
        String[] mMapKeys = CollectionOps.getPsMatrixMapKeys((Map)mMap);
        PsMatrix[] mMapValues = CollectionOps.getPsMatrixMapValues((Map)mMap, (String[])mMapKeys);
        for (int i = 0; i < mMapKeys.length; ++i) {
            String mRowKeySubPrefix = PsKey.getMatrixParRowKeySubPrefix(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion(), mMapKeys[i]);
            this.updatePsMatrix(mMapValues[i], mRowKeySubPrefix, hbaseOpsEnum);
        }
    }

    @Override
    public PsMatrix searchPsMatrix(PsMatrix psMatrix, String subPrefixKey, boolean isAll) throws Exception {
        if (psMatrix == null) {
            return null;
        }
        Map psVectorMap = psMatrix.psVectorMap();
        int[] mapKeys = CollectionOps.getPsVectorMapIntKeys((Map)psVectorMap);
        PsVector[] mapValues = CollectionOps.getPsVectorMapValues((Map)psVectorMap, (int[])mapKeys);
        PsVector[] mapNewValues = new PsVector[mapKeys.length];
        for (int i = 0; i < mapKeys.length; ++i) {
            String rowKeyPrefix = PsKey.getMatrixParRowKeyPrefix(subPrefixKey, mapKeys[i]);
            mapNewValues[i] = this.searchPsVector(mapValues[i], rowKeyPrefix, isAll);
        }
        PsMatrix ret = new PsMatrix(CollectionOps.toPsVectorMap((int[])mapKeys, (PsVector[])mapNewValues), psMatrix.numRows(), psMatrix.numCols());
        return ret;
    }

    @Override
    public void updatePsMatrix(PsMatrix psMatrix, String subPrefixKey, HbaseOpsEnum hbaseOpsEnum) throws Exception {
        if (psMatrix == null) {
            return;
        }
        Map psVectorMap = psMatrix.psVectorMap();
        int[] mapKeys = CollectionOps.getPsVectorMapIntKeys((Map)psVectorMap);
        PsVector[] mapValues = CollectionOps.getPsVectorMapValues((Map)psVectorMap, (int[])mapKeys);
        for (int i = 0; i < mapKeys.length; ++i) {
            String rowKeyPrefix = PsKey.getMatrixParRowKeyPrefix(subPrefixKey, mapKeys[i]);
            this.updatePsVector(mapValues[i], rowKeyPrefix, hbaseOpsEnum);
        }
    }

    @Override
    public PsVector searchPsVector(PsVector psVector, String rowKeyPrefix, boolean isAll) throws Exception {
        if (psVector == null) {
            return null;
        }
        Map parVectorMap = psVector.parVectorMap();
        int[] mapKeys = CollectionOps.getSparseVectorMapKeys((Map)parVectorMap);
        SparseVector[] mapValues = CollectionOps.getSparseVectorMapValues((Map)parVectorMap, (int[])mapKeys);
        SparseVector[] mapNewValues = new SparseVector[mapKeys.length];
        for (int i = 0; i < mapKeys.length; ++i) {
            String rowKey = PsKey.getParRowKey(rowKeyPrefix, mapKeys[i]);
            mapNewValues[i] = isAll ? PsBo.searchSparseVector(PsConstant.TABLE_NAME_MODEL, rowKey, PsConstant.FAMILY_MODEL, psVector.vectorSize()) : PsBo.searchSparseVector(PsConstant.TABLE_NAME_MODEL, rowKey, PsConstant.FAMILY_MODEL, mapValues[i]);
        }
        PsVector ret = new PsVector(CollectionOps.toSparseVectorMap((int[])mapKeys, (SparseVector[])mapNewValues), psVector.parSize(), psVector.vectorSize());
        return ret;
    }

    @Override
    public void updatePsVector(PsVector psVector, String rowKeyPrefix, HbaseOpsEnum hbaseOpsEnum) throws Exception {
        if (psVector == null) {
            return;
        }
        Map parVectorMap = psVector.parVectorMap();
        int[] mapKeys = CollectionOps.getSparseVectorMapKeys((Map)parVectorMap);
        SparseVector[] mapValues = CollectionOps.getSparseVectorMapValues((Map)parVectorMap, (int[])mapKeys);
        for (int i = 0; i < mapKeys.length; ++i) {
            String rowKey = PsKey.getParRowKey(rowKeyPrefix, mapKeys[i]);
            if (HbaseOpsEnum.INCREMENT.equals((Object)hbaseOpsEnum)) {
                PsBo.incrementSparseVector(PsConstant.TABLE_NAME_MODEL, rowKey, PsConstant.FAMILY_MODEL, mapValues[i]);
            }
            if (HbaseOpsEnum.INSERT_AND_UPDATE.equals((Object)hbaseOpsEnum)) {
                PsBo.insertSparseVector(PsConstant.TABLE_NAME_MODEL, rowKey, PsConstant.FAMILY_MODEL, mapValues[i]);
            }
            if (!HbaseOpsEnum.DELETE.equals((Object)hbaseOpsEnum)) continue;
            PsBo.deleteSparseVector(PsConstant.TABLE_NAME_MODEL, rowKey);
        }
    }

    @Override
    public Map<String, Object> searchSingleValue(String[] colKeys, String rowKey) throws Exception {
        if (colKeys == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        CollectionUtils.addAll(set, (Object[])colKeys);
        java.util.Map<String, Double> map = PsBo.searchSingleValue(PsConstant.TABLE_NAME_MODEL, rowKey, PsConstant.FAMILY_MODEL, set);
        double[] values = new double[colKeys.length];
        for (int i = 0; i < colKeys.length; ++i) {
            String key = colKeys[i];
            Double val = map.get(key);
            values[i] = val != null ? val : 0.0;
        }
        return CollectionOps.toMap((String[])colKeys, (double[])values);
    }

    @Override
    public void updateSingleValue(String rowKey, Map<String, Object> map, HbaseOpsEnum hbaseOpsEnum) throws Exception {
        if (rowKey == null) {
            return;
        }
        String[] mapKeys = CollectionOps.getStringKeys(map);
        double[] mapValues = CollectionOps.getStringMapValues(map, (String[])mapKeys);
        if (HbaseOpsEnum.INCREMENT.equals((Object)hbaseOpsEnum)) {
            PsBo.incrementSingleValue(PsConstant.TABLE_NAME_MODEL, rowKey, PsConstant.FAMILY_MODEL, mapKeys, mapValues);
        }
        if (HbaseOpsEnum.INSERT_AND_UPDATE.equals((Object)hbaseOpsEnum)) {
            PsBo.insertSingleValue(PsConstant.TABLE_NAME_MODEL, rowKey, PsConstant.FAMILY_MODEL, mapKeys, mapValues);
        }
        if (HbaseOpsEnum.DELETE.equals((Object)hbaseOpsEnum)) {
            PsBo.deleteSingleValue(PsConstant.TABLE_NAME_MODEL, rowKey);
        }
    }
}

