/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo;

import cn.com.duiba.nezha.compute.biz.bo.IPsBo;
import cn.com.duiba.nezha.compute.biz.bo.RedisBaseBo;
import cn.com.duiba.nezha.compute.biz.dto.PsModelBaseInfo;
import cn.com.duiba.nezha.compute.biz.enums.hbase.HbaseOpsEnum;
import cn.com.duiba.nezha.compute.biz.utils.cachekey.PsKey;
import cn.com.duiba.nezha.compute.core.model.ops.CollectionOps;
import cn.com.duiba.nezha.compute.core.model.ps.PsMatrix;
import cn.com.duiba.nezha.compute.core.model.ps.PsModel;
import cn.com.duiba.nezha.compute.core.model.ps.PsVector;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.spark.mllib.linalg.SparseVector;

public class PsRedisBo
extends RedisBaseBo
implements IPsBo {
    @Override
    public PsModelBaseInfo getPsBaseInfo(String modelId) throws Exception {
        String rowKey = PsKey.getRowKeyOfPsBaseInfo(modelId);
        PsModelBaseInfo ret = PsRedisBo.get(rowKey, PsModelBaseInfo.class);
        return ret;
    }

    @Override
    public void deletePsBaseInfo(String modelId) throws Exception {
        String rowKey = PsKey.getRowKeyOfPsBaseInfo(modelId);
        PsRedisBo.delete(rowKey);
    }

    @Override
    public void updatePsBaseInfo(String modelId, PsModelBaseInfo psModelBaseInfo) throws Exception {
        String rowKey = PsKey.getRowKeyOfPsBaseInfo(modelId);
        if (psModelBaseInfo != null) {
            PsRedisBo.insert(rowKey, psModelBaseInfo);
        }
    }

    @Override
    public PsModel searchPsModel(PsModel psModel, PsModelBaseInfo psModelBaseInfo, boolean isAll) throws Exception {
        if (psModel == null) {
            return null;
        }
        scala.collection.immutable.Map valMap = psModel.getValueMap();
        String valRowKey = PsKey.getValKey(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion());
        scala.collection.immutable.Map<String, Object> valNewMap = this.searchSingleValue(CollectionOps.getStringKeys((scala.collection.immutable.Map)valMap), valRowKey);
        scala.collection.immutable.Map vMap = psModel.getVectorMap();
        String[] vMapKeys = CollectionOps.getPsVectorMapKeys((scala.collection.immutable.Map)vMap);
        PsVector[] vMapValues = CollectionOps.getPsVectorMapValues((scala.collection.immutable.Map)vMap, (String[])vMapKeys);
        PsVector[] vMapNewValues = new PsVector[vMapKeys.length];
        for (int i = 0; i < vMapKeys.length; ++i) {
            String vRowKeyPrefix = PsKey.getVectorParRowKeyPrefix(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion(), vMapKeys[i]);
            vMapNewValues[i] = this.searchPsVector(vMapValues[i], vRowKeyPrefix, isAll);
        }
        scala.collection.immutable.Map mMap = psModel.getMatrixMap();
        String[] mMapKeys = CollectionOps.getPsMatrixMapKeys((scala.collection.immutable.Map)mMap);
        PsMatrix[] mMapValues = CollectionOps.getPsMatrixMapValues((scala.collection.immutable.Map)mMap, (String[])mMapKeys);
        PsMatrix[] mMapNewValues = new PsMatrix[mMapKeys.length];
        for (int i = 0; i < mMapKeys.length; ++i) {
            String mRowKeySubPrefix = PsKey.getMatrixParRowKeySubPrefix(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion(), mMapKeys[i]);
            mMapNewValues[i] = this.searchPsMatrix(mMapValues[i], mRowKeySubPrefix, isAll);
        }
        PsModel ret = new PsModel(valNewMap, CollectionOps.toPsVectorMap((String[])vMapKeys, (PsVector[])vMapNewValues), CollectionOps.toPsMatrixMap((String[])mMapKeys, (PsMatrix[])mMapNewValues), psModelBaseInfo.getParSize());
        return ret;
    }

    @Override
    public void updatePsModel(PsModel psModel, PsModelBaseInfo psModelBaseInfo, HbaseOpsEnum hbaseOpsEnum) throws Exception {
        if (psModel == null) {
            return;
        }
        scala.collection.immutable.Map valMap = psModel.getValueMap();
        String valRowKey = PsKey.getValKey(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion());
        this.updateSingleValue(valRowKey, (scala.collection.immutable.Map<String, Object>)valMap, hbaseOpsEnum);
        scala.collection.immutable.Map vMap = psModel.getVectorMap();
        String[] vMapKeys = CollectionOps.getPsVectorMapKeys((scala.collection.immutable.Map)vMap);
        PsVector[] vMapValues = CollectionOps.getPsVectorMapValues((scala.collection.immutable.Map)vMap, (String[])vMapKeys);
        for (int i = 0; i < vMapKeys.length; ++i) {
            String vRowKeyPrefix = PsKey.getVectorParRowKeyPrefix(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion(), vMapKeys[i]);
            this.updatePsVector(vMapValues[i], vRowKeyPrefix, hbaseOpsEnum);
        }
        scala.collection.immutable.Map mMap = psModel.getMatrixMap();
        String[] mMapKeys = CollectionOps.getPsMatrixMapKeys((scala.collection.immutable.Map)mMap);
        PsMatrix[] mMapValues = CollectionOps.getPsMatrixMapValues((scala.collection.immutable.Map)mMap, (String[])mMapKeys);
        for (int i = 0; i < mMapKeys.length; ++i) {
            String mRowKeySubPrefix = PsKey.getMatrixParRowKeySubPrefix(psModelBaseInfo.getModelId(), psModelBaseInfo.getVersion(), mMapKeys[i]);
            this.updatePsMatrix(mMapValues[i], mRowKeySubPrefix, hbaseOpsEnum);
        }
    }

    @Override
    public PsMatrix searchPsMatrix(PsMatrix psMatrix, String subPrefixKey, boolean isAll) throws Exception {
        if (psMatrix == null) {
            return null;
        }
        scala.collection.immutable.Map psVectorMap = psMatrix.psVectorMap();
        int[] mapKeys = CollectionOps.getPsVectorMapIntKeys((scala.collection.immutable.Map)psVectorMap);
        PsVector[] mapValues = CollectionOps.getPsVectorMapValues((scala.collection.immutable.Map)psVectorMap, (int[])mapKeys);
        PsVector[] mapNewValues = new PsVector[mapKeys.length];
        for (int i = 0; i < mapKeys.length; ++i) {
            String rowKeyPrefix = PsKey.getMatrixParRowKeyPrefix(subPrefixKey, mapKeys[i]);
            mapNewValues[i] = this.searchPsVector(mapValues[i], rowKeyPrefix, isAll);
        }
        PsMatrix ret = new PsMatrix(CollectionOps.toPsVectorMap((int[])mapKeys, (PsVector[])mapNewValues), psMatrix.numRows(), psMatrix.numCols());
        return ret;
    }

    @Override
    public void updatePsMatrix(PsMatrix psMatrix, String subPrefixKey, HbaseOpsEnum hbaseOpsEnum) throws Exception {
        if (psMatrix == null) {
            return;
        }
        scala.collection.immutable.Map psVectorMap = psMatrix.psVectorMap();
        int[] mapKeys = CollectionOps.getPsVectorMapIntKeys((scala.collection.immutable.Map)psVectorMap);
        PsVector[] mapValues = CollectionOps.getPsVectorMapValues((scala.collection.immutable.Map)psVectorMap, (int[])mapKeys);
        for (int i = 0; i < mapKeys.length; ++i) {
            String rowKeyPrefix = PsKey.getMatrixParRowKeyPrefix(subPrefixKey, mapKeys[i]);
            this.updatePsVector(mapValues[i], rowKeyPrefix, hbaseOpsEnum);
        }
    }

    @Override
    public PsVector searchPsVector(PsVector psVector, String rowKeyPrefix, boolean isAll) throws Exception {
        if (psVector == null) {
            return null;
        }
        scala.collection.immutable.Map parVectorMap = psVector.parVectorMap();
        int[] mapKeys = CollectionOps.getSparseVectorMapKeys((scala.collection.immutable.Map)parVectorMap);
        SparseVector[] mapValues = CollectionOps.getSparseVectorMapValues((scala.collection.immutable.Map)parVectorMap, (int[])mapKeys);
        SparseVector[] mapNewValues = new SparseVector[mapKeys.length];
        for (int i = 0; i < mapKeys.length; ++i) {
            String rowKey = PsKey.getParRowKey(rowKeyPrefix, mapKeys[i]);
            mapNewValues[i] = isAll ? PsRedisBo.searchSparseVector(rowKey, psVector.vectorSize()) : PsRedisBo.searchSparseVector(rowKey, mapValues[i]);
        }
        PsVector ret = new PsVector(CollectionOps.toSparseVectorMap((int[])mapKeys, (SparseVector[])mapNewValues), psVector.parSize(), psVector.vectorSize());
        return ret;
    }

    @Override
    public void updatePsVector(PsVector psVector, String rowKeyPrefix, HbaseOpsEnum hbaseOpsEnum) throws Exception {
        if (psVector == null) {
            return;
        }
        scala.collection.immutable.Map parVectorMap = psVector.parVectorMap();
        int[] mapKeys = CollectionOps.getSparseVectorMapKeys((scala.collection.immutable.Map)parVectorMap);
        SparseVector[] mapValues = CollectionOps.getSparseVectorMapValues((scala.collection.immutable.Map)parVectorMap, (int[])mapKeys);
        for (int i = 0; i < mapKeys.length; ++i) {
            String rowKey = PsKey.getParRowKey(rowKeyPrefix, mapKeys[i]);
            if (HbaseOpsEnum.INCREMENT.equals((Object)hbaseOpsEnum)) {
                PsRedisBo.incrementSparseVector(rowKey, mapValues[i]);
            }
            if (HbaseOpsEnum.INSERT_AND_UPDATE.equals((Object)hbaseOpsEnum)) {
                PsRedisBo.insertSparseVector(rowKey, mapValues[i]);
            }
            if (!HbaseOpsEnum.DELETE.equals((Object)hbaseOpsEnum)) continue;
            PsRedisBo.deleteSparseVector(rowKey);
        }
    }

    @Override
    public scala.collection.immutable.Map<String, Object> searchSingleValue(String[] colKeys, String rowKey) throws Exception {
        if (colKeys == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        CollectionUtils.addAll(set, (Object[])colKeys);
        Map<String, Double> map = PsRedisBo.searchMapValue(rowKey, set);
        double[] values = new double[colKeys.length];
        for (int i = 0; i < colKeys.length; ++i) {
            String key = colKeys[i];
            Double val = map.get(key);
            values[i] = val != null ? val : 0.0;
        }
        return CollectionOps.toMap((String[])colKeys, (double[])values);
    }

    @Override
    public void updateSingleValue(String rowKey, scala.collection.immutable.Map<String, Object> map, HbaseOpsEnum hbaseOpsEnum) throws Exception {
        if (rowKey == null) {
            return;
        }
        String[] mapKeys = CollectionOps.getStringKeys(map);
        double[] mapValues = CollectionOps.getStringMapValues(map, (String[])mapKeys);
        if (HbaseOpsEnum.INCREMENT.equals((Object)hbaseOpsEnum)) {
            PsRedisBo.incrementMapValue(rowKey, mapKeys, mapValues);
        }
        if (HbaseOpsEnum.INSERT_AND_UPDATE.equals((Object)hbaseOpsEnum)) {
            PsRedisBo.insertMapValue(rowKey, mapKeys, mapValues);
        }
        if (HbaseOpsEnum.DELETE.equals((Object)hbaseOpsEnum)) {
            PsRedisBo.deleteMapValue(rowKey);
        }
    }
}

