/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo.match;

import cn.com.duiba.nezha.compute.biz.bo.PsBo;
import cn.com.duiba.nezha.compute.biz.bo.match.MatchUtil;
import cn.com.duiba.nezha.compute.biz.bo.match.RankMap;
import cn.com.duiba.nezha.compute.biz.bo.match.StatKeyMap;
import cn.com.duiba.nezha.compute.biz.bo.stat.MatchStatisBo;
import cn.com.duiba.nezha.compute.biz.bo.stat.StatSampleBo;
import cn.com.duiba.nezha.compute.biz.bo.stat.StatisAdInfo;
import cn.com.duiba.nezha.compute.biz.conf.JedisPoolConf;
import cn.com.duiba.nezha.compute.biz.dto.stat.MatchOrderSample;
import cn.com.duiba.nezha.compute.biz.enums.AdvertTypeEnum;
import cn.com.duiba.nezha.compute.biz.utils.jedis.JedisUtil;
import cn.com.duiba.nezha.compute.core.enums.DateStyle;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.core.util.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.sql.Row;
import scala.collection.Iterator;

public class MatchBo {
    static JedisUtil jedisUtil1 = new JedisUtil(JedisPoolConf.psJedisConfig);
    static JedisUtil jedisUtil2 = new JedisUtil(JedisPoolConf.jedisConfig);

    public static List<StatisAdInfo> runSparse(Iterator<Row> partitionOfRecords) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo  start");
        ArrayList<StatisAdInfo> samples = new ArrayList<StatisAdInfo>();
        while (partitionOfRecords.hasNext()) {
            Row row = (Row)partitionOfRecords.next();
            try {
                if (row == null) continue;
                StatisAdInfo sample = new StatisAdInfo(0L, 0L, 0L, 0L, 0L, 0L, 0.0, 0.0);
                sample.setRedisKey(row.getString(0) + '_' + row.getLong(1));
                sample.setStatKey(row.getString(0) + '_' + row.getLong(2));
                sample.setKey(row.getString(0) + '_' + row.getLong(1) + '_' + row.getLong(2));
                sample.setAdKey("" + row.getLong(2));
                sample.setSlotId("" + row.getLong(1));
                sample.setExpCnt(row.getLong(3));
                sample.setChargeCnt(row.getLong(4));
                sample.setChargeFees(row.getLong(6));
                sample.setConvert0Cnt(row.getLong(5));
                sample.setConvert3Cnt(row.getLong(7));
                sample.setCvr(MatchUtil.cvr(sample));
                sample.setDcvr(MatchUtil.dcvr(sample));
                samples.add(sample);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("sparse offline samples size" + samples.size());
        return samples;
    }

    public static List<RankMap> rankOff(List<StatisAdInfo> statisAdInfoList) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  MatchBo  start");
        ArrayList<RankMap> res = new ArrayList<RankMap>();
        if (AssertUtil.isNotEmpty(statisAdInfoList)) {
            Map<String, List<StatisAdInfo>> statKey = statisAdInfoList.stream().collect(Collectors.groupingBy(StatisAdInfo::getStatKey));
            for (Map.Entry<String, List<StatisAdInfo>> entry : statKey.entrySet()) {
                RankMap res3;
                RankMap res2;
                HashMap<String, StatisAdInfo> statisAdInfoMap = new HashMap<String, StatisAdInfo>();
                entry.getValue().forEach(item -> statisAdInfoMap.put(item.getSlotId(), (StatisAdInfo)item));
                String offKey = entry.getKey();
                jedisUtil1.setObjectex(offKey, ((Object)statisAdInfoMap).toString(), Constant.DAY_2_EXPIRE);
                RankMap res1 = MatchUtil.rank(statisAdInfoMap, Constant.type1, Constant.num);
                if (res1 != null) {
                    res.add(res1);
                }
                if ((res2 = MatchUtil.rank(statisAdInfoMap, Constant.type2, Constant.num)) != null) {
                    res.add(res2);
                }
                if ((res3 = MatchUtil.rank(statisAdInfoMap, Constant.type3, Constant.num)) == null) continue;
                res.add(res3);
            }
        }
        return res;
    }

    public static List<StatisAdInfo> runOnMatch(Iterator<String> partitionOfRecords, AdvertTypeEnum advertTypeEnum) throws Exception {
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "  ModelBo.runOnMsg  start");
        ArrayList<String> timeList = new ArrayList<String>();
        while (partitionOfRecords.hasNext()) {
            String timeStr = (String)partitionOfRecords.next();
            try {
                if (timeStr == null) continue;
                timeList.add(timeStr);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        List<String> orderList = PsBo.getOrderList(timeList, advertTypeEnum);
        System.out.println("orderList.size=" + orderList.size());
        List<MatchOrderSample> samples = StatSampleBo.getStatSample2(orderList);
        System.out.println("samples.size=" + samples.size());
        List<StatisAdInfo> statisAdInfoList = MatchStatisBo.statSum(samples);
        System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS) + "statsum  end");
        return statisAdInfoList;
    }

    public static List<StatKeyMap> merge(List<StatisAdInfo> statisAdInfoList) throws Exception {
        if (AssertUtil.isEmpty(statisAdInfoList)) {
            return null;
        }
        Map<String, StatisAdInfo> collect = statisAdInfoList.stream().collect(Collectors.groupingBy(StatisAdInfo::getKey, Collectors.collectingAndThen(Collectors.toList(), list1 -> MatchBo.sumStatisAdInfo(list1))));
        Map<String, List<StatisAdInfo>> statKeyMap = new ArrayList<StatisAdInfo>(collect.values()).stream().collect(Collectors.groupingBy(StatisAdInfo::getStatKey));
        ArrayList<StatKeyMap> res = new ArrayList<StatKeyMap>();
        for (Map.Entry<String, List<StatisAdInfo>> entry : statKeyMap.entrySet()) {
            StatKeyMap rkm = new StatKeyMap();
            rkm.statKey = entry.getKey();
            rkm.StatisAdInfoList = entry.getValue();
            res.add(rkm);
        }
        return res;
    }

    public static void merge2save(List<RankMap> rankMapList) throws Exception {
        Map<String, Map> collect = rankMapList.stream().collect(Collectors.groupingBy(RankMap::getTypeKey, Collectors.collectingAndThen(Collectors.toList(), list -> MatchBo.convertMap(list))));
        for (Map.Entry<String, Map> entry1 : collect.entrySet()) {
            String type = entry1.getKey();
            Map redisKeyMap = entry1.getValue();
            for (Map.Entry entry2 : redisKeyMap.entrySet()) {
                ArrayList res = new ArrayList((Collection)entry2.getValue());
                String key = (String)entry2.getKey();
                String rediskey = Constant.profix + type + "_" + key;
                jedisUtil2.setex(rediskey, JSON.toJSONString(res), Constant.DAY_2_EXPIRE);
                if (!(Math.random() > 0.99)) continue;
                System.out.println("merge2save" + rediskey + "\uff1a " + JSON.toJSONString(res));
            }
        }
    }

    public static List<RankMap> saveAndCal(List<StatKeyMap> statisAdInfoListMap) throws Exception {
        if (AssertUtil.isEmpty(statisAdInfoListMap)) {
            return null;
        }
        ArrayList<RankMap> res = new ArrayList<RankMap>();
        if (AssertUtil.isNotEmpty(statisAdInfoListMap)) {
            for (StatKeyMap entry : statisAdInfoListMap) {
                HashMap<String, StatisAdInfo> statisAdInfoMap30min = new HashMap<String, StatisAdInfo>();
                entry.getStatisAdInfoList().forEach(item -> statisAdInfoMap30min.put(item.getSlotId(), (StatisAdInfo)item));
                List<RankMap> rankMaps1 = MatchBo.updateHourVars(entry.getStatKey(), statisAdInfoMap30min);
                List<RankMap> rankMaps2 = MatchBo.updateDayVars(entry.getStatKey(), statisAdInfoMap30min);
                jedisUtil1.setex(entry.getStatKey(), JSON.toJSONString(statisAdInfoMap30min), Constant.HOUR_0_EXPIRE);
                res.addAll(rankMaps1);
                res.addAll(rankMaps2);
            }
        }
        return res;
    }

    public static Map<String, List<StatisAdInfo>> convertMap(List<RankMap> rankMapList) {
        ArrayList list = new ArrayList();
        rankMapList.forEach(rankMap -> list.addAll(rankMap.getStatisAdInfoList()));
        return list.stream().collect(Collectors.groupingBy(StatisAdInfo::getRedisKey));
    }

    public static StatisAdInfo sumStatisAdInfo(List<StatisAdInfo> statisAdInfoList) {
        StatisAdInfo statisAdInfo = new StatisAdInfo(0L, 0L, 0L, 0L, 0L, 0L, 0.0, 0.0);
        statisAdInfo.setKey(statisAdInfoList.get(0).getKey());
        statisAdInfo.setRedisKey(statisAdInfoList.get(0).getRedisKey());
        statisAdInfo.setStatKey(statisAdInfoList.get(0).getStatKey());
        statisAdInfo.setAdKey(statisAdInfoList.get(0).getAdKey());
        statisAdInfo.setSlotId(statisAdInfoList.get(0).getSlotId());
        for (StatisAdInfo sd : statisAdInfoList) {
            statisAdInfo.addExpCnt(sd.getExpCnt());
            statisAdInfo.addChargeCnt(sd.getChargeCnt());
            statisAdInfo.addChargeFees(sd.getChargeFees());
            statisAdInfo.addConvert0Cnt(sd.getConvert0Cnt());
            statisAdInfo.addConvert2Cnt(sd.getConvert2Cnt());
            statisAdInfo.addConvert3Cnt(sd.getConvert3Cnt());
            statisAdInfo.setCvr(MatchUtil.cvr(statisAdInfo));
            statisAdInfo.setDcvr(MatchUtil.dcvr(statisAdInfo));
        }
        return statisAdInfo;
    }

    private static List<RankMap> updateHourVars(String statKey, Map<String, StatisAdInfo> statisAdInfoMap30m_new) {
        RankMap res3;
        RankMap res2;
        ArrayList<RankMap> res = new ArrayList<RankMap>();
        HashMap statisAdInfoMap30m_last_object = (HashMap)jedisUtil1.get(statKey, Map.class);
        if (statisAdInfoMap30m_last_object == null) {
            statisAdInfoMap30m_last_object = new HashMap();
        }
        Map statisAdInfoMap30m_last = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)statisAdInfoMap30m_last_object), (TypeReference)new TypeReference<Map<String, StatisAdInfo>>(){}, (Feature[])new Feature[0]);
        Map<String, StatisAdInfo> statisAdInfoMap1hour = Stream.concat(statisAdInfoMap30m_last.entrySet().stream(), statisAdInfoMap30m_new.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value1, value2) -> {
            StatisAdInfo statisAdInfo = new StatisAdInfo(0L, 0L, 0L, 0L, 0L, 0L, 0.0, 0.0);
            statisAdInfo.setKey(value2.getKey().replace("30min", "1hour"));
            statisAdInfo.setRedisKey(value2.getRedisKey().replace("30min", "1hour"));
            statisAdInfo.setStatKey(value2.getStatKey().replace("30min", "1hour"));
            statisAdInfo.setAdKey(value2.getAdKey());
            statisAdInfo.setSlotId(value2.getSlotId());
            statisAdInfo.addExpCnt(value1.getExpCnt() + value2.getExpCnt());
            statisAdInfo.addChargeCnt(value1.getChargeCnt() + value2.getChargeCnt());
            statisAdInfo.addChargeFees(value1.getChargeFees() + value2.getChargeFees());
            statisAdInfo.addConvert0Cnt(value1.getConvert0Cnt() + value2.getConvert0Cnt());
            statisAdInfo.addConvert2Cnt(value1.getConvert2Cnt() + value2.getConvert2Cnt());
            statisAdInfo.addConvert3Cnt(value1.getConvert3Cnt() + value2.getConvert3Cnt());
            statisAdInfo.setCvr(MatchUtil.cvr(statisAdInfo));
            statisAdInfo.setDcvr(MatchUtil.dcvr(statisAdInfo));
            return statisAdInfo;
        }));
        for (Map.Entry<String, StatisAdInfo> entry : statisAdInfoMap1hour.entrySet()) {
            entry.getValue().setRedisKey(entry.getValue().getRedisKey().replace("30min", "1hour"));
            entry.getValue().setKey(entry.getValue().getKey().replace("30min", "1hour"));
            entry.getValue().setStatKey(entry.getValue().getStatKey().replace("30min", "1hour"));
            if (entry.getValue().getCvr() == null) {
                entry.getValue().setCvr(0.0);
            }
            if (entry.getValue().getDcvr() != null) continue;
            entry.getValue().setDcvr(0.0);
        }
        String hourKey = statKey.replace("30min", "1hour");
        jedisUtil1.setex(hourKey, JSON.toJSONString(statisAdInfoMap1hour), Constant.HOUR_0_EXPIRE);
        RankMap res1 = MatchUtil.rank(statisAdInfoMap1hour, Constant.type1, Constant.num);
        if (res1 != null) {
            res.add(res1);
        }
        if ((res2 = MatchUtil.rank(statisAdInfoMap1hour, Constant.type2, Constant.num)) != null) {
            res.add(res2);
        }
        if ((res3 = MatchUtil.rank(statisAdInfoMap1hour, Constant.type3, Constant.num)) != null) {
            res.add(res3);
        }
        return res;
    }

    private static List<RankMap> updateDayVars(String statKey, Map<String, StatisAdInfo> statisAdInfoMap30min_new) {
        ArrayList<RankMap> res = new ArrayList<RankMap>();
        String dayStatKey = statKey.replace("30min", "1day");
        HashMap statisAdInfoMap1d_last_object = (HashMap)jedisUtil1.get(dayStatKey, Map.class);
        String currentTime = DateUtil.getCurrentTime((DateStyle)DateStyle.HH);
        if (statisAdInfoMap1d_last_object == null) {
            statisAdInfoMap1d_last_object = new HashMap();
        }
        Map statisAdInfoMap1d_last = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)statisAdInfoMap1d_last_object), (TypeReference)new TypeReference<Map<String, StatisAdInfo>>(){}, (Feature[])new Feature[0]);
        Map<Object, Object> statisAdInfoMap1day = new HashMap();
        if ("0".equals(currentTime)) {
            for (Map.Entry<String, StatisAdInfo> entry : statisAdInfoMap30min_new.entrySet()) {
                String key = entry.getKey();
                StatisAdInfo value = entry.getValue();
                StatisAdInfo statisAdInfo = new StatisAdInfo(0L, 0L, 0L, 0L, 0L, 0L, 0.0, 0.0);
                statisAdInfo.setKey(entry.getKey().replace("30min", "1day"));
                statisAdInfo.setRedisKey(value.getRedisKey().replace("30min", "1day"));
                statisAdInfo.setStatKey(value.getStatKey().replace("30min", "1day"));
                statisAdInfo.setAdKey(value.getAdKey());
                statisAdInfo.setSlotId(value.getSlotId());
                statisAdInfo.addExpCnt(value.getExpCnt());
                statisAdInfo.addChargeCnt(value.getChargeCnt());
                statisAdInfo.addChargeFees(value.getChargeFees());
                statisAdInfo.addConvert0Cnt(value.getConvert0Cnt());
                statisAdInfo.addConvert2Cnt(value.getConvert2Cnt());
                statisAdInfo.addConvert3Cnt(value.getConvert3Cnt());
                statisAdInfo.setCvr(MatchUtil.cvr(statisAdInfo));
                statisAdInfo.setDcvr(MatchUtil.dcvr(statisAdInfo));
                statisAdInfoMap1day.put(key, statisAdInfo);
            }
        } else {
            RankMap res3;
            RankMap res2;
            statisAdInfoMap1day = Stream.concat(statisAdInfoMap1d_last.entrySet().stream(), statisAdInfoMap30min_new.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value1, value2) -> {
                StatisAdInfo statisAdInfo = new StatisAdInfo(0L, 0L, 0L, 0L, 0L, 0L, 0.0, 0.0);
                statisAdInfo.setKey(value2.getKey().replace("30min", "1day"));
                statisAdInfo.setRedisKey(value2.getRedisKey().replace("30min", "1day"));
                statisAdInfo.setStatKey(value2.getStatKey().replace("30min", "1day"));
                statisAdInfo.setAdKey(value2.getAdKey());
                statisAdInfo.setSlotId(value2.getSlotId());
                statisAdInfo.addExpCnt(value1.getExpCnt() + value2.getExpCnt());
                statisAdInfo.addChargeCnt(value1.getChargeCnt() + value2.getChargeCnt());
                statisAdInfo.addChargeFees(value1.getChargeFees() + value2.getChargeFees());
                statisAdInfo.addConvert0Cnt(value1.getConvert0Cnt() + value2.getConvert0Cnt());
                statisAdInfo.addConvert2Cnt(value1.getConvert2Cnt() + value2.getConvert2Cnt());
                statisAdInfo.addConvert3Cnt(value1.getConvert3Cnt() + value2.getConvert3Cnt());
                statisAdInfo.setCvr(MatchUtil.cvr(statisAdInfo));
                statisAdInfo.setDcvr(MatchUtil.dcvr(statisAdInfo));
                return statisAdInfo;
            }));
            for (Map.Entry<Object, Object> entry : statisAdInfoMap1day.entrySet()) {
                ((StatisAdInfo)entry.getValue()).setRedisKey(((StatisAdInfo)entry.getValue()).getRedisKey().replace("30min", "1day"));
                ((StatisAdInfo)entry.getValue()).setStatKey(((StatisAdInfo)entry.getValue()).getStatKey().replace("30min", "1day"));
                ((StatisAdInfo)entry.getValue()).setKey(((StatisAdInfo)entry.getValue()).getKey().replace("30min", "1day"));
                if (((StatisAdInfo)entry.getValue()).getCvr() == null) {
                    ((StatisAdInfo)entry.getValue()).setCvr(0.0);
                }
                if (((StatisAdInfo)entry.getValue()).getDcvr() != null) continue;
                ((StatisAdInfo)entry.getValue()).setDcvr(0.0);
            }
            jedisUtil1.setex(dayStatKey, JSON.toJSONString(statisAdInfoMap1day), Constant.DAY_1_EXPIRE);
            RankMap res1 = MatchUtil.rank(statisAdInfoMap1day, Constant.type1, Constant.num);
            if (res1 != null) {
                res.add(res1);
            }
            if ((res2 = MatchUtil.rank(statisAdInfoMap1day, Constant.type2, Constant.num)) != null) {
                res.add(res2);
            }
            if ((res3 = MatchUtil.rank(statisAdInfoMap1day, Constant.type3, Constant.num)) != null) {
                res.add(res3);
            }
        }
        return res;
    }

    static class Constant {
        static String profix = "NZ_K109_";
        static String type1 = "charge";
        static String type2 = "cvr";
        static String type3 = "dcvr";
        static double costlimit = 5000.0;
        static double cvrlimit = 0.08;
        static double dcvrlimit = 0.05;
        static int num = 40;
        static int DAY_2_EXPIRE = 172800;
        static int DAY_1_EXPIRE = 86400;
        static int HOUR_0_EXPIRE = 3600;

        Constant() {
        }
    }
}

