/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo.match;

import cn.com.duiba.nezha.compute.biz.bo.match.MatchBo;
import cn.com.duiba.nezha.compute.biz.bo.match.RankMap;
import cn.com.duiba.nezha.compute.biz.bo.stat.StatisAdInfo;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.milib.ModelCache.HdfsSaveBo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MatchUtil {
    public static Double cvr(StatisAdInfo statisAdInfo) {
        if (statisAdInfo == null) {
            return 0.0;
        }
        double cvr = 0.0;
        if (statisAdInfo.getConvert0Cnt() != null && (double)statisAdInfo.getConvert0Cnt().longValue() > 0.0) {
            cvr = MatchUtil.calWilsonScore(statisAdInfo.getConvert0Cnt(), statisAdInfo.getChargeCnt());
        }
        return cvr;
    }

    public static Double dcvr(StatisAdInfo statisAdInfo) {
        if (statisAdInfo == null) {
            return 0.0;
        }
        double dcvr = 0.0;
        if (statisAdInfo.getConvert3Cnt() != null && (double)statisAdInfo.getConvert3Cnt().longValue() > 0.0) {
            dcvr = MatchUtil.calWilsonScore(statisAdInfo.getConvert3Cnt(), statisAdInfo.getConvert0Cnt());
        }
        return dcvr;
    }

    private static double calWilsonScore(Long convert, Long click) {
        if (convert == null || click == null) {
            return 0.0;
        }
        if (click == 0L) {
            return 0.0;
        }
        if (convert > click) {
            return 0.0;
        }
        double ratio = (double)convert.longValue() * 1.0 / (double)click.longValue();
        double faithLevel = 0.99;
        double faithSquare = faithLevel * faithLevel;
        return (ratio + faithSquare / (double)(2L * click) - faithLevel * Math.sqrt((double)(4L * click) * ratio * (1.0 - ratio) + faithSquare) / (double)(2L * click)) / (1.0 + faithSquare / (double)click.longValue());
    }

    public static RankMap rank(Map<String, StatisAdInfo> statisAdInfoMap, String type, Integer size) {
        RankMap result = new RankMap();
        if (AssertUtil.isEmpty(statisAdInfoMap)) {
            return null;
        }
        List<Object> res = new ArrayList();
        ArrayList<StatisAdInfo> statisAdInfoList = new ArrayList<StatisAdInfo>(statisAdInfoMap.values());
        if (type == MatchBo.Constant.type1) {
            res = statisAdInfoList.stream().filter(statisAdInfo -> statisAdInfo.getCvr() > 0.5 * MatchBo.Constant.cvrlimit).sorted(Comparator.comparing(StatisAdInfo::getChargeFees).reversed()).collect(Collectors.toList());
            if (res.size() >= 1 && ((StatisAdInfo)res.get(0)).getChargeFees() > 0L) {
                Long statisChargeMax = ((StatisAdInfo)res.get(0)).getChargeFees();
                res.stream().forEach(sinfo -> sinfo.setChargescore(1.0 * (double)sinfo.getChargeFees().longValue() / (double)statisChargeMax.longValue()));
                long chargeSum = res.stream().mapToLong(StatisAdInfo::getChargeFees).sum();
                long charge = 0L;
                int listsize = res.size();
                int limitsize = 1;
                for (int i = 0; i < listsize; ++i) {
                    if (!((double)(charge += ((StatisAdInfo)res.get(i)).getChargeFees().longValue()) >= 0.9 * (double)chargeSum)) continue;
                    limitsize = i;
                    break;
                }
                ArrayList<StatisAdInfo> res2 = new ArrayList<StatisAdInfo>();
                int limitsize1 = limitsize >= size ? size : limitsize;
                res2.addAll(res.subList(0, limitsize1));
                result.setTypeKey(MatchBo.Constant.type1);
                result.setStatisAdInfoList(res2);
            } else {
                return null;
            }
        }
        if (type == MatchBo.Constant.type2) {
            if (((StatisAdInfo)statisAdInfoList.get(0)).getStatKey() != null && ((StatisAdInfo)statisAdInfoList.get(0)).getStatKey().contains("trade")) {
                res = statisAdInfoList.stream().filter(statisAdInfo -> statisAdInfo.getCvr() > MatchBo.Constant.cvrlimit).filter(statisAdInfo -> statisAdInfo.getConvert0Cnt() >= 30L).sorted(Comparator.comparing(StatisAdInfo::getCvr).reversed()).limit(size.intValue()).collect(Collectors.toList());
            } else if (((StatisAdInfo)statisAdInfoList.get(0)).getStatKey() != null && ((StatisAdInfo)statisAdInfoList.get(0)).getStatKey().contains("account")) {
                res = statisAdInfoList.stream().filter(statisAdInfo -> statisAdInfo.getCvr() > MatchBo.Constant.cvrlimit).filter(statisAdInfo -> statisAdInfo.getConvert0Cnt() >= 20L).sorted(Comparator.comparing(StatisAdInfo::getCvr).reversed()).limit(size.intValue()).collect(Collectors.toList());
            } else if (((StatisAdInfo)statisAdInfoList.get(0)).getStatKey() != null && ((StatisAdInfo)statisAdInfoList.get(0)).getStatKey().contains("advert")) {
                res = statisAdInfoList.stream().filter(statisAdInfo -> statisAdInfo.getCvr() > MatchBo.Constant.cvrlimit).filter(statisAdInfo -> statisAdInfo.getConvert0Cnt() >= 10L).sorted(Comparator.comparing(StatisAdInfo::getCvr).reversed()).limit(size.intValue()).collect(Collectors.toList());
            }
            if (res.size() >= 1 && ((StatisAdInfo)res.get(0)).getCvr() > 0.0) {
                double statisCvrMax = ((StatisAdInfo)res.get(0)).getCvr();
                res.stream().forEach(sinfo -> sinfo.setCvrscore(1.0 * sinfo.getCvr() / statisCvrMax));
                result.setTypeKey(MatchBo.Constant.type2);
                result.setStatisAdInfoList(res);
            } else {
                return null;
            }
        }
        if (type == MatchBo.Constant.type3) {
            if (((StatisAdInfo)statisAdInfoList.get(0)).getStatKey() != null && ((StatisAdInfo)statisAdInfoList.get(0)).getStatKey().contains("trade")) {
                res = statisAdInfoList.stream().filter(statisAdInfo -> statisAdInfo.getDcvr() > MatchBo.Constant.dcvrlimit).filter(statisAdInfo -> statisAdInfo.getConvert3Cnt() >= 30L).sorted(Comparator.comparing(StatisAdInfo::getDcvr).reversed()).limit(size.intValue()).collect(Collectors.toList());
            } else if (((StatisAdInfo)statisAdInfoList.get(0)).getStatKey() != null && ((StatisAdInfo)statisAdInfoList.get(0)).getStatKey().contains("account")) {
                res = statisAdInfoList.stream().filter(statisAdInfo -> statisAdInfo.getDcvr() > MatchBo.Constant.dcvrlimit).filter(statisAdInfo -> statisAdInfo.getConvert3Cnt() >= 20L).sorted(Comparator.comparing(StatisAdInfo::getDcvr).reversed()).limit(size.intValue()).collect(Collectors.toList());
            } else if (((StatisAdInfo)statisAdInfoList.get(0)).getStatKey() != null && ((StatisAdInfo)statisAdInfoList.get(0)).getStatKey().contains("advert")) {
                res = statisAdInfoList.stream().filter(statisAdInfo -> statisAdInfo.getDcvr() > MatchBo.Constant.dcvrlimit).filter(statisAdInfo -> statisAdInfo.getConvert3Cnt() >= 10L).sorted(Comparator.comparing(StatisAdInfo::getDcvr).reversed()).limit(size.intValue()).collect(Collectors.toList());
            }
            if (res.size() >= 1 && ((StatisAdInfo)res.get(0)).getDcvr() > 0.0) {
                double statisDcvrMax = ((StatisAdInfo)res.get(0)).getDcvr();
                res.stream().forEach(sinfo -> sinfo.setDcvrscore(1.0 * sinfo.getDcvr() / statisDcvrMax));
                result.setTypeKey(MatchBo.Constant.type3);
                result.setStatisAdInfoList(res);
            } else {
                return null;
            }
        }
        return result;
    }

    public static void hdfsSave(String obj, String path) {
        try {
            System.out.println("save to hdfs   ");
            String path1 = "hdfs://prd-bigdata01:8020/user/db_sa/data/matchsave/" + path;
            HdfsSaveBo.hdfsSaveFile1((String)obj, (String)path1);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

