/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.biz.bo.stat;

import cn.com.duiba.nezha.compute.biz.bo.stat.StatisAdInfo;
import cn.com.duiba.nezha.compute.biz.dto.stat.MatchOrderSample;
import cn.com.duiba.nezha.compute.biz.enums.stat.StatMatchTypeEnum;
import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MatchStatisBo {
    private static String seq = "_";

    public static List<StatisAdInfo> statSum(List<MatchOrderSample> samples) {
        HashMap<String, StatisAdInfo> statisAdInfoMap = new HashMap<String, StatisAdInfo>();
        if (AssertUtil.isNotEmpty(samples)) {
            for (MatchOrderSample sample : samples) {
                MatchStatisBo.statBase(statisAdInfoMap, sample);
            }
        }
        ArrayList<StatisAdInfo> list = new ArrayList<StatisAdInfo>(statisAdInfoMap.values());
        return list;
    }

    public static void statBase(Map<String, StatisAdInfo> statisAdInfoMap, MatchOrderSample sample) {
        MatchStatisBo.statBase(statisAdInfoMap, sample, sample.getAdvertId() + "", seq, StatMatchTypeEnum.SLOT_AD.getProfix(), sample.getSlotId() + "");
        MatchStatisBo.statBase(statisAdInfoMap, sample, sample.getAccountId() + "", seq, StatMatchTypeEnum.SLOT_ACC.getProfix(), sample.getSlotId() + "");
        MatchStatisBo.statBase2(statisAdInfoMap, sample, sample.getNewTradeTagId() + "", seq, StatMatchTypeEnum.SLOT_TRADE.getProfix(), sample.getSlotId() + "");
    }

    public static void statBase(Map<String, StatisAdInfo> statisAdInfoMap, MatchOrderSample sample, String adKey, String seq, String profix, String subKey) {
        String redisKey = MatchStatisBo.getStatKey(seq, profix, subKey);
        String statKey = MatchStatisBo.getStatKey(seq, profix, adKey);
        String key = redisKey + "_" + adKey;
        if (!statisAdInfoMap.containsKey(key)) {
            StatisAdInfo statisAdInfo = new StatisAdInfo();
            statisAdInfo.setKey(key);
            statisAdInfo.setRedisKey(redisKey);
            statisAdInfo.setStatKey(statKey);
            statisAdInfo.setAdKey(adKey);
            statisAdInfo.setSlotId(subKey);
            statisAdInfo.setExpCnt(sample.getExpCnt());
            statisAdInfo.setChargeCnt(sample.getChargeCnt());
            statisAdInfo.setChargeFees(sample.getChargeFees());
            statisAdInfo.setConvert0Cnt(sample.getConvert0Cnt());
            statisAdInfo.setConvert2Cnt(sample.getConvert2Cnt());
            statisAdInfo.setConvert3Cnt(sample.getConvert3Cnt());
            statisAdInfoMap.put(key, statisAdInfo);
        } else {
            StatisAdInfo statisAdInfo = statisAdInfoMap.get(key);
            statisAdInfo.addExpCnt(sample.getExpCnt());
            statisAdInfo.addChargeCnt(sample.getChargeCnt());
            statisAdInfo.addChargeFees(sample.getChargeFees());
            statisAdInfo.addConvert0Cnt(sample.getConvert0Cnt());
            statisAdInfo.addConvert2Cnt(sample.getConvert2Cnt());
            statisAdInfo.addConvert3Cnt(sample.getConvert3Cnt());
        }
    }

    public static void statBase2(Map<String, StatisAdInfo> statisAdInfoMap, MatchOrderSample sample, String adKey, String seq, String profix, String subKey) {
        String redisKey = MatchStatisBo.getStatKey(seq, profix, subKey);
        String statKey = MatchStatisBo.getStatKey(seq, profix, adKey);
        String key = redisKey + "_" + adKey;
        ArrayList accountList = Lists.newArrayList((Object[])new Long[]{30497L, 21330L, 31399L, 26448L, 15334L});
        if (!statisAdInfoMap.containsKey(key)) {
            StatisAdInfo statisAdInfo = new StatisAdInfo();
            statisAdInfo.setKey(key);
            statisAdInfo.setRedisKey(redisKey);
            statisAdInfo.setStatKey(statKey);
            statisAdInfo.setAdKey(adKey);
            statisAdInfo.setSlotId(subKey);
            statisAdInfo.setExpCnt(sample.getExpCnt());
            statisAdInfo.setChargeCnt(sample.getChargeCnt());
            statisAdInfo.setChargeFees(sample.getChargeFees());
            if (accountList.contains(sample.getAccountId())) {
                statisAdInfo.setConvert0Cnt(0L);
                statisAdInfo.setConvert2Cnt(0L);
                statisAdInfo.setConvert3Cnt(0L);
            } else {
                statisAdInfo.setConvert0Cnt(sample.getConvert0Cnt());
                statisAdInfo.setConvert2Cnt(sample.getConvert2Cnt());
                statisAdInfo.setConvert3Cnt(sample.getConvert3Cnt());
            }
            statisAdInfoMap.put(key, statisAdInfo);
        } else {
            StatisAdInfo statisAdInfo = statisAdInfoMap.get(key);
            statisAdInfo.addExpCnt(sample.getExpCnt());
            statisAdInfo.addChargeCnt(sample.getChargeCnt());
            statisAdInfo.addChargeFees(sample.getChargeFees());
            if (!accountList.contains(sample.getAccountId())) {
                statisAdInfo.addConvert0Cnt(sample.getConvert0Cnt());
                statisAdInfo.addConvert2Cnt(sample.getConvert2Cnt());
                statisAdInfo.addConvert3Cnt(sample.getConvert3Cnt());
            } else {
                statisAdInfo.addConvert0Cnt(0L);
                statisAdInfo.addConvert2Cnt(0L);
                statisAdInfo.addConvert3Cnt(0L);
            }
        }
    }

    public static String getStatKey(String seq, String profix, Long ... subKey) {
        return profix + StringUtils.join((Object[])subKey, (String)seq);
    }

    public static String getStatKey(String seq, String profix, String ... subKey) {
        return profix + StringUtils.join((Object[])subKey, (String)seq);
    }

    public static String getStatKey(String seq, Long ... subKey) {
        return StringUtils.join((Object[])subKey, (String)seq);
    }

    public static void main(String[] args) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 2);
        map.put(2, 1);
        map.put(3, 1);
        map.put(4, 1);
        map.put(5, 1);
        ArrayList list = new ArrayList(map.values());
        System.out.println(MatchStatisBo.getStatKey("_", 10L, 12L, null, 14L));
    }
}

